/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.procgen;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.VisualPanelAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.impl.campaign.procgen.Constellation;
import com.fs.starfarer.api.impl.campaign.procgen.StarAge;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RemnantThemeGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.ThemeGenContext;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcGenTestPluginImpl
implements InteractionDialogPlugin {
    protected InteractionDialogAPI dialog;
    protected TextPanelAPI textPanel;
    protected OptionPanelAPI options;
    protected VisualPanelAPI visual;
    protected CampaignFleetAPI playerFleet;
    protected PlanetAPI planet;
    protected static final Color HIGHLIGHT_COLOR = Global.getSettings().getColor("buttonShortcut");
    protected OptionId lastOptionMousedOver = null;

    @Override
    public void init(InteractionDialogAPI dialog) {
        this.dialog = dialog;
        this.textPanel = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        this.visual = dialog.getVisualPanel();
        this.playerFleet = Global.getSector().getPlayerFleet();
        this.planet = (PlanetAPI)dialog.getInteractionTarget();
        this.visual.setVisualFade(0.25f, 0.25f);
        dialog.setOptionOnEscape("Leave", (Object)OptionId.LEAVE);
        this.optionSelected(null, (Object)OptionId.INIT);
    }

    @Override
    public Map<String, MemoryAPI> getMemoryMap() {
        return null;
    }

    @Override
    public void backFromEngagement(EngagementResultAPI result) {
    }

    @Override
    public void optionSelected(String text, Object optionData) {
        if (optionData == null) {
            return;
        }
        OptionId option = (OptionId)((Object)optionData);
        if (text != null) {
            this.dialog.addOptionSelectedText((Object)option);
        }
        int genCount = 1;
        Constellation constellation = null;
        switch (option) {
            case INIT: {
                this.createInitialOptions();
                break;
            }
            case GEN_YOUNG: {
                int i = 0;
                while (i < genCount) {
                    constellation = new StarSystemGenerator(new StarSystemGenerator.CustomConstellationParams(StarAge.YOUNG)).generate();
                    ++i;
                }
                this.addText("Generated star system.");
                this.optionSelected(null, (Object)OptionId.LEAVE);
                break;
            }
            case GEN_AVERAGE: {
                int i = 0;
                while (i < genCount) {
                    constellation = new StarSystemGenerator(new StarSystemGenerator.CustomConstellationParams(StarAge.AVERAGE)).generate();
                    ++i;
                }
                this.addText("Generated star system.");
                this.optionSelected(null, (Object)OptionId.LEAVE);
                break;
            }
            case GEN_OLD: {
                int i = 0;
                while (i < genCount) {
                    constellation = new StarSystemGenerator(new StarSystemGenerator.CustomConstellationParams(StarAge.OLD)).generate();
                    ++i;
                }
                this.addText("Generated star system.");
                this.optionSelected(null, (Object)OptionId.LEAVE);
                break;
            }
            case GEN_SALVAGE: {
                ThemeGenContext context = new ThemeGenContext();
                HashSet<Constellation> c = new HashSet<Constellation>();
                block13: for (StarSystemAPI system : Global.getSector().getStarSystems()) {
                    if (system.getConstellation() == null) continue;
                    for (StarSystemAPI curr : system.getConstellation().getSystems()) {
                        if (!curr.isProcgen()) continue;
                        c.add(system.getConstellation());
                        continue block13;
                    }
                }
                context.constellations = new ArrayList<Constellation>(c);
                new RemnantThemeGenerator().generateForSector(context, 1.0f);
                break;
            }
            case GEN_CUSTOM: {
                StarSystemGenerator.CustomConstellationParams params = new StarSystemGenerator.CustomConstellationParams(StarAge.YOUNG);
                params.numStars = 7;
                params.forceNebula = true;
                params.systemTypes.add(StarSystemGenerator.StarSystemType.TRINARY_2CLOSE);
                params.systemTypes.add(StarSystemGenerator.StarSystemType.SINGLE);
                params.systemTypes.add(StarSystemGenerator.StarSystemType.TRINARY_1CLOSE_1FAR);
                params.systemTypes.add(StarSystemGenerator.StarSystemType.NEBULA);
                params.systemTypes.add(StarSystemGenerator.StarSystemType.SINGLE);
                params.systemTypes.add(StarSystemGenerator.StarSystemType.BINARY_CLOSE);
                params.systemTypes.add(StarSystemGenerator.StarSystemType.BINARY_CLOSE);
                params.starTypes.add("black_hole");
                params.starTypes.add("star_blue_giant");
                params.starTypes.add("star_orange");
                params.starTypes.add("star_neutron");
                params.starTypes.add("star_neutron");
                params.starTypes.add("star_neutron");
                params.starTypes.add("star_neutron");
                params.starTypes.add("nebula_center_average");
                params.starTypes.add("black_hole");
                params.starTypes.add("black_hole");
                params.starTypes.add("black_hole");
                params.starTypes.add("star_blue_giant");
                constellation = new StarSystemGenerator(params).generate();
                this.addText("Generated star system.");
                this.optionSelected(null, (Object)OptionId.LEAVE);
                break;
            }
            case PRINT_STATS: {
                this.printStats();
                break;
            }
            case LEAVE: {
                this.dialog.dismiss();
            }
        }
    }

    protected void printStats() {
        String value;
        Integer count;
        final HashMap<String, Integer> counts = new HashMap<String, Integer>();
        final HashMap<String, Integer> hab = new HashMap<String, Integer>();
        int totalPlanets = 0;
        int totalSystems = 0;
        int totalHab = 0;
        int totalPlanetsInSystemsWithTerran = 0;
        int maxPlanetsInSystemsWithTerran = 0;
        for (StarSystemAPI system : Global.getSector().getStarSystems()) {
            if (!system.isProcgen()) continue;
            String starType = null;
            if (system.getStar() != null) {
                starType = system.getStar().getSpec().getName();
            }
            ++totalSystems;
            int planets = 0;
            HashSet<String> seen = new HashSet<String>();
            for (PlanetAPI planet : system.getPlanets()) {
                if (planet.getMarket() == null || !planet.getMarket().isPlanetConditionMarketOnly()) continue;
                String type = planet.getSpec().getName();
                seen.add(planet.getSpec().getPlanetType());
                ++planets;
                Integer count2 = 0;
                if (counts.containsKey(type)) {
                    count2 = (Integer)counts.get(type);
                }
                count2 = count2 + 1;
                counts.put(type, count2);
                if (planet.getMarket().hasCondition("habitable")) {
                    ++totalHab;
                    if (starType != null) {
                        count2 = 0;
                        if (hab.containsKey(starType)) {
                            count2 = (Integer)hab.get(starType);
                        }
                        count2 = count2 + 1;
                        hab.put(starType, count2);
                    }
                }
                ++totalPlanets;
            }
            if (!seen.contains("terran")) continue;
            if (planets > maxPlanetsInSystemsWithTerran) {
                maxPlanetsInSystemsWithTerran = planets;
            }
            totalPlanetsInSystemsWithTerran += planets;
        }
        ArrayList list = new ArrayList(counts.keySet());
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return ((Integer)counts.get(o2)).compareTo((Integer)counts.get(o1));
            }
        });
        ArrayList habList = new ArrayList(hab.keySet());
        Collections.sort(habList, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return ((Integer)hab.get(o2)).compareTo((Integer)hab.get(o1));
            }
        });
        this.textPanel.addParagraph("");
        this.print(String.format("Star systems: %4d", totalSystems));
        this.print(String.format("Planets:      %4d", totalPlanets));
        this.print(String.format("Habitable     %4d", totalHab));
        this.print(String.format("Planets in systems with terran worlds: %4d", totalPlanetsInSystemsWithTerran));
        this.print(String.format("Max planets in system with terran world: %4d", maxPlanetsInSystemsWithTerran));
        if (totalPlanets > 0) {
            this.print("Planet totals:");
            for (String type : list) {
                count = (Integer)counts.get(type);
                value = String.valueOf(Misc.getRoundedValueMaxOneAfterDecimal((float)count.intValue() * 100.0f / (float)totalPlanets)) + "%";
                value = String.valueOf(value) + " (" + count + ")";
                this.print(String.format("  %-20s%10s", type, value));
            }
            this.print("");
        }
        if (totalHab > 0) {
            this.print("Habitable totals by star:");
            for (String type : habList) {
                count = (Integer)hab.get(type);
                value = String.valueOf(Misc.getRoundedValueMaxOneAfterDecimal((float)count.intValue() * 100.0f / (float)totalHab)) + "%";
                value = String.valueOf(value) + " (" + count + ")";
                this.print(String.format("  %-20s%10s", type, value));
            }
            this.print("");
        }
    }

    protected void print(String str) {
        this.textPanel.appendToLastParagraph("\n" + str);
        System.out.println(str);
    }

    protected void createInitialOptions() {
        this.options.clearOptions();
        this.options.addOption("Generate young constellation", (Object)OptionId.GEN_YOUNG, null);
        this.options.addOption("Generate average constellation", (Object)OptionId.GEN_AVERAGE, null);
        this.options.addOption("Generate old constellation", (Object)OptionId.GEN_OLD, null);
        this.options.addOption("Generate preset constellation", (Object)OptionId.GEN_CUSTOM, null);
        this.options.addOption("Generate salvage entities", (Object)OptionId.GEN_SALVAGE, null);
        this.options.addOption("Print stats", (Object)OptionId.PRINT_STATS, null);
        this.options.addOption("Leave", (Object)OptionId.LEAVE, null);
    }

    @Override
    public void optionMousedOver(String optionText, Object optionData) {
    }

    @Override
    public void advance(float amount) {
    }

    protected void addText(String text) {
        this.textPanel.addParagraph(text);
    }

    protected void appendText(String text) {
        this.textPanel.appendToLastParagraph(" " + text);
    }

    protected String getString(String id) {
        String str = Global.getSettings().getString("planetInteractionDialog", id);
        String fleetOrShip = "fleet";
        if (this.playerFleet.getFleetData().getMembersListCopy().size() == 1) {
            fleetOrShip = "ship";
            if (this.playerFleet.getFleetData().getMembersListCopy().get(0).isFighterWing()) {
                fleetOrShip = "fighter wing";
            }
        }
        str = str.replaceAll("\\$fleetOrShip", fleetOrShip);
        str = str.replaceAll("\\$planetName", this.planet.getName());
        return str;
    }

    @Override
    public Object getContext() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum OptionId {
        INIT,
        GEN_YOUNG,
        GEN_AVERAGE,
        GEN_OLD,
        GEN_CUSTOM,
        GEN_SALVAGE,
        PRINT_STATS,
        LEAVE;

    }
}

