/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.procgen;

import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.TerrainGenDataSpec;
import com.fs.starfarer.api.impl.campaign.procgen.TerrainGenPlugin;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class RingGenPlugin
implements TerrainGenPlugin {
    public static final String RING_GEN_DATA_KEY = "rgd_key";

    protected TexAndIndex getTexAndIndex(TerrainGenDataSpec data) {
        TexAndIndex result = new TexAndIndex();
        WeightedRandomPicker<Integer> indexPicker = new WeightedRandomPicker<Integer>(StarSystemGenerator.random);
        if (data.getId().equals("ring_ice")) {
            result.tex = "rings_ice0";
            indexPicker.add(0);
            indexPicker.add(1);
            indexPicker.add(2);
            indexPicker.add(3);
        } else if (data.getId().equals("ring_dust")) {
            result.tex = "rings_dust0";
            indexPicker.add(0);
            indexPicker.add(1);
            indexPicker.add(2);
            indexPicker.add(3);
        } else if (data.getId().equals("ring_special")) {
            result.tex = "rings_special0";
            indexPicker.add(1);
        }
        result.index = (Integer)indexPicker.pick();
        return result;
    }

    public RingGenData getData(StarSystemGenerator.GenContext context) {
        RingGenData data = null;
        if (context.customData.get(RING_GEN_DATA_KEY) instanceof RingGenData) {
            data = (RingGenData)context.customData.get(RING_GEN_DATA_KEY);
        }
        if (data == null) {
            data = new RingGenData();
            context.customData.put(RING_GEN_DATA_KEY, data);
        }
        return data;
    }

    public StarSystemGenerator.GenResult generate(TerrainGenDataSpec terrainData, StarSystemGenerator.GenContext context) {
        TexAndIndex tex;
        float spacing;
        StarSystemAPI system = context.system;
        SectorEntityToken parent = context.center;
        if (context.parent != null) {
            parent = context.parent;
        }
        float orbitRadius = context.currentRadius;
        float bandWidth = 256.0f;
        RingGenData data = this.getData(context);
        Color color = StarSystemGenerator.getColor(terrainData.getMinColor(), terrainData.getMaxColor());
        ArrayList<SectorEntityToken> rings = new ArrayList<SectorEntityToken>();
        float totalWidth = 0.0f;
        if (StarSystemGenerator.random.nextFloat() < 0.25f) {
            spacing = 175.0f;
            totalWidth = bandWidth * 2.0f + spacing;
            float orbitDays = (orbitRadius + totalWidth / 2.0f) / (15.0f + 5.0f * StarSystemGenerator.random.nextFloat());
            tex = this.getTexAndIndex(terrainData);
            rings.add(system.addRingBand(parent, "misc", tex.tex, 256.0f, tex.index, color, bandWidth, orbitRadius + bandWidth / 2.0f, orbitDays, "ring", null));
            orbitDays = (orbitRadius + bandWidth / 2.0f + spacing + bandWidth / 2.0f) / (15.0f + 5.0f * StarSystemGenerator.random.nextFloat());
            tex = this.getTexAndIndex(terrainData);
            rings.add(system.addRingBand(parent, "misc", tex.tex, 256.0f, tex.index, color, bandWidth, orbitRadius + bandWidth / 2.0f + spacing + bandWidth / 2.0f, orbitDays * 1.2f, "ring", null));
        } else {
            float numBands = 1.0f;
            if (orbitRadius > 2000.0f && StarSystemGenerator.random.nextFloat() > 0.5f) {
                numBands += 1.0f;
            }
            if (orbitRadius > 4000.0f && StarSystemGenerator.random.nextFloat() > 0.5f) {
                numBands += 1.0f;
            }
            if (orbitRadius > 6000.0f && StarSystemGenerator.random.nextFloat() > 0.5f) {
                numBands += 1.0f;
            }
            float startingRadius = orbitRadius + bandWidth / 2.0f;
            float spacing2 = bandWidth * 0.5f;
            float i = 0.0f;
            while (i < numBands) {
                float currentRadius = startingRadius + i * spacing2;
                float orbitDays = currentRadius / (15.0f + 5.0f * StarSystemGenerator.random.nextFloat());
                tex = this.getTexAndIndex(terrainData);
                if (StarSystemGenerator.random.nextFloat() > 0.5f) {
                    if (StarSystemGenerator.random.nextFloat() > 0.5f) {
                        tex = this.getTexAndIndex(terrainData);
                    }
                    rings.add(system.addRingBand(parent, "misc", tex.tex, 256.0f, tex.index, color, bandWidth, currentRadius, orbitDays * 1.2f, "ring", null));
                    if (StarSystemGenerator.random.nextFloat() > 0.5f) {
                        if (StarSystemGenerator.random.nextFloat() > 0.5f) {
                            tex = this.getTexAndIndex(terrainData);
                        }
                        rings.add(system.addRingBand(parent, "misc", tex.tex, 256.0f, tex.index, color, bandWidth, currentRadius, orbitDays * 1.4f, "ring", null));
                    }
                }
                i += 1.0f;
            }
            totalWidth = (numBands - 1.0f) * spacing2 + bandWidth;
        }
        if (context.orbitIndex > 0 && data.lastOrbitAddedAt == context.orbitIndex - 1) {
            spacing = bandWidth * 0.5f;
            float currRadius = data.endOfLastRingRadius;
            while (currRadius <= orbitRadius) {
                float orbitDays = currRadius / (15.0f + 5.0f * StarSystemGenerator.random.nextFloat());
                tex = this.getTexAndIndex(terrainData);
                rings.add(system.addRingBand(parent, "misc", tex.tex, 256.0f, tex.index, color, bandWidth, currRadius, orbitDays, "ring", null));
                currRadius += spacing;
            }
            if (data.lastBatch != null) {
                rings.addAll(data.lastBatch);
                for (SectorEntityToken ring : rings) {
                    context.gen.getAllEntitiesAdded().remove(ring);
                }
            }
        }
        data.lastOrbitAddedAt = context.orbitIndex;
        data.endOfLastRingRadius = orbitRadius + bandWidth;
        data.lastBatch = new ArrayList<SectorEntityToken>(rings);
        StarSystemGenerator.GenResult result = new StarSystemGenerator.GenResult();
        result.onlyIncrementByWidth = false;
        result.orbitalWidth = totalWidth;
        result.entities.addAll(rings);
        return result;
    }

    public boolean wantsToHandle(TerrainGenDataSpec terrainData, StarSystemGenerator.GenContext context) {
        return terrainData != null && (terrainData.getId().equals("ring_ice") || terrainData.getId().equals("ring_dust") || terrainData.getId().equals("ring_special"));
    }

    public static class RingGenData {
        public int lastOrbitAddedAt = -1;
        public float endOfLastRingRadius = -1.0f;
        public List<SectorEntityToken> lastBatch = null;
    }

    public static class TexAndIndex {
        public String tex;
        public int index;
    }
}

