/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.procgen;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.SectorGenProgress;
import com.fs.starfarer.api.campaign.SectorProcGenPlugin;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.characters.CharacterCreationData;
import com.fs.starfarer.api.impl.campaign.procgen.Constellation;
import com.fs.starfarer.api.impl.campaign.procgen.MarkovNames;
import com.fs.starfarer.api.impl.campaign.procgen.NebulaEditor;
import com.fs.starfarer.api.impl.campaign.procgen.StarAge;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.SectorThemeGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.ThemeGenContext;
import com.fs.starfarer.api.impl.campaign.terrain.HyperspaceTerrainPlugin;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.Pair;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SectorProcGen
implements SectorProcGenPlugin {
    public static final float CELL_SIZE = 2000.0f;
    public static final int CONSTELLATION_CELLS = 10;

    @Override
    public void prepare(CharacterCreationData data) {
        if (data.getSeed() > 0L) {
            StarSystemGenerator.random.setSeed(data.getSeed());
        }
        StarSystemGenerator.updateBackgroundPickers();
        MarkovNames.loadIfNeeded();
    }

    @Override
    public void generate(CharacterCreationData data, SectorGenProgress progress) {
        float w = Global.getSettings().getFloat("sectorWidth");
        float h = Global.getSettings().getFloat("sectorHeight");
        boolean small = "small".equals(data.getSectorSize());
        StarAge sectorAge = data.getSectorAge();
        if (sectorAge == null) {
            sectorAge = StarAge.ANY;
        }
        int cellsWide = (int)(w / 2000.0f);
        int cellsHigh = (int)(h / 2000.0f);
        boolean[][] cells = new boolean[cellsWide][cellsHigh];
        int count = 100;
        int vPad = 5;
        int hPad = 5;
        if (small) {
            hPad = 15;
            vPad = 9;
        }
        int i = 0;
        while (i < cells.length) {
            int j = 0;
            while (j < cells[0].length) {
                if (i <= hPad || j <= vPad || i >= cellsWide - hPad || j >= cellsHigh - vPad) {
                    cells[i][j] = true;
                }
                ++j;
            }
            ++i;
        }
        for (StarSystemAPI system : Global.getSector().getStarSystems()) {
            int[] index = SectorProcGen.getIndex(system.getLocation());
            int x = index[0];
            int y = index[1];
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            if (x > cellsWide - 1) {
                x = cellsWide - 1;
            }
            if (y > cellsHigh - 1) {
                y = cellsHigh - 1;
            }
            SectorProcGen.blotOut(cells, x, y, 8);
        }
        SectorProcGen.blotOut(cells, 0, 0, 12);
        SectorProcGen.blotOut(cells, 6, 0, 12);
        SectorProcGen.blotOut(cells, 12, 0, 12);
        progress.render("Generating sector...", 0.1f);
        List<StarSystemGenerator.CustomConstellationParams> custom = SectorProcGen.getCustomConstellations();
        ArrayList<Constellation> constellations = new ArrayList<Constellation>();
        int k = 0;
        while (k < count) {
            WeightedRandomPicker<Pair<Integer, Integer>> picker = new WeightedRandomPicker<Pair<Integer, Integer>>(StarSystemGenerator.random);
            int i2 = 0;
            while (i2 < cells.length) {
                int j = 0;
                while (j < cells[0].length) {
                    if (!cells[i2][j]) {
                        Pair<Integer, Integer> p = new Pair<Integer, Integer>(i2, j);
                        picker.add(p);
                    }
                    ++j;
                }
                ++i2;
            }
            Pair pick = (Pair)picker.pick();
            if (pick != null) {
                StarAge age;
                SectorProcGen.blotOut(cells, (Integer)pick.one, (Integer)pick.two, 10);
                float x = (float)((Integer)pick.one).intValue() * 2000.0f - w / 2.0f;
                float y = (float)((Integer)pick.two).intValue() * 2000.0f - h / 2.0f;
                StarSystemGenerator.CustomConstellationParams params = new StarSystemGenerator.CustomConstellationParams(StarAge.ANY);
                if (!custom.isEmpty()) {
                    params = custom.remove(0);
                }
                if ((age = sectorAge) == StarAge.ANY) {
                    WeightedRandomPicker<StarAge> agePicker = new WeightedRandomPicker<StarAge>(StarSystemGenerator.random);
                    agePicker.add(StarAge.YOUNG);
                    agePicker.add(StarAge.AVERAGE);
                    agePicker.add(StarAge.OLD);
                    age = (StarAge)((Object)agePicker.pick());
                }
                params.age = age;
                params.location = new Vector2f(x, y);
                Constellation c = new StarSystemGenerator(params).generate();
                constellations.add(c);
                progress.render("Generating constellations...", 0.1f + 0.8f * (float)k / (float)count);
            }
            ++k;
        }
        HyperspaceTerrainPlugin hyper = (HyperspaceTerrainPlugin)Misc.getHyperspaceTerrain().getPlugin();
        NebulaEditor editor = new NebulaEditor(hyper);
        editor.regenNoise();
        editor.noisePrune(0.8f);
        editor.regenNoise();
        Random random = StarSystemGenerator.random;
        float angleOffset = random.nextFloat() * 360.0f;
        editor.clearArc(0.0f, 0.0f, w / 2.0f, w / 2.0f + 3000.0f, angleOffset + 0.0f, angleOffset + 360.0f * (2.0f + random.nextFloat() * 2.0f), 0.01f, 0.33f);
        int numArcs = (int)(20.0f + 8.0f * random.nextFloat());
        int i3 = 0;
        while (i3 < numArcs) {
            float dist = w / 2.0f + w / 2.0f * random.nextFloat();
            float angle = random.nextFloat() * 360.0f;
            Vector2f dir = Misc.getUnitVectorAtDegreeAngle(angle);
            dir.scale(dist - (w / 12.0f + w / 3.0f * random.nextFloat()));
            float width = 800.0f * (1.0f + 2.0f * random.nextFloat());
            float clearThreshold = 0.0f + 0.5f * random.nextFloat();
            editor.clearArc(dir.x, dir.y, dist - width / 2.0f, dist + width / 2.0f, 0.0f, 360.0f, clearThreshold);
            ++i3;
        }
        progress.render("Generating objects...", 0.9f);
        ThemeGenContext context = new ThemeGenContext();
        context.constellations = constellations;
        SectorThemeGenerator.generate(context);
        progress.render("Finishing generation...", 1.0f);
    }

    public static void blotOut(boolean[][] cells, int x, int y, int c) {
        int i = Math.max(0, x - c / 2);
        while (i <= x + c / 2 && i < cells.length) {
            int j = Math.max(0, y - c / 2);
            while (j <= y + c / 2 && j < cells[0].length) {
                cells[i][j] = true;
                ++j;
            }
            ++i;
        }
    }

    public static int[] getIndex(Vector2f loc) {
        float w = Global.getSettings().getFloat("sectorWidth");
        float h = Global.getSettings().getFloat("sectorHeight");
        int x = (int)((loc.x + w / 2.0f) / 2000.0f);
        int y = (int)((loc.y + h / 2.0f) / 2000.0f);
        return new int[]{x, y};
    }

    public static List<StarSystemGenerator.CustomConstellationParams> getCustomConstellations() {
        ArrayList<StarSystemGenerator.CustomConstellationParams> result = new ArrayList<StarSystemGenerator.CustomConstellationParams>();
        for (StarSystemGenerator.StarSystemType type : EnumSet.allOf(StarSystemGenerator.StarSystemType.class)) {
            StarSystemGenerator.CustomConstellationParams params = new StarSystemGenerator.CustomConstellationParams(StarAge.ANY);
            params.systemTypes.add(type);
            if (type == StarSystemGenerator.StarSystemType.NEBULA) {
                params.forceNebula = true;
            }
            result.add(params);
        }
        StarSystemGenerator.CustomConstellationParams params = new StarSystemGenerator.CustomConstellationParams(StarAge.ANY);
        params.starTypes.add("black_hole");
        result.add(params);
        params = new StarSystemGenerator.CustomConstellationParams(StarAge.ANY);
        params.starTypes.add("star_neutron");
        result.add(params);
        return result;
    }
}

