/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.procgen;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignTerrainAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.PlanetSpecAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.characters.FullName;
import com.fs.starfarer.api.impl.campaign.procgen.AccretionDiskGenPlugin;
import com.fs.starfarer.api.impl.campaign.procgen.AgeGenDataSpec;
import com.fs.starfarer.api.impl.campaign.procgen.AsteroidBeltGenPlugin;
import com.fs.starfarer.api.impl.campaign.procgen.AsteroidFieldGenPlugin;
import com.fs.starfarer.api.impl.campaign.procgen.CategoryGenDataSpec;
import com.fs.starfarer.api.impl.campaign.procgen.Constellation;
import com.fs.starfarer.api.impl.campaign.procgen.ConstellationGen;
import com.fs.starfarer.api.impl.campaign.procgen.EntityGenDataSpec;
import com.fs.starfarer.api.impl.campaign.procgen.LocationGenDataSpec;
import com.fs.starfarer.api.impl.campaign.procgen.MagFieldGenPlugin;
import com.fs.starfarer.api.impl.campaign.procgen.NameAssigner;
import com.fs.starfarer.api.impl.campaign.procgen.NebulaEditor;
import com.fs.starfarer.api.impl.campaign.procgen.NebulaSmallGenPlugin;
import com.fs.starfarer.api.impl.campaign.procgen.PlanetConditionGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.PlanetGenDataSpec;
import com.fs.starfarer.api.impl.campaign.procgen.RingGenPlugin;
import com.fs.starfarer.api.impl.campaign.procgen.StarAge;
import com.fs.starfarer.api.impl.campaign.procgen.StarGenDataSpec;
import com.fs.starfarer.api.impl.campaign.procgen.TerrainGenDataSpec;
import com.fs.starfarer.api.impl.campaign.procgen.TerrainGenPlugin;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseThemeGenerator;
import com.fs.starfarer.api.impl.campaign.terrain.BaseTiledTerrain;
import com.fs.starfarer.api.impl.campaign.terrain.HyperspaceTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.NebulaTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.PulsarBeamTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.StarCoronaTerrainPlugin;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StarSystemGenerator {
    public static final float MIN_STAR_DIST = 2000.0f;
    public static final float MAX_STAR_DIST = 2000.0f;
    public static final float TILT_MIN = -45.0f;
    public static final float TILT_MAX = 45.0f;
    public static final float PITCH_MIN = -15.0f;
    public static final float PITCH_MAX = 45.0f;
    public static final float MAX_ORBIT_RADIUS = 20000.0f;
    public static final float FAR_MAX_ORBIT_RADIUS = 5000.0f;
    public static final float LAGRANGE_OFFSET = 60.0f;
    public static final float BASE_INCR = 800.0f;
    public static final float BASE_INCR_MOON = 200.0f;
    public static final float STARTING_RADIUS_STAR_BASE = 750.0f;
    public static final float STARTING_RADIUS_STAR_RANGE = 500.0f;
    public static final float STARTING_RADIUS_MOON_BASE = 300.0f;
    public static final float STARTING_RADIUS_MOON_RANGE = 100.0f;
    public static final float MOON_RADIUS_MAX_FRACTION_OF_PARENT = 0.33f;
    public static final float MOON_RADIUS_MIN_FRACTION_OF_NORMAL = 0.2f;
    public static final float MOON_RADIUS_MAX_FRACTION_OF_NORMAL = 0.75f;
    public static final float MIN_MOON_RADIUS = 60.0f;
    public static final String TAG_FIRST_ORBIT_ONLY = "first_orbit_only";
    public static final String TAG_GIANT_MOON = "around_giant_at_any_offset";
    public static final String TAG_LAGRANGE_ONLY = "lagrange_only";
    public static final String TAG_NOT_IN_NEBULA = "not_in_nebula";
    public static final String TAG_REQUIRES_NEBULA = "requires_nebula";
    public static final String TAG_NOT_NEBULA_UNLESS_MOON = "not_NEBULA_unless_moon";
    public static final String CAT_HAB5 = "cat_hab5";
    public static final String CAT_HAB4 = "cat_hab4";
    public static final String CAT_HAB3 = "cat_hab3";
    public static final String CAT_HAB2 = "cat_hab2";
    public static final String CAT_HAB1 = "cat_hab1";
    public static final String CAT_NOTHING = "cat_nothing";
    public static final String CAT_GIANT = "cat_giant";
    public static final String COL_LAGRANGE = "lagrange";
    public static final String COL_IN_ASTEROIDS = "in_asteroids";
    public static final String COL_IS_MOON = "is_moon";
    public static final String COL_BINARY = "binary";
    public static final String COL_TRINARY = "trinary";
    public static final String NEBULA_DEFAULT = "nebula";
    public static final String NEBULA_AMBER = "nebula_amber";
    public static final String NEBULA_BLUE = "nebula_blue";
    public static final String NEBULA_NONE = "no_nebula";
    public static Map<StarAge, String> nebulaTypes = new LinkedHashMap<StarAge, String>();
    public static Map<String, WeightedRandomPicker<String>> backgroundsByNebulaType = new LinkedHashMap<String, WeightedRandomPicker<String>>();
    public static List<TerrainGenPlugin> terrainPlugins = new ArrayList<TerrainGenPlugin>();
    public static Random random = new Random();
    public static boolean DEBUG;
    protected StarAge constellationAge;
    protected StarSystemType systemType = StarSystemType.SINGLE;
    protected StarAge starAge;
    protected SectorAPI sector;
    protected StarSystemAPI system;
    protected LocationAPI hyper;
    protected PlanetAPI star;
    protected PlanetAPI secondary;
    protected PlanetAPI tertiary;
    protected SectorEntityToken systemCenter;
    protected float centerRadius = 0.0f;
    protected AgeGenDataSpec constellationAgeData;
    protected AgeGenDataSpec starAgeData;
    protected StarGenDataSpec starData;
    protected String nebulaType;
    protected String backgroundName;
    protected Map<SectorEntityToken, PlanetAPI> lagrangeParentMap = new LinkedHashMap<SectorEntityToken, PlanetAPI>();
    protected Map<SectorEntityToken, List<SectorEntityToken>> allNameableEntitiesAdded = new LinkedHashMap<SectorEntityToken, List<SectorEntityToken>>();
    protected CustomConstellationParams params;

    static {
        terrainPlugins.add(new RingGenPlugin());
        terrainPlugins.add(new AsteroidBeltGenPlugin());
        terrainPlugins.add(new MagFieldGenPlugin());
        terrainPlugins.add(new NebulaSmallGenPlugin());
        terrainPlugins.add(new AsteroidFieldGenPlugin());
        terrainPlugins.add(new AccretionDiskGenPlugin());
        nebulaTypes.put(StarAge.YOUNG, NEBULA_BLUE);
        nebulaTypes.put(StarAge.AVERAGE, NEBULA_DEFAULT);
        nebulaTypes.put(StarAge.OLD, NEBULA_AMBER);
        nebulaTypes.put(StarAge.ANY, NEBULA_DEFAULT);
        StarSystemGenerator.updateBackgroundPickers();
        DEBUG = Global.getSettings().isDevMode();
    }

    public static void addTerrainGenPlugin(TerrainGenPlugin plugin) {
        terrainPlugins.add(0, plugin);
    }

    public static void removeTerrainGenPlugin(TerrainGenPlugin plugin) {
        terrainPlugins.remove(plugin);
    }

    public static void updateBackgroundPickers() {
        WeightedRandomPicker<String> picker = new WeightedRandomPicker<String>(random);
        picker.add("graphics/backgrounds/background2.jpg", 10.0f);
        picker.add("graphics/backgrounds/background4.jpg", 10.0f);
        backgroundsByNebulaType.put(NEBULA_NONE, picker);
        picker = new WeightedRandomPicker(random);
        picker.add("graphics/backgrounds/background5.jpg", 10.0f);
        backgroundsByNebulaType.put(NEBULA_BLUE, picker);
        picker = new WeightedRandomPicker(random);
        picker.add("graphics/backgrounds/background6.jpg", 10.0f);
        backgroundsByNebulaType.put(NEBULA_AMBER, picker);
        picker = new WeightedRandomPicker(random);
        picker.add("graphics/backgrounds/background1.jpg", 10.0f);
        picker.add("graphics/backgrounds/background2.jpg", 10.0f);
        backgroundsByNebulaType.put(NEBULA_DEFAULT, picker);
    }

    public static TerrainGenPlugin pickTerrainGenPlugin(TerrainGenDataSpec terrainData, GenContext context) {
        for (TerrainGenPlugin plugin : terrainPlugins) {
            if (!plugin.wantsToHandle(terrainData, context)) continue;
            return plugin;
        }
        return null;
    }

    public StarSystemGenerator(CustomConstellationParams params) {
        this.params = params;
        this.constellationAge = params.age;
        if (this.constellationAge == StarAge.ANY) {
            WeightedRandomPicker<StarAge> picker = new WeightedRandomPicker<StarAge>(random);
            picker.add(StarAge.AVERAGE);
            picker.add(StarAge.OLD);
            picker.add(StarAge.YOUNG);
            this.constellationAge = (StarAge)((Object)picker.pick());
        }
        this.constellationAgeData = (AgeGenDataSpec)Global.getSettings().getSpec(AgeGenDataSpec.class, this.constellationAge.name(), true);
    }

    public void pickNebulaAndBackground() {
        boolean hasNebula;
        boolean bl = hasNebula = this.constellationAgeData.getProbNebula() > random.nextFloat();
        if (this.params != null && this.params.forceNebula) {
            hasNebula = true;
        }
        this.nebulaType = NEBULA_NONE;
        if (hasNebula) {
            this.nebulaType = nebulaTypes.get((Object)this.constellationAge);
        }
        WeightedRandomPicker<String> bgPicker = backgroundsByNebulaType.get(this.nebulaType);
        this.backgroundName = bgPicker.pick();
    }

    public Constellation generate() {
        this.lagrangeParentMap = new LinkedHashMap<SectorEntityToken, PlanetAPI>();
        this.allNameableEntitiesAdded = new LinkedHashMap<SectorEntityToken, List<SectorEntityToken>>();
        SectorAPI sector = Global.getSector();
        Vector2f loc = new Vector2f();
        if (this.params != null && this.params.location != null) {
            loc = new Vector2f((ReadableVector2f)this.params.location);
        } else {
            loc = new Vector2f((ReadableVector2f)sector.getPlayerFleet().getLocation());
            loc.x = (int)loc.x;
            loc.y = (int)loc.y;
        }
        this.pickNebulaAndBackground();
        ArrayList<StarSystemAPI> systems = new ArrayList<StarSystemAPI>();
        int stars = Math.round(StarSystemGenerator.getNormalRandom(1.0f, 7.0f));
        if (this.params != null && this.params.numStars > 0) {
            stars = this.params.numStars;
        } else if (this.params != null && this.params.minStars > 0 && this.params.maxStars > 0) {
            stars = Math.round(StarSystemGenerator.getNormalRandom(this.params.minStars, this.params.maxStars));
        }
        int i = 0;
        while (i < stars) {
            this.generateSystem(new Vector2f(0.0f, 0.0f));
            if (this.system != null) {
                systems.add(this.system);
            }
            ++i;
        }
        ConstellationGen.SpringSystem springs = ConstellationGen.doConstellationLayout(systems, random, loc);
        Global.getSector().getHyperspace().updateAllOrbits();
        HyperspaceTerrainPlugin plugin = (HyperspaceTerrainPlugin)Misc.getHyperspaceTerrain().getPlugin();
        NebulaEditor editor = new NebulaEditor(plugin);
        float minRadius = plugin.getTileSize() * 2.0f;
        for (StarSystemAPI curr : systems) {
            float radius = curr.getMaxRadiusInHyperspace();
            editor.clearArc(curr.getLocation().x, curr.getLocation().y, 0.0f, radius + minRadius * 0.5f, 0.0f, 360.0f);
            editor.clearArc(curr.getLocation().x, curr.getLocation().y, 0.0f, radius + minRadius, 0.0f, 360.0f, 0.25f);
        }
        for (ConstellationGen.SpringConnection conn : springs.connections) {
            if (!conn.pull) continue;
            float r1 = ((StarSystemAPI)conn.from.custom).getMaxRadiusInHyperspace();
            float r2 = ((StarSystemAPI)conn.to.custom).getMaxRadiusInHyperspace();
            float dist = Misc.getDistance(conn.from.loc, conn.to.loc);
            float radius = Math.max(0.0f, dist * 0.67f - r1 - r2);
            Vector2f diff = Vector2f.sub((Vector2f)conn.to.loc, (Vector2f)conn.from.loc, (Vector2f)new Vector2f());
            float x = conn.from.loc.x + diff.x * 0.33f;
            float y = conn.from.loc.y + diff.y * 0.33f;
            editor.clearArc(x, y, 0.0f, radius + minRadius * 1.0f, 0.0f, 360.0f);
            editor.clearArc(x, y, 0.0f, radius + minRadius * 2.0f, 0.0f, 360.0f, 0.25f);
            x = conn.from.loc.x + diff.x * 0.67f;
            y = conn.from.loc.y + diff.y * 0.67f;
            editor.clearArc(x, y, 0.0f, radius + minRadius * 1.0f, 0.0f, 360.0f);
            editor.clearArc(x, y, 0.0f, radius + minRadius * 2.0f, 0.0f, 360.0f, 0.25f);
        }
        Constellation.ConstellationType type = Constellation.ConstellationType.NORMAL;
        if (!NEBULA_NONE.equals(this.nebulaType)) {
            type = Constellation.ConstellationType.NEBULA;
        }
        Constellation c = new Constellation(type, this.constellationAge);
        c.getSystems().addAll(systems);
        c.setLagrangeParentMap(this.lagrangeParentMap);
        c.setAllEntitiesAdded(this.allNameableEntitiesAdded);
        NameAssigner namer = new NameAssigner(c);
        namer.setSpecialNamesProbability(0.37f);
        namer.assignNames(this.params.name, this.params.secondaryName);
        for (SectorEntityToken entity : this.allNameableEntitiesAdded.keySet()) {
            if (!(entity instanceof PlanetAPI) || entity.getMarket() == null) continue;
            entity.getMarket().setName(entity.getName());
        }
        for (StarSystemAPI system : systems) {
            system.setConstellation(c);
        }
        return c;
    }

    public void generateSystem(Vector2f loc) {
        this.systemType = this.pickSystemType(this.constellationAge);
        String uuid = Misc.genUID();
        String id = "system_" + uuid;
        String name = "System " + uuid;
        if (!this.initSystem(name, loc)) {
            this.cleanup();
            return;
        }
        this.star = null;
        this.secondary = null;
        this.tertiary = null;
        this.systemCenter = null;
        if (!this.addStars(id)) {
            this.cleanup();
            return;
        }
        this.updateAgeAfterPickingStar();
        float binaryPad = 1500.0f;
        float maxOrbitRadius = 20000.0f;
        if (this.systemType == StarSystemType.BINARY_FAR || this.systemType == StarSystemType.TRINARY_1CLOSE_1FAR || this.systemType == StarSystemType.TRINARY_2FAR) {
            maxOrbitRadius -= 5000.0f + binaryPad;
        }
        GenResult result = this.addPlanetsAndTerrain(20000.0f);
        float primaryOrbitalRadius = this.star.getRadius();
        if (result != null) {
            primaryOrbitalRadius = result.orbitalWidth * 0.5f;
        }
        float orbitAngle = random.nextFloat() * 360.0f;
        float baseOrbitRadius = primaryOrbitalRadius + binaryPad;
        float orbitDays = baseOrbitRadius / (3.0f + random.nextFloat() * 2.0f);
        if (this.systemType == StarSystemType.BINARY_FAR && this.secondary != null) {
            this.addFarStar(this.secondary, orbitAngle, baseOrbitRadius, orbitDays);
        } else if (this.systemType == StarSystemType.TRINARY_1CLOSE_1FAR && this.tertiary != null) {
            this.addFarStar(this.tertiary, orbitAngle, baseOrbitRadius, orbitDays);
        } else if (this.systemType == StarSystemType.TRINARY_2FAR) {
            this.addFarStar(this.secondary, orbitAngle, baseOrbitRadius, orbitDays);
            this.addFarStar(this.tertiary, orbitAngle + 60.0f + 180.0f * random.nextFloat(), baseOrbitRadius, orbitDays);
        }
        if (this.systemType == StarSystemType.NEBULA) {
            this.star.setSkipForJumpPointAutoGen(true);
        }
        this.addJumpPoints(result, false);
        if (this.systemType == StarSystemType.NEBULA) {
            this.system.removeEntity(this.star);
            StarCoronaTerrainPlugin coronaPlugin = Misc.getCoronaFor(this.star);
            if (coronaPlugin != null) {
                this.system.removeEntity(coronaPlugin.getEntity());
            }
            this.system.setStar(null);
            this.system.initNonStarCenter();
            for (SectorEntityToken entity : this.system.getAllEntities()) {
                if (entity.getOrbitFocus() != this.star && entity.getOrbitFocus() != this.system.getCenter()) continue;
                entity.setOrbit(null);
            }
            this.system.getCenter().addTag("ambient_ls");
        }
        this.system.autogenerateHyperspaceJumpPoints(true, false);
        if (this.systemType == StarSystemType.NEBULA) {
            this.system.setStar(this.star);
        }
        this.addStableLocations();
        this.addSystemwideNebula();
    }

    protected void addFarStar(PlanetAPI farStar, float orbitAngle, float baseOrbitRadius, float orbitPeriod) {
        float min = 0.0f;
        float max = 2.0f;
        int numOrbits = Math.round(StarSystemGenerator.getNormalRandom(min, max));
        GenResult resultFar = null;
        if (numOrbits > 0) {
            float currentRadius = farStar.getRadius() + 750.0f + 500.0f * random.nextFloat();
            StarGenDataSpec farData = (StarGenDataSpec)Global.getSettings().getSpec(StarGenDataSpec.class, farStar.getSpec().getPlanetType(), false);
            StarAge farAge = farData.getAge();
            if (farAge == StarAge.ANY) {
                farAge = this.constellationAge;
            }
            GenContext context = new GenContext(this, this.system, farStar, farData, null, 0, farAge.name(), currentRadius, 5000.0f, null, -1);
            resultFar = this.addOrbitingEntities(context, numOrbits, false, true, false, true);
            resultFar.context = context;
        }
        if (resultFar != null) {
            baseOrbitRadius += resultFar.orbitalWidth * 0.5f;
        }
        SectorEntityToken center = this.star;
        if (this.systemType == StarSystemType.TRINARY_1CLOSE_1FAR) {
            center = this.systemCenter;
        }
        farStar.setCircularOrbit(center, orbitAngle, baseOrbitRadius, orbitPeriod);
        if (resultFar != null) {
            this.addJumpPoints(resultFar, true);
        }
    }

    protected StarSystemType pickSystemType(StarAge constellationAge) {
        if (this.params != null && !this.params.systemTypes.isEmpty()) {
            return this.params.systemTypes.remove(0);
        }
        WeightedRandomPicker<StarSystemType> picker = new WeightedRandomPicker<StarSystemType>(random);
        for (StarSystemType type : EnumSet.allOf(StarSystemType.class)) {
            Object test = Global.getSettings().getSpec(LocationGenDataSpec.class, type.name(), true);
            if (test == null) continue;
            LocationGenDataSpec data = (LocationGenDataSpec)test;
            boolean nebulaStatusOk = NEBULA_NONE.equals(this.nebulaType) || !data.hasTag(TAG_NOT_IN_NEBULA);
            if (!(nebulaStatusOk &= !NEBULA_NONE.equals(this.nebulaType) || !data.hasTag(TAG_REQUIRES_NEBULA))) continue;
            float freq = 0.0f;
            switch (constellationAge) {
                case AVERAGE: {
                    freq = data.getFreqAVERAGE();
                    break;
                }
                case OLD: {
                    freq = data.getFreqOLD();
                    break;
                }
                case YOUNG: {
                    freq = data.getFreqYOUNG();
                }
            }
            picker.add(type, freq);
        }
        return (StarSystemType)((Object)picker.pick());
    }

    protected boolean addStars(String id) {
        float dist;
        PlanetSpecAPI starSpec;
        if (this.systemType == StarSystemType.BINARY_CLOSE || this.systemType == StarSystemType.TRINARY_1CLOSE_1FAR || this.systemType == StarSystemType.TRINARY_2CLOSE) {
            this.system.initNonStarCenter();
            this.systemCenter = this.system.getCenter();
        }
        if ((starSpec = this.pickStar(this.constellationAge)) == null) {
            return false;
        }
        this.starData = (StarGenDataSpec)Global.getSettings().getSpec(StarGenDataSpec.class, starSpec.getPlanetType(), false);
        float radius = StarSystemGenerator.getRadius(this.starData.getMinRadius(), this.starData.getMaxRadius());
        float corona = radius * (this.starData.getCoronaMult() + this.starData.getCoronaVar() * (random.nextFloat() - 0.5f));
        if (corona < this.starData.getCoronaMin()) {
            corona = this.starData.getCoronaMin();
        }
        this.star = this.system.initStar(id, starSpec.getPlanetType(), radius, corona, this.starData.getSolarWind(), this.starData.getMinFlare() + (this.starData.getMaxFlare() - this.starData.getMinFlare()) * random.nextFloat(), this.starData.getCrLossMult());
        if (this.systemType == StarSystemType.NEBULA) {
            this.star.addTag("ambient_ls");
        }
        if (this.systemCenter == null) {
            this.systemCenter = this.star;
            this.centerRadius = this.star.getRadius();
        }
        if (this.systemType == StarSystemType.BINARY_CLOSE) {
            this.secondary = this.addRandomStar(String.valueOf(id) + "_b", String.valueOf(this.system.getBaseName()) + " B");
            if (this.secondary == null) {
                return false;
            }
            this.switchPrimaryAndSecondaryIfNeeded(true);
        } else if (this.systemType == StarSystemType.BINARY_FAR) {
            this.secondary = this.addRandomStar(String.valueOf(id) + "_b", String.valueOf(this.system.getBaseName()) + " B");
            if (this.secondary == null) {
                return false;
            }
            this.switchPrimaryAndSecondaryIfNeeded(true);
            this.centerRadius = this.star.getRadius();
            this.secondary.setLightColorOverrideIfStar(this.pickLightColorForStar(this.secondary));
        } else if (this.systemType == StarSystemType.TRINARY_2CLOSE || this.systemType == StarSystemType.TRINARY_1CLOSE_1FAR || this.systemType == StarSystemType.TRINARY_2FAR) {
            this.secondary = this.addRandomStar(String.valueOf(id) + "_b", String.valueOf(this.system.getBaseName()) + " B");
            if (this.secondary == null) {
                return false;
            }
            this.switchPrimaryAndSecondaryIfNeeded(true);
            this.tertiary = this.addRandomStar(String.valueOf(id) + "_c", String.valueOf(this.system.getBaseName()) + " C");
            if (this.tertiary == null) {
                return false;
            }
            this.switchPrimaryAndTertiaryIfNeeded(true);
            if (this.systemType == StarSystemType.TRINARY_1CLOSE_1FAR) {
                this.tertiary.setLightColorOverrideIfStar(this.pickLightColorForStar(this.tertiary));
            } else if (this.systemType == StarSystemType.TRINARY_2FAR) {
                this.secondary.setLightColorOverrideIfStar(this.pickLightColorForStar(this.secondary));
                this.tertiary.setLightColorOverrideIfStar(this.pickLightColorForStar(this.tertiary));
            }
        }
        if (this.systemType == StarSystemType.BINARY_CLOSE || this.systemType == StarSystemType.TRINARY_1CLOSE_1FAR) {
            dist = 750.0f + 500.0f * random.nextFloat();
            float r1 = this.star.getRadius();
            float r2 = this.secondary.getRadius();
            if (this.star.getSpec().getPlanetType().equals("black_hole")) {
                r1 *= 5.0f;
            }
            if (this.secondary.getSpec().getPlanetType().equals("black_hole")) {
                r2 *= 5.0f;
            }
            float totalRadius = r1 + r2;
            float orbitPrimary = (dist += totalRadius) * r2 / totalRadius;
            float orbitSecondary = dist * r1 / totalRadius;
            this.centerRadius = Math.max(orbitPrimary + this.star.getRadius(), orbitSecondary + this.secondary.getRadius());
            float anglePrimary = random.nextFloat() * 360.0f;
            float orbitDays = dist / (30.0f + random.nextFloat() * 50.0f);
            this.star.setCircularOrbit(this.system.getCenter(), anglePrimary, orbitPrimary, orbitDays);
            this.secondary.setCircularOrbit(this.system.getCenter(), anglePrimary + 180.0f, orbitSecondary, orbitDays);
        } else if (this.systemType == StarSystemType.TRINARY_2CLOSE) {
            dist = 750.0f + 500.0f * random.nextFloat();
            float anglePrimary = random.nextFloat() * 360.0f;
            float orbitDays = (dist += this.star.getRadius()) / (20.0f + random.nextFloat() * 80.0f);
            this.star.setCircularOrbit(this.system.getCenter(), anglePrimary, dist - 10.0f, orbitDays);
            this.secondary.setCircularOrbit(this.system.getCenter(), anglePrimary + 120.0f, dist - 5.0f, orbitDays);
            this.tertiary.setCircularOrbit(this.system.getCenter(), anglePrimary + 240.0f, dist, orbitDays);
            this.centerRadius = dist + this.star.getRadius();
        } else {
            this.star.getLocation().set(0.0f, 0.0f);
        }
        if (this.star != null) {
            this.starData = (StarGenDataSpec)Global.getSettings().getSpec(StarGenDataSpec.class, this.star.getSpec().getPlanetType(), false);
        }
        this.setDefaultLightColorBasedOnStars();
        if (this.star != null) {
            ArrayList<PlanetAPI> list = new ArrayList<PlanetAPI>();
            list.add(this.star);
            this.allNameableEntitiesAdded.put(this.star, list);
            this.system.setStar(this.star);
        }
        if (this.secondary != null) {
            ArrayList<PlanetAPI> list = new ArrayList<PlanetAPI>();
            list.add(this.secondary);
            this.allNameableEntitiesAdded.put(this.secondary, list);
            this.system.setSecondary(this.secondary);
        }
        if (this.tertiary != null) {
            ArrayList<PlanetAPI> list = new ArrayList<PlanetAPI>();
            list.add(this.tertiary);
            this.allNameableEntitiesAdded.put(this.tertiary, list);
            this.system.setTertiary(this.tertiary);
        }
        this.setBlackHoleIfBlackHole(this.star);
        this.setBlackHoleIfBlackHole(this.secondary);
        this.setBlackHoleIfBlackHole(this.tertiary);
        this.setPulsarIfNeutron(this.star);
        this.setPulsarIfNeutron(this.secondary);
        this.setPulsarIfNeutron(this.tertiary);
        return true;
    }

    protected void setBlackHoleIfBlackHole(PlanetAPI star) {
        if (star == null) {
            return;
        }
        if (star.getSpec().getPlanetType().equals("black_hole")) {
            StarCoronaTerrainPlugin coronaPlugin = Misc.getCoronaFor(star);
            if (coronaPlugin != null) {
                this.system.removeEntity(coronaPlugin.getEntity());
            }
            StarGenDataSpec starData = (StarGenDataSpec)Global.getSettings().getSpec(StarGenDataSpec.class, star.getSpec().getPlanetType(), false);
            float corona = star.getRadius() * (starData.getCoronaMult() + starData.getCoronaVar() * (random.nextFloat() - 0.5f));
            if (corona < starData.getCoronaMin()) {
                corona = starData.getCoronaMin();
            }
            SectorEntityToken eventHorizon = this.system.addTerrain("event_horizon", new StarCoronaTerrainPlugin.CoronaParams(star.getRadius() + corona, (star.getRadius() + corona) / 2.0f, star, starData.getSolarWind(), starData.getMinFlare() + (starData.getMaxFlare() - starData.getMinFlare()) * random.nextFloat(), starData.getCrLossMult()));
            eventHorizon.setCircularOrbit(star, 0.0f, 0.0f, 100.0f);
        }
    }

    protected void setPulsarIfNeutron(PlanetAPI star) {
        if (star == null) {
            return;
        }
        if (star.getSpec().getPlanetType().equals("star_neutron")) {
            StarCoronaTerrainPlugin coronaPlugin = Misc.getCoronaFor(star);
            if (coronaPlugin != null) {
                this.system.removeEntity(coronaPlugin.getEntity());
            }
            this.system.addCorona(star, 300.0f, 3.0f, 0.0f, 3.0f);
            StarGenDataSpec starData = (StarGenDataSpec)Global.getSettings().getSpec(StarGenDataSpec.class, star.getSpec().getPlanetType(), false);
            float corona = star.getRadius() * (starData.getCoronaMult() + starData.getCoronaVar() * (random.nextFloat() - 0.5f));
            if (corona < starData.getCoronaMin()) {
                corona = starData.getCoronaMin();
            }
            SectorEntityToken eventHorizon = this.system.addTerrain("pulsar_beam", new StarCoronaTerrainPlugin.CoronaParams(star.getRadius() + corona, (star.getRadius() + corona) / 2.0f, star, starData.getSolarWind(), starData.getMinFlare() + (starData.getMaxFlare() - starData.getMinFlare()) * random.nextFloat(), starData.getCrLossMult()));
            eventHorizon.setCircularOrbit(star, 0.0f, 0.0f, 100.0f);
        }
    }

    protected void switchPrimaryAndSecondaryIfNeeded(boolean sizeDownSmaller) {
        if (this.star == null || this.secondary == null) {
            return;
        }
        if (this.star.getRadius() < this.secondary.getRadius()) {
            this.star = this.secondary;
            this.secondary = this.system.getStar();
            this.system.setStar(this.star);
            String temp = this.star.getName();
            this.star.setName(this.secondary.getName());
            this.secondary.setName(temp);
            temp = this.star.getId();
            this.star.setId(this.secondary.getId());
            this.secondary.setId(temp);
            if (sizeDownSmaller) {
                this.secondary.setRadius(Math.min(this.secondary.getRadius(), this.star.getRadius() * 0.67f));
            }
            if (this.secondary == this.systemCenter) {
                this.systemCenter = this.star;
                this.centerRadius = this.systemCenter.getRadius();
            }
        }
    }

    protected void switchPrimaryAndTertiaryIfNeeded(boolean sizeDownSmaller) {
        if (this.star == null || this.tertiary == null) {
            return;
        }
        if (this.star.getRadius() < this.tertiary.getRadius()) {
            this.star = this.tertiary;
            this.tertiary = this.system.getStar();
            this.system.setStar(this.star);
            String temp = this.star.getName();
            this.star.setName(this.tertiary.getName());
            this.tertiary.setName(temp);
            temp = this.star.getId();
            this.star.setId(this.tertiary.getId());
            this.tertiary.setId(temp);
            if (sizeDownSmaller) {
                this.tertiary.setRadius(Math.min(this.tertiary.getRadius(), this.star.getRadius() * 0.67f));
            }
            if (this.tertiary == this.systemCenter) {
                this.systemCenter = this.star;
                this.centerRadius = this.systemCenter.getRadius();
            }
        }
    }

    protected void addStableLocations() {
        int max = 3;
        int min = 1;
        int num = random.nextInt(max + 1 - min) + min;
        if (num == min && random.nextFloat() < 0.25f) {
            num = 0;
        }
        StarSystemGenerator.addStableLocations(this.system, num);
    }

    public static void addStableLocations(StarSystemAPI system, int num) {
        int i = 0;
        while (i < num) {
            LinkedHashMap<BaseThemeGenerator.LocationType, Float> weights = new LinkedHashMap<BaseThemeGenerator.LocationType, Float>();
            weights.put(BaseThemeGenerator.LocationType.STAR_ORBIT, Float.valueOf(10.0f));
            weights.put(BaseThemeGenerator.LocationType.OUTER_SYSTEM, Float.valueOf(10.0f));
            weights.put(BaseThemeGenerator.LocationType.L_POINT, Float.valueOf(10.0f));
            weights.put(BaseThemeGenerator.LocationType.IN_SMALL_NEBULA, Float.valueOf(2.0f));
            WeightedRandomPicker<BaseThemeGenerator.EntityLocation> locs = BaseThemeGenerator.getLocations(random, system, null, 100.0f, weights);
            BaseThemeGenerator.EntityLocation loc = locs.pick();
            BaseThemeGenerator.AddedEntity added = BaseThemeGenerator.addNonSalvageEntity(system, loc, "stable_location", "neutral");
            if (added != null) {
                BaseThemeGenerator.convertOrbitPointingDown(added.entity);
            }
            ++i;
        }
    }

    protected void addJumpPoints(GenResult result, boolean farStarMode) {
        float outerRadius = this.centerRadius + 750.0f + 500.0f * random.nextFloat();
        if (result != null) {
            outerRadius = result.orbitalWidth / 2.0f + 500.0f;
        }
        if (farStarMode) {
            if (result.context.orbitIndex < 0 && random.nextFloat() < 0.5f) {
                return;
            }
            SectorEntityToken farStar = result.context.center;
            String name = "Omega Jump-point";
            if (result.context.center == this.tertiary) {
                name = "Omicron Jump-point";
            }
            JumpPointAPI point = Global.getFactory().createJumpPoint(null, name);
            point.setStandardWormholeToHyperspaceVisual();
            float orbitDays = outerRadius / (15.0f + random.nextFloat() * 5.0f);
            point.setCircularOrbit(farStar, random.nextFloat() * 360.0f, outerRadius, orbitDays);
            this.system.addEntity(point);
            return;
        }
        JumpPointAPI point = Global.getFactory().createJumpPoint(null, "Fringe Jump-point");
        point.setStandardWormholeToHyperspaceVisual();
        float orbitDays = outerRadius / (15.0f + random.nextFloat() * 5.0f);
        point.setCircularOrbit(this.systemCenter, random.nextFloat() * 360.0f, outerRadius, orbitDays);
        this.system.addEntity(point);
        this.system.updateAllOrbits();
        if (result != null) {
            float halfway = outerRadius * 0.5f;
            WeightedRandomPicker<LagrangePoint> inner = new WeightedRandomPicker<LagrangePoint>(random);
            WeightedRandomPicker<LagrangePoint> outer = new WeightedRandomPicker<LagrangePoint>(random);
            int total = 0;
            for (GeneratedPlanet planet : result.context.generatedPlanets) {
                if (planet.isMoon || planet.planet.getOrbit() == null || planet.planet.getOrbit().getFocus() == null) continue;
                ++total;
                for (LagrangePointType type : EnumSet.of(LagrangePointType.L4, LagrangePointType.L5)) {
                    float orbitRadius = planet.orbitRadius;
                    float angleOffset = -30.0f;
                    if (type == LagrangePointType.L5) {
                        angleOffset = 30.0f;
                    }
                    float angle = planet.orbitAngle + angleOffset;
                    Vector2f location = Misc.getUnitVectorAtDegreeAngle(angle + angleOffset);
                    location.scale(orbitRadius);
                    Vector2f.add((Vector2f)location, (Vector2f)planet.planet.getOrbit().getFocus().getLocation(), (Vector2f)location);
                    boolean clear = true;
                    for (PlanetAPI curr : this.system.getPlanets()) {
                        float dist = Misc.getDistance(curr.getLocation(), location);
                        if (!(dist < 500.0f)) continue;
                        clear = false;
                        break;
                    }
                    if (!clear) continue;
                    if (planet.orbitRadius < halfway || planet.orbitRadius < 5000.0f) {
                        inner.add(new LagrangePoint(planet, type), 10.0f);
                        continue;
                    }
                    outer.add(new LagrangePoint(planet, type), 10.0f);
                }
            }
            if (outerRadius > 2000.0f + 5000.0f * random.nextFloat()) {
                String name;
                LagrangePoint p;
                boolean addedOne = false;
                if (!inner.isEmpty()) {
                    p = (LagrangePoint)inner.pick();
                    name = "Inner System Jump-point";
                    if (this.systemType == StarSystemType.NEBULA) {
                        name = "Inner Jump-point";
                    }
                    this.addJumpPoint(p, name);
                    addedOne = true;
                }
                if (!(outer.isEmpty() || !(random.nextFloat() < (float)outer.getItems().size() * 0.2f) && addedOne)) {
                    p = (LagrangePoint)outer.pick();
                    name = "Outer System Jump-point";
                    if (this.systemType == StarSystemType.NEBULA) {
                        name = "Outer Jump-point";
                    }
                    this.addJumpPoint(p, name);
                    addedOne = true;
                }
            }
        }
    }

    protected void addJumpPoint(LagrangePoint p, String name) {
        float orbitRadius = p.parent.orbitRadius;
        float orbitDays = p.parent.orbitDays;
        float angleOffset = -30.0f;
        if (p.type == LagrangePointType.L5) {
            angleOffset = 30.0f;
        }
        float angle = p.parent.orbitAngle + angleOffset;
        SectorEntityToken focus = p.parent.planet.getOrbitFocus();
        if (focus == null) {
            focus = this.systemCenter;
        }
        JumpPointAPI point = Global.getFactory().createJumpPoint(null, name);
        point.setStandardWormholeToHyperspaceVisual();
        if (!p.parent.planet.isGasGiant()) {
            point.setRelatedPlanet(p.parent.planet);
        }
        point.setCircularOrbit(focus, angle + angleOffset, orbitRadius, orbitDays);
        this.system.addEntity(point);
    }

    public static float addOrbitingEntities(StarSystemAPI system, SectorEntityToken parentStar, StarAge age, int min, int max, float startingRadius, int nameOffset, boolean withSpecialNames) {
        return StarSystemGenerator.addOrbitingEntities(system, parentStar, age, min, max, startingRadius, nameOffset, withSpecialNames, true);
    }

    public static float addOrbitingEntities(StarSystemAPI system, SectorEntityToken parentStar, StarAge age, int min, int max, float startingRadius, int nameOffset, boolean withSpecialNames, boolean allowHabitable) {
        CustomConstellationParams p = new CustomConstellationParams(age);
        p.forceNebula = true;
        StarSystemGenerator gen = new StarSystemGenerator(p);
        gen.system = system;
        gen.starData = (StarGenDataSpec)Global.getSettings().getSpec(StarGenDataSpec.class, system.getStar().getSpec().getPlanetType(), false);
        gen.starAge = age;
        gen.constellationAge = age;
        gen.starAgeData = (AgeGenDataSpec)Global.getSettings().getSpec(AgeGenDataSpec.class, age.name(), true);
        gen.star = system.getStar();
        gen.pickNebulaAndBackground();
        if (system.getType() != null) {
            gen.systemType = system.getType();
        }
        gen.systemCenter = system.getCenter();
        StarGenDataSpec starData = gen.starData;
        PlanetGenDataSpec planetData = null;
        PlanetAPI parentPlanet = null;
        if (parentStar instanceof PlanetAPI) {
            PlanetAPI planet = (PlanetAPI)parentStar;
            if (planet.isStar()) {
                starData = (StarGenDataSpec)Global.getSettings().getSpec(StarGenDataSpec.class, planet.getSpec().getPlanetType(), false);
            } else {
                planetData = (PlanetGenDataSpec)Global.getSettings().getSpec(PlanetGenDataSpec.class, planet.getSpec().getPlanetType(), false);
                parentPlanet = planet;
            }
        }
        int parentOrbitIndex = -1;
        int startingOrbitIndex = 0;
        boolean addingAroundStar = parentPlanet == null;
        float r = 0.0f;
        if (parentStar != null) {
            r = parentStar.getRadius();
        }
        float approximateExtraRadiusPerOrbit = 400.0f;
        if (addingAroundStar) {
            parentOrbitIndex = -1;
            startingOrbitIndex = (int)((startingRadius - r - 750.0f - 250.0f) / (1000.0f + approximateExtraRadiusPerOrbit));
            if (startingOrbitIndex < 0) {
                startingOrbitIndex = 0;
            }
        } else {
            float dist = 0.0f;
            if (parentPlanet.getOrbitFocus() != null) {
                dist = Misc.getDistance(parentPlanet.getLocation(), parentPlanet.getOrbitFocus().getLocation());
            }
            parentOrbitIndex = (int)((dist - r - 750.0f - 250.0f) / (1000.0f + approximateExtraRadiusPerOrbit));
            startingOrbitIndex = (int)((startingRadius - 300.0f - 50.0f) / 250.0f);
            if (parentOrbitIndex < 0) {
                parentOrbitIndex = 0;
            }
            if (startingOrbitIndex < 0) {
                startingOrbitIndex = 0;
            }
        }
        int num = Math.round(StarSystemGenerator.getNormalRandom(min, max));
        GenContext context = new GenContext(gen, system, gen.systemCenter, starData, parentPlanet, startingOrbitIndex, age.name(), startingRadius, 20000.0f, planetData != null ? planetData.getCategory() : null, parentOrbitIndex);
        if (!allowHabitable) {
            context.excludeCategories.add(CAT_HAB5);
            context.excludeCategories.add(CAT_HAB4);
            context.excludeCategories.add(CAT_HAB3);
            context.excludeCategories.add(CAT_HAB2);
        }
        GenResult result = gen.addOrbitingEntities(context, num, false, addingAroundStar, false, false);
        Constellation c = new Constellation(Constellation.ConstellationType.NORMAL, age);
        c.getSystems().add(system);
        c.setLagrangeParentMap(gen.lagrangeParentMap);
        c.setAllEntitiesAdded(gen.allNameableEntitiesAdded);
        c.setLeavePickedNameUnused(true);
        NameAssigner namer = new NameAssigner(c);
        if (withSpecialNames) {
            namer.setSpecialNamesProbability(1.0f);
        } else {
            namer.setSpecialNamesProbability(0.0f);
        }
        namer.setRenameSystem(false);
        namer.setStructuralNameOffset(nameOffset);
        namer.assignNames(null, null);
        for (SectorEntityToken entity : gen.allNameableEntitiesAdded.keySet()) {
            if (!(entity instanceof PlanetAPI) || entity.getMarket() == null) continue;
            entity.getMarket().setName(entity.getName());
        }
        return result.orbitalWidth * 0.5f;
    }

    public static void addSystemwideNebula(StarSystemAPI system, StarAge age) {
        CustomConstellationParams p = new CustomConstellationParams(age);
        p.forceNebula = true;
        StarSystemGenerator gen = new StarSystemGenerator(p);
        gen.system = system;
        gen.starData = (StarGenDataSpec)Global.getSettings().getSpec(StarGenDataSpec.class, system.getStar().getSpec().getPlanetType(), false);
        gen.starAge = age;
        gen.constellationAge = age;
        gen.starAgeData = (AgeGenDataSpec)Global.getSettings().getSpec(AgeGenDataSpec.class, age.name(), true);
        gen.pickNebulaAndBackground();
        if (system.getType() != null) {
            gen.systemType = system.getType();
        }
        gen.addSystemwideNebula();
        system.setAge(age);
        system.setHasSystemwideNebula(true);
    }

    protected void addSystemwideNebula() {
        if (this.nebulaType.equals(NEBULA_NONE)) {
            return;
        }
        int w = 128;
        int h = 128;
        StringBuilder string = new StringBuilder();
        int y = h - 1;
        while (y >= 0) {
            int x = 0;
            while (x < w) {
                string.append("x");
                ++x;
            }
            --y;
        }
        SectorEntityToken nebula = this.system.addTerrain(NEBULA_DEFAULT, new BaseTiledTerrain.TileParams(string.toString(), w, h, "terrain", this.nebulaType, 4, 4, null));
        nebula.getLocation().set(0.0f, 0.0f);
        NebulaTerrainPlugin nebulaPlugin = (NebulaTerrainPlugin)((CampaignTerrainAPI)nebula).getPlugin();
        NebulaEditor editor = new NebulaEditor(nebulaPlugin);
        editor.regenNoise();
        editor.noisePrune(this.starAgeData.getNebulaDensity());
        editor.regenNoise();
        if (this.systemType != StarSystemType.NEBULA) {
            for (PlanetAPI planet : this.system.getPlanets()) {
                if (planet.getOrbit() != null && planet.getOrbit().getFocus() != null && planet.getOrbit().getFocus().getOrbit() != null) continue;
                float clearThreshold = 0.0f;
                float clearInnerRadius = 0.0f;
                float clearOuterRadius = 0.0f;
                Vector2f clearLoc = null;
                if (!planet.isStar() && !planet.isGasGiant() && (clearThreshold = 1.0f - Math.min(0.0f, planet.getRadius() / 300.0f)) > 0.5f) {
                    clearThreshold = 0.5f;
                }
                Vector2f loc = planet.getLocation();
                if (planet.getOrbit() != null && planet.getOrbit().getFocus() != null) {
                    Vector2f focusLoc = planet.getOrbit().getFocus().getLocation();
                    float dist = Misc.getDistance(planet.getOrbit().getFocus().getLocation(), loc);
                    float width = planet.getRadius() * 4.0f + 100.0f;
                    if (planet.isStar()) {
                        PulsarBeamTerrainPlugin pulsar;
                        StarCoronaTerrainPlugin corona = Misc.getCoronaFor(planet);
                        if (corona != null) {
                            width = corona.getParams().bandWidthInEngine * 4.0f;
                        }
                        if ((pulsar = Misc.getPulsarFor(planet)) != null) {
                            width = Math.max(width, pulsar.getParams().bandWidthInEngine * 0.5f);
                        }
                    }
                    clearLoc = focusLoc;
                    clearInnerRadius = dist - width / 2.0f;
                    clearOuterRadius = dist + width / 2.0f;
                } else if (planet.getOrbit() == null) {
                    float width = planet.getRadius() * 4.0f + 100.0f;
                    if (planet.isStar()) {
                        PulsarBeamTerrainPlugin pulsar;
                        StarCoronaTerrainPlugin corona = Misc.getCoronaFor(planet);
                        if (corona != null) {
                            width = corona.getParams().bandWidthInEngine * 4.0f;
                        }
                        if ((pulsar = Misc.getPulsarFor(planet)) != null) {
                            width = Math.max(width, pulsar.getParams().bandWidthInEngine * 0.5f);
                        }
                    }
                    clearLoc = loc;
                    clearInnerRadius = 0.0f;
                    clearOuterRadius = width;
                }
                if (clearLoc == null) continue;
                float min = nebulaPlugin.getTileSize() * 2.0f;
                if (clearOuterRadius - clearInnerRadius < min) {
                    clearOuterRadius = clearInnerRadius + min;
                }
                editor.clearArc(clearLoc.x, clearLoc.y, clearInnerRadius, clearOuterRadius, 0.0f, 360.0f, clearThreshold);
            }
        }
        float angleOffset = random.nextFloat() * 360.0f;
        editor.clearArc(0.0f, 0.0f, 30000.0f, 31000.0f + 1000.0f * random.nextFloat(), angleOffset + 0.0f, angleOffset + 360.0f * (2.0f + random.nextFloat() * 2.0f), 0.01f, 0.0f);
        int numArcs = (int)(8.0f + 6.0f * random.nextFloat());
        int i = 0;
        while (i < numArcs) {
            float dist = 15000.0f + 15000.0f * random.nextFloat();
            float angle = random.nextFloat() * 360.0f;
            Vector2f dir = Misc.getUnitVectorAtDegreeAngle(angle);
            dir.scale(dist - (2000.0f + 8000.0f * random.nextFloat()));
            float width = 800.0f * (1.0f + 2.0f * random.nextFloat());
            float clearThreshold = 0.0f + 0.5f * random.nextFloat();
            editor.clearArc(dir.x, dir.y, dist - width / 2.0f, dist + width / 2.0f, 0.0f, 360.0f, clearThreshold);
            ++i;
        }
    }

    protected GenResult addPlanetsAndTerrain(float maxOrbitRadius) {
        float max;
        boolean hasOrbits;
        boolean bl = hasOrbits = random.nextFloat() < this.starData.getProbOrbits();
        if (!hasOrbits) {
            return null;
        }
        float min = this.starData.getMinOrbits() + this.starAgeData.getMinExtraOrbits();
        int numOrbits = Math.round(StarSystemGenerator.getNormalRandom(min, max = this.starData.getMaxOrbits() + this.starAgeData.getMaxExtraOrbits()));
        if (numOrbits <= 0) {
            return null;
        }
        float currentRadius = this.centerRadius + 750.0f + 500.0f * random.nextFloat();
        GenContext context = new GenContext(this, this.system, this.systemCenter, this.starData, null, 0, this.starAge.name(), currentRadius, maxOrbitRadius, null, -1);
        if (this.systemType == StarSystemType.BINARY_CLOSE || this.systemType == StarSystemType.TRINARY_1CLOSE_1FAR) {
            context.multipliers.add(COL_BINARY);
        }
        if (this.systemType == StarSystemType.TRINARY_2CLOSE) {
            context.multipliers.add(COL_TRINARY);
        }
        GenResult result = this.addOrbitingEntities(context, numOrbits, false, true, false, true);
        result.context = context;
        return result;
    }

    protected GenResult addOrbitingEntities(GenContext context, int numOrbits, boolean addingMoons, boolean addMoons, boolean parentIsMoon, boolean nothingOk) {
        if (DEBUG && context.starData != null) {
            if (addingMoons && context.parent != null) {
                System.out.println("  Adding " + numOrbits + " moon orbits around " + context.parent.getSpec().getPlanetType());
            } else {
                System.out.println("Adding " + numOrbits + " orbits around " + context.starData.getId());
            }
        }
        float currentRadius = context.currentRadius;
        float lastIncrementExtra = 0.0f;
        String extraMult = null;
        if (parentIsMoon) {
            extraMult = COL_IS_MOON;
        }
        int extra = 0;
        int i = 0;
        while (i < numOrbits) {
            context.orbitIndex = i + context.startingOrbitIndex + extra;
            CategoryGenDataSpec categoryData = this.pickCategory(context, extraMult, nothingOk);
            nothingOk = true;
            GenResult result = null;
            float incrMult = 1.0f;
            if (categoryData != null && !CAT_NOTHING.equals(categoryData.getCategory())) {
                WeightedRandomPicker<EntityGenDataSpec> picker = this.getPickerForCategory(categoryData, context, extraMult);
                if (DEBUG) {
                    picker.print("  Picking from category " + categoryData.getCategory() + ", orbit index " + (context.parent != null ? context.parentOrbitIndex : context.orbitIndex));
                }
                EntityGenDataSpec entityData = picker.pick();
                if (DEBUG) {
                    if (entityData == null) {
                        System.out.println("  Nothing to pick");
                        System.out.println();
                    } else {
                        System.out.println("  Picked: " + entityData.getId());
                        System.out.println();
                    }
                }
                context.currentRadius = currentRadius;
                if (entityData instanceof PlanetGenDataSpec) {
                    PlanetGenDataSpec planetData = (PlanetGenDataSpec)entityData;
                    result = this.addPlanet(context, planetData, addingMoons, addMoons);
                } else if (entityData instanceof TerrainGenDataSpec) {
                    TerrainGenDataSpec terrainData = (TerrainGenDataSpec)entityData;
                    result = this.addTerrain(context, terrainData);
                }
                if (result != null) {
                    for (SectorEntityToken curr : result.entities) {
                        if (context.lagrangeParent != null && !result.entities.isEmpty()) {
                            this.lagrangeParentMap.put(curr, context.lagrangeParent.planet);
                        }
                        this.allNameableEntitiesAdded.put(curr, result.entities);
                    }
                } else {
                    incrMult = 0.5f;
                }
            } else {
                incrMult = 0.5f;
            }
            float baseIncr = 800.0f;
            if (addingMoons) {
                baseIncr = 200.0f;
            }
            float increment = (baseIncr *= incrMult) + baseIncr * 0.5f * random.nextFloat();
            if (result != null) {
                if (result.orbitalWidth > 1000.0f) {
                    ++extra;
                }
                increment = Math.max(increment + Math.min(result.orbitalWidth, 300.0f), result.orbitalWidth + increment * 0.5f);
                if (result.onlyIncrementByWidth) {
                    increment = result.orbitalWidth;
                }
                lastIncrementExtra = Math.max(increment * 0.1f, increment - result.orbitalWidth);
            } else {
                lastIncrementExtra = increment;
            }
            if ((currentRadius += increment) >= context.maxOrbitRadius) break;
            ++i;
        }
        GenResult result = new GenResult();
        result.onlyIncrementByWidth = false;
        result.orbitalWidth = (currentRadius - lastIncrementExtra) * 2.0f;
        return result;
    }

    protected GenResult addTerrain(GenContext context, TerrainGenDataSpec terrainData) {
        TerrainGenPlugin plugin = StarSystemGenerator.pickTerrainGenPlugin(terrainData, context);
        if (plugin == null) {
            return null;
        }
        GenResult result = plugin.generate(terrainData, context);
        return result;
    }

    public GenResult addPlanet(GenContext context, PlanetGenDataSpec planetData, boolean isMoon, boolean addMoons) {
        PlanetAPI planet;
        float radius = StarSystemGenerator.getRadius(planetData.getMinRadius(), planetData.getMaxRadius());
        if (isMoon) {
            float max;
            float mult = 0.2f + random.nextFloat() * 0.55f;
            if ((radius *= mult) < 60.0f) {
                radius = 60.0f;
            }
            float parentRadius = 100000.0f;
            if (context.parent != null || context.lagrangeParent != null) {
                PlanetAPI parent = context.parent;
                if (context.lagrangeParent != null) {
                    parent = context.lagrangeParent.planet;
                }
                parentRadius = parent.getRadius();
            }
            if (context.parentRadiusOverride > 0.0f) {
                parentRadius = context.parentRadiusOverride;
            }
            if (parentRadius > 181.81818f && radius > (max = parentRadius * 0.33f)) {
                radius = max;
            }
        }
        float orbitRadius = context.currentRadius + radius;
        float orbitDays = orbitRadius / (20.0f + random.nextFloat() * 5.0f);
        String planetId = String.valueOf(context.center.getId()) + ":planet_" + context.orbitIndex;
        String planetName = "Planet " + context.orbitIndex;
        if (context.parent != null) {
            planetId = String.valueOf(this.system.getId()) + "_moon_" + context.center.getId() + "_" + context.parent.getId() + "_" + context.orbitIndex;
            planetName = String.valueOf(context.parent.getName()) + " moon " + context.orbitIndex;
        }
        String planetType = planetData.getId();
        SectorEntityToken parent = context.center;
        if (context.parent != null) {
            parent = context.parent;
        }
        float angle = random.nextFloat() * 360.0f;
        if (context.parentCategory == null && context.lagrangeParent != null && context.lagrangePointType != null) {
            orbitRadius = context.lagrangeParent.orbitRadius;
            orbitDays = context.lagrangeParent.orbitDays;
            float angleOffset = -60.0f;
            if (context.lagrangePointType == LagrangePointType.L5) {
                angleOffset = 60.0f;
            }
            angle = context.lagrangeParent.orbitAngle + angleOffset;
            planetName = String.valueOf(planetName) + " " + context.lagrangePointType.name();
            planetId = String.valueOf(planetId) + "_" + context.lagrangePointType.name();
        }
        if ((planet = this.system.addPlanet(planetId, parent, planetName, planetType, angle, radius, orbitRadius, orbitDays)).isGasGiant() && this.systemType == StarSystemType.NEBULA) {
            planet.setAutogenJumpPointNameInHyper(String.valueOf(this.system.getBaseName()) + ", " + planetName + " Gravity Well");
        }
        float radiusWithMoons = planet.getRadius();
        if (addMoons) {
            boolean hasOrbits = random.nextFloat() < planetData.getProbOrbits();
            float min = planetData.getMinOrbits();
            float max = planetData.getMaxOrbits();
            int numOrbits = Math.round(StarSystemGenerator.getNormalRandom(min, max));
            if (hasOrbits && numOrbits > 0) {
                float startingRadius = planet.getRadius() + 300.0f + 100.0f * random.nextFloat();
                GenContext moonContext = new GenContext(this, context.system, context.center, context.starData, planet, 0, this.starAge.name(), startingRadius, context.maxOrbitRadius, planetData.getCategory(), context.orbitIndex);
                moonContext.excludeCategories.addAll(context.excludeCategories);
                moonContext.multipliers.addAll(context.multipliers);
                GenResult moonResult = this.addOrbitingEntities(moonContext, numOrbits, true, false, false, false);
                context.generatedPlanets.addAll(moonContext.generatedPlanets);
                radius = moonResult.orbitalWidth * 0.5f;
                orbitRadius = context.currentRadius + radius;
                orbitDays = orbitRadius / (20.0f + random.nextFloat() * 5.0f);
                radiusWithMoons = radius;
                planet.setOrbit(Global.getFactory().createCircularOrbit(context.center, angle, orbitRadius, orbitDays));
            }
        } else if (isMoon) {
            float startingRadius = planet.getRadius() + 300.0f + 100.0f * random.nextFloat();
            GenContext moonContext = new GenContext(this, context.system, context.center, context.starData, planet, 0, this.starAge.name(), startingRadius, context.maxOrbitRadius, planetData.getCategory(), context.orbitIndex);
            moonContext.excludeCategories.addAll(context.excludeCategories);
            moonContext.multipliers.addAll(context.multipliers);
            GenResult moonResult = this.addOrbitingEntities(moonContext, 1, true, false, true, true);
            context.generatedPlanets.addAll(moonContext.generatedPlanets);
        }
        Color color = StarSystemGenerator.getColor(planetData.getMinColor(), planetData.getMaxColor());
        planet.getSpec().setPlanetColor(color);
        if (planet.getSpec().getAtmosphereThickness() > 0.0f) {
            Color atmosphereColor = Misc.interpolateColor(planet.getSpec().getAtmosphereColor(), color, 0.25f);
            atmosphereColor = Misc.setAlpha(atmosphereColor, planet.getSpec().getAtmosphereColor().getAlpha());
            planet.getSpec().setAtmosphereColor(atmosphereColor);
            if (planet.getSpec().getCloudTexture() != null) {
                Color cloudColor = Misc.interpolateColor(planet.getSpec().getCloudColor(), color, 0.25f);
                cloudColor = Misc.setAlpha(cloudColor, planet.getSpec().getCloudColor().getAlpha());
                planet.getSpec().setAtmosphereColor(atmosphereColor);
            }
        }
        float tilt = planet.getSpec().getTilt();
        float pitch = planet.getSpec().getPitch();
        float sign = Math.signum(random.nextFloat() - 0.5f);
        double r = random.nextFloat();
        tilt = sign > 0.0f ? (float)((double)tilt + r * 45.0) : (float)((double)tilt + r * -45.0);
        sign = Math.signum(random.nextFloat() - 0.5f);
        r = random.nextFloat();
        if (sign > 0.0f) {
            pitch = (float)((double)pitch + r * 45.0);
        } else {
            tilt = (float)((double)tilt + r * -15.0);
        }
        planet.getSpec().setTilt(tilt);
        planet.getSpec().setPitch(pitch);
        if (context.orbitIndex == 0 && context.parent == null && (float)context.orbitIndex < context.starData.getHabZoneStart() && orbitRadius < 1500.0f + context.starData.getHabZoneStart() * 200.0f && planet.getSpec().getAtmosphereThickness() > 0.0f) {
            WeightedRandomPicker<String> glowPicker = new WeightedRandomPicker<String>(random);
            glowPicker.add("banded", 10.0f);
            glowPicker.add("aurorae", 10.0f);
            String glow = (String)glowPicker.pick();
            planet.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", glow));
            if (context.center instanceof PlanetAPI) {
                planet.getSpec().setGlowColor(((PlanetAPI)context.center).getSpec().getCoronaColor());
            }
            planet.getSpec().setUseReverseLightForGlow(true);
            planet.getSpec().setAtmosphereThickness(0.5f);
            planet.getSpec().setCloudRotation(planet.getSpec().getCloudRotation() * (-1.0f - 2.0f * random.nextFloat()));
            if (planet.isGasGiant()) {
                this.system.addCorona(planet, "corona_aka_mainyu", 300.0f + 200.0f * random.nextFloat(), 5.0f, 0.0f, 1.0f);
            }
        }
        planet.applySpecChanges();
        PlanetConditionGenerator.generateConditionsForPlanet(context, planet);
        GeneratedPlanet generatedPlanetData = new GeneratedPlanet(parent, planet, isMoon, orbitDays, orbitRadius, angle);
        context.generatedPlanets.add(generatedPlanetData);
        if (!isMoon && context.lagrangeParent == null) {
            this.addStuffAtLagrangePoints(context, generatedPlanetData);
        }
        GenResult result = new GenResult();
        result.orbitalWidth = radius * 2.0f;
        result.onlyIncrementByWidth = false;
        result.entities.add(planet);
        return result;
    }

    protected void addStuffAtLagrangePoints(GenContext context, GeneratedPlanet planet) {
        float radius = planet.planet.getRadius();
        float probability = radius / 500.0f;
        if (radius < 150.0f) {
            probability = 0.0f;
        }
        if (planet.planet.isGasGiant()) {
            probability = 1.0f;
        }
        if (random.nextFloat() > probability) {
            return;
        }
        EnumSet<LagrangePointType> points = EnumSet.of(LagrangePointType.L4, LagrangePointType.L5);
        for (LagrangePointType point : points) {
            CategoryGenDataSpec categoryData = this.pickCategory(context, COL_LAGRANGE, true);
            if (categoryData == null || CAT_NOTHING.equals(categoryData.getCategory())) continue;
            WeightedRandomPicker<EntityGenDataSpec> picker = this.getPickerForCategory(categoryData, context, COL_LAGRANGE);
            if (DEBUG) {
                picker.print("  Picking from category " + categoryData.getCategory() + ", orbit index " + (context.parent != null ? Integer.valueOf(context.parentOrbitIndex) : String.valueOf(context.orbitIndex) + ", for lagrange point"));
            }
            EntityGenDataSpec entityData = picker.pick();
            if (DEBUG) {
                if (entityData == null) {
                    System.out.println("  Nothing to pick");
                    System.out.println();
                } else {
                    System.out.println("  Picked: " + entityData.getId());
                    System.out.println();
                }
            }
            context.lagrangeParent = planet;
            context.lagrangePointType = point;
            GenResult result = null;
            if (entityData instanceof PlanetGenDataSpec) {
                PlanetGenDataSpec planetData = (PlanetGenDataSpec)entityData;
                result = this.addPlanet(context, planetData, true, true);
            } else if (entityData instanceof TerrainGenDataSpec) {
                TerrainGenDataSpec terrainData = (TerrainGenDataSpec)entityData;
                result = this.addTerrain(context, terrainData);
            }
            if (result == null) continue;
            for (SectorEntityToken curr : result.entities) {
                if (context.lagrangeParent != null && !result.entities.isEmpty()) {
                    this.lagrangeParentMap.put(curr, context.lagrangeParent.planet);
                }
                this.allNameableEntitiesAdded.put(curr, result.entities);
            }
        }
        context.lagrangeParent = null;
        context.lagrangePointType = null;
    }

    public CategoryGenDataSpec pickCategory(GenContext context, String extraMult, boolean nothingOk) {
        PlanetAPI star;
        String age = context.age;
        String starType = this.star.getTypeId();
        if (context.center instanceof PlanetAPI && (star = (PlanetAPI)context.center).isStar()) {
            starType = star.getTypeId();
        }
        String parentCategory = context.parentCategory;
        WeightedRandomPicker<CategoryGenDataSpec> picker = new WeightedRandomPicker<CategoryGenDataSpec>(random);
        Collection<CategoryGenDataSpec> categoryDataSpecs = Global.getSettings().getAllSpecs(CategoryGenDataSpec.class);
        for (CategoryGenDataSpec categoryData : categoryDataSpecs) {
            if (context.excludeCategories.contains(categoryData.getCategory())) continue;
            boolean catNothing = categoryData.getCategory().equals(CAT_NOTHING);
            if (!nothingOk && catNothing) continue;
            float weight = categoryData.getFrequency();
            if (age != null) {
                weight *= categoryData.getMultiplier(age);
            }
            if (starType != null) {
                weight *= categoryData.getMultiplier(starType);
            }
            if (parentCategory != null) {
                weight *= categoryData.getMultiplier(parentCategory);
            }
            for (String col : context.multipliers) {
                weight *= categoryData.getMultiplier(col);
            }
            if (extraMult != null) {
                weight *= categoryData.getMultiplier(extraMult);
            }
            if (!(weight > 0.0f) || !catNothing && this.isCategoryEmpty(categoryData, context, extraMult, nothingOk)) continue;
            picker.add(categoryData, weight);
        }
        if (DEBUG) {
            boolean withParent = context.parent != null;
            int orbitIndex = context.orbitIndex;
            String parentType = "";
            if (withParent) {
                parentType = context.parent.getSpec().getPlanetType();
                orbitIndex = context.parentOrbitIndex;
            }
            int habDiff = orbitIndex - (int)context.starData.getHabZoneStart();
            if (withParent) {
                picker.print("  Picking category for moon of " + parentType + ", orbit from star: " + orbitIndex + " (" + habDiff + ")" + ", extra: " + extraMult);
            } else {
                picker.print("  Picking category for entity orbiting star " + starType + ", orbit from star: " + orbitIndex + " (" + habDiff + ")" + ", extra: " + extraMult);
            }
        }
        CategoryGenDataSpec pick = (CategoryGenDataSpec)picker.pick();
        if (DEBUG) {
            System.out.println("  Picked: " + pick.getCategory());
            System.out.println();
        }
        return pick;
    }

    public boolean isCategoryEmpty(CategoryGenDataSpec categoryData, GenContext context, String extraMult, boolean nothingOk) {
        return this.getPickerForCategory(categoryData, context, extraMult, nothingOk).isEmpty();
    }

    protected float getHabOffset(EntityGenDataSpec data) {
        if (this.starAge == StarAge.YOUNG) {
            return data.getHabOffsetYOUNG();
        }
        if (this.starAge == StarAge.AVERAGE) {
            return data.getHabOffsetAVERAGE();
        }
        if (this.starAge == StarAge.OLD) {
            return data.getHabOffsetOLD();
        }
        return 0.0f;
    }

    protected WeightedRandomPicker<EntityGenDataSpec> getPickerForCategory(CategoryGenDataSpec categoryData, GenContext context, String extraMult) {
        return this.getPickerForCategory(categoryData, context, extraMult, true);
    }

    protected WeightedRandomPicker<EntityGenDataSpec> getPickerForCategory(CategoryGenDataSpec categoryData, GenContext context, String extraMult, boolean nothingOk) {
        PlanetAPI star;
        int orbitIndex = context.orbitIndex;
        if (context.parentOrbitIndex >= 0) {
            orbitIndex = context.parentOrbitIndex;
        }
        int fromParentOrbitIndex = context.orbitIndex;
        String age = context.age;
        String starType = this.star.getTypeId();
        if (context.center instanceof PlanetAPI && (star = (PlanetAPI)context.center).isStar()) {
            starType = star.getTypeId();
        }
        String parentCategory = context.parentCategory;
        WeightedRandomPicker<EntityGenDataSpec> picker = new WeightedRandomPicker<EntityGenDataSpec>(random);
        Collection<PlanetGenDataSpec> planetDataSpecs = Global.getSettings().getAllSpecs(PlanetGenDataSpec.class);
        for (PlanetGenDataSpec planetData : planetDataSpecs) {
            boolean lagrangeStatusOk;
            boolean orbitIndexOk;
            boolean giantMoonException;
            if (!planetData.getCategory().equals(categoryData.getCategory())) continue;
            float offset = this.getHabOffset(planetData);
            float minIndex = context.starData.getHabZoneStart() + planetData.getHabOffsetMin() + offset;
            float maxIndex = context.starData.getHabZoneStart() + planetData.getHabOffsetMax() + offset;
            boolean inRightRange = (float)orbitIndex >= minIndex && (float)orbitIndex <= maxIndex;
            boolean bl = giantMoonException = CAT_GIANT.equals(parentCategory) && planetData.hasTag(TAG_GIANT_MOON) && context.parent != null && context.parent.isGasGiant();
            if (!inRightRange && !giantMoonException) continue;
            boolean bl2 = orbitIndexOk = fromParentOrbitIndex == 0 || !planetData.hasTag(TAG_FIRST_ORBIT_ONLY);
            if (!orbitIndexOk) continue;
            boolean bl3 = lagrangeStatusOk = COL_LAGRANGE.equals(extraMult) || !planetData.hasTag(TAG_LAGRANGE_ONLY);
            if (!lagrangeStatusOk) continue;
            boolean nebulaStatusOk = NEBULA_NONE.equals(this.nebulaType) || !planetData.hasTag(TAG_NOT_IN_NEBULA);
            nebulaStatusOk &= !NEBULA_NONE.equals(this.nebulaType) || !planetData.hasTag(TAG_REQUIRES_NEBULA);
            if (!(nebulaStatusOk &= this.systemType != StarSystemType.NEBULA || !planetData.hasTag(TAG_NOT_NEBULA_UNLESS_MOON) || context.parent != null)) continue;
            float weight = planetData.getFrequency();
            if (age != null) {
                weight *= planetData.getMultiplier(age);
            }
            if (starType != null) {
                weight *= planetData.getMultiplier(starType);
            }
            if (parentCategory != null) {
                weight *= planetData.getMultiplier(parentCategory);
            }
            for (String col : context.multipliers) {
                weight *= planetData.getMultiplier(col);
            }
            if (extraMult != null) {
                weight *= planetData.getMultiplier(extraMult);
            }
            if (!(weight > 0.0f)) continue;
            picker.add(planetData, weight);
        }
        Collection<TerrainGenDataSpec> terrainDataSpecs = Global.getSettings().getAllSpecs(TerrainGenDataSpec.class);
        for (TerrainGenDataSpec terrainData : terrainDataSpecs) {
            boolean lagrangeStatusOk;
            boolean orbitIndexOk;
            boolean giantMoonException;
            if (!terrainData.getCategory().equals(categoryData.getCategory()) || !nothingOk && terrainData.getId().equals("rings_nothing")) continue;
            float offset = this.getHabOffset(terrainData);
            float minIndex = context.starData.getHabZoneStart() + terrainData.getHabOffsetMin() + offset;
            float maxIndex = context.starData.getHabZoneStart() + terrainData.getHabOffsetMax() + offset;
            boolean inRightRange = (float)orbitIndex >= minIndex && (float)orbitIndex <= maxIndex;
            boolean bl = giantMoonException = CAT_GIANT.equals(parentCategory) && terrainData.hasTag(TAG_GIANT_MOON) && context.parent != null && context.parent.isGasGiant();
            if (!inRightRange && !giantMoonException) continue;
            boolean bl4 = orbitIndexOk = fromParentOrbitIndex == 0 || !terrainData.hasTag(TAG_FIRST_ORBIT_ONLY);
            if (!orbitIndexOk) continue;
            boolean bl5 = lagrangeStatusOk = COL_LAGRANGE.equals(extraMult) || !terrainData.hasTag(TAG_LAGRANGE_ONLY);
            if (!lagrangeStatusOk) continue;
            boolean nebulaStatusOk = NEBULA_NONE.equals(this.nebulaType) || !terrainData.hasTag(TAG_NOT_IN_NEBULA);
            nebulaStatusOk &= !NEBULA_NONE.equals(this.nebulaType) || !terrainData.hasTag(TAG_REQUIRES_NEBULA);
            if (!(nebulaStatusOk &= this.systemType != StarSystemType.NEBULA || !terrainData.hasTag(TAG_NOT_NEBULA_UNLESS_MOON) || context.parent != null)) continue;
            float weight = terrainData.getFrequency();
            if (age != null) {
                weight *= terrainData.getMultiplier(age);
            }
            if (starType != null) {
                weight *= terrainData.getMultiplier(starType);
            }
            if (parentCategory != null) {
                weight *= terrainData.getMultiplier(parentCategory);
            }
            for (String col : context.multipliers) {
                weight *= terrainData.getMultiplier(col);
            }
            if (extraMult != null) {
                weight *= terrainData.getMultiplier(extraMult);
            }
            if (!(weight > 0.0f)) continue;
            picker.add(terrainData, weight);
        }
        return picker;
    }

    protected void setDefaultLightColorBasedOnStars() {
        Color one = Color.white;
        Color two = null;
        Color three = null;
        switch (this.systemType) {
            case SINGLE: 
            case BINARY_FAR: 
            case TRINARY_2FAR: 
            case NEBULA: {
                one = this.pickLightColorForStar(this.star);
                break;
            }
            case BINARY_CLOSE: 
            case TRINARY_1CLOSE_1FAR: {
                one = this.pickLightColorForStar(this.star);
                two = this.pickLightColorForStar(this.secondary);
                break;
            }
            case TRINARY_2CLOSE: {
                one = this.pickLightColorForStar(this.star);
                two = this.pickLightColorForStar(this.secondary);
                three = this.pickLightColorForStar(this.tertiary);
            }
        }
        Color result = one;
        if (two != null && three == null) {
            result = Misc.interpolateColor(one, two, 0.5f);
        } else if (two != null && three != null) {
            result = Misc.interpolateColor(one, two, 0.5f);
            result = Misc.interpolateColor(result, three, 0.5f);
        }
        this.system.setLightColor(result);
    }

    protected Color pickLightColorForStar(PlanetAPI star) {
        StarGenDataSpec starData = (StarGenDataSpec)Global.getSettings().getSpec(StarGenDataSpec.class, star.getSpec().getPlanetType(), false);
        Color min = starData.getLightColorMin();
        Color max = starData.getLightColorMax();
        Color lightColor = Misc.interpolateColor(min, max, random.nextFloat());
        return lightColor;
    }

    protected PlanetAPI addRandomStar(String id, String name) {
        PlanetSpecAPI starSpec = this.pickStar(this.constellationAge);
        if (starSpec == null) {
            return null;
        }
        StarGenDataSpec starData = (StarGenDataSpec)Global.getSettings().getSpec(StarGenDataSpec.class, starSpec.getPlanetType(), false);
        float radius = StarSystemGenerator.getRadius(starData.getMinRadius(), starData.getMaxRadius());
        float corona = radius * (starData.getCoronaMult() + starData.getCoronaVar() * (random.nextFloat() - 0.5f));
        if (corona < starData.getCoronaMin()) {
            corona = starData.getCoronaMin();
        }
        PlanetAPI star = this.system.addPlanet(id, null, name, starSpec.getPlanetType(), 0.0f, radius, 10000.0f, 1000.0f);
        this.system.addCorona(star, corona, starData.getSolarWind(), starData.getMinFlare() + (starData.getMaxFlare() - starData.getMinFlare()) * random.nextFloat(), starData.getCrLossMult());
        return star;
    }

    protected boolean initSystem(String name, Vector2f loc) {
        this.sector = Global.getSector();
        this.system = this.sector.createStarSystem(name);
        this.system.setProcgen(true);
        this.system.setType(this.systemType);
        this.system.getLocation().set((ReadableVector2f)loc);
        this.hyper = Global.getSector().getHyperspace();
        this.system.setBackgroundTextureFilename(this.backgroundName);
        return true;
    }

    protected void updateAgeAfterPickingStar() {
        this.starAge = this.starData.getAge();
        if (this.starAge == StarAge.ANY) {
            this.starAge = this.constellationAge;
        }
        this.starAgeData = (AgeGenDataSpec)Global.getSettings().getSpec(AgeGenDataSpec.class, this.starAge.name(), true);
    }

    protected void cleanup() {
        if (this.system != null) {
            Global.getSector().removeStarSystem(this.system);
            this.system = null;
        }
    }

    public String getNebulaType() {
        return this.nebulaType;
    }

    public StarAge getConstellationAge() {
        return this.constellationAge;
    }

    public StarAge getStarAge() {
        return this.starAge;
    }

    public PlanetSpecAPI pickStar(StarAge age) {
        if (this.params != null && !this.params.starTypes.isEmpty()) {
            String id = this.params.starTypes.remove(0);
            for (PlanetSpecAPI spec : Global.getSettings().getAllPlanetSpecs()) {
                boolean nebulaStatusOk;
                Object test;
                if (!spec.getPlanetType().equals(id) || (test = Global.getSettings().getSpec(StarGenDataSpec.class, id, true)) == null) continue;
                StarGenDataSpec data = (StarGenDataSpec)test;
                boolean hasTag = data.hasTag(StarSystemType.NEBULA.name());
                boolean nebType = this.systemType == StarSystemType.NEBULA;
                boolean bl = nebulaStatusOk = hasTag == nebType;
                if (!nebulaStatusOk) continue;
                return spec;
            }
        }
        WeightedRandomPicker<PlanetSpecAPI> picker = new WeightedRandomPicker<PlanetSpecAPI>(random);
        for (PlanetSpecAPI spec : Global.getSettings().getAllPlanetSpecs()) {
            boolean nebulaStatusOk;
            if (!spec.isStar()) continue;
            String id = spec.getPlanetType();
            Object test = Global.getSettings().getSpec(StarGenDataSpec.class, id, true);
            if (test == null) continue;
            StarGenDataSpec data = (StarGenDataSpec)test;
            boolean hasTag = data.hasTag(StarSystemType.NEBULA.name());
            boolean nebType = this.systemType == StarSystemType.NEBULA;
            boolean bl = nebulaStatusOk = hasTag == nebType;
            if (!nebulaStatusOk) continue;
            float freq = 0.0f;
            switch (age) {
                case AVERAGE: {
                    freq = data.getFreqAVERAGE();
                    break;
                }
                case OLD: {
                    freq = data.getFreqOLD();
                    break;
                }
                case YOUNG: {
                    freq = data.getFreqYOUNG();
                }
            }
            picker.add(spec, freq);
        }
        return (PlanetSpecAPI)picker.pick();
    }

    public static Color getColor(Color min, Color max) {
        Color color = new Color((int)((double)min.getRed() + (double)(max.getRed() - min.getRed()) * random.nextDouble()), (int)((double)min.getGreen() + (double)(max.getGreen() - min.getGreen()) * random.nextDouble()), (int)((double)min.getBlue() + (double)(max.getBlue() - min.getBlue()) * random.nextDouble()), 255);
        return color;
    }

    public static float getNormalRandom(float min, float max) {
        return StarSystemGenerator.getNormalRandom(random, min, max);
    }

    public static float getNormalRandom(Random random, float min, float max) {
        double r = random.nextGaussian();
        r *= (double)0.2f;
        if ((r += 0.5) < 0.0) {
            r = 0.0;
        }
        if (r > 1.0) {
            r = 1.0;
        }
        return min + (float)r * (max - min);
    }

    public static float getRadius(float min, float max) {
        float radius = min + (max - min) * random.nextFloat();
        return radius;
    }

    public static float getRandom(float min, float max) {
        float radius = min + (max - min) * random.nextFloat();
        return radius;
    }

    public Map<SectorEntityToken, PlanetAPI> getLagrangeParentMap() {
        return this.lagrangeParentMap;
    }

    public Map<SectorEntityToken, List<SectorEntityToken>> getAllEntitiesAdded() {
        return this.allNameableEntitiesAdded;
    }

    public static FullName.Gender pickGender() {
        if (random.nextBoolean()) {
            return FullName.Gender.MALE;
        }
        return FullName.Gender.FEMALE;
    }

    public static class CustomConstellationParams
    implements Cloneable {
        public String name = null;
        public String secondaryName = null;
        public StarAge age = null;
        public int minStars = 0;
        public int maxStars = 0;
        public int numStars = 0;
        public boolean forceNebula = false;
        public List<StarSystemType> systemTypes = new ArrayList<StarSystemType>();
        public List<String> starTypes = new ArrayList<String>();
        public Vector2f location = null;

        public CustomConstellationParams(StarAge age) {
            this.age = age;
        }

        public CustomConstellationParams clone() {
            try {
                return (CustomConstellationParams)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    public static class GenContext {
        public StarSystemGenerator gen;
        public List<GeneratedPlanet> generatedPlanets = new ArrayList<GeneratedPlanet>();
        public Set<String> excludeCategories = new LinkedHashSet<String>();
        public StarSystemAPI system;
        public SectorEntityToken center;
        public StarGenDataSpec starData;
        public PlanetAPI parent;
        public int orbitIndex = -1;
        public int startingOrbitIndex = 0;
        public String age;
        public float currentRadius;
        public String parentCategory;
        public int parentOrbitIndex;
        public float parentRadiusOverride = -1.0f;
        public GeneratedPlanet lagrangeParent = null;
        public LagrangePointType lagrangePointType = null;
        public List<String> multipliers = new ArrayList<String>();
        public float maxOrbitRadius;
        public Map<Object, Object> customData = new LinkedHashMap<Object, Object>();

        public GenContext(StarSystemGenerator gen, StarSystemAPI system, SectorEntityToken center, StarGenDataSpec starData, PlanetAPI parent, int orbitIndex, String age, float currentRadius, float maxOrbitRadius, String parentCategory, int parentOrbitIndex) {
            this.maxOrbitRadius = maxOrbitRadius;
            this.gen = gen;
            this.system = system;
            this.center = center;
            this.starData = starData;
            this.parent = parent;
            this.startingOrbitIndex = orbitIndex;
            this.orbitIndex = 0;
            this.age = age;
            this.currentRadius = currentRadius;
            this.parentCategory = parentCategory;
            this.parentOrbitIndex = parentOrbitIndex;
        }
    }

    public static class GenResult {
        public float orbitalWidth;
        public boolean onlyIncrementByWidth = false;
        public List<SectorEntityToken> entities = new ArrayList<SectorEntityToken>();
        public GenContext context;
    }

    public static class GeneratedPlanet {
        public SectorEntityToken parent;
        public PlanetAPI planet;
        public float orbitDays;
        public float orbitRadius;
        public float orbitAngle;
        public boolean isMoon;

        public GeneratedPlanet(SectorEntityToken parent, PlanetAPI planet, boolean isMoon, float orbitDays, float orbitRadius, float orbitAngle) {
            this.parent = parent;
            this.planet = planet;
            this.isMoon = isMoon;
            this.orbitDays = orbitDays;
            this.orbitRadius = orbitRadius;
            this.orbitAngle = orbitAngle;
        }
    }

    public static class LagrangePoint {
        public GeneratedPlanet parent;
        public LagrangePointType type;

        public LagrangePoint(GeneratedPlanet parent, LagrangePointType type) {
            this.parent = parent;
            this.type = type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LagrangePointType {
        L4,
        L5;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StarSystemType {
        SINGLE,
        BINARY_CLOSE,
        BINARY_FAR,
        TRINARY_2CLOSE,
        TRINARY_1CLOSE_1FAR,
        TRINARY_2FAR,
        NEBULA;

    }
}

