/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.procgen;

import com.fs.starfarer.api.impl.campaign.procgen.EntityGenDataSpec;
import com.fs.starfarer.api.impl.campaign.procgen.StarGenDataSpec;
import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TerrainGenDataSpec
implements EntityGenDataSpec {
    private String id;
    private String category;
    private float frequency;
    private float habOffsetMin;
    private float habOffsetMax;
    private float minRadius;
    private float maxRadius;
    private float probOrbits;
    private float minOrbits;
    private float maxOrbits;
    private Color minColor;
    private Color maxColor;
    private float habOffsetYOUNG;
    private float habOffsetAVERAGE;
    private float habOffsetOLD;
    private Map<String, Float> multipliers = new HashMap<String, Float>();
    private Set<String> tags = new HashSet<String>();

    public TerrainGenDataSpec(JSONObject row) throws JSONException {
        this.id = row.getString("id");
        this.category = row.getString("category");
        this.frequency = (float)row.getDouble("frequency");
        this.habOffsetMin = (float)row.optDouble("habOffsetMin", -1000.0);
        this.habOffsetMax = (float)row.optDouble("habOffsetMax", 1000.0);
        this.minRadius = (float)row.optDouble("minRadius", 0.0);
        this.maxRadius = (float)row.optDouble("maxRadius", 0.0);
        this.habOffsetYOUNG = (float)row.optDouble("habOffsetYOUNG", 0.0);
        this.habOffsetAVERAGE = (float)row.optDouble("habOffsetAVERAGE", 0.0);
        this.habOffsetOLD = (float)row.optDouble("habOffsetOLD", 0.0);
        this.probOrbits = (float)row.optDouble("probOrbits", 0.0);
        this.minOrbits = (float)row.optDouble("minOrbits", 0.0);
        this.maxOrbits = (float)row.optDouble("maxOrbits", 0.0);
        String[] stringArray = JSONObject.getNames((JSONObject)row);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            float frequency = (float)row.optDouble(key, 1.0);
            if (frequency != 1.0f) {
                this.multipliers.put(key, Float.valueOf(frequency));
            }
            ++n2;
        }
        String tags = row.optString("tags", null);
        if (tags != null) {
            String[] split;
            String[] stringArray2 = split = tags.split(",");
            int n3 = split.length;
            int n4 = 0;
            while (n4 < n3) {
                String tag = stringArray2[n4];
                if (!(tag = tag.trim()).isEmpty()) {
                    this.addTag(tag);
                }
                ++n4;
            }
        }
        this.minColor = StarGenDataSpec.parseColor(String.valueOf(row.optString("minColor", null)) + " 255", " ");
        this.maxColor = StarGenDataSpec.parseColor(String.valueOf(row.optString("maxColor", null)) + " 255", " ");
    }

    public String toString() {
        return this.getId();
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    public float getFrequency() {
        return this.frequency;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public float getHabOffsetMin() {
        return this.habOffsetMin;
    }

    public float getHabOffsetMax() {
        return this.habOffsetMax;
    }

    public float getMinRadius() {
        return this.minRadius;
    }

    public float getMaxRadius() {
        return this.maxRadius;
    }

    public Color getMinColor() {
        return this.minColor;
    }

    public Color getMaxColor() {
        return this.maxColor;
    }

    public float getMultiplier(String key) {
        if (!this.multipliers.containsKey(key)) {
            return 1.0f;
        }
        return this.multipliers.get(key).floatValue();
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void addTag(String tag) {
        this.tags.add(tag);
    }

    public boolean hasTag(String tag) {
        return this.tags.contains(tag);
    }

    public Map<String, Float> getMultipliers() {
        return this.multipliers;
    }

    public float getProbOrbits() {
        return this.probOrbits;
    }

    public float getMinOrbits() {
        return this.minOrbits;
    }

    public float getMaxOrbits() {
        return this.maxOrbits;
    }

    @Override
    public float getHabOffsetYOUNG() {
        return this.habOffsetYOUNG;
    }

    @Override
    public float getHabOffsetAVERAGE() {
        return this.habOffsetAVERAGE;
    }

    @Override
    public float getHabOffsetOLD() {
        return this.habOffsetOLD;
    }
}

