/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.procgen.themes;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignTerrainAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.impl.campaign.DerelictShipEntityPlugin;
import com.fs.starfarer.api.impl.campaign.econ.impl.TechMining;
import com.fs.starfarer.api.impl.campaign.events.OfficerManagerEvent;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParamsV3;
import com.fs.starfarer.api.impl.campaign.intel.events.ht.HTPoints;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseThemeGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.DerelictThemeGenerator;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.BlueprintSpecial;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.BreadcrumbSpecial;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.CargoManifestSpecial;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.ShipRecoverySpecial;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.SleeperPodsSpecial;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.SurveyDataSpecial;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.TopographicDataSpecial;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.TransmitterTrapSpecial;
import com.fs.starfarer.api.impl.campaign.terrain.DebrisFieldTerrainPlugin;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SalvageSpecialAssigner {
    @Deprecated
    public static int MIN_PODS_OFFICER_LEVEL = Global.getSettings().getInt("minSleeperPodsOfficerLevel");
    @Deprecated
    public static int MAX_PODS_OFFICER_LEVEL = Global.getSettings().getInt("maxSleeperPodsOfficerLevel");
    public static int STANDARD_PODS_OFFICER_LEVEL = Global.getSettings().getInt("standardSleeperPodsOfficerLevel");
    public static int EXCEPTIONAL_PODS_OFFICER_LEVEL = Global.getSettings().getInt("exceptionalSleeperPodsOfficerLevel");
    public static int EXCEPTIONAL_PODS_OFFICER_ELITE_SKILLS = Global.getSettings().getInt("exceptionalSleeperPodsOfficerEliteSkills");
    public static int MAX_EXCEPTIONAL_PODS_OFFICERS = Global.getSettings().getInt("maxExceptionalSleeperPodsOfficers");
    public static float PROB_EXCEPTIONAL_PODS_OFFICER = Global.getSettings().getFloat("probSleeperPodsOfficerIsExceptional");
    public static int MAX_NORMAL_OFFICER_LEVEL = Global.getSettings().getInt("officerMaxLevel");
    protected static Random randomOverride = null;

    public static void assignSpecialForBattleWreck(SectorEntityToken entity) {
        Random random = StarSystemGenerator.random;
        WeightedRandomPicker<SpecialCreator> picker = new WeightedRandomPicker<SpecialCreator>(random);
        picker.add(new NothingSpecialCreator(), 10.0f);
        picker.add(new ShipRecoverySpecialCreator(random, 0, 0, false, null, null), 10.0f);
        SpecialCreator pick = (SpecialCreator)picker.pick();
        SpecialCreationContext context = new SpecialCreationContext();
        Object specialData = pick.createSpecial(entity, context);
        if (specialData != null) {
            Misc.setSalvageSpecial(entity, specialData);
        }
    }

    public static void assignSpecialForDistressDerelict(SectorEntityToken entity) {
        Random random = new Random();
        WeightedRandomPicker<SpecialCreator> picker = new WeightedRandomPicker<SpecialCreator>(random);
        DerelictShipEntityPlugin plugin = (DerelictShipEntityPlugin)entity.getCustomPlugin();
        ShipRecoverySpecial.PerShipData shipData = plugin.getData().ship;
        ShipVariantAPI variant = shipData.variant;
        if (variant == null && shipData.variantId != null) {
            variant = Global.getSettings().getVariant(shipData.variantId);
        }
        float p = variant.getHullSpec().getMaxCrew();
        float c = variant.getHullSpec().getCargo();
        WeightedRandomPicker<String> recoverableShipFactions = SalvageSpecialAssigner.getNearbyFactions(random, entity);
        if (entity.getContainingLocation().hasTag("theme_remnant")) {
            recoverableShipFactions = Misc.createStringPicker(random, "tritachyon", Float.valueOf(10.0f), "hegemony", Float.valueOf(7.0f), "independent", Float.valueOf(3.0f));
        }
        WeightedRandomPicker<String> officerFactions = recoverableShipFactions;
        WeightedRandomPicker<String> valuableCargo = SalvageSpecialAssigner.getValuableCargo(random);
        picker.add(new NothingSpecialCreator(), 10.0f);
        picker.add(new ShipRecoverySpecialCreator(random, 0, 0, false, null, null), 30.0f);
        picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.MARINES, p * 0.125f, p * 0.25f, null), 2.0f);
        picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.CREW, p * 0.25f, p * 0.5f, null), 20.0f);
        picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.OFFICER, STANDARD_PODS_OFFICER_LEVEL, EXCEPTIONAL_PODS_OFFICER_LEVEL, officerFactions), 15.0f);
        picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.ADMIN, 1.0f, 1.0f, officerFactions), 2.0f);
        picker.add(new CargoManifestSpecialCreator(random, valuableCargo, c * 0.25f, c * 0.5f), 10.0f);
        picker.add(new SurveyDataSpecialCreator(random, SurveyDataSpecial.SurveyDataSpecialType.AUTO_PICK_NOT_SYSTEM), 5.0f);
        picker.add(new BlueprintSpecialCreator(random), 1.0f);
        picker.add(new TopographicDataSpecialCreator(random, HTPoints.LOW_MIN, HTPoints.LOW_MAX), 1.0f);
        SpecialCreator pick = (SpecialCreator)picker.pick();
        SpecialCreationContext context = new SpecialCreationContext();
        Object specialData = pick.createSpecial(entity, context);
        if (specialData != null) {
            Misc.setSalvageSpecial(entity, specialData);
        }
    }

    public static void assignSpecialForDebrisField(SectorEntityToken entity) {
        Random random = StarSystemGenerator.random;
        WeightedRandomPicker<SpecialCreator> picker = new WeightedRandomPicker<SpecialCreator>(random);
        WeightedRandomPicker<String> recoverableShipFactions = SalvageSpecialAssigner.getNearbyFactions(random, entity);
        WeightedRandomPicker<String> trapFactions = Misc.createStringPicker(random, "pirates", Float.valueOf(10.0f));
        WeightedRandomPicker<String> valuableCargo = SalvageSpecialAssigner.getValuableCargo(random);
        picker.add(new NothingSpecialCreator(), 60.0f);
        picker.add(new ShipRecoverySpecialCreator(random, 1, 3, true, null, recoverableShipFactions), 10.0f);
        picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.MARINES, 10.0f, 20.0f, null), 2.0f);
        picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.CREW, 20.0f, 40.0f, null), 6.0f);
        picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.ORGANS, 1.0f, 5.0f, null), 3.0f);
        picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.OFFICER, STANDARD_PODS_OFFICER_LEVEL, EXCEPTIONAL_PODS_OFFICER_LEVEL, recoverableShipFactions), 1.0f);
        picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.ADMIN, 1.0f, 1.0f, recoverableShipFactions), 0.2f);
        picker.add(new CargoManifestSpecialCreator(random, valuableCargo, 10.0f, 50.0f), 10.0f);
        picker.add(new SurveyDataSpecialCreator(random, SurveyDataSpecial.SurveyDataSpecialType.AUTO_PICK_NOT_SYSTEM), 10.0f);
        picker.add(new BreadcrumbSpecialCreator(random, null), 10.0f);
        picker.add(new TransmitterTrapSpecialCreator(random, 0.5f, "patrolSmall", trapFactions, 4, 25), 10.0f);
        picker.add(new TopographicDataSpecialCreator(random, HTPoints.LOW_MIN, HTPoints.LOW_MAX), 5.0f);
        SpecialCreator pick = (SpecialCreator)picker.pick();
        SpecialCreationContext context = new SpecialCreationContext();
        Object specialData = pick.createSpecial(entity, context);
        if (specialData != null) {
            Misc.setSalvageSpecial(entity, specialData);
        }
    }

    public static WeightedRandomPicker<String> getValuableCargo(Random random) {
        WeightedRandomPicker<String> valuableCargo = Misc.createStringPicker(random, "volatiles", Float.valueOf(10.0f), "rare_metals", Float.valueOf(10.0f), "rare_ore", Float.valueOf(10.0f), "heavy_machinery", Float.valueOf(10.0f), "hand_weapons", Float.valueOf(10.0f), "organs", Float.valueOf(10.0f), "drugs", Float.valueOf(10.0f), "luxury_goods", Float.valueOf(10.0f), "lobster", Float.valueOf(10.0f));
        return valuableCargo;
    }

    public static WeightedRandomPicker<String> getIndustryCargo(Random random) {
        WeightedRandomPicker<String> industryCargo = Misc.createStringPicker(random, "volatiles", Float.valueOf(10.0f), "rare_metals", Float.valueOf(10.0f), "rare_ore", Float.valueOf(10.0f), "heavy_machinery", Float.valueOf(10.0f), "ore", Float.valueOf(10.0f));
        return industryCargo;
    }

    public static WeightedRandomPicker<String> getHabCargo(Random random) {
        WeightedRandomPicker<String> habCargo = Misc.createStringPicker(random, "hand_weapons", Float.valueOf(10.0f), "organs", Float.valueOf(10.0f), "drugs", Float.valueOf(10.0f), "luxury_goods", Float.valueOf(10.0f), "lobster", Float.valueOf(10.0f));
        return habCargo;
    }

    public static WeightedRandomPicker<String> getNearbyFactions(Random random, SectorEntityToken entity) {
        WeightedRandomPicker<String> picker = Misc.createStringPicker(random, "independent", Float.valueOf(10.0f));
        for (MarketAPI market : Misc.getNearbyMarkets(entity.getLocationInHyperspace(), 10.0f)) {
            picker.add(market.getFactionId(), market.getSize());
        }
        return picker;
    }

    public static WeightedRandomPicker<String> getNearbyFactions(Random random, SectorEntityToken entity, float rangeLY, float indWeight, float pirateWeight) {
        if (random == null) {
            random = new Random();
        }
        return SalvageSpecialAssigner.getNearbyFactions(random, entity.getLocationInHyperspace(), rangeLY, indWeight, pirateWeight);
    }

    public static WeightedRandomPicker<String> getNearbyFactions(Random random, Vector2f locationInHyper, float rangeLY, float indWeight, float pirateWeight) {
        if (random == null) {
            random = new Random();
        }
        WeightedRandomPicker<String> picker = new WeightedRandomPicker<String>(random);
        if (indWeight > 0.0f) {
            picker.add("independent", indWeight);
            picker.add("mercenary", indWeight * 0.1f);
        }
        if (pirateWeight > 0.0f) {
            picker.add("pirates", pirateWeight);
        }
        for (MarketAPI market : Misc.getNearbyMarkets(locationInHyper, rangeLY)) {
            picker.add(market.getFactionId(), market.getSize());
        }
        return picker;
    }

    public static SpecialCreator pickSpecialFor(SectorEntityToken entity, SpecialCreationContext context) {
        List<String> equipmentSmall;
        List<String> equipment;
        List<String> suppliesSmall;
        List<String> supplies;
        List<String> weaponsSmall;
        List<String> weapons;
        boolean debris;
        WeightedRandomPicker<String> piratesFaction;
        Random random = StarSystemGenerator.random;
        if (randomOverride != null) {
            random = randomOverride;
        }
        WeightedRandomPicker<SpecialCreator> picker = new WeightedRandomPicker<SpecialCreator>(random);
        String type = entity.getCustomEntityType();
        WeightedRandomPicker<String> recoverableShipFactions = SalvageSpecialAssigner.getNearbyFactions(random, entity);
        if (entity.getContainingLocation().hasTag("theme_remnant")) {
            recoverableShipFactions = Misc.createStringPicker(random, "tritachyon", Float.valueOf(10.0f), "hegemony", Float.valueOf(7.0f), "independent", Float.valueOf(3.0f));
        }
        int maxPodsOfficerLevel = EXCEPTIONAL_PODS_OFFICER_LEVEL;
        WeightedRandomPicker<String> remnantsFaction = Misc.createStringPicker(random, "remnant", Float.valueOf(10.0f));
        WeightedRandomPicker<String> trapFactions = piratesFaction = Misc.createStringPicker(random, "pirates", Float.valueOf(10.0f));
        if (entity.getContainingLocation().hasTag("theme_remnant_suppressed") || entity.getContainingLocation().hasTag("theme_remnant_resurgent")) {
            trapFactions = remnantsFaction;
        }
        WeightedRandomPicker<String> officerFactions = recoverableShipFactions;
        WeightedRandomPicker<String> valuableCargo = SalvageSpecialAssigner.getValuableCargo(random);
        WeightedRandomPicker<String> industryCargo = SalvageSpecialAssigner.getIndustryCargo(random);
        WeightedRandomPicker<String> habCargo = SalvageSpecialAssigner.getHabCargo(random);
        if (entity instanceof PlanetAPI) {
            float sizeMult = TechMining.getTechMiningRuinSizeModifier(entity.getMarket());
            picker.add(new NothingSpecialCreator(), 30.0f);
            picker.add(new ShipRecoverySpecialCreator(random, 1, 2, false, DerelictShipEntityPlugin.DerelictType.CIVILIAN, recoverableShipFactions), 5.0f);
            picker.add(new ShipRecoverySpecialCreator(random, 1, 3, false, DerelictShipEntityPlugin.DerelictType.SMALL, recoverableShipFactions), 10.0f);
            picker.add(new ShipRecoverySpecialCreator(random, 1, 1, false, DerelictShipEntityPlugin.DerelictType.MEDIUM, recoverableShipFactions), 3.0f);
            picker.add(new ShipRecoverySpecialCreator(random, 1, 1, false, DerelictShipEntityPlugin.DerelictType.LARGE, recoverableShipFactions), 1.0f);
            if (sizeMult > 0.0f) {
                picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.MARINES, 100.0f * sizeMult, 200.0f * sizeMult, null), 2.0f);
                picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.CREW, 500.0f * sizeMult, 1000.0f * sizeMult, null), 6.0f);
                picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.ORGANS, 50.0f * sizeMult, 500.0f * sizeMult, null), 3.0f);
            }
            picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.OFFICER, STANDARD_PODS_OFFICER_LEVEL, maxPodsOfficerLevel, officerFactions), 1.0f);
            picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.ADMIN, 1.0f, 1.0f, officerFactions), 5.0f);
            picker.add(new CargoManifestSpecialCreator(random, industryCargo, 500.0f * sizeMult, 2500.0f * sizeMult), 15.0f);
            picker.add(new CargoManifestSpecialCreator(random, valuableCargo, 500.0f * sizeMult, 2500.0f * sizeMult), 15.0f);
            picker.add(new TransmitterTrapSpecialCreator(random, 0.5f, "patrolLarge", trapFactions, (int)(10.0f + 30.0f * sizeMult), (int)(10.0f + 30.0f * sizeMult)), 10.0f);
            picker.add(new TopographicDataSpecialCreator(random, HTPoints.LOW_MIN, HTPoints.HIGH_MAX), 3.0f);
        }
        if (entity.getCustomPlugin() instanceof DerelictShipEntityPlugin || "wreck".equals(type)) {
            DerelictShipEntityPlugin plugin = (DerelictShipEntityPlugin)entity.getCustomPlugin();
            ShipRecoverySpecial.PerShipData shipData = plugin.getData().ship;
            ShipVariantAPI variant = shipData.variant;
            if (variant == null && shipData.variantId != null) {
                variant = Global.getSettings().getVariant(shipData.variantId);
            }
            float p = variant.getHullSpec().getMaxCrew();
            float c = variant.getHullSpec().getCargo();
            picker.add(new NothingSpecialCreator(), 40.0f);
            picker.add(new ShipRecoverySpecialCreator(random, 0, 0, false, null, null), 30.0f);
            picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.MARINES, p * 0.125f, p * 0.25f, null), 2.0f);
            picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.CREW, p * 0.25f, p * 0.5f, null), 7.0f);
            picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.ORGANS, p * 0.1f, p * 0.2f, null), 3.0f);
            picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.OFFICER, STANDARD_PODS_OFFICER_LEVEL, maxPodsOfficerLevel, officerFactions), 10.0f);
            picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.ADMIN, 1.0f, 1.0f, officerFactions), 0.2f);
            picker.add(new CargoManifestSpecialCreator(random, valuableCargo, c * 0.25f, c * 0.5f), 10.0f);
            picker.add(new SurveyDataSpecialCreator(random, SurveyDataSpecial.SurveyDataSpecialType.AUTO_PICK_NOT_SYSTEM), 10.0f);
            picker.add(new BreadcrumbSpecialCreator(random, context.all), 10.0f);
            picker.add(new TopographicDataSpecialCreator(random, HTPoints.LOW_MIN, HTPoints.LOW_MAX), 5.0f);
            if (entity.getOrbit() != null) {
                picker.add(new TransmitterTrapSpecialCreator(random, 0.5f, "patrolSmall", trapFactions, 4, 25), 10.0f);
            }
            if (!entity.hasTag("expires")) {
                picker.add(new BlueprintSpecialCreator(random), 1.0f);
            }
        }
        boolean bl = debris = entity instanceof CampaignTerrainAPI && ((CampaignTerrainAPI)entity).getPlugin() instanceof DebrisFieldTerrainPlugin;
        if (debris) {
            picker.add(new NothingSpecialCreator(), 60.0f);
            picker.add(new ShipRecoverySpecialCreator(random, 1, 3, true, null, recoverableShipFactions), 10.0f);
            picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.MARINES, 10.0f, 30.0f, null), 2.0f);
            picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.CREW, 10.0f, 50.0f, null), 6.0f);
            picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.ORGANS, 1.0f, 5.0f, null), 3.0f);
            picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.OFFICER, STANDARD_PODS_OFFICER_LEVEL, maxPodsOfficerLevel, officerFactions), 1.0f);
            picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.ADMIN, 1.0f, 5.0f, officerFactions), 0.2f);
            picker.add(new CargoManifestSpecialCreator(random, valuableCargo, 10.0f, 50.0f), 10.0f);
            picker.add(new SurveyDataSpecialCreator(random, SurveyDataSpecial.SurveyDataSpecialType.AUTO_PICK_NOT_SYSTEM), 10.0f);
            picker.add(new BreadcrumbSpecialCreator(random, context.all), 10.0f);
            picker.add(new TransmitterTrapSpecialCreator(random, 0.5f, "patrolSmall", trapFactions, 4, 25), 10.0f);
            picker.add(new TopographicDataSpecialCreator(random, HTPoints.LOW_MIN, HTPoints.LOW_MAX), 1.0f);
        }
        if ("station_mining_remnant".equals(type) || "station_mining_remnant".equals(type)) {
            picker.add(new NothingSpecialCreator(), 30.0f);
            picker.add(new ShipRecoverySpecialCreator(random, 1, 3, false, DerelictShipEntityPlugin.DerelictType.CIVILIAN, recoverableShipFactions), 10.0f);
            picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.MARINES, 10.0f, 20.0f, null), 1.0f);
            picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.CREW, 100.0f, 200.0f, null), 6.0f);
            picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.ORGANS, 5.0f, 50.0f, null), 3.0f);
            picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.OFFICER, STANDARD_PODS_OFFICER_LEVEL, maxPodsOfficerLevel, officerFactions), 1.0f);
            picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.ADMIN, 1.0f, 5.0f, officerFactions), 3.0f);
            picker.add(new CargoManifestSpecialCreator(random, industryCargo, 50.0f, 250.0f), 30.0f);
            picker.add(new SurveyDataSpecialCreator(random, SurveyDataSpecial.SurveyDataSpecialType.AUTO_PICK), 20.0f);
            picker.add(new BreadcrumbSpecialCreator(random, context.all), 10.0f);
            picker.add(new TransmitterTrapSpecialCreator(random, 0.5f, "patrolMedium", trapFactions, 10, 16), 10.0f);
            picker.add(new TopographicDataSpecialCreator(random, HTPoints.MEDIUM_MIN, HTPoints.MEDIUM_MAX), 1.0f);
        }
        if ("station_research_remnant".equals(type) || "station_research_remnant".equals(type)) {
            picker.add(new NothingSpecialCreator(), 30.0f);
            picker.add(new ShipRecoverySpecialCreator(random, 1, 3, false, DerelictShipEntityPlugin.DerelictType.CIVILIAN, recoverableShipFactions), 10.0f);
            picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.MARINES, 50.0f, 100.0f, null), 2.0f);
            picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.CREW, 100.0f, 200.0f, null), 6.0f);
            picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.ORGANS, 5.0f, 50.0f, null), 3.0f);
            picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.OFFICER, STANDARD_PODS_OFFICER_LEVEL, maxPodsOfficerLevel, officerFactions), 1.0f);
            picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.ADMIN, 1.0f, 5.0f, officerFactions), 3.0f);
            picker.add(new CargoManifestSpecialCreator(random, valuableCargo, 10.0f, 30.0f), 10.0f);
            picker.add(new SurveyDataSpecialCreator(random, SurveyDataSpecial.SurveyDataSpecialType.AUTO_PICK), 10.0f);
            picker.add(new BreadcrumbSpecialCreator(random, context.all), 10.0f);
            picker.add(new TransmitterTrapSpecialCreator(random, 0.5f, "patrolMedium", trapFactions, 10, 16), 20.0f);
            picker.add(new TopographicDataSpecialCreator(random, HTPoints.HIGH_MIN, HTPoints.HIGH_MAX), 10.0f);
        }
        if ("orbital_habitat_remnant".equals(type) || "orbital_habitat_remnant".equals(type)) {
            picker.add(new NothingSpecialCreator(), 40.0f);
            picker.add(new ShipRecoverySpecialCreator(random, 1, 3, false, DerelictShipEntityPlugin.DerelictType.CIVILIAN, recoverableShipFactions), 20.0f);
            picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.MARINES, 50.0f, 100.0f, null), 6.0f);
            picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.CREW, 100.0f, 200.0f, null), 20.0f);
            picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.ORGANS, 5.0f, 50.0f, null), 5.0f);
            picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.OFFICER, STANDARD_PODS_OFFICER_LEVEL, maxPodsOfficerLevel, officerFactions), 10.0f);
            picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.ADMIN, 1.0f, 5.0f, officerFactions), 5.0f);
            picker.add(new CargoManifestSpecialCreator(random, habCargo, 10.0f, 30.0f), 10.0f);
            picker.add(new SurveyDataSpecialCreator(random, SurveyDataSpecial.SurveyDataSpecialType.AUTO_PICK), 5.0f);
            picker.add(new BreadcrumbSpecialCreator(random, context.all), 10.0f);
            picker.add(new TransmitterTrapSpecialCreator(random, 0.5f, "patrolMedium", trapFactions, 10, 16), 10.0f);
            picker.add(new TopographicDataSpecialCreator(random, HTPoints.MEDIUM_MIN, HTPoints.MEDIUM_MAX), 2.0f);
        }
        if ((weapons = Arrays.asList("weapons_cache", "weapons_cache_high", "weapons_cache_low", "weapons_cache_remnant")).contains(type)) {
            picker.add(new NothingSpecialCreator(), 30.0f);
            picker.add(new ShipRecoverySpecialCreator(random, 1, 1, false, DerelictShipEntityPlugin.DerelictType.SMALL, recoverableShipFactions), 10.0f);
            picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.MARINES, 50.0f, 100.0f, null), 1.0f);
            picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.OFFICER, STANDARD_PODS_OFFICER_LEVEL, maxPodsOfficerLevel, officerFactions), 2.0f);
            picker.add(new CargoManifestSpecialCreator(random, valuableCargo, 10.0f, 30.0f), 10.0f);
            picker.add(new TransmitterTrapSpecialCreator(random, 0.5f, "patrolSmall", trapFactions, 4, 8), 10.0f);
        }
        if ((weaponsSmall = Arrays.asList("weapons_cache_small", "weapons_cache_small_high", "weapons_cache_small_low", "weapons_cache_small_remnant")).contains(type)) {
            picker.add(new NothingSpecialCreator(), 30.0f);
            picker.add(new ShipRecoverySpecialCreator(random, 1, 1, false, DerelictShipEntityPlugin.DerelictType.SMALL, recoverableShipFactions), 10.0f);
            picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.OFFICER, STANDARD_PODS_OFFICER_LEVEL, maxPodsOfficerLevel, officerFactions), 1.0f);
            picker.add(new CargoManifestSpecialCreator(random, valuableCargo, 10.0f, 30.0f), 10.0f);
            picker.add(new TransmitterTrapSpecialCreator(random, 0.5f, "patrolSmall", trapFactions, 4, 8), 10.0f);
        }
        if ((supplies = Arrays.asList("supply_cache")).contains(type)) {
            picker.add(new NothingSpecialCreator(), 30.0f);
            picker.add(new ShipRecoverySpecialCreator(random, 1, 1, false, DerelictShipEntityPlugin.DerelictType.SMALL, recoverableShipFactions), 10.0f);
            picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.OFFICER, STANDARD_PODS_OFFICER_LEVEL, maxPodsOfficerLevel, officerFactions), 1.0f);
            picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.ADMIN, 1.0f, 5.0f, officerFactions), 0.2f);
            picker.add(new CargoManifestSpecialCreator(random, valuableCargo, 10.0f, 30.0f), 10.0f);
            picker.add(new TransmitterTrapSpecialCreator(random, 0.5f, "patrolSmall", trapFactions, 4, 8), 10.0f);
        }
        if ((suppliesSmall = Arrays.asList("supply_cache_small")).contains(type)) {
            picker.add(new NothingSpecialCreator(), 30.0f);
            picker.add(new ShipRecoverySpecialCreator(random, 1, 1, false, DerelictShipEntityPlugin.DerelictType.SMALL, recoverableShipFactions), 10.0f);
            picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.OFFICER, STANDARD_PODS_OFFICER_LEVEL, maxPodsOfficerLevel, officerFactions), 1.0f);
            picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.ADMIN, 1.0f, 5.0f, officerFactions), 0.2f);
            picker.add(new CargoManifestSpecialCreator(random, valuableCargo, 10.0f, 30.0f), 10.0f);
            picker.add(new TransmitterTrapSpecialCreator(random, 0.5f, "patrolSmall", trapFactions, 4, 8), 10.0f);
        }
        if ((equipment = Arrays.asList("equipment_cache")).contains(type)) {
            picker.add(new NothingSpecialCreator(), 30.0f);
            picker.add(new ShipRecoverySpecialCreator(random, 1, 1, false, DerelictShipEntityPlugin.DerelictType.SMALL, recoverableShipFactions), 10.0f);
            picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.OFFICER, STANDARD_PODS_OFFICER_LEVEL, maxPodsOfficerLevel, officerFactions), 1.0f);
            picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.ADMIN, 1.0f, 5.0f, officerFactions), 0.2f);
            picker.add(new CargoManifestSpecialCreator(random, industryCargo, 10.0f, 30.0f), 10.0f);
            picker.add(new TransmitterTrapSpecialCreator(random, 0.5f, "patrolSmall", trapFactions, 4, 8), 10.0f);
            picker.add(new TopographicDataSpecialCreator(random, HTPoints.LOW_MIN, HTPoints.LOW_MAX), 1.0f);
        }
        if ((equipmentSmall = Arrays.asList("equipment_cache_small")).contains(type)) {
            picker.add(new NothingSpecialCreator(), 30.0f);
            picker.add(new ShipRecoverySpecialCreator(random, 1, 1, false, DerelictShipEntityPlugin.DerelictType.SMALL, recoverableShipFactions), 10.0f);
            picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.OFFICER, STANDARD_PODS_OFFICER_LEVEL, maxPodsOfficerLevel, officerFactions), 1.0f);
            picker.add(new SleeperPodsSpecialCreator(random, SleeperPodsSpecial.SleeperSpecialType.ADMIN, 1.0f, 5.0f, officerFactions), 0.2f);
            picker.add(new CargoManifestSpecialCreator(random, industryCargo, 10.0f, 30.0f), 10.0f);
            picker.add(new TransmitterTrapSpecialCreator(random, 0.5f, "patrolSmall", trapFactions, 4, 8), 10.0f);
        }
        return (SpecialCreator)picker.pick();
    }

    public static void assignSpecials(SectorEntityToken entity) {
        SalvageSpecialAssigner.assignSpecials(entity, true);
    }

    public static void assignSpecials(SectorEntityToken entity, boolean onNewGame, Random random) {
        randomOverride = random;
        SalvageSpecialAssigner.assignSpecials(entity, onNewGame);
        randomOverride = null;
    }

    public static void assignSpecials(SectorEntityToken entity, boolean onNewGame) {
        SpecialCreationContext context = new SpecialCreationContext();
        context.onNewGame = onNewGame;
        SpecialCreator creator = SalvageSpecialAssigner.pickSpecialFor(entity, context);
        if (creator == null) {
            return;
        }
        Object specialData = creator.createSpecial(entity, context);
        if (specialData != null) {
            Misc.setSalvageSpecial(entity, specialData);
            if (DerelictThemeGenerator.DEBUG) {
                String id = entity.getCustomEntityType();
                if (id == null) {
                    id = entity.getClass().getSimpleName();
                }
                System.out.println("Assigned " + specialData.getClass().getSimpleName() + " to " + id);
            }
        }
    }

    public static void assignSpecials(List<BaseThemeGenerator.StarSystemData> systemData, SpecialCreationContext context) {
        context.all.clear();
        for (BaseThemeGenerator.StarSystemData data : systemData) {
            for (BaseThemeGenerator.AddedEntity added : data.generated) {
                context.all.add(added.entity);
            }
            for (PlanetAPI planet : data.system.getPlanets()) {
                if (planet.getMarket() == null || !planet.getMarket().isPlanetConditionMarketOnly() || !Misc.hasRuins(planet.getMarket())) continue;
                context.all.add(planet);
            }
        }
        if (DerelictThemeGenerator.DEBUG) {
            System.out.println("\n\n\nAssigning salvage specials");
        }
        for (SectorEntityToken entity : context.all) {
            Object specialData;
            SpecialCreator creator = SalvageSpecialAssigner.pickSpecialFor(entity, context);
            if (creator == null || (specialData = creator.createSpecial(entity, context)) == null) continue;
            Misc.setSalvageSpecial(entity, specialData);
            if (!DerelictThemeGenerator.DEBUG) continue;
            String id = entity.getCustomEntityType();
            if (id == null) {
                id = entity.getClass().getSimpleName();
            }
            System.out.println("Assigned " + specialData.getClass().getSimpleName() + " to " + id);
        }
        if (DerelictThemeGenerator.DEBUG) {
            System.out.println("Finished assigning salvage specials\n\n\n\n");
        }
    }

    public static class BlueprintSpecialCreator
    implements SpecialCreator {
        private Random random;

        public BlueprintSpecialCreator(Random random) {
            this.random = random;
        }

        public Object createSpecial(SectorEntityToken entity, SpecialCreationContext context) {
            return new BlueprintSpecial.BlueprintSpecialData();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BreadcrumbSpecialCreator
    implements SpecialCreator {
        private Random random;
        private List<SectorEntityToken> all;

        public BreadcrumbSpecialCreator(Random random, List<SectorEntityToken> all) {
            this.random = random;
            this.all = all;
        }

        @Override
        public Object createSpecial(SectorEntityToken entity, SpecialCreationContext context) {
            WeightedRandomPicker<SectorEntityToken> picker = new WeightedRandomPicker<SectorEntityToken>(this.random);
            if (this.all != null) {
                for (SectorEntityToken other : this.all) {
                    if (other == entity || !BreadcrumbSpecialCreator.isLargeShipOrNonShip(other)) continue;
                    picker.add(other);
                }
            }
            List<StarSystemAPI> systems = Misc.getNearbyStarSystems(entity, 10.0f);
            for (StarSystemAPI system : systems) {
                for (SectorEntityToken other : system.getEntitiesWithTag("salvageable")) {
                    if (!other.hasSensorProfile() && !other.isDiscoverable() || other == entity || !BreadcrumbSpecialCreator.isLargeShipOrNonShip(other) || other.hasTag("expires") || other.hasTag("not_random_mission_target") || other.getContainingLocation() != null && other.getContainingLocation().hasTag("theme_hidden") || other.getMemoryWithoutUpdate() != null && other.getMemoryWithoutUpdate().getBoolean("$ttWeaponsCache")) continue;
                    picker.add(other);
                }
            }
            SectorEntityToken target = (SectorEntityToken)picker.pick();
            if (target == null) {
                return null;
            }
            BreadcrumbSpecial.BreadcrumbSpecialData data = new BreadcrumbSpecial.BreadcrumbSpecialData(target.getId());
            return data;
        }

        public static boolean isLargeShipOrNonShip(SectorEntityToken other) {
            if (other.getCustomPlugin() instanceof DerelictShipEntityPlugin) {
                DerelictShipEntityPlugin dsep = (DerelictShipEntityPlugin)other.getCustomPlugin();
                ShipVariantAPI variant = dsep.getData().ship.variant;
                if (variant == null && dsep.getData().ship.variantId != null) {
                    variant = Global.getSettings().getVariant(dsep.getData().ship.variantId);
                }
                if (variant != null) {
                    if (variant.getHullSize() == ShipAPI.HullSize.FRIGATE) {
                        return false;
                    }
                    if (variant.getHullSize() == ShipAPI.HullSize.DESTROYER) {
                        return false;
                    }
                    if (variant.getHullSize() == ShipAPI.HullSize.CRUISER && variant.getHullSpec().getHints().contains((Object)ShipHullSpecAPI.ShipTypeHints.CIVILIAN)) {
                        return false;
                    }
                }
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CargoManifestSpecialCreator
    implements SpecialCreator {
        private Random random;
        private SurveyDataSpecial.SurveyDataSpecialType type;
        private WeightedRandomPicker<String> cargoPicker;
        private int min;
        private int max;

        public CargoManifestSpecialCreator(Random random, WeightedRandomPicker<String> cargoPicker, float min, float max) {
            if (min < 1.0f) {
                min = 1.0f;
            }
            if (max < 1.0f) {
                max = 1.0f;
            }
            this.random = random;
            this.cargoPicker = cargoPicker;
            this.min = (int)min;
            this.max = (int)max;
        }

        @Override
        public Object createSpecial(SectorEntityToken entity, SpecialCreationContext context) {
            CargoManifestSpecial.CargoManifestSpecialData data = new CargoManifestSpecial.CargoManifestSpecialData(this.cargoPicker.pick(), this.min, this.max);
            return data;
        }
    }

    public static class NothingSpecialCreator
    implements SpecialCreator {
        public Object createSpecial(SectorEntityToken entity, SpecialCreationContext context) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShipRecoverySpecialCreator
    implements SpecialCreator {
        private int min;
        private int max;
        private WeightedRandomPicker<String> factionPicker;
        private Random random;
        private boolean badCondition;
        private DerelictShipEntityPlugin.DerelictType type;

        public ShipRecoverySpecialCreator(Random random, int min, int max, boolean badCondition, DerelictShipEntityPlugin.DerelictType type, WeightedRandomPicker<String> factionPicker) {
            this.badCondition = badCondition;
            this.type = type;
            if (random == null) {
                random = new Random();
            }
            this.random = random;
            this.min = min;
            this.max = max;
            this.factionPicker = factionPicker;
        }

        @Override
        public Object createSpecial(SectorEntityToken entity, SpecialCreationContext context) {
            if (entity.getCustomPlugin() instanceof DerelictShipEntityPlugin) {
                DerelictShipEntityPlugin plugin = (DerelictShipEntityPlugin)entity.getCustomPlugin();
                ShipRecoverySpecial.ShipRecoverySpecialData data = new ShipRecoverySpecial.ShipRecoverySpecialData(null);
                data.addShip(plugin.getData().ship.clone());
                return data;
            }
            String desc = null;
            if (entity instanceof PlanetAPI) {
                desc = "found in a sealed hangar bay";
            }
            ShipRecoverySpecial.ShipRecoverySpecialData data = new ShipRecoverySpecial.ShipRecoverySpecialData(desc);
            int num = this.min + this.random.nextInt(this.max - this.min + 1);
            int i = 0;
            while (i < num) {
                DerelictShipEntityPlugin.DerelictShipData dsd;
                String factionId = this.factionPicker.pick();
                ShipRecoverySpecial.ShipCondition condition = DerelictShipEntityPlugin.pickDerelictCondition(this.random);
                if (this.badCondition) {
                    condition = DerelictShipEntityPlugin.pickBadCondition(this.random);
                }
                if ((dsd = DerelictShipEntityPlugin.createRandom(factionId, this.type, this.random, 0.0f)) != null && dsd.ship != null) {
                    dsd.ship.condition = condition;
                    data.addShip(dsd.ship);
                }
                ++i;
            }
            if (data.ships == null || data.ships.isEmpty()) {
                return null;
            }
            return data;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SleeperPodsSpecialCreator
    implements SpecialCreator {
        private SleeperPodsSpecial.SleeperSpecialType type;
        private int min;
        private int max;
        private WeightedRandomPicker<String> officerFactions;
        private Random random;

        public SleeperPodsSpecialCreator(Random random, SleeperPodsSpecial.SleeperSpecialType type, float min, float max, WeightedRandomPicker<String> officerFactions) {
            if (min < 1.0f) {
                min = 1.0f;
            }
            if (max < 1.0f) {
                max = 1.0f;
            }
            if (min > max) {
                min = max;
            }
            this.random = random;
            this.type = type;
            this.min = (int)min;
            this.max = (int)max;
            this.officerFactions = officerFactions;
        }

        @Override
        public Object createSpecial(SectorEntityToken entity, SpecialCreationContext context) {
            SleeperPodsSpecial.SleeperPodsSpecialData data = new SleeperPodsSpecial.SleeperPodsSpecialData(this.type, null);
            if (this.type == SleeperPodsSpecial.SleeperSpecialType.OFFICER) {
                String factionId = this.officerFactions.pick();
                FactionAPI faction = Global.getSector().getFaction(factionId);
                String key = "$SleeperPodsSpecialCreator_exceptionalCount";
                int numAlreadyCreated = Global.getSector().getMemoryWithoutUpdate().getInt(key);
                int level = this.min;
                if (numAlreadyCreated < MAX_EXCEPTIONAL_PODS_OFFICERS && this.random.nextFloat() < PROB_EXCEPTIONAL_PODS_OFFICER) {
                    level = EXCEPTIONAL_PODS_OFFICER_LEVEL;
                    Global.getSector().getMemoryWithoutUpdate().set(key, ++numAlreadyCreated);
                }
                OfficerManagerEvent.SkillPickPreference pref = OfficerManagerEvent.SkillPickPreference.ANY;
                int eliteSkillNumOverride = 1;
                if (level == EXCEPTIONAL_PODS_OFFICER_LEVEL) {
                    eliteSkillNumOverride = EXCEPTIONAL_PODS_OFFICER_ELITE_SKILLS;
                }
                PersonAPI officer = OfficerManagerEvent.createOfficer(faction, level, pref, true, null, true, true, eliteSkillNumOverride, this.random);
                if (level == EXCEPTIONAL_PODS_OFFICER_LEVEL) {
                    officer.getMemoryWithoutUpdate().set("$exceptionalSleeperPodOfficer", true);
                }
                data.officer = officer;
                data.min = 1;
                data.max = 1;
            } else if (this.type == SleeperPodsSpecial.SleeperSpecialType.ADMIN) {
                PersonAPI officer;
                String factionId = this.officerFactions.pick();
                FactionAPI faction = Global.getSector().getFaction(factionId);
                WeightedRandomPicker<Integer> tierPicker = new WeightedRandomPicker<Integer>(this.random);
                tierPicker.add(1, 50.0f);
                tierPicker.add(2, 50.0f);
                int tier = (Integer)tierPicker.pick();
                data.officer = officer = OfficerManagerEvent.createAdmin(faction, tier, this.random);
                data.min = 1;
                data.max = 1;
            } else {
                data.min = this.min;
                data.max = this.max;
            }
            return data;
        }
    }

    public static class SpecialCreationContext {
        public String themeId;
        public boolean onNewGame = true;
        public List<SectorEntityToken> all = new ArrayList<SectorEntityToken>();
    }

    public static interface SpecialCreator {
        public Object createSpecial(SectorEntityToken var1, SpecialCreationContext var2);
    }

    public static class SurveyDataSpecialCreator
    implements SpecialCreator {
        private Random random;
        private SurveyDataSpecial.SurveyDataSpecialType type;

        public SurveyDataSpecialCreator(Random random, SurveyDataSpecial.SurveyDataSpecialType type) {
            this.random = random;
            this.type = type;
        }

        public Object createSpecial(SectorEntityToken entity, SpecialCreationContext context) {
            SurveyDataSpecial.SurveyDataSpecialData data = new SurveyDataSpecial.SurveyDataSpecialData(this.type);
            return data;
        }
    }

    public static class TopographicDataSpecialCreator
    implements SpecialCreator {
        private Random random;
        private int min;
        private int max;

        public TopographicDataSpecialCreator(Random random, int min, int max) {
            if (min < 1) {
                min = 1;
            }
            if (max < 1) {
                max = 1;
            }
            this.random = random;
            this.min = min;
            this.max = max;
        }

        public Object createSpecial(SectorEntityToken entity, SpecialCreationContext context) {
            int points = this.min + this.random.nextInt(this.max - this.min + 1);
            TopographicDataSpecial.TopographicDataSpecialData data = new TopographicDataSpecial.TopographicDataSpecialData(points);
            return data;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TransmitterTrapSpecialCreator
    implements SpecialCreator {
        private Random random;
        private WeightedRandomPicker<String> factionPicker;
        private int minPts;
        private int maxPts;
        private final float chance;
        private final String fleetType;

        public TransmitterTrapSpecialCreator(Random random, float chance, String fleetType, WeightedRandomPicker<String> factionPicker, int min, int max) {
            this.random = random;
            this.chance = chance;
            this.fleetType = fleetType;
            this.factionPicker = factionPicker;
            this.minPts = min;
            this.maxPts = max;
        }

        @Override
        public Object createSpecial(SectorEntityToken entity, SpecialCreationContext context) {
            String factionId;
            TransmitterTrapSpecial.TransmitterTrapSpecialData data = new TransmitterTrapSpecial.TransmitterTrapSpecialData();
            data.prob = this.chance;
            data.nearbyFleetFaction = factionId = this.factionPicker.pick();
            data.useAllFleetsInRange = true;
            if (this.fleetType != null) {
                FleetParamsV3 params;
                int combatPoints = this.minPts + this.random.nextInt(this.maxPts - this.minPts + 1);
                data.params = params = new FleetParamsV3(null, entity.getLocationInHyperspace(), factionId, null, this.fleetType, combatPoints *= 5, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            }
            return data;
        }
    }
}

