/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignClockAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.ai.CampaignFleetAIAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.BroadcastPlayerAction;
import com.fs.starfarer.api.impl.campaign.rulecmd.Wait;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BroadcastPlayerWaitAction
extends BaseCommandPlugin {
    private EveryFrameScript broadcastScript;
    private Misc.VarAndMemory waitHandle;

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        this.waitHandle = params.get(0).getVarNameAndMemory(memoryMap);
        final CampaignFleetAIAPI.ActionType type = Enum.valueOf(CampaignFleetAIAPI.ActionType.class, params.get((int)1).string);
        final float range = Float.parseFloat(params.get((int)2).string);
        final String responseVariable = params.get((int)3).string;
        final SectorEntityToken target = dialog.getInteractionTarget();
        final CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        BroadcastPlayerAction.broadcast(type, range, responseVariable, playerFleet, target);
        this.broadcastScript = new EveryFrameScript(){
            private IntervalUtil tracker = new IntervalUtil(0.05f, 0.15f);
            private boolean done = false;

            public boolean runWhilePaused() {
                return false;
            }

            public boolean isDone() {
                return this.done;
            }

            public void advance(float amount) {
                CampaignClockAPI clock = Global.getSector().getClock();
                float days = clock.convertToDays(amount);
                this.tracker.advance(days);
                if (this.tracker.intervalElapsed() && !this.done) {
                    if (((BroadcastPlayerWaitAction)BroadcastPlayerWaitAction.this).waitHandle.memory.contains(((BroadcastPlayerWaitAction)BroadcastPlayerWaitAction.this).waitHandle.name)) {
                        Wait wait = (Wait)((BroadcastPlayerWaitAction)BroadcastPlayerWaitAction.this).waitHandle.memory.get(((BroadcastPlayerWaitAction)BroadcastPlayerWaitAction.this).waitHandle.name);
                        if (wait.getWaitScript().isDone()) {
                            this.done = true;
                            return;
                        }
                    } else {
                        this.done = true;
                        return;
                    }
                    BroadcastPlayerAction.broadcast(type, range, responseVariable, playerFleet, target);
                }
            }
        };
        Global.getSector().addScript(this.broadcastScript);
        return true;
    }
}

