/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.rules.ExpressionAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.campaign.rules.Option;
import com.fs.starfarer.api.campaign.rules.RuleAPI;
import com.fs.starfarer.api.campaign.rules.RulesAPI;
import com.fs.starfarer.api.impl.campaign.DevMenuOptions;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FireAll
extends BaseCommandPlugin {
    private InteractionDialogAPI dialog;
    private Map<String, MemoryAPI> memoryMap;

    public static boolean fire(String ruleId, InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap, String params) {
        return new FireAll().execute(ruleId, dialog, Misc.tokenize(params), memoryMap);
    }

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, final Map<String, MemoryAPI> memoryMap) {
        RulesAPI rules;
        List<RuleAPI> matches;
        this.dialog = dialog;
        this.memoryMap = memoryMap;
        String trigger = params.get((int)0).string;
        if (params.get(0).isVariable()) {
            Misc.VarAndMemory var = params.get(0).getVarNameAndMemory(memoryMap);
            trigger = var.memory.getString(var.name);
        }
        if ((matches = (rules = Global.getSector().getRules()).getAllMatching(ruleId, trigger, dialog, memoryMap)).isEmpty()) {
            return false;
        }
        ArrayList<OptionAdder> options = new ArrayList<OptionAdder>();
        for (RuleAPI rule : matches) {
            for (Option option : rule.getOptions()) {
                if (option.id.startsWith("(dev)") && !Global.getSettings().isDevMode()) continue;
                options.add(new OptionAdder(option));
            }
            for (ExpressionAPI e : rule.getScriptCopy()) {
                if (!e.doesCommandAddOptions()) continue;
                options.add(new OptionAdder(e));
            }
        }
        if (!options.isEmpty()) {
            Collections.sort(options, new Comparator<OptionAdder>(){

                @Override
                public int compare(OptionAdder o1, OptionAdder o2) {
                    float diff = o1.getOrder(memoryMap) - o2.getOrder(memoryMap);
                    if (diff < 0.0f) {
                        return -1;
                    }
                    if (diff > 0.0f) {
                        return 1;
                    }
                    return 0;
                }
            });
            dialog.getOptionPanel().clearOptions();
            for (OptionAdder option : options) {
                option.add(ruleId, dialog, params, memoryMap);
            }
            if (Global.getSettings().isDevMode()) {
                DevMenuOptions.addOptions(dialog);
            }
        }
        for (RuleAPI rule : matches) {
            this.applyRule(rule);
        }
        return true;
    }

    private void applyRule(RuleAPI rule) {
        this.addText(rule.getId(), rule.pickText());
        rule.runScript(this.dialog, this.memoryMap);
    }

    private void addText(String ruleId, String text) {
        if (text == null || text.isEmpty()) {
            return;
        }
        text = Global.getSector().getRules().performTokenReplacement(ruleId, text, this.dialog.getInteractionTarget(), this.memoryMap);
        this.dialog.getTextPanel().addParagraph(text);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OptionAdder {
        private Option option;
        private ExpressionAPI expression;

        public OptionAdder(ExpressionAPI expression) {
            this.expression = expression;
        }

        public OptionAdder(Option option) {
            this.option = option;
        }

        public int getOrder(Map<String, MemoryAPI> memoryMap) {
            if (this.option != null) {
                return (int)this.option.order;
            }
            if (this.expression != null) {
                return this.expression.getOptionOrder(memoryMap);
            }
            return 0;
        }

        public void add(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
            if (this.option != null) {
                String text = Global.getSector().getRules().performTokenReplacement(ruleId, this.option.text, dialog.getInteractionTarget(), memoryMap);
                dialog.getOptionPanel().addOption(text, this.option.id, null);
            } else if (this.expression != null) {
                this.expression.execute(ruleId, dialog, memoryMap);
            }
        }
    }
}

