/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.impl.campaign.econ.ShippingDisruption;
import com.fs.starfarer.api.impl.campaign.fleets.EconomyFleetAssignmentAI;
import com.fs.starfarer.api.impl.campaign.fleets.EconomyFleetRouteManager;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FleetDesc
extends BaseCommandPlugin {
    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        MemoryAPI mem;
        if (dialog == null) {
            return false;
        }
        if (!(dialog.getInteractionTarget() instanceof CampaignFleetAPI)) {
            return false;
        }
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        CampaignFleetAPI fleet = (CampaignFleetAPI)dialog.getInteractionTarget();
        FactionAPI faction = fleet.getFaction();
        TextPanelAPI text = dialog.getTextPanel();
        if (Global.getSettings().isDevMode() && !Global.getSettings().getBoolean("playtestingMode")) {
            text.addParagraph("Admiral skills:");
            for (MutableCharacterStatsAPI.SkillLevelAPI skill : fleet.getCommanderStats().getSkillsCopy()) {
                if (!skill.getSkill().isAdmiralSkill()) continue;
                text.addParagraph("    " + skill.getSkill().getId());
            }
        }
        if (!(mem = fleet.getMemoryWithoutUpdate()).contains("$shownFleetDescAlready")) {
            mem.set("$shownFleetDescAlready", true, 0.0f);
        }
        boolean smuggler = mem.getBoolean("$isSmuggler");
        boolean trader = mem.getBoolean("$isTradeFleet");
        Color hl = Misc.getHighlightColor();
        Color red = Misc.getNegativeHighlightColor();
        RouteManager.RouteData route = RouteManager.getInstance().getRoute("econ", fleet);
        if ((trader || smuggler) && route != null) {
            EconomyFleetAssignmentAI.EconomyRouteData data = (EconomyFleetAssignmentAI.EconomyRouteData)route.getCustom();
            Integer id = route.getCurrentSegmentId();
            String from = data.from.getName();
            String to = data.to.getName();
            if (id >= EconomyFleetRouteManager.ROUTE_DST_LOAD) {
                from = data.to.getName();
                to = data.from.getName();
            }
            String cargo = "";
            if (id <= EconomyFleetRouteManager.ROUTE_DST_UNLOAD) {
                cargo = EconomyFleetAssignmentAI.EconomyRouteData.getCargoList(data.cargoDeliver);
                if (!cargo.isEmpty() && id == EconomyFleetRouteManager.ROUTE_SRC_LOAD) {
                    cargo = String.valueOf(cargo) + " (being loaded)";
                }
            } else {
                cargo = EconomyFleetAssignmentAI.EconomyRouteData.getCargoList(data.cargoReturn);
                if (!cargo.isEmpty() && id == EconomyFleetRouteManager.ROUTE_DST_LOAD) {
                    cargo = String.valueOf(cargo) + " (being loaded)";
                }
            }
            if (trader || smuggler) {
                LabelAPI label = text.addParagraph("You encounter " + fleet.getFaction().getPersonNamePrefixAOrAn() + " " + fleet.getFaction().getPersonNamePrefix() + " " + fleet.getName().toLowerCase() + ".");
                label.highlightFirst(fleet.getFaction().getPersonNamePrefix());
                label.setHighlightColor(fleet.getFaction().getBaseUIColor());
                text.setFontSmallInsignia();
                text.addParagraph("--------------------------------------------------------------------------------------------------------------");
                if (data.from.isHidden()) {
                    text.addPara("Port of origin: %s", hl, "Unknown");
                } else {
                    text.addPara("Port of origin: %s", hl, data.from.getName());
                }
                text.addPara("Current destination: %s", hl, to);
                if (from.equals(data.to.getName())) {
                    text.addPara("Returning from: %s", hl, data.to.getName());
                }
                if (cargo.isEmpty()) {
                    text.addPara("No cargo");
                } else {
                    text.addPara("Cargo: %s", hl, cargo);
                }
                text.addParagraph("--------------------------------------------------------------------------------------------------------------");
                text.setFontInsignia();
                int penalty = Math.round(ShippingDisruption.getPenaltyForShippingLost(data.from.getSize(), data.size) * 100.0f);
                if (!fleet.getFaction().isPlayerFaction()) {
                    if (data.from.isHidden()) {
                        text.addPara("If this fleet does not reach its destination safely, it will cause a shortage of the commodities it carries. In addition, its loss would reduce the accessibility of its port of origin by %s for up to three months.", Misc.getTextColor(), Misc.getHighlightColor(), penalty + "%");
                    } else {
                        text.addPara("If this fleet does not reach its destination safely, it will cause a shortage of the commodities it carries. In addition, its loss would reduce the accessbility of " + data.from.getName() + " by %s for up to three months.", Misc.getTextColor(), Misc.getHighlightColor(), penalty + "%");
                    }
                }
            }
        }
        if (!fleet.getFaction().isPlayerFaction() && !fleet.getFaction().isNeutralFaction()) {
            if (fleet.getMemoryWithoutUpdate().getBoolean("$noRepImpact")) {
                if (Misc.isDecentralized(fleet.getFaction())) {
                    text.addPara("Engaging this fleet in battle will not cause any changes to your reputation with the faction it nominally belongs to.", Misc.getHighlightColor(), "will not cause any changes to your reputation");
                } else {
                    text.addPara("This fleet is operating without official sanction from the faction it nominally belongs to. Engaging it in battle will not cause any changes to your reputation.", Misc.getHighlightColor(), "will not cause any changes to your reputation");
                }
            } else if (fleet.getMemoryWithoutUpdate().getBoolean("$lowRepImpact") && fleet.knowsWhoPlayerIs()) {
                if (Misc.isDecentralized(fleet.getFaction())) {
                    text.addPara("Engaging this fleet in battle will not cause immediate hostilities with the faction it nominally belongs to, though it will slightly strain the relationship.", Misc.getHighlightColor(), "will not cause immediate hostilities");
                } else {
                    text.addPara("This fleet is either operating in a legal gray area or its behavior falls outside accepted norms. Engaging it in battle will not cause immediate hostilities with the faction it nominally belongs to, though it will slightly strain the relationship.", Misc.getHighlightColor(), "will not cause immediate hostilities");
                }
            }
        }
        return true;
    }
}

