/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.ai.ModularFleetAIAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MonthlyReport;
import com.fs.starfarer.api.campaign.listeners.ColonyPlayerHostileActListener;
import com.fs.starfarer.api.campaign.listeners.CurrentLocationChangedListener;
import com.fs.starfarer.api.campaign.listeners.EconomyTickListener;
import com.fs.starfarer.api.campaign.listeners.FleetEventListener;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathBaseManager;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.HALuddicPathDealFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.HAPirateKingDealFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.PirateBasePirateActivityCause2;
import com.fs.starfarer.api.impl.campaign.missions.FleetCreatorMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.MissionFleetAutoDespawn;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.impl.campaign.shared.SharedData;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HA_CMD
extends BaseCommandPlugin {
    public static final String PATHER_AGREEMENT = "$patherAgreement";
    public static final String PATHER_AGREEMENT_PERMANENT = "$patherAgreementPermanent";

    public static void setPatherAgreement(boolean agreement, float duration) {
        if (!agreement) {
            Global.getSector().getPlayerMemoryWithoutUpdate().unset(PATHER_AGREEMENT);
            Global.getSector().getPlayerMemoryWithoutUpdate().unset(PATHER_AGREEMENT_PERMANENT);
            return;
        }
        if (duration <= 0.0f) {
            Global.getSector().getPlayerMemoryWithoutUpdate().set(PATHER_AGREEMENT_PERMANENT, true);
        }
        Global.getSector().getPlayerMemoryWithoutUpdate().set(PATHER_AGREEMENT, true, duration);
    }

    public static boolean playerHasPatherAgreement() {
        return Global.getSector().getPlayerMemoryWithoutUpdate().getBoolean(PATHER_AGREEMENT) || Global.getSector().getMemoryWithoutUpdate().getBoolean(PATHER_AGREEMENT);
    }

    public static boolean playerPatherAgreementIsPermanent() {
        return Global.getSector().getPlayerMemoryWithoutUpdate().getBoolean(PATHER_AGREEMENT_PERMANENT) || Global.getSector().getMemoryWithoutUpdate().getBoolean(PATHER_AGREEMENT_PERMANENT);
    }

    public static float getPlayerPatherAgreementDays() {
        return Global.getSector().getPlayerMemoryWithoutUpdate().getExpire(PATHER_AGREEMENT);
    }

    public static int computePirateProtectionPaymentPerMonth(PirateBaseIntel intel) {
        int perTick = HA_CMD.computePirateProtectionPaymentPerTick(intel);
        float numIter = Global.getSettings().getFloat("economyIterPerMonth");
        return (int)((float)perTick * numIter);
    }

    public static int computePirateProtectionPaymentPerTick(PirateBaseIntel intel) {
        float numIter = Global.getSettings().getFloat("economyIterPerMonth");
        float f = 1.0f / numIter;
        int payment = 0;
        float feeFraction = Global.getSettings().getFloat("pirateProtectionPaymentFraction");
        for (MarketAPI market : PirateBasePirateActivityCause2.getColoniesAffectedBy(intel)) {
            if (!market.isPlayerOwned()) continue;
            payment = (int)((float)payment + (float)((int)(market.getGrossIncome() * f)) * feeFraction);
        }
        return payment;
    }

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (dialog == null) {
            return false;
        }
        OptionPanelAPI options = dialog.getOptionPanel();
        TextPanelAPI text = dialog.getTextPanel();
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        CargoAPI cargo = pf.getCargo();
        String action = params.get(0).getString(memoryMap);
        MemoryAPI memory = memoryMap.get("local");
        if (memory == null) {
            return false;
        }
        StarSystemAPI system = null;
        if (dialog.getInteractionTarget().getContainingLocation() instanceof StarSystemAPI) {
            system = (StarSystemAPI)dialog.getInteractionTarget().getContainingLocation();
        }
        if ("baseInvolved".equals(action)) {
            if (system == null) {
                return false;
            }
            PirateBaseIntel base = PirateBaseIntel.getIntelFor(dialog.getInteractionTarget());
            if (base == null) {
                return false;
            }
            return HA_CMD.baseInvolved(system, base);
        }
        if ("addStationKingScript".equals(action)) {
            Global.getSoundPlayer().playUISound("ui_rep_raise", 1.0f, 1.0f);
            PirateBaseIntel base = PirateBaseIntel.getIntelFor(dialog.getInteractionTarget());
            if (base == null) {
                return false;
            }
            base.getSystem().addScript(new StationKingScript(base));
            HostileActivityEventIntel ha = HostileActivityEventIntel.get();
            if (ha != null) {
                int tier = base.getTier().ordinal();
                if (tier < 0) {
                    tier = 0;
                }
                if (tier > 4) {
                    tier = 4;
                }
                int points = -1 * Global.getSettings().getIntFromArray("HA_pirateBase", tier);
                HAPirateKingDealFactor factor = new HAPirateKingDealFactor(points);
                ha.addFactor(factor, dialog);
            }
            Misc.adjustRep(base.getBaseCommander(), 0.05f, text);
            Misc.adjustRep(base.getBaseCommander().getFaction().getId(), 0.03f, text);
        } else {
            if ("endStationKingDeal".equals(action)) {
                PirateBaseIntel base = PirateBaseIntel.getIntelFor(dialog.getInteractionTarget());
                if (base == null) {
                    return false;
                }
                for (EveryFrameScript curr : base.getSystem().getScripts()) {
                    if (!(curr instanceof StationKingScript)) continue;
                    StationKingScript script = (StationKingScript)curr;
                    script.endDeal(true, dialog);
                    return true;
                }
                return false;
            }
            if ("playerColoniesHavePatherActvity".equals(action)) {
                for (MarketAPI market : Misc.getPlayerMarkets(false)) {
                    float interest = LuddicPathBaseManager.getLuddicPathMarketInterest(market);
                    if (!market.hasCondition("pather_cells") || !(interest > 0.0f)) continue;
                    return true;
                }
            } else {
                if ("payMegaTithe".equals(action)) {
                    int megaTithe = memory.getInt("$LP_megaTithe");
                    int dur = memory.getInt("$LP_megaTitheDuration");
                    cargo.getCredits().subtract(megaTithe);
                    AddRemoveCommodity.addCreditsLossText(megaTithe, text);
                    if (cargo.getCredits().get() <= 0.0f) {
                        cargo.getCredits().set(0.0f);
                    }
                    HA_CMD.setPatherAgreement(true, dur);
                    String factionId = "luddic_path";
                    float range = 100000.0f;
                    List<CampaignFleetAPI> fleets = Misc.findNearbyFleets(pf, range, new Misc.FleetFilter(){

                        public boolean accept(CampaignFleetAPI curr) {
                            return curr.getFaction().getId().equals("luddic_path");
                        }
                    });
                    for (CampaignFleetAPI curr : fleets) {
                        if (curr.getAI() != null) {
                            curr.getAI().setActionTextOverride(null);
                        }
                        if (curr.getAI() instanceof ModularFleetAIAPI) {
                            ModularFleetAIAPI mAI = (ModularFleetAIAPI)curr.getAI();
                            mAI.getTacticalModule().forceTargetReEval();
                        }
                        Misc.giveStandardReturnToSourceAssignments(curr, true);
                    }
                    HostileActivityEventIntel ha = HostileActivityEventIntel.get();
                    if (ha != null) {
                        int points = -1 * Global.getSettings().getInt("HA_megaTithe");
                        HALuddicPathDealFactor factor = new HALuddicPathDealFactor(points);
                        ha.addFactor(factor, dialog);
                    }
                    return true;
                }
                if ("gavePKToPather".equals(action)) {
                    HostileActivityEventIntel ha = HostileActivityEventIntel.get();
                    if (ha != null) {
                        int points = -1 * Global.getSettings().getInt("HA_givePK");
                        HALuddicPathDealFactor factor = new HALuddicPathDealFactor(points);
                        ha.addFactor(factor, dialog);
                    }
                } else if ("computeMegaTithe".equals(action)) {
                    float credits = cargo.getCredits().get();
                    float normalTithe = Global.getSector().getPlayerFleet().getFleetPoints() * 200;
                    int tithe = 0;
                    float tithePerPointPerColonySize = Global.getSettings().getFloat("luddicPathTithePerPointOfInterestPerColonySize");
                    int titheDuration = Global.getSettings().getInt("luddicPathTitheDurationDays");
                    for (MarketAPI market : Misc.getPlayerMarkets(false)) {
                        float interest = LuddicPathBaseManager.getLuddicPathMarketInterest(market);
                        tithe = (int)((float)tithe + (interest += (float)market.getSize()) * (float)market.getSize() * tithePerPointPerColonySize);
                    }
                    tithe = (int)((float)tithe + normalTithe);
                    tithe = (int)Misc.getRounded(tithe);
                    memoryMap.get("local").set("$LP_megaTithe", tithe, 0.0f);
                    memoryMap.get("local").set("$LP_megaTitheDGS", Misc.getWithDGS(tithe), 0.0f);
                    memoryMap.get("local").set("$LP_megaTitheDuration", titheDuration, 0.0f);
                    return tithe > 0;
                }
            }
        }
        return false;
    }

    public static boolean baseInvolved(StarSystemAPI system, PirateBaseIntel base) {
        if (system == null) {
            return false;
        }
        if (base == null) {
            return false;
        }
        return !PirateBasePirateActivityCause2.getColoniesAffectedBy(base).isEmpty();
    }

    public static class StationKingScript
    implements EveryFrameScript,
    TooltipMakerAPI.TooltipCreator,
    EconomyTickListener,
    FleetEventListener,
    CurrentLocationChangedListener,
    ColonyPlayerHostileActListener {
        protected boolean done = false;
        protected PirateBaseIntel intel;
        protected Random random = new Random();
        protected float untilMercCheck = 0.0f;
        protected float mercProbMult = 1.0f;
        protected transient boolean spawnMerc = false;

        public StationKingScript(PirateBaseIntel intel) {
            this.intel = intel;
            Global.getSector().getListenerManager().addListener(this);
            this.resetMercCheckDelay();
        }

        protected Object readResolve() {
            if (this.random == null) {
                this.random = new Random();
            }
            return this;
        }

        protected void resetMercCheckDelay() {
            this.untilMercCheck = Global.getSettings().getFloatFromArray("pirateProtectionMercSpawnInterval", 0) + (Global.getSettings().getFloatFromArray("pirateProtectionMercSpawnInterval", 1) - Global.getSettings().getFloatFromArray("pirateProtectionMercSpawnInterval", 0)) * Misc.random.nextFloat();
        }

        protected void setDone() {
            this.done = true;
            Global.getSector().getListenerManager().removeListener(this);
        }

        public boolean isDone() {
            return this.done;
        }

        public boolean runWhilePaused() {
            return false;
        }

        public void reportEconomyTick(int iterIndex) {
            MonthlyReport report = SharedData.getData().getCurrentReport();
            MonthlyReport.FDNode marketsNode = report.getNode(MonthlyReport.OUTPOSTS);
            int payment = HA_CMD.computePirateProtectionPaymentPerTick(this.intel);
            if (payment <= 0) {
                return;
            }
            MonthlyReport.FDNode paymentNode = report.getNode(marketsNode, "pirate_payment");
            paymentNode.name = "Protection payment";
            paymentNode.upkeep += (float)payment;
            paymentNode.tooltipCreator = this;
            paymentNode.mapEntity = this.intel.getEntity();
            paymentNode.icon = Global.getSettings().getSpriteName("income_report", "generic_expense");
        }

        public void reportEconomyMonthEnd() {
        }

        public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
            float opad = 10.0f;
            tooltip.addSpacer(-10.0f);
            tooltip.addPara("Protection payment to the " + this.intel.getBaseCommander().getPost() + " of " + this.intel.getEntity().getName() + ". The pirate base is located in the " + this.intel.getSystem().getNameWithLowercaseTypeShort() + ".", opad);
        }

        public float getTooltipWidth(Object tooltipParam) {
            return 450.0f;
        }

        public boolean isTooltipExpandable(Object tooltipParam) {
            return false;
        }

        public void advance(float amount) {
            if (this.isDone()) {
                return;
            }
            if (this.intel.isEnded() || this.intel.isEnding()) {
                if (this.intel.playerHasDealWithBaseCommander()) {
                    this.intel.setPlayerHasDealWithBaseCommander(false);
                }
                this.setDone();
                return;
            }
            if (this.intel.playerHasDealWithBaseCommander() && this.intel.getSystem().isCurrentLocation()) {
                CampaignFleetAPI station = Misc.getStationFleet(this.intel.getEntity());
                ArrayList<CampaignFleetAPI> fleets = new ArrayList<CampaignFleetAPI>(this.intel.getSystem().getFleets());
                fleets.add(station);
                for (CampaignFleetAPI fleet : fleets) {
                    MarketAPI source = Misc.getSourceMarket(fleet);
                    if (source != this.intel.getMarket() && fleet != station) continue;
                    Misc.setFlagWithReason(fleet.getMemoryWithoutUpdate(), "$cfai_makeNonHostile", "psk_deal", true, 0.1f);
                    fleet.getMemoryWithoutUpdate().set("$cfai_allowPlayerBattleJoinTOff", true, 0.1f);
                }
            }
            float days = Global.getSector().getClock().convertToDays(amount);
            this.untilMercCheck -= days;
            if (this.untilMercCheck < 0.0f) {
                this.untilMercCheck = 0.0f;
            }
            if (this.spawnMerc) {
                this.spawnMerc();
                this.spawnMerc = false;
            }
        }

        public void reportFleetDespawnedToListener(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
        }

        public void reportBattleOccurred(CampaignFleetAPI fleet, CampaignFleetAPI primaryWinner, BattleAPI battle) {
            if (!battle.isPlayerInvolved()) {
                return;
            }
            CampaignFleetAPI station = Misc.getStationFleet(this.intel.getEntity());
            for (CampaignFleetAPI curr : battle.getNonPlayerSideSnapshot()) {
                MarketAPI source;
                if (!curr.knowsWhoPlayerIs() && curr != station || (source = Misc.getSourceMarket(curr)) != this.intel.getMarket() && curr != station) continue;
                this.endDeal(false, null);
                return;
            }
        }

        public void reportRaidForValuablesFinishedBeforeCargoShown(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData, CargoAPI cargo) {
            if (market == this.intel.getMarket() && !actionData.secret && !cargo.isEmpty()) {
                this.endDeal(false, dialog);
            }
        }

        public void reportRaidToDisruptFinished(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData, Industry industry) {
            if (market == this.intel.getMarket() && !actionData.secret) {
                this.endDeal(false, dialog);
            }
        }

        public void reportTacticalBombardmentFinished(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData) {
            if (market == this.intel.getMarket() && !actionData.secret) {
                this.endDeal(false, dialog);
            }
        }

        public void reportSaturationBombardmentFinished(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData) {
            if (market == this.intel.getMarket() && !actionData.secret) {
                this.endDeal(false, dialog);
            }
        }

        public void endDeal(boolean amicable, InteractionDialogAPI dialog) {
            if (!this.intel.playerHasDealWithBaseCommander()) {
                return;
            }
            TextPanelAPI textPanel = dialog == null ? null : dialog.getTextPanel();
            this.intel.setPlayerHasDealWithBaseCommander(false);
            if (amicable) {
                this.intel.sendUpdateIfPlayerHasIntel(PirateBaseIntel.DEAL_CANCELLED_PARAM, textPanel);
            } else {
                this.intel.sendUpdateIfPlayerHasIntel(PirateBaseIntel.DEAL_BROKEN_PARAM, textPanel);
            }
            if (!amicable) {
                Misc.incrUntrustwortyCount();
            }
            if (amicable) {
                Misc.adjustRep(this.intel.getBaseCommander(), -0.060000002f, textPanel);
                Misc.adjustRep(this.intel.getBaseCommander().getFaction().getId(), -0.04f, textPanel);
            } else {
                Misc.adjustRep(this.intel.getBaseCommander(), -0.1f, textPanel);
                Misc.adjustRep(this.intel.getBaseCommander().getFaction().getId(), -0.06f, textPanel);
            }
            CampaignFleetAPI station = Misc.getStationFleet(this.intel.getEntity());
            ArrayList<CampaignFleetAPI> fleets = new ArrayList<CampaignFleetAPI>(this.intel.getSystem().getFleets());
            fleets.add(station);
            for (CampaignFleetAPI fleet : fleets) {
                MarketAPI source = Misc.getSourceMarket(fleet);
                if (source != this.intel.getMarket() && fleet != station) continue;
                Misc.setFlagWithReason(fleet.getMemoryWithoutUpdate(), "$cfai_makeNonHostile", "psk_deal", false, 0.0f);
                fleet.getMemoryWithoutUpdate().unset("$cfai_allowPlayerBattleJoinTOff");
            }
            this.setDone();
        }

        public void reportCurrentLocationChanged(LocationAPI prev, LocationAPI curr) {
            if (curr == this.intel.getSystem()) {
                float prob = Global.getSettings().getFloat("pirateProtectionMercSpawnChance");
                prob *= this.mercProbMult;
                if (this.untilMercCheck <= 0.0f && this.random.nextFloat() < prob) {
                    this.mercProbMult *= Global.getSettings().getFloat("pirateProtectionMercSpawnChanceMult");
                    this.spawnMerc = true;
                    this.resetMercCheckDelay();
                }
            }
        }

        public void spawnMerc() {
            JumpPointAPI jp;
            CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
            float dist = Misc.getDistance(pf, jp = Misc.findNearestJumpPointTo(pf));
            if (dist > 500.0f) {
                return;
            }
            float f = 10.0f;
            StarSystemAPI system = this.intel.getSystem();
            int difficulty = 0;
            PirateBaseIntel.PirateBaseTier tier = this.intel.getTier();
            switch (tier) {
                case TIER_1_1MODULE: {
                    difficulty = 3;
                    break;
                }
                case TIER_2_1MODULE: {
                    difficulty = 4;
                    break;
                }
                case TIER_3_2MODULE: {
                    difficulty = 5;
                    break;
                }
                case TIER_4_3MODULE: {
                    difficulty = 6;
                    break;
                }
                case TIER_5_3MODULE: {
                    difficulty = 7;
                }
            }
            FleetCreatorMission m = new FleetCreatorMission(this.random);
            m.beginFleet();
            Vector2f hLoc = system.getLocation();
            m.createQualityFleet(difficulty += this.random.nextInt(3), "mercenary", hLoc);
            m.triggerSetFleetFaction("independent");
            m.triggerMakeLowRepImpact();
            m.triggerFleetSetAllWeapons();
            m.triggerFleetMakeImportantPermanent(null);
            m.triggerSetFleetMemoryValue("$psk_merc", true);
            CampaignFleetAPI fleet = m.createFleet();
            if (fleet != null) {
                system.addEntity(fleet);
                Vector2f loc = new Vector2f((ReadableVector2f)pf.getLocation());
                loc = Misc.getPointAtRadius(loc, 400.0f);
                fleet.setLocation(loc.x, loc.y);
                SectorEntityToken e = system.createToken(loc);
                fleet.addAssignment(FleetAssignment.ORBIT_AGGRESSIVE, e, 2.0f + 3.0f * this.random.nextFloat(), "preparing to attack " + this.intel.getEntity().getName());
                fleet.addAssignment(FleetAssignment.GO_TO_LOCATION, this.intel.getEntity(), 20.0f, "moving to attack " + this.intel.getEntity().getName());
                fleet.addScript(new MissionFleetAutoDespawn(null, fleet));
                fleet.addAssignmentAtStart(FleetAssignment.INTERCEPT, pf, 1.0f, null);
            }
        }
    }
}

