/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.intel.events.ht.HTPoints;
import com.fs.starfarer.api.impl.campaign.intel.events.ht.HTScavengerDataFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.ht.HyperspaceTopographyEventIntel;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.Objectives;
import com.fs.starfarer.api.impl.campaign.velfield.SlipstreamVisibilityManager;
import com.fs.starfarer.api.util.Misc;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HT_CMD
extends BaseCommandPlugin {
    public static int CREDITS_PER_TD_POINT = 200;
    public static float MIN_SCAVENGER_FP = 50.0f;
    public static float MAX_SCAVENGER_FP = 150.0f;

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (dialog == null) {
            return false;
        }
        OptionPanelAPI options = dialog.getOptionPanel();
        TextPanelAPI text = dialog.getTextPanel();
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        CargoAPI cargo = pf.getCargo();
        SectorEntityToken entity = dialog.getInteractionTarget();
        if (entity == null) {
            return false;
        }
        String action = params.get(0).getString(memoryMap);
        MemoryAPI memory = memoryMap.get("local");
        if (memory == null) {
            return false;
        }
        StarSystemAPI system = null;
        if (dialog.getInteractionTarget().getContainingLocation() instanceof StarSystemAPI) {
            system = (StarSystemAPI)dialog.getInteractionTarget().getContainingLocation();
        }
        if ("hasRecentReadingsNearby".equals(action)) {
            return HyperspaceTopographyEventIntel.hasRecentReadingsNearPlayer();
        }
        if ("computeDataStats".equals(action)) {
            if (entity instanceof CampaignFleetAPI) {
                CampaignFleetAPI fleet = (CampaignFleetAPI)entity;
                float fp = fleet.getFleetPoints();
                int cost = HT_CMD.getDataCost(fp);
                float range = HT_CMD.getRevealRange(fp);
                memory.set("$ht_dataCost", Misc.getWithDGS(cost));
                memory.set("$ht_dataRange", "" + (int)range);
                return true;
            }
            return false;
        }
        if ("getScavengerData".equals(action)) {
            if (entity instanceof CampaignFleetAPI) {
                CampaignFleetAPI fleet = (CampaignFleetAPI)entity;
                float fp = fleet.getFleetPoints();
                float range = HT_CMD.getRevealRange(fp);
                SlipstreamVisibilityManager.updateSlipstreamVisibility(entity.getLocationInHyperspace(), range);
                int points = HT_CMD.getDataPoints(fp);
                boolean hasRecent = HyperspaceTopographyEventIntel.hasRecentReadingsNearPlayer();
                if (!hasRecent && points > 0) {
                    HyperspaceTopographyEventIntel.addFactorCreateIfNecessary(new HTScavengerDataFactor(points), dialog);
                    if (HyperspaceTopographyEventIntel.get() != null) {
                        HyperspaceTopographyEventIntel.get().addRecentReadings(entity.getLocationInHyperspace());
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public static int getDataCost(float fp) {
        return HT_CMD.getDataPoints(fp) * CREDITS_PER_TD_POINT;
    }

    public static int getRevealRange(float fp) {
        float min = Objectives.BURST_RANGE_SCAVENGER_MIN;
        float max = Objectives.BURST_RANGE_SCAVENGER_MAX;
        float f = Math.max(fp - MIN_SCAVENGER_FP, 0.0f) / (MAX_SCAVENGER_FP - MIN_SCAVENGER_FP);
        if (f > 1.0f) {
            f = 1.0f;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        int result = Math.round(min + (max - min) * f);
        return result;
    }

    public static int getDataPoints(float fp) {
        float min = HTPoints.SCAVENGER_MIN;
        float max = HTPoints.SCAVENGER_MAX;
        float f = Math.max(fp - MIN_SCAVENGER_FP, 0.0f) / (MAX_SCAVENGER_FP - MIN_SCAVENGER_FP);
        if (f > 1.0f) {
            f = 1.0f;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        int result = Math.round(min + (max - min) * f);
        return result;
    }
}

