/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.GameState;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.impl.campaign.DevMenuOptions;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.DumpMemory;
import com.fs.starfarer.api.impl.campaign.rulecmd.FireBest;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaginatedOptions
extends BaseCommandPlugin
implements InteractionDialogPlugin {
    public static String OPTION_NEXT_PAGE = "core_option_next_page";
    public static String OPTION_PREV_PAGE = "core_option_prev_page";
    protected InteractionDialogPlugin originalPlugin;
    protected InteractionDialogAPI dialog;
    protected Map<String, MemoryAPI> memoryMap;
    protected List<PaginatedOption> options = new ArrayList<PaginatedOption>();
    protected List<PaginatedOption> optionsAllPages = new ArrayList<PaginatedOption>();
    protected int optionsPerPage = 5;
    protected int currPage = 0;
    protected boolean withSpacers = true;

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        this.dialog = dialog;
        this.memoryMap = memoryMap;
        this.originalPlugin = dialog.getPlugin();
        dialog.setPlugin(this);
        this.init(dialog);
        int i = 0;
        while (i < params.size()) {
            String text = params.get(i).getString(memoryMap);
            String id = params.get(i + 1).getString(memoryMap);
            this.addOption(text, id);
            i += 2;
        }
        if (params.size() > 0) {
            this.showOptions();
        }
        return true;
    }

    public void addOption(String text, String id) {
        this.options.add(new PaginatedOption(text, id));
    }

    public void addOptionAllPages(String text, String id) {
        this.optionsAllPages.add(new PaginatedOption(text, id));
    }

    public void showOptions() {
        int start;
        this.dialog.getOptionPanel().clearOptions();
        int maxPages = (int)Math.ceil((float)this.options.size() / (float)this.optionsPerPage);
        if (this.currPage > maxPages - 1) {
            this.currPage = maxPages - 1;
        }
        if (this.currPage < 0) {
            this.currPage = 0;
        }
        int i = start = this.currPage * this.optionsPerPage;
        while (i < start + this.optionsPerPage) {
            if (i >= this.options.size()) {
                if (maxPages > 1 && this.withSpacers) {
                    this.dialog.getOptionPanel().addOption("", "spacer" + i);
                    this.dialog.getOptionPanel().setEnabled("spacer" + i, false);
                }
            } else {
                PaginatedOption option = this.options.get(i);
                this.dialog.getOptionPanel().addOption(option.text, option.id);
            }
            ++i;
        }
        if (maxPages > 1) {
            this.dialog.getOptionPanel().addOption(this.getPreviousPageText(), OPTION_PREV_PAGE);
            this.dialog.getOptionPanel().addOption(this.getNextPageText(), OPTION_NEXT_PAGE);
            if (this.currPage >= maxPages - 1) {
                this.dialog.getOptionPanel().setEnabled(OPTION_NEXT_PAGE, false);
            }
            if (this.currPage <= 0) {
                this.dialog.getOptionPanel().setEnabled(OPTION_PREV_PAGE, false);
            }
        }
        for (PaginatedOption option : this.optionsAllPages) {
            this.dialog.getOptionPanel().addOption(option.text, option.id);
        }
        if (Global.getSettings().isDevMode()) {
            DevMenuOptions.addOptions(this.dialog);
        }
    }

    public String getPreviousPageText() {
        return "Previous page";
    }

    public String getNextPageText() {
        return "Next page";
    }

    public boolean isNewGameDialog() {
        return Global.getCurrentState() == GameState.TITLE;
    }

    @Override
    public void optionSelected(String optionText, Object optionData) {
        if (optionData == OPTION_PREV_PAGE) {
            --this.currPage;
            this.showOptions();
            return;
        }
        if (optionData == OPTION_NEXT_PAGE) {
            ++this.currPage;
            this.showOptions();
            return;
        }
        if (optionText != null) {
            this.dialog.getTextPanel().addParagraph(optionText, Global.getSettings().getColor("buttonText"));
        }
        if (optionData == "DumpMemory.option_dump_memory") {
            new DumpMemory().execute(null, this.dialog, null, this.getMemoryMap());
            return;
        }
        if (DevMenuOptions.isDevOption(optionData)) {
            DevMenuOptions.execute(this.dialog, (String)optionData);
            return;
        }
        this.dialog.setPlugin(this.originalPlugin);
        MemoryAPI memory = this.dialog.getInteractionTarget().getMemory();
        memory.set("$option", optionData);
        memory.expire("$option", 0.0f);
        this.memoryMap.get("local").set("$option", optionData, 0.0f);
        boolean fired = FireBest.fire(null, this.dialog, this.memoryMap, this.isNewGameDialog() ? "NewGameOptionSelected" : "DialogOptionSelected");
        if (!fired) {
            this.dialog.setPlugin(this);
        }
    }

    @Override
    public void advance(float amount) {
    }

    @Override
    public void backFromEngagement(EngagementResultAPI battleResult) {
    }

    @Override
    public Object getContext() {
        return null;
    }

    @Override
    public Map<String, MemoryAPI> getMemoryMap() {
        return this.memoryMap;
    }

    @Override
    public void optionMousedOver(String optionText, Object optionData) {
    }

    @Override
    public void init(InteractionDialogAPI dialog) {
    }

    public static class PaginatedOption {
        public String text;
        public String id;

        public PaginatedOption(String text, String id) {
            this.text = text;
            this.id = id;
        }
    }
}

