/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.salvage;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.CoreInteractionListener;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.CargoPodsEntityPlugin;
import com.fs.starfarer.api.impl.campaign.intel.misc.CargoPodsIntel;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.FireAll;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CargoPods
extends BaseCommandPlugin {
    public static final String TRAPPED = "$trapped";
    public static final String LOCKED = "$locked";
    public static final String CAN_UNLOCK = "$canUnlock";
    public static final float BREAK_KEEP_FRACTION = 0.5f;
    protected CampaignFleetAPI playerFleet;
    protected SectorEntityToken entity;
    protected FactionAPI playerFaction;
    protected FactionAPI entityFaction;
    protected TextPanelAPI text;
    protected OptionPanelAPI options;
    protected CargoAPI playerCargo;
    protected CargoAPI podsCargo;
    protected MemoryAPI memory;
    protected InteractionDialogAPI dialog;
    protected CargoPodsEntityPlugin plugin;
    protected Map<String, MemoryAPI> memoryMap;

    protected boolean isLocked() {
        return this.memory.getBoolean(LOCKED);
    }

    protected boolean isTrapped() {
        return this.memory.getBoolean(TRAPPED);
    }

    protected boolean canUnlock() {
        return this.memory.getBoolean(CAN_UNLOCK);
    }

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        this.dialog = dialog;
        this.memoryMap = memoryMap;
        String command = params.get(0).getString(memoryMap);
        if (command == null) {
            return false;
        }
        this.memory = CargoPods.getEntityMemory(memoryMap);
        this.entity = dialog.getInteractionTarget();
        this.text = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        this.playerFleet = Global.getSector().getPlayerFleet();
        this.playerCargo = this.playerFleet.getCargo();
        this.podsCargo = this.entity.getCargo();
        this.playerFaction = Global.getSector().getPlayerFaction();
        this.entityFaction = this.entity.getFaction();
        this.plugin = (CargoPodsEntityPlugin)this.entity.getCustomPlugin();
        if (command.equals("printDesc")) {
            this.showDescription();
        } else if (command.equals("openCargo")) {
            this.openCargo();
        } else if (command.equals("breakLocks")) {
            this.breakLocks();
        } else if (command.equals("destroy")) {
            this.destroy();
        } else if (command.equals("stabilize")) {
            this.stabilize();
        } else if (command.equals("computeStabilizeData")) {
            this.computeStabilizeData();
        }
        return true;
    }

    protected void computeStabilizeData() {
        float total = (float)this.podsCargo.getTotalPersonnel() + this.podsCargo.getSpaceUsed() + this.podsCargo.getFuel();
        float stabilizeSupplies = Math.max((int)total / 200, 2);
        this.memory.set("$stabilizeSupplies", (int)stabilizeSupplies, 0.0f);
        float stabilizeDays = 400.0f;
        this.memory.set("$stabilizeDays", (int)stabilizeDays, 0.0f);
    }

    public static SectorEntityToken findOrbitFocus(SectorEntityToken entity) {
        if (entity.isInHyperspace()) {
            return null;
        }
        SectorEntityToken target = null;
        float minDist = Float.MAX_VALUE;
        ArrayList<PlanetAPI> potential = new ArrayList<PlanetAPI>(entity.getContainingLocation().getPlanets());
        SectorEntityToken center = ((StarSystemAPI)entity.getContainingLocation()).getCenter();
        potential.add((PlanetAPI)center);
        potential.addAll(entity.getContainingLocation().getJumpPoints());
        for (SectorEntityToken sectorEntityToken : potential) {
            float dist = Misc.getDistance(entity.getLocation(), sectorEntityToken.getLocation());
            dist -= sectorEntityToken.getRadius();
            float maxDist = 400.0f;
            if (sectorEntityToken instanceof PlanetAPI && ((PlanetAPI)sectorEntityToken).isStar() || sectorEntityToken == center) {
                maxDist = 1.0E11f;
            }
            if (!(dist < maxDist) || !(dist < minDist)) continue;
            target = sectorEntityToken;
            minDist = dist;
        }
        return target;
    }

    public static void stabilizeOrbit(SectorEntityToken entity, boolean makeDiscovered) {
        SectorEntityToken focus = CargoPods.findOrbitFocus(entity);
        if (focus != null) {
            float radius = Misc.getDistance(focus.getLocation(), entity.getLocation());
            float orbitDays = radius / (5.0f + Misc.random.nextFloat() * 20.0f);
            float angle = Misc.getAngleInDegreesStrict(focus.getLocation(), entity.getLocation());
            entity.setCircularOrbit(focus, angle, radius, orbitDays);
        } else {
            entity.getVelocity().set(0.0f, 0.0f);
        }
        if (makeDiscovered) {
            entity.setDiscoverable(null);
            entity.setSensorProfile(null);
        }
        entity.getMemoryWithoutUpdate().set("$stabilized", true);
    }

    protected void stabilize() {
        CargoPods.stabilizeOrbit(this.entity, true);
        float stabilizeSupplies = this.memory.getFloat("$stabilizeSupplies");
        float stabilizeDays = this.memory.getFloat("$stabilizeDays");
        this.playerCargo.removeSupplies(stabilizeSupplies);
        this.plugin.setElapsed(0.0f);
        this.plugin.setExtraDays(stabilizeDays);
        this.plugin.updateBaseMaxDays();
        AddRemoveCommodity.updatePlayerMemoryQuantity("supplies");
        AddRemoveCommodity.addCommodityLossText("supplies", (int)stabilizeSupplies, this.text);
        this.text.addParagraph("Your crew busy themselves attaching micro-thrusters and carefully sealing, balancing, and interconnecting the pods to make sure they remain in a stable orbit.");
        float daysLeft = this.plugin.getDaysLeft();
        this.memory.set("$stabilized", true);
        this.memory.set("$daysLeft", (int)daysLeft, 0.0f);
        CargoPodsIntel intel = null;
        for (IntelInfoPlugin iip : Global.getSector().getIntelManager().getIntel(CargoPodsIntel.class)) {
            CargoPodsIntel curr = (CargoPodsIntel)iip;
            if (curr.getPods() != this.entity) continue;
            intel = curr;
            break;
        }
        if (intel == null) {
            intel = new CargoPodsIntel(this.entity);
            Global.getSector().getIntelManager().addIntel(intel, true);
        }
        Global.getSector().getIntelManager().addIntelToTextPanel(intel, this.text);
    }

    protected void destabilize() {
        if (!this.memory.getBoolean("$stabilized")) {
            return;
        }
        this.entity.setOrbit(null);
        Vector2f vel = Misc.getUnitVectorAtDegreeAngle((float)Math.random() * 360.0f);
        vel.scale(5.0f + 10.0f * (float)Math.random());
        this.entity.getVelocity().set((ReadableVector2f)vel);
        this.entity.setDiscoverable(null);
        this.entity.setSensorProfile(Float.valueOf(1.0f));
        this.plugin.setElapsed(0.0f);
        this.plugin.setExtraDays(0.0f);
        this.plugin.updateBaseMaxDays();
        float daysLeft = this.plugin.getDaysLeft();
        String atLeastTime = Misc.getAtLeastStringForDays((int)daysLeft);
        this.text.addParagraph("Working with the cargo has destablized the orbit, but the pods should still be trackable for " + atLeastTime + ".");
        this.memory.unset("$stabilized");
    }

    protected void breakLocks() {
        this.pruneCargo(0.5f);
        this.openCargo();
    }

    protected void pruneCargo(float fractionKeep) {
        CargoAPI keep = Global.getFactory().createCargo(true);
        Random random = new Random();
        if (this.memory.contains("$salvageSeed")) {
            long seed = this.memory.getLong("$salvageSeed");
            random = new Random(seed);
        }
        for (CargoStackAPI stack : this.podsCargo.getStacksCopy()) {
            int qty = (int)stack.getSize();
            int i = 0;
            while (i < qty) {
                if (random.nextFloat() < fractionKeep) {
                    keep.addItems(stack.getType(), stack.getData(), 1.0f);
                }
                ++i;
            }
        }
        this.podsCargo.clear();
        this.podsCargo.addAll(keep);
    }

    protected void destroy() {
        this.podsCargo.clear();
        Misc.fadeAndExpire(this.entity, 1.0f);
    }

    protected void showDescription() {
        float daysLeft = this.plugin.getDaysLeft();
        this.memory.set("$daysLeft", (int)daysLeft, 0.0f);
        boolean stabilized = this.memory.getBoolean("$stabilized");
        if (daysLeft >= 5000.0f) {
            this.text.addParagraph("The cargo pods are in a stable orbit and are unlikely to drift apart any time soon.");
        } else {
            String atLeastTime = Misc.getAtLeastStringForDays((int)daysLeft);
            if (stabilized && daysLeft > 20.0f) {
                this.text.addParagraph("The cargo pods are in a stabilized orbit, and your systems should be able to keep track of them for " + atLeastTime + ".");
            } else {
                this.text.addParagraph("The cargo pods are in an unstable orbit, but should not drift apart and be lost for " + atLeastTime + ".");
            }
        }
        if (this.podsCargo.getTotalPersonnel() > 0) {
            String crewText = "Sensor readings are indicative of the presence of active life support and cryosleep equipment.";
            this.text.addParagraph(crewText);
        }
        if (this.isLocked()) {
            if (this.canUnlock()) {
                this.text.addParagraph("The pods are locked, but you are in posession of the keycode.");
            } else {
                this.text.addParagraph("The pods are locked, and you don't have the keycode. It's possible to force the locks, but this carries a risk to the cargo. Some pods are also fitted with a self-destruct mechanism, ensuring the total loss of all cargo in the event of a breach attempt.");
            }
        }
    }

    public void openCargo() {
        final CargoAPI preOpen = Global.getFactory().createCargo(true);
        preOpen.addAll(this.podsCargo);
        this.dialog.getVisualPanel().showLoot("Cargo Pods", this.podsCargo, true, false, false, new CoreInteractionListener(){

            public void coreUIDismissed() {
                CargoPods.this.plugin.updateBaseMaxDays();
                if (CargoPods.this.podsCargo.isEmpty()) {
                    Misc.fadeAndExpire(CargoPods.this.entity, 1.0f);
                    CargoPods.this.dialog.dismiss();
                    CargoPods.this.dialog.hideTextPanel();
                    CargoPods.this.dialog.hideVisualPanel();
                } else if (!Misc.isSameCargo(preOpen, CargoPods.this.podsCargo)) {
                    CargoPods.this.destabilize();
                }
                CargoPods.this.dialog.setPromptText("You decide to...");
                FireAll.fire(null, CargoPods.this.dialog, CargoPods.this.memoryMap, "CargoPodsOptions");
                FireAll.fire(null, CargoPods.this.dialog, CargoPods.this.memoryMap, "CargoPodsOptionsUpdate");
            }
        });
        this.options.clearOptions();
        this.dialog.setPromptText("");
    }
}

