/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.salvage;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.CoreInteractionListener;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.ResourceCostPanelAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.listeners.ListenerUtil;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.impl.campaign.DerelictShipEntityPlugin;
import com.fs.starfarer.api.impl.campaign.RepairGantry;
import com.fs.starfarer.api.impl.campaign.procgen.DropGroupRow;
import com.fs.starfarer.api.impl.campaign.procgen.SalvageEntityGenDataSpec;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.SalvageEntityGeneratorOld;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.FireBest;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.BaseSalvageSpecial;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.ShipRecoverySpecial;
import com.fs.starfarer.api.impl.campaign.terrain.DebrisFieldTerrainPlugin;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SalvageEntity
extends BaseCommandPlugin {
    public static float SALVAGE_DETECTION_MOD_FLAT = 1000.0f;
    public static int FIELD_RADIUS_FOR_BASE_REQ = 200;
    public static int FIELD_RADIUS_FOR_MAX_REQ = 1000;
    public static int FIELD_RADIUS_MAX_REQ_MULT = 10;
    public static float FIELD_MIN_SALVAGE_MULT = 0.01f;
    public static float FIELD_SALVAGE_FRACTION_PER_ATTEMPT = 1.0f;
    public static float FIELD_CONTENT_MULTIPLIER_AFTER_SALVAGE = 0.25f;
    public static float FIELD_CONTENT_MULTIPLIER_AFTER_DEMOLITION = 1.0f;
    public static int BASE_MACHINERY = 10;
    public static int BASE_CREW = 30;
    public static int MIN_MACHINERY = 5;
    public static float COST_HEIGHT = 67.0f;
    protected CampaignFleetAPI playerFleet;
    protected SectorEntityToken entity;
    protected FactionAPI playerFaction;
    protected FactionAPI entityFaction;
    protected TextPanelAPI text;
    protected OptionPanelAPI options;
    protected SalvageEntityGenDataSpec spec;
    protected CargoAPI cargo;
    protected MemoryAPI memory;
    protected InteractionDialogAPI dialog;
    private DebrisFieldTerrainPlugin debris;
    private Map<String, MemoryAPI> memoryMap;

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        this.dialog = dialog;
        this.memoryMap = memoryMap;
        String command = params.get(0).getString(memoryMap);
        if (command == null) {
            return false;
        }
        this.memory = SalvageEntity.getEntityMemory(memoryMap);
        this.entity = dialog.getInteractionTarget();
        String specId = this.entity.getCustomEntityType();
        if (specId == null || this.entity.getMemoryWithoutUpdate().contains("$salvageSpecId")) {
            specId = this.entity.getMemoryWithoutUpdate().getString("$salvageSpecId");
        }
        this.spec = SalvageEntityGeneratorOld.getSalvageSpec(specId);
        this.text = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        this.playerFleet = Global.getSector().getPlayerFleet();
        this.cargo = this.playerFleet.getCargo();
        this.playerFaction = Global.getSector().getPlayerFaction();
        this.entityFaction = this.entity.getFaction();
        Object test = this.entity.getMemoryWithoutUpdate().get("$salvageDebrisField");
        if (test instanceof DebrisFieldTerrainPlugin) {
            this.debris = (DebrisFieldTerrainPlugin)test;
        }
        if (command.equals("showCost")) {
            if (this.debris == null) {
                this.showCost();
            } else {
                this.showCostDebrisField();
            }
        } else if (command.equals("performSalvage")) {
            this.performSalvage();
        } else if (command.equals("descDebris")) {
            this.showDebrisDescription();
        } else if (command.equals("checkAccidents")) {
            this.checkAccidents();
        } else if (command.equals("demolish")) {
            this.demolish();
        } else {
            if (command.equals("canBeMadeRecoverable")) {
                return this.canBeMadeRecoverable();
            }
            if (command.equals("showRecoverable")) {
                this.showRecoverable();
            }
        }
        return true;
    }

    private void demolish() {
        boolean isDebrisField = "debris_field_shared".equals(this.entity.getCustomEntityType());
        if (!isDebrisField) {
            this.convertToDebrisField(FIELD_CONTENT_MULTIPLIER_AFTER_DEMOLITION);
            Global.getSoundPlayer().playSound("hit_heavy", 1.0f, 1.0f, Global.getSoundPlayer().getListenerPos(), new Vector2f());
            this.dialog.dismiss();
        }
    }

    private float getAccidentProbability() {
        if (this.debris == null) {
            return 0.0f;
        }
        float accidentProbability = 0.2f + 0.8f * (1.0f - this.debris.getParams().density);
        if (accidentProbability > 0.9f) {
            accidentProbability = 0.9f;
        }
        return accidentProbability;
    }

    private void checkAccidents() {
        float fMachinery;
        if (this.debris == null) {
            this.memory.set("$option", "salPerform");
            FireBest.fire(null, this.dialog, this.memoryMap, "DialogOptionSelected");
            return;
        }
        float accidentProbability = this.getAccidentProbability();
        long seed = this.memory.getLong("$salvageSeed");
        Random random = Misc.getRandom(seed, 175);
        if (random.nextFloat() > accidentProbability) {
            this.memory.set("$option", "salPerform");
            FireBest.fire(null, this.dialog, this.memoryMap, "DialogOptionSelected");
            return;
        }
        Color color = this.playerFaction.getColor();
        Color bad = Misc.getNegativeHighlightColor();
        Color highlight = Misc.getHighlightColor();
        Map<String, Integer> requiredRes = SalvageEntity.computeRequiredToSalvage(this.entity);
        float reqCrew = requiredRes.get("crew").intValue();
        float reqMachinery = requiredRes.get("heavy_machinery").intValue();
        float crew = this.playerFleet.getCargo().getCrew();
        float machinery = this.playerFleet.getCargo().getCommodityQuantity("heavy_machinery");
        float fCrew = crew / reqCrew;
        if (fCrew < 0.0f) {
            fCrew = 0.0f;
        }
        if (fCrew > 1.0f) {
            fCrew = 1.0f;
        }
        if ((fMachinery = machinery / reqMachinery) < 0.0f) {
            fMachinery = 0.0f;
        }
        if (fMachinery > 1.0f) {
            fMachinery = 1.0f;
        }
        float lossValue = reqCrew * fCrew * 5.0f;
        lossValue += (1.0f - this.debris.getParams().density / this.debris.getParams().baseDensity) * 500.0f;
        lossValue *= 0.5f + random.nextFloat();
        WeightedRandomPicker<String> lossPicker = new WeightedRandomPicker<String>(random);
        lossPicker.add("crew", 10.0f + 100.0f * (1.0f - fMachinery));
        lossPicker.add("heavy_machinery", 10.0f + 100.0f * fMachinery);
        CargoAPI losses = Global.getFactory().createCargo(true);
        float loss = 0.0f;
        while (loss < lossValue) {
            String id = (String)lossPicker.pick();
            CommoditySpecAPI spec = Global.getSector().getEconomy().getCommoditySpec(id);
            loss += spec.getBasePrice();
            losses.addCommodity(id, 1.0f);
        }
        losses.sort();
        int crewLost = losses.getCrew();
        if (crewLost > 0) {
            losses.removeCrew(crewLost);
            crewLost = (int)((float)crewLost * this.playerFleet.getStats().getDynamic().getValue("overall_crew_loss_mult"));
            if (crewLost < 1) {
                crewLost = 1;
            }
            losses.addCrew(crewLost);
        }
        int machineryLost = (int)losses.getCommodityQuantity("heavy_machinery");
        if ((float)crewLost > crew) {
            crewLost = (int)crew;
        }
        if ((float)machineryLost > machinery) {
            machineryLost = (int)machinery;
        }
        if (crewLost <= 0 && machineryLost <= 0) {
            this.memory.set("$option", "salPerform");
            FireBest.fire(null, this.dialog, this.memoryMap, "DialogOptionSelected");
        }
        for (CargoStackAPI stack : losses.getStacksCopy()) {
            this.cargo.removeCommodity(stack.getCommodityId(), stack.getSize());
        }
        this.text.setFontInsignia();
        this.text.addParagraph("An accident during the operation has resulted in the loss of ");
        if (crewLost <= 0) {
            this.text.appendToLastParagraph(machineryLost + " heavy machinery.");
            this.text.highlightInLastPara(highlight, "" + machineryLost);
        } else if (machineryLost <= 0) {
            this.text.appendToLastParagraph(crewLost + " crew.");
            this.text.highlightInLastPara(highlight, "" + crewLost);
        } else {
            this.text.appendToLastParagraph(crewLost + " crew and " + machineryLost + " heavy machinery.");
            this.text.highlightInLastPara(highlight, "" + crewLost, "" + machineryLost);
        }
        Global.getSoundPlayer().playSound("hit_solid", 1.0f, 1.0f, Global.getSoundPlayer().getListenerPos(), new Vector2f());
        this.options.clearOptions();
        this.options.addOption("Continue", "salPerform");
    }

    private void showDebrisDescription() {
        if (this.debris == null) {
            return;
        }
        float daysLeft = this.debris.getDaysLeft();
        if (daysLeft >= 1000.0f) {
            this.text.addParagraph("The field appears stable and will not drift apart any time soon.");
        } else {
            String atLeastTime = Misc.getAtLeastStringForDays((int)daysLeft);
            this.text.addParagraph("The field is unstable, but should not drift apart for " + atLeastTime + ".");
        }
        float lootValue = 0.0f;
        for (SalvageEntityGenDataSpec.DropData data : this.debris.getEntity().getDropValue()) {
            lootValue += (float)data.value;
        }
        for (SalvageEntityGenDataSpec.DropData data : this.debris.getEntity().getDropRandom()) {
            if (data.value > 0) {
                lootValue += (float)data.value;
                continue;
            }
            lootValue += 500.0f;
        }
        float d = this.debris.getParams().density;
        if ((lootValue *= d) < 500.0f) {
            this.text.appendToLastParagraph(" Long-range scans indicate it's unlikely anything of much value would be found inside.");
            this.text.highlightLastInLastPara("unlikely", Misc.getNegativeHighlightColor());
        } else if (lootValue < 2500.0f) {
            this.text.appendToLastParagraph(" Long-range scans indicate it's possible something of value could be found inside.");
            this.text.highlightLastInLastPara("possible", Misc.getHighlightColor());
        } else {
            this.text.appendToLastParagraph(" Long-range scans indicate it's likely something of value could be found inside.");
            this.text.highlightLastInLastPara("likely", Misc.getPositiveHighlightColor());
        }
        float accidentProbability = this.getAccidentProbability();
        if (accidentProbability <= 0.2f) {
            this.text.addPara("There are indications of some easy pickings to be had, and the risk of an accident during a salvage operation is low.", Misc.getPositiveHighlightColor(), "low");
        } else if (accidentProbability < 0.7f) {
            this.text.addPara("There are indications that what salvage is to be had may not be easy to get to, and there's %s risk involved in running a salvage operation.", Misc.getHighlightColor(), "significant");
        } else {
            this.text.addPara("The salvage that remains is extremely difficult to get to, and there's %s risk involved in running a salvage operation.", Misc.getNegativeHighlightColor(), "high");
        }
    }

    public static Map<String, Integer> computeRequiredToSalvage(SectorEntityToken entity) {
        LinkedHashMap<String, Integer> result = new LinkedHashMap<String, Integer>();
        String specId = entity.getCustomEntityType();
        if (specId == null || entity.getMemoryWithoutUpdate().contains("$salvageSpecId")) {
            specId = entity.getMemoryWithoutUpdate().getString("$salvageSpecId");
        }
        SalvageEntityGenDataSpec spec = SalvageEntityGeneratorOld.getSalvageSpec(specId);
        float mult = 1.0f + spec.getSalvageRating() * 9.0f;
        Object test = entity.getMemoryWithoutUpdate().get("$salvageDebrisField");
        if (test instanceof DebrisFieldTerrainPlugin) {
            DebrisFieldTerrainPlugin debris = (DebrisFieldTerrainPlugin)test;
            mult = SalvageEntity.getDebrisReqMult(debris);
        }
        int crew = Math.round((float)((int)((float)BASE_CREW * mult)) / 10.0f) * 10;
        int machinery = Math.round((float)((int)((float)BASE_MACHINERY * mult)) / 10.0f) * 10;
        result.put("crew", crew);
        result.put("heavy_machinery", machinery);
        return result;
    }

    protected MutableStat getValueRecoveryStat(boolean withSkillMultForRares) {
        Map<String, Integer> requiredRes = SalvageEntity.computeRequiredToSalvage(this.entity);
        MutableStat valueRecovery = new MutableStat(1.0f);
        int i = 0;
        float machineryContrib = 0.75f;
        valueRecovery.modifyPercent("base", -100.0f);
        if (machineryContrib < 1.0f) {
            valueRecovery.modifyPercent("base_positive", Math.round(100.0f - 100.0f * machineryContrib), "Base effectiveness");
        }
        float per = 0.5f;
        per = 1.0f;
        for (String commodityId : requiredRes.keySet()) {
            float required = requiredRes.get(commodityId).intValue();
            float available = (int)this.cargo.getCommodityQuantity(commodityId);
            if (required <= 0.0f) continue;
            CommoditySpecAPI spec = Global.getSector().getEconomy().getCommoditySpec(commodityId);
            float val = Math.min(available / required, 1.0f) * per;
            int percent = Math.round(val * 100.0f);
            if ("heavy_machinery".equals(commodityId)) {
                val = Math.min(available / required, machineryContrib) * per;
                percent = Math.round(val * 100.0f);
                valueRecovery.modifyPercentAlways("" + i++, percent, String.valueOf(Misc.ucFirst(spec.getLowerCaseName())) + " available");
                continue;
            }
            valueRecovery.modifyMultAlways("" + i++, val, String.valueOf(Misc.ucFirst(spec.getLowerCaseName())) + " available");
        }
        boolean modified = false;
        if (withSkillMultForRares) {
            for (MutableStat.StatMod mod : this.playerFleet.getStats().getDynamic().getStat("salvage_value_bonus_fleet").getFlatMods().values()) {
                modified = true;
                valueRecovery.modifyPercentAlways("" + i++, Math.round(mod.value * 100.0f), mod.desc);
            }
        }
        for (MutableStat.StatMod mod : this.playerFleet.getStats().getDynamic().getStat("salvage_value_bonus_fleet_not_rare").getFlatMods().values()) {
            modified = true;
            valueRecovery.modifyPercentAlways("" + i++, Math.round(mod.value * 100.0f), mod.desc);
        }
        if (!modified) {
            valueRecovery.modifyPercentAlways("" + i++, Math.round(0.0f), "Salvaging skill");
        }
        float fleetSalvageShips = SalvageEntity.getPlayerShipsSalvageModUncapped();
        valueRecovery.modifyPercentAlways("" + i++, Math.round(fleetSalvageShips * 100.0f), "Fleetwide salvaging capability");
        return valueRecovery;
    }

    public void showCost() {
        Color color = this.playerFaction.getColor();
        Color bad = Misc.getNegativeHighlightColor();
        Color highlight = Misc.getHighlightColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float small = 5.0f;
        Map<String, Integer> requiredRes = SalvageEntity.computeRequiredToSalvage(this.entity);
        this.text.addParagraph("You receive a preliminary assessment of a potential salvage operation from the exploration crews.");
        ResourceCostPanelAPI cost = this.text.addCostPanel("Crew & machinery: required (available)", COST_HEIGHT, color, this.playerFaction.getDarkUIColor());
        cost.setNumberOnlyMode(true);
        cost.setWithBorder(false);
        cost.setAlignment(Alignment.LMID);
        for (String commodityId : requiredRes.keySet()) {
            int required = requiredRes.get(commodityId);
            int available = (int)this.cargo.getCommodityQuantity(commodityId);
            Color curr = color;
            if ((float)required > this.cargo.getQuantity(CargoAPI.CargoItemType.RESOURCES, commodityId)) {
                curr = bad;
            }
            cost.addCost(commodityId, required + " (" + available + ")", curr);
        }
        cost.update();
        MutableStat valueRecovery = this.getValueRecoveryStat(true);
        int valuePercent = Math.round(valueRecovery.getModifiedValue() * 100.0f);
        if (valuePercent < 0) {
            valuePercent = 0;
        }
        String valueString = valuePercent + "%";
        Color valueColor = highlight;
        if (valuePercent < 100) {
            valueColor = bad;
        }
        TooltipMakerAPI info = this.text.beginTooltip();
        info.setParaSmallInsignia();
        info.addPara("Resource recovery effectiveness: %s", 0.0f, valueColor, valueString);
        if (!valueRecovery.isUnmodified()) {
            info.addStatModGrid(300.0f, 50.0f, opad, small, valueRecovery, true, this.getModPrinter());
        }
        this.text.addTooltip();
        this.printSalvageModifiers();
    }

    protected TooltipMakerAPI.StatModValueGetter getModPrinter() {
        return new TooltipMakerAPI.StatModValueGetter(){
            boolean percent = false;

            public String getPercentValue(MutableStat.StatMod mod) {
                this.percent = true;
                if (mod.desc == null || mod.desc.isEmpty()) {
                    return "";
                }
                String prefix = mod.getValue() >= 0.0f ? "+" : "";
                return String.valueOf(prefix) + (int)mod.getValue() + "%";
            }

            public String getMultValue(MutableStat.StatMod mod) {
                this.percent = false;
                return null;
            }

            public String getFlatValue(MutableStat.StatMod mod) {
                this.percent = false;
                return null;
            }

            public Color getModColor(MutableStat.StatMod mod) {
                if (!this.percent && mod.getValue() < 1.0f || mod.getValue() < 0.0f) {
                    return Misc.getNegativeHighlightColor();
                }
                return null;
            }
        };
    }

    protected void printSalvageModifiers() {
        float fuelMult = this.playerFleet.getStats().getDynamic().getValue("fuel_salvage_value_mult_fleet");
        String fuelStr = Math.round((fuelMult - 1.0f) * 100.0f) + "%";
        float rareMult = this.playerFleet.getStats().getDynamic().getValue("salvage_value_bonus_fleet");
        String rareStr = Math.round((rareMult - 1.0f) * 100.0f) + "%";
        if (fuelMult > 1.0f && rareMult > 1.0f) {
            this.text.addPara("Your fleet also has a %s bonus to the amount of fuel recovered, and a %s bonus to the number of rare items found.", Misc.getHighlightColor(), fuelStr, rareStr);
        } else if (fuelMult > 1.0f) {
            this.text.addPara("Your fleet also has a %s bonus to the amount of fuel recovered.", Misc.getHighlightColor(), fuelStr);
        } else if (rareMult > 1.0f) {
            this.text.addPara("Your fleet also has a %s bonus to the number of rare items found.", Misc.getHighlightColor(), rareStr);
        }
        if (this.debris != null) {
            this.text.addParagraph("The density of the debris field affects both the amount of resources and the number of rare items found.");
        } else {
            this.text.addPara("The recovery effectiveness does not affect the chance of finding rare and valuable items.");
        }
    }

    public void showCostDebrisField() {
        Color color = this.playerFaction.getColor();
        Color bad = Misc.getNegativeHighlightColor();
        Color highlight = Misc.getHighlightColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float small = 5.0f;
        Map<String, Integer> requiredRes = SalvageEntity.computeRequiredToSalvage(this.entity);
        ResourceCostPanelAPI cost = this.text.addCostPanel("Crew & machinery: required (available)", COST_HEIGHT, color, this.playerFaction.getDarkUIColor());
        cost.setNumberOnlyMode(true);
        cost.setWithBorder(false);
        cost.setAlignment(Alignment.LMID);
        for (String commodityId : requiredRes.keySet()) {
            int required = requiredRes.get(commodityId);
            int available = (int)this.cargo.getCommodityQuantity(commodityId);
            Color curr = color;
            if ((float)required > this.cargo.getQuantity(CargoAPI.CargoItemType.RESOURCES, commodityId)) {
                curr = bad;
            }
            cost.addCost(commodityId, required + " (" + available + ")", curr);
        }
        cost.update();
        MutableStat valueRecovery = this.getValueRecoveryStat(true);
        float overallMult = this.computeOverallMultForDebrisField();
        valueRecovery.modifyMult("debris_mult", overallMult, "Debris field density");
        int valuePercent = Math.round(valueRecovery.getModifiedValue() * 100.0f);
        if (valuePercent < 0) {
            valuePercent = 0;
        }
        String valueString = valuePercent + "%";
        Color valueColor = highlight;
        if (valuePercent < 100) {
            valueColor = bad;
        }
        TooltipMakerAPI info = this.text.beginTooltip();
        info.setParaSmallInsignia();
        info.addPara("Scavenging effectiveness: %s", 0.0f, valueColor, valueString);
        if (!valueRecovery.isUnmodified()) {
            info.addStatModGrid(300.0f, 50.0f, opad, small, valueRecovery, true, this.getModPrinter());
        }
        this.text.addTooltip();
        this.printSalvageModifiers();
    }

    protected float computeOverallMultForDebrisField() {
        float overallMult = 1.0f;
        if (this.debris != null) {
            float f = 1.0f;
            DebrisFieldTerrainPlugin.DebrisFieldParams params = this.debris.getParams();
            overallMult = params.baseDensity > 0.0f ? params.density / params.baseDensity * f * FIELD_SALVAGE_FRACTION_PER_ATTEMPT : 0.0f;
            if (overallMult < FIELD_MIN_SALVAGE_MULT) {
                overallMult = FIELD_MIN_SALVAGE_MULT;
            }
        }
        return overallMult;
    }

    public void performSalvage() {
        long seed = this.memory.getLong("$salvageSeed");
        Random random = Misc.getRandom(seed, 100);
        Misc.stopPlayerFleet();
        MutableStat valueRecovery = this.getValueRecoveryStat(true);
        float valueMultFleet = valueRecovery.getModifiedValue();
        float rareItemSkillMult = this.playerFleet.getStats().getDynamic().getValue("salvage_value_bonus_fleet");
        ArrayList<SalvageEntityGenDataSpec.DropData> dropValue = new ArrayList<SalvageEntityGenDataSpec.DropData>(this.spec.getDropValue());
        ArrayList<SalvageEntityGenDataSpec.DropData> dropRandom = new ArrayList<SalvageEntityGenDataSpec.DropData>(this.spec.getDropRandom());
        dropValue.addAll(this.entity.getDropValue());
        dropRandom.addAll(this.entity.getDropRandom());
        float overallMult = this.computeOverallMultForDebrisField();
        if (this.debris != null) {
            BaseCommandPlugin.getEntityMemory(this.memoryMap).unset("$salvageSpecialData");
        }
        float fuelMult = this.playerFleet.getStats().getDynamic().getValue("fuel_salvage_value_mult_fleet");
        CargoAPI salvage = SalvageEntity.generateSalvage(random, valueMultFleet, rareItemSkillMult, overallMult, fuelMult, dropValue, dropRandom);
        CargoAPI extra = BaseSalvageSpecial.getCombinedExtraSalvage(this.memoryMap);
        salvage.addAll(extra);
        BaseSalvageSpecial.clearExtraSalvage(this.memoryMap);
        if (!extra.isEmpty()) {
            ListenerUtil.reportExtraSalvageShown(this.entity);
        }
        if (this.debris != null) {
            this.debris.getParams().density -= overallMult;
            if (this.debris.getParams().density < 0.0f) {
                this.debris.getParams().density = 0.0f;
            }
            this.debris.getEntity().getMemoryWithoutUpdate().set("$salvageSeed", random.nextLong());
            this.debris.setScavenged(true);
        }
        if (!salvage.isEmpty()) {
            this.dialog.getVisualPanel().showLoot("Salvaged", salvage, false, true, true, new CoreInteractionListener(){

                public void coreUIDismissed() {
                    long xp = 0L;
                    if (SalvageEntity.this.entity.hasSalvageXP()) {
                        xp = (long)SalvageEntity.this.entity.getSalvageXP().floatValue();
                    } else if (SalvageEntity.this.spec != null && SalvageEntity.this.spec.getXpSalvage() > 0.0f) {
                        xp = (long)SalvageEntity.this.spec.getXpSalvage();
                    }
                    if (!SalvageEntity.this.memory.contains("$doNotDismissDialogAfterSalvage")) {
                        SalvageEntity.this.dialog.dismiss();
                        SalvageEntity.this.dialog.hideTextPanel();
                        SalvageEntity.this.dialog.hideVisualPanel();
                        if (xp > 0L) {
                            Global.getSector().getPlayerPerson().getStats().addXP(xp);
                        }
                    } else if (xp > 0L) {
                        Global.getSector().getPlayerPerson().getStats().addXP(xp, SalvageEntity.this.dialog.getTextPanel());
                    }
                }
            });
            this.options.clearOptions();
            this.dialog.setPromptText("");
        } else {
            this.text.addParagraph("Operations conclude with nothing of value found.");
            this.options.clearOptions();
            String leave = "Leave";
            if (this.memory.contains("$salvageLeaveText")) {
                leave = this.memory.getString("$salvageLeaveText");
            }
            this.options.addOption(leave, "defaultLeave");
            this.options.setShortcut("defaultLeave", 1, false, false, false, true);
        }
        boolean isDebrisField = "debris_field_shared".equals(this.entity.getCustomEntityType());
        if (!isDebrisField) {
            if (!this.spec.hasTag("no_debris")) {
                this.convertToDebrisField(FIELD_CONTENT_MULTIPLIER_AFTER_SALVAGE);
            } else if (!this.spec.hasTag("no_remove")) {
                Misc.fadeAndExpire(this.entity, 1.0f);
            }
        }
        if (this.playerFleet != null) {
            this.playerFleet.getStats().addTemporaryModFlat(0.25f, "salvage_ops", "Recent salvage operation", SALVAGE_DETECTION_MOD_FLAT, this.playerFleet.getStats().getDetectedRangeMod());
            Global.getSector().addPing((SectorEntityToken)this.playerFleet, "noticed_player");
        }
    }

    public void convertToDebrisField(float valueMult) {
        this.convertToDebrisField(null, valueMult);
    }

    public void convertToDebrisField(Random random, float valueMult) {
        SalvageEntityGenDataSpec.DropData copy;
        if (random == null) {
            random = new Random();
        }
        Misc.fadeAndExpire(this.entity, 1.0f);
        float salvageRating = this.spec.getSalvageRating();
        float debrisFieldRadius = 200.0f + salvageRating * 400.0f;
        float density = 0.5f + salvageRating * 0.5f;
        density = 1.0f;
        if (valueMult <= FIELD_CONTENT_MULTIPLIER_AFTER_SALVAGE) {
            density = 0.5f + salvageRating * 0.5f;
        }
        float duration = 10.0f + salvageRating * 20.0f;
        DebrisFieldTerrainPlugin.DebrisFieldParams params = new DebrisFieldTerrainPlugin.DebrisFieldParams(debrisFieldRadius, density, duration, duration * 0.5f);
        params.source = DebrisFieldTerrainPlugin.DebrisFieldSource.PLAYER_SALVAGE;
        float xp = this.spec.getXpSalvage() * 0.25f;
        if (this.entity.hasSalvageXP()) {
            xp = this.entity.getSalvageXP().floatValue() * 0.25f;
        }
        if (xp >= 10.0f) {
            params.baseSalvageXP = (long)xp;
        }
        SectorEntityToken debris = Misc.addDebrisField(this.entity.getContainingLocation(), params, null);
        CargoAPI extra = BaseSalvageSpecial.getCombinedExtraSalvage(this.memoryMap);
        if (extra != null && !extra.isEmpty()) {
            BaseSalvageSpecial.addExtraSalvage(extra, debris.getMemoryWithoutUpdate(), -1.0f);
        }
        debris.setSensorProfile(null);
        debris.setDiscoverable(null);
        debris.setFaction(this.entity.getFaction().getId());
        debris.getDropValue().clear();
        debris.getDropRandom().clear();
        for (SalvageEntityGenDataSpec.DropData data : this.spec.getDropValue()) {
            copy = data.clone();
            copy.valueMult = valueMult;
            debris.addDropValue(data.clone());
        }
        for (SalvageEntityGenDataSpec.DropData data : this.spec.getDropRandom()) {
            copy = data.clone();
            copy.valueMult = valueMult;
            debris.addDropRandom(copy);
        }
        for (SalvageEntityGenDataSpec.DropData data : this.entity.getDropValue()) {
            copy = data.clone();
            copy.valueMult = valueMult;
            debris.addDropValue(data.clone());
        }
        for (SalvageEntityGenDataSpec.DropData data : this.entity.getDropRandom()) {
            copy = data.clone();
            copy.valueMult = valueMult;
            debris.addDropRandom(copy);
        }
        if (this.entity.getOrbit() != null) {
            debris.setOrbit(this.entity.getOrbit().makeCopy());
        } else {
            debris.getLocation().set((ReadableVector2f)this.entity.getLocation());
        }
        long seed = this.memory.getLong("$salvageSeed");
        if (seed != 0L) {
            debris.getMemoryWithoutUpdate().set("$salvageSeed", Misc.getRandom(seed, 150).nextLong());
        }
    }

    public static float getPlayerShipsSalvageModUncapped() {
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        float valueModShips = RepairGantry.getAdjustedGantryModifier(playerFleet, null, 0.0f);
        return valueModShips;
    }

    public static float getDebrisReqMult(DebrisFieldTerrainPlugin field) {
        float r = field.getParams().bandWidthInEngine;
        float f = (r - (float)FIELD_RADIUS_FOR_BASE_REQ) / (float)(FIELD_RADIUS_FOR_MAX_REQ - FIELD_RADIUS_FOR_BASE_REQ);
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        float mult = 1.0f + ((float)FIELD_RADIUS_MAX_REQ_MULT - 1.0f) * f;
        return mult;
    }

    public static CargoAPI generateSalvage(Random random, float valueMult, float overallMult, float fuelMult, List<SalvageEntityGenDataSpec.DropData> dropValue, List<SalvageEntityGenDataSpec.DropData> dropRandom) {
        return SalvageEntity.generateSalvage(random, valueMult, 1.0f, overallMult, fuelMult, dropValue, dropRandom);
    }

    public static CargoAPI generateSalvage(Random random, float valueMult, float randomMult, float overallMult, float fuelMult, List<SalvageEntityGenDataSpec.DropData> dropValue, List<SalvageEntityGenDataSpec.DropData> dropRandom) {
        CargoAPI result;
        block23: {
            if (random == null) {
                random = new Random();
            }
            result = Global.getFactory().createCargo(true);
            if (Misc.isEasy()) {
                overallMult *= Global.getSettings().getFloat("easySalvageMult");
            }
            if (dropRandom == null) break block23;
            for (SalvageEntityGenDataSpec.DropData data : dropRandom) {
                int chances = data.chances;
                if (data.maxChances > chances) {
                    chances += random.nextInt(data.maxChances - chances + 1);
                }
                float modifiedChances = chances;
                modifiedChances *= overallMult;
                if (data.value <= 0) {
                    modifiedChances *= randomMult;
                }
                float rem = (modifiedChances *= data.valueMult) - (float)((int)modifiedChances);
                chances = (int)modifiedChances + (random.nextFloat() < rem ? 1 : 0);
                WeightedRandomPicker<DropGroupRow> picker = data.getCustom();
                if (picker == null && data.group == null) continue;
                if (picker == null) {
                    picker = DropGroupRow.getPicker(data.group);
                }
                Random innerRandom = Misc.getRandom(random.nextLong(), 5);
                picker.setRandom(innerRandom);
                int i = 0;
                while (i < chances) {
                    block24: {
                        float qty;
                        DropGroupRow row;
                        block28: {
                            block29: {
                                block27: {
                                    block26: {
                                        block25: {
                                            row = picker.pick();
                                            if (row.isMultiValued()) {
                                                row = row.resolveToSpecificItem(innerRandom);
                                            }
                                            if (row.isNothing()) break block24;
                                            float baseUnitValue = row.getBaseUnitValue();
                                            qty = 1.0f;
                                            if (data.value <= 0) break block25;
                                            float randMult = StarSystemGenerator.getNormalRandom(innerRandom, 0.5f, 1.5f);
                                            qty = (float)data.value * valueMult * randMult / baseUnitValue;
                                            qty = (int)qty;
                                            if (valueMult <= 0.0f) break block24;
                                            if (qty < 1.0f) {
                                                qty = 1.0f;
                                            }
                                        }
                                        if (!row.isWeapon()) break block26;
                                        result.addWeapons(row.getWeaponId(), (int)qty);
                                        break block24;
                                    }
                                    if (!row.isFighterWing()) break block27;
                                    result.addItems(CargoAPI.CargoItemType.FIGHTER_CHIP, row.getFighterWingId(), (int)qty);
                                    break block24;
                                }
                                if (!row.isSpecialItem()) break block28;
                                if (!"modspec".equals(row.getSpecialItemId())) break block29;
                                if (result.getQuantity(CargoAPI.CargoItemType.SPECIAL, new SpecialItemData(row.getSpecialItemId(), row.getSpecialItemData())) > 0.0f) break block24;
                            }
                            result.addItems(CargoAPI.CargoItemType.SPECIAL, new SpecialItemData(row.getSpecialItemId(), row.getSpecialItemData()), (int)qty);
                            break block24;
                        }
                        result.addCommodity(row.getCommodity(), qty);
                    }
                    ++i;
                }
            }
        }
        if (dropValue != null) {
            for (SalvageEntityGenDataSpec.DropData data : dropValue) {
                float maxValue = data.value;
                if (data.value > 1) {
                    maxValue *= valueMult;
                }
                maxValue *= overallMult;
                maxValue *= data.valueMult;
                float randMult = StarSystemGenerator.getNormalRandom(random, 0.5f, 1.5f);
                maxValue *= randMult;
                WeightedRandomPicker<DropGroupRow> picker = data.getCustom();
                if (picker == null && data.group == null) continue;
                if (picker == null) {
                    picker = DropGroupRow.getPicker(data.group);
                }
                picker.setRandom(random);
                float value = 0.0f;
                int nothingInARow = 0;
                while (value < maxValue && nothingInARow < 10) {
                    DropGroupRow row = picker.pick();
                    if (row.isMultiValued()) {
                        row = row.resolveToSpecificItem(random);
                    }
                    if (row.isNothing()) {
                        ++nothingInARow;
                        continue;
                    }
                    nothingInARow = 0;
                    float baseUnitValue = row.getBaseUnitValue();
                    float qty = 1.0f;
                    float currValue = baseUnitValue * qty;
                    value += currValue;
                    if (row.isWeapon()) {
                        if (!(value <= maxValue)) continue;
                        result.addWeapons(row.getWeaponId(), (int)qty);
                        continue;
                    }
                    if (row.isFighterWing()) {
                        if (!(value <= maxValue)) continue;
                        result.addItems(CargoAPI.CargoItemType.FIGHTER_CHIP, row.getFighterWingId(), (int)qty);
                        continue;
                    }
                    if (row.isSpecialItem()) {
                        if ("modspec".equals(row.getSpecialItemId())) {
                            if (result.getQuantity(CargoAPI.CargoItemType.SPECIAL, new SpecialItemData(row.getSpecialItemId(), row.getSpecialItemData())) > 0.0f) continue;
                        }
                        result.addItems(CargoAPI.CargoItemType.SPECIAL, new SpecialItemData(row.getSpecialItemId(), row.getSpecialItemData()), (int)qty);
                        continue;
                    }
                    if (!(value <= maxValue)) continue;
                    result.addCommodity(row.getCommodity(), qty);
                }
            }
        }
        float fuel = result.getFuel();
        if (fuelMult > 1.0f) {
            result.addFuel(Math.round(fuel * (fuelMult - 1.0f)));
        }
        result.sort();
        return result;
    }

    public boolean canBeMadeRecoverable() {
        if (this.entity.getCustomPlugin() instanceof DerelictShipEntityPlugin) {
            if (Misc.getSalvageSpecial(this.entity) instanceof ShipRecoverySpecial.ShipRecoverySpecialData) {
                return false;
            }
            if (this.entity.hasTag("unrecoverable")) {
                return false;
            }
            DerelictShipEntityPlugin plugin = (DerelictShipEntityPlugin)this.entity.getCustomPlugin();
            ShipVariantAPI variant = plugin.getData().ship.getVariant();
            if (variant != null && !Misc.isUnboardable(variant.getHullSpec())) {
                return true;
            }
        }
        return false;
    }

    public void showRecoverable() {
        Object prev = Misc.getSalvageSpecial(this.entity);
        if (prev != null) {
            Misc.setPrevSalvageSpecial(this.entity, prev);
        }
        ShipRecoverySpecial.ShipRecoverySpecialData data = new ShipRecoverySpecial.ShipRecoverySpecialData(null);
        DerelictShipEntityPlugin plugin = (DerelictShipEntityPlugin)this.entity.getCustomPlugin();
        data.addShip(plugin.getData().ship.clone());
        data.storyPointRecovery = true;
        Misc.setSalvageSpecial(this.entity, data);
        long seed = Misc.getSalvageSeed(this.entity);
        this.entity.getMemoryWithoutUpdate().set("$salvageSeed", seed);
    }
}

