/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special;

import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.impl.campaign.procgen.SalvageEntityGenDataSpec;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.SalvageEntity;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.SalvageSpecialInteraction;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.BaseSalvageSpecial;
import java.util.ArrayList;
import java.util.Random;

public class BlueprintSpecial
extends BaseSalvageSpecial {
    public static float MAX_RANGE = 16000.0f;
    protected BlueprintSpecialData data;

    public void init(InteractionDialogAPI dialog, Object specialData) {
        super.init(dialog, specialData);
        this.data = (BlueprintSpecialData)specialData;
        CargoAPI bp = this.generateBP(this.random);
        bp.sort();
        if (bp.getStacksCopy().size() <= 0) {
            this.initNothing();
        } else {
            this.initBP(bp.getStacksCopy().get(0));
        }
    }

    public void initNothing() {
        this.addText("Your salvage crews find a likely-looking safe, but it's unfortunately empty.");
        this.setDone(true);
    }

    protected void initBP(CargoStackAPI stack) {
        if (!stack.isSpecialStack()) {
            this.initNothing();
            return;
        }
        this.addText("Your salvage crews find a well-hidden safe. After an EMP pulse and some delicate work with a plasma cutter, the safe yields its contents.");
        this.playerFleet.getCargo().addFromStack(stack);
        AddRemoveCommodity.addStackGainText(stack, this.text, false);
        this.setDone(true);
    }

    public void optionSelected(String optionText, Object optionData) {
        super.optionSelected(optionText, optionData);
    }

    public CargoAPI generateBP(Random random) {
        ArrayList<SalvageEntityGenDataSpec.DropData> dropRandom = new ArrayList<SalvageEntityGenDataSpec.DropData>();
        SalvageEntityGenDataSpec.DropData d = new SalvageEntityGenDataSpec.DropData();
        d.chances = 1;
        d.group = "blueprints_guaranteed";
        dropRandom.add(d);
        CargoAPI result = SalvageEntity.generateSalvage(random, 1.0f, 1.0f, 1.0f, 1.0f, null, dropRandom);
        return result;
    }

    public static class BlueprintSpecialData
    implements SalvageSpecialInteraction.SalvageSpecialData {
        public SalvageSpecialInteraction.SalvageSpecialPlugin createSpecialPlugin() {
            return new BlueprintSpecial();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SurveyDataSpecialType {
        SCRAMBLED,
        PLANET_INTERESTING_PROPERTY,
        PLANET_SURVEY_DATA,
        SYSTEM_PRELIMINARY_SURVEY,
        AUTO_PICK,
        AUTO_PICK_NOT_SYSTEM;

    }
}

