/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignTerrainAPI;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.impl.campaign.DerelictShipEntityPlugin;
import com.fs.starfarer.api.impl.campaign.intel.misc.BreadcrumbIntel;
import com.fs.starfarer.api.impl.campaign.procgen.Constellation;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.SalvageSpecialInteraction;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.BaseSalvageSpecial;
import com.fs.starfarer.api.util.CountingMap;
import com.fs.starfarer.api.util.Misc;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BreadcrumbSpecial
extends BaseSalvageSpecial {
    private BreadcrumbSpecialData data;

    @Override
    public void init(InteractionDialogAPI dialog, Object specialData) {
        super.init(dialog, specialData);
        this.data = (BreadcrumbSpecialData)specialData;
        this.initEntityLocation();
    }

    private void initEntityLocation() {
        if (this.data.targetId == null) {
            this.initNothing();
            return;
        }
        SectorEntityToken target = Global.getSector().getEntityById(this.data.targetId);
        if (target == null) {
            this.initNothing();
            return;
        }
        if (!target.hasSensorProfile() && !target.isDiscoverable()) {
            this.initNothing();
            return;
        }
        String targetName = BreadcrumbSpecial.getNameWithAOrAn(target, this.data.targetName, true, false);
        String targetNameUC = BreadcrumbSpecial.getNameWithAOrAn(target, this.data.targetName, false, true);
        String located = BreadcrumbSpecial.getLocatedString(target, true);
        String nameForTitle = targetNameUC.substring(targetNameUC.indexOf(" ") + 1);
        String subject = this.getString("Location: " + nameForTitle);
        String text1 = "The $shortName's memory banks are partially accessible, and ";
        text1 = String.valueOf(text1) + "contain information indicating that " + targetName + " is " + located + ".";
        String text1ForIntel = "While exploring $aOrAn $nameInText, your crews found a partially accessible memory bank containing information that indicates " + targetName + " is " + located + ".";
        boolean debris = "debris_field_shared".equals(this.entity.getCustomEntityType());
        if (debris) {
            text1 = "Your salvage crews find a functional memory bank in the debris. It contains information indicating that " + targetName.toLowerCase() + " is " + located + ".";
        }
        if (target.getCustomPlugin() instanceof DerelictShipEntityPlugin) {
            DerelictShipEntityPlugin dsep = (DerelictShipEntityPlugin)target.getCustomPlugin();
            ShipVariantAPI variant = dsep.getData().ship.variant;
            if (variant == null && dsep.getData().ship.variantId != null) {
                variant = Global.getSettings().getVariant(dsep.getData().ship.variantId);
            }
            if (variant != null) {
                String size = null;
                size = variant.getHullSize() == ShipAPI.HullSize.FRIGATE || variant.getHullSize() == ShipAPI.HullSize.DESTROYER ? "Based on the information, it's likely the ship is small, a frigate or a destroyer at the largest." : "The vessel is likely to be at least cruiser-sized.";
                if (size != null) {
                    text1 = String.valueOf(text1) + "\n\n" + size;
                    text1ForIntel = String.valueOf(text1ForIntel) + "\n\n" + size;
                }
            }
        }
        this.addText(text1);
        BreadcrumbIntel intel = new BreadcrumbIntel(this.entity, target);
        intel.setTitle(this.getString(subject));
        intel.setText(this.getString(text1ForIntel));
        Global.getSector().getIntelManager().addIntel(intel, false, this.text);
        this.setDone(true);
    }

    public static String getNameWithAOrAn(SectorEntityToken target, String override, boolean lowercaseDebris, boolean forTitle) {
        String targetAOrAn = "a";
        String targetName = override;
        if (targetName == null) {
            if (target instanceof CustomCampaignEntityAPI) {
                CustomCampaignEntityAPI custom = (CustomCampaignEntityAPI)target;
                targetName = custom.getCustomEntitySpec().getNameInText();
                if (forTitle) {
                    targetName = custom.getName();
                }
                targetAOrAn = custom.getCustomEntitySpec().getAOrAn();
            } else if (target instanceof PlanetAPI) {
                PlanetAPI planet = (PlanetAPI)target;
                targetName = planet.getTypeNameWithLowerCaseWorld().toLowerCase();
                if (forTitle) {
                    targetName = planet.getTypeNameWithWorld();
                }
                targetAOrAn = planet.getSpec().getAOrAn();
            } else {
                targetName = target.getName();
            }
        }
        if (lowercaseDebris && target.hasTag("debris")) {
            targetName = targetName.toLowerCase();
        }
        return String.valueOf(targetAOrAn) + " " + targetName;
    }

    public static String getLocatedString(SectorEntityToken target) {
        return BreadcrumbSpecial.getLocatedString(target, false);
    }

    public static String getLocatedString(SectorEntityToken target, boolean withSystem) {
        String terrainString;
        String loc = BreadcrumbSpecial.getLocationDescription(target, withSystem);
        String orbiting = "";
        boolean useTerrain = false;
        if (target.getOrbitFocus() != null) {
            if (target.getOrbitFocus() instanceof PlanetAPI) {
                boolean isPrimary;
                PlanetAPI focus = (PlanetAPI)target.getOrbitFocus();
                boolean bl = isPrimary = target.getContainingLocation() instanceof StarSystemAPI && focus == ((StarSystemAPI)target.getContainingLocation()).getStar();
                if (!focus.isStar() || !isPrimary) {
                    orbiting = "orbiting " + focus.getSpec().getAOrAn() + " " + focus.getTypeNameWithLowerCaseWorld().toLowerCase() + " in ";
                } else {
                    float dist = Misc.getDistance(focus.getLocation(), target.getLocation());
                    orbiting = dist < 3000.0f ? "located in the heart of " : (dist > 12000.0f ? "located in the outer reaches of " : "located some distance away from the center of ");
                    useTerrain = true;
                }
            } else if (target.getOrbitFocus() instanceof CustomCampaignEntityAPI) {
                CustomCampaignEntityAPI custom = (CustomCampaignEntityAPI)target.getOrbitFocus();
                orbiting = "orbiting " + custom.getCustomEntitySpec().getAOrAn() + " " + custom.getCustomEntitySpec().getNameInText() + " in ";
            } else if (target.getOrbitFocus() instanceof JumpPointAPI) {
                orbiting = "orbiting a jump-point in ";
            } else {
                float dist = Misc.getDistance(new Vector2f(), target.getLocation());
                orbiting = dist < 3000.0f ? "located in the heart of " : (dist > 8000.0f ? "located in the outer reaches of " : "located some distance away from the center of ");
                useTerrain = true;
            }
        } else if (target.getContainingLocation() != null && target.getContainingLocation().isNebula()) {
            float dist = Misc.getDistance(new Vector2f(), target.getLocation());
            orbiting = dist < 3000.0f ? "located in the heart of " : (dist > 8000.0f ? "located on the outskirts of " : "located some distance away from the center of ");
            useTerrain = true;
        }
        if (useTerrain && (terrainString = BreadcrumbSpecial.getTerrainString(target)) != null) {
            orbiting = "located in " + terrainString + " in ";
        }
        if (orbiting == null || orbiting.isEmpty()) {
            orbiting = "located in ";
        }
        return String.valueOf(orbiting) + loc;
    }

    public static String getTerrainString(SectorEntityToken entity) {
        if (!(entity.getContainingLocation() instanceof StarSystemAPI)) {
            return null;
        }
        StarSystemAPI system = (StarSystemAPI)entity.getContainingLocation();
        for (CampaignTerrainAPI terrain : system.getTerrainCopy()) {
            if (!terrain.getPlugin().containsEntity(entity)) continue;
            String type = terrain.getType();
            if ("asteroid_belt".equals(type)) {
                return "an asteroid belt";
            }
            if ("asteroid_field".equals(type)) {
                return "an asteroid field";
            }
            if (terrain.hasTag("accretion_disk")) {
                return "an accretion disk";
            }
            if (!"ring".equals(type)) continue;
            return "a ring system";
        }
        return null;
    }

    public static String getLocationDescription(SectorEntityToken entity, boolean withSystem) {
        LocationAPI loc = entity.getContainingLocation();
        if (loc == null) {
            return "an unknown location";
        }
        if (loc.isHyperspace()) {
            return "hyperspace";
        }
        StarSystemAPI system = (StarSystemAPI)loc;
        if (withSystem || entity.getConstellation() == null || entity.getConstellation().getSystems().size() == 1 || entity.isInCurrentLocation()) {
            return "the " + system.getNameWithLowercaseType();
        }
        Constellation c = entity.getConstellation();
        String cText = "in the " + c.getNameWithLowercaseType();
        if (c.getSystems().size() == 1) {
            return "the " + system.getNameWithLowercaseType();
        }
        if (system.isNebula()) {
            return "a nebula " + cText;
        }
        if (system.getTertiary() != null) {
            return "a trinary star system " + cText;
        }
        if (system.getSecondary() != null) {
            return "a binary star system " + cText;
        }
        PlanetAPI star = system.getStar();
        if (star != null) {
            if (star.getSpec().isBlackHole()) {
                return "a black hole system " + cText;
            }
            String type = BreadcrumbSpecial.getStarTypeName(star);
            String color = BreadcrumbSpecial.getStarColorName(star);
            String sysText = null;
            CountingMap<String> counts = BreadcrumbSpecial.getTypeAndColorCounts(c);
            int cColor = counts.getCount(color);
            int cType = counts.getCount(type);
            if (cColor > 1 && cType > cColor) {
                sysText = "a system with " + star.getSpec().getAOrAn() + " " + color + " primary star ";
            } else if (cType > 0) {
                sysText = "a system with a " + type + " primary star ";
            } else if (cColor > 0) {
                sysText = "a system with " + star.getSpec().getAOrAn() + " " + color + " primary star ";
            }
            if (sysText != null) {
                return String.valueOf(sysText) + cText;
            }
        }
        return "the " + system.getNameWithLowercaseType() + " " + cText;
    }

    public static CountingMap<String> getTypeAndColorCounts(Constellation c) {
        CountingMap<String> map = new CountingMap<String>();
        for (StarSystemAPI system : c.getSystems()) {
            PlanetAPI star = system.getStar();
            if (system.isNebula() || system.getSecondary() != null || system.getTertiary() != null) continue;
            String type = BreadcrumbSpecial.getStarTypeName(star);
            String color = BreadcrumbSpecial.getStarColorName(star);
            if (type != null) {
                map.add(type);
            }
            if (color == null) continue;
            map.add(color);
        }
        return map;
    }

    public static String getStarTypeName(PlanetAPI star) {
        String name = star.getSpec().getName().toLowerCase();
        if (name.contains(" dwarf")) {
            return "dwarf";
        }
        if (name.contains(" star")) {
            return null;
        }
        if (name.contains(" giant")) {
            return "giant";
        }
        if (name.contains(" supergiant")) {
            return "supergiant";
        }
        return null;
    }

    public static String getStarColorName(PlanetAPI star) {
        String name = star.getSpec().getName().toLowerCase();
        if (name.contains(" dwarf")) {
            name = name.replace(" dwarf", "");
        } else if (name.contains(" star")) {
            name = name.replace(" star", "");
        } else if (name.contains(" giant")) {
            name = name.replace(" giant", "");
        } else if (name.contains(" supergiant")) {
            name = name.replace(" supergiant", "");
        }
        if (!name.equals(star.getSpec().getName().toLowerCase())) {
            return name;
        }
        return null;
    }

    @Override
    public void optionSelected(String optionText, Object optionData) {
        super.optionSelected(optionText, optionData);
    }

    public static class BreadcrumbSpecialData
    implements SalvageSpecialInteraction.SalvageSpecialData {
        public String targetId = null;
        public String targetName = null;

        public BreadcrumbSpecialData(String targetId) {
            this.targetId = targetId;
        }

        public SalvageSpecialInteraction.SalvageSpecialPlugin createSpecialPlugin() {
            return new BreadcrumbSpecial();
        }
    }
}

