/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.intel.misc.BreadcrumbIntel;
import com.fs.starfarer.api.impl.campaign.procgen.Constellation;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.SalvageSpecialInteraction;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.BaseSalvageSpecial;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.BreadcrumbSpecial;

public class DomainSurveyDerelictSpecial
extends BaseSalvageSpecial {
    private DomainSurveyDerelictSpecialData data;

    public void init(InteractionDialogAPI dialog, Object specialData) {
        SectorEntityToken entity;
        super.init(dialog, specialData);
        this.data = (DomainSurveyDerelictSpecialData)specialData;
        if (this.data.entityId != null && (entity = Global.getSector().getEntityById(this.data.entityId)) == null) {
            this.data.entityId = null;
            this.data.type = SpecialType.SCRAMBLED;
        }
        switch (this.data.type) {
            case SCRAMBLED: {
                this.initNothing();
                break;
            }
            case LOCATION_SURVEY_SHIP: {
                this.initSurveyParentEntity();
                break;
            }
            case LOCATION_MOTHERSHIP: {
                this.initSurveyParentEntity();
            }
        }
    }

    public boolean shouldShowAgain() {
        return this.data != null && (this.data.type == SpecialType.ACTIVATE_PROBE || this.data.type == SpecialType.ACTIVATE_SURVEY_SHIP);
    }

    private void initSurveyParentEntity() {
        if (this.data.entityId == null) {
            this.initNothing();
            return;
        }
        SectorEntityToken parent = Global.getSector().getEntityById(this.data.entityId);
        if (parent == null || !parent.hasSensorProfile()) {
            this.initNothing();
            return;
        }
        String text1 = "The $shortName's memory banks are partially accessible, and ";
        String text1ForIntel = "While exploring $aOrAn $nameInText, your crews found partially accessible memory banks that ";
        String name = parent.getCustomEntitySpec().getNameInText();
        String nameForTitle = parent.getCustomEntitySpec().getDefaultName();
        String subject = this.getString("Derelict " + nameForTitle + " Location");
        text1 = String.valueOf(text1) + "contain information pointing to the location of a " + name + ". ";
        text1ForIntel = String.valueOf(text1ForIntel) + "contain information pointing to the location of a " + name + ". ";
        String located = BreadcrumbSpecial.getLocatedString(parent, true);
        text1 = String.valueOf(text1) + "It was last seen by this $shortName " + located + ".";
        text1ForIntel = String.valueOf(text1ForIntel) + "It was last seen by this $shortName " + located + ".";
        text1 = this.getString(text1);
        this.addText(text1);
        BreadcrumbIntel intel = new BreadcrumbIntel(this.entity, parent);
        intel.setTitle(this.getString(subject));
        intel.setText(this.getString(text1ForIntel));
        Global.getSector().getIntelManager().addIntel(intel, false, this.text);
        this.setDone(true);
    }

    public void initNothing() {
        this.addText("The $shortName's memory banks have been scrubbed clean by hard radiation, and the systems are largely inert and non-functional.");
        this.setDone(true);
    }

    public static String getLocationName(SectorEntityToken entity) {
        LocationAPI loc = entity.getContainingLocation();
        if (loc == null) {
            return "in an unknown location nearby";
        }
        if (loc.isHyperspace()) {
            return "in hyperspace nearby";
        }
        StarSystemAPI system = (StarSystemAPI)loc;
        if (system == Global.getSector().getCurrentLocation()) {
            if (system.isNebula()) {
                return "inside this nebula";
            }
            return "in this system";
        }
        return "in the " + system.getNameWithLowercaseType();
    }

    public static String getLocationDescription(SectorEntityToken entity) {
        LocationAPI loc = entity.getContainingLocation();
        if (loc == null) {
            return "in an unknown location nearby";
        }
        if (loc.isHyperspace()) {
            return "in hyperspace nearby";
        }
        StarSystemAPI system = (StarSystemAPI)loc;
        if (system == Global.getSector().getCurrentLocation()) {
            if (system.isNebula()) {
                return "inside this nebula";
            }
            return "in this system";
        }
        if (entity.getConstellation() != null && entity.getConstellation() != Global.getSector().getCurrentLocation().getConstellation()) {
            Constellation c = entity.getConstellation();
            String cText = "in the " + c.getNameWithLowercaseType();
            if (c.getSystems().size() == 1) {
                return "orbiting " + DomainSurveyDerelictSpecial.getStarDescription(system.getStar()) + " nearby";
            }
            if (system.isNebula()) {
                return "inside a nebula " + cText;
            }
            if (system.getTertiary() != null) {
                return "in a trinary star system " + cText;
            }
            if (system.getSecondary() != null) {
                return "in a binary star system " + cText;
            }
            return "orbiting " + DomainSurveyDerelictSpecial.getStarDescription(system.getStar()) + " " + cText;
        }
        if (system.isNebula()) {
            return "inside a nearby nebula";
        }
        if (system.getTertiary() != null) {
            return "in a nearby trinary star system";
        }
        if (system.getSecondary() != null) {
            return "in a nearby binary star system";
        }
        return "orbiting " + DomainSurveyDerelictSpecial.getStarDescription(system.getStar()) + " nearby";
    }

    public static String getStarDescription(PlanetAPI star) {
        String type = star.getTypeId();
        if (type.equals("black_hole")) {
            return "a black hole";
        }
        if (type.equals("star_neutron")) {
            return "a neutron star";
        }
        if (type.equals("star_orange") || type.equals("star_orange_giant")) {
            return "an orange star";
        }
        if (type.equals("star_red_dwarf") || type.equals("star_red_supergiant") || type.equals("star_red_giant")) {
            return "a red star";
        }
        if (type.equals("star_blue_giant") || type.equals("star_blue_supergiant")) {
            return "a blue star";
        }
        if (type.equals("star_browndwarf") || type.equals("star_white")) {
            return "a dim star";
        }
        if (type.equals("star_yellow")) {
            return "a yellow star";
        }
        return "a star of unknown type";
    }

    public void optionSelected(String optionText, Object optionData) {
        super.optionSelected(optionText, optionData);
        if ("continue".equals(optionData)) {
            this.setDone(true);
        }
    }

    public boolean endWithContinue() {
        return super.endWithContinue();
    }

    public static class DomainSurveyDerelictSpecialData
    implements SalvageSpecialInteraction.SalvageSpecialData {
        public SpecialType type = SpecialType.SCRAMBLED;
        public String entityId = null;
        public String secondaryId = null;

        public DomainSurveyDerelictSpecialData(SpecialType type) {
            this.type = type;
        }

        public SalvageSpecialInteraction.SalvageSpecialPlugin createSpecialPlugin() {
            return new DomainSurveyDerelictSpecial();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SpecialType {
        SCRAMBLED,
        LOCATION_SURVEY_SHIP,
        LOCATION_MOTHERSHIP,
        ACTIVATE_PROBE,
        ACTIVATE_SURVEY_SHIP;

    }
}

