/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.shared;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.EconomyAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.SaveableIterator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommodityStatTracker {
    private IntervalUtil timer = new IntervalUtil(0.25f, 0.75f);
    private Map<String, CommodityStats> priceData = new HashMap<String, CommodityStats>();
    private boolean firstFrame = true;
    private SaveableIterator<String> commodityIterator = null;

    public void advance(float days) {
        if (this.firstFrame) {
            this.firstFrame = false;
            EconomyAPI economy = Global.getSector().getEconomy();
            for (String id : economy.getAllCommodityIds()) {
                this.updateCommodityStats(id);
            }
        }
        this.timer.advance(days);
        if (this.timer.intervalElapsed()) {
            this.updateStatsNextStep();
        }
    }

    public boolean isSupplyPriceSignificant(CommodityOnMarketAPI com) {
        return this.isSupplyPriceWithMultSignificant(com, 1.0f);
    }

    public boolean isDemandPriceSignificant(CommodityOnMarketAPI com) {
        return this.isDemandPriceWithMultSignificant(com, 1.0f);
    }

    public boolean isSupplyPriceWithMultSignificant(CommodityOnMarketAPI com, float mult) {
        float supplyPrice = Math.round(com.getMarket().getSupplyPrice(com.getId(), 1.0, true));
        return this.isSupplyPriceSignificant(com, supplyPrice *= mult);
    }

    public boolean isDemandPriceWithMultSignificant(CommodityOnMarketAPI com, float mult) {
        float demandPrice = Math.round(com.getMarket().getDemandPrice(com.getId(), 1.0, true));
        return this.isSupplyPriceSignificant(com, demandPrice *= mult);
    }

    public boolean isSupplyPriceSignificant(CommodityOnMarketAPI com, float price) {
        CommodityStats stats = this.getStats(com.getId());
        float average = stats.getAverageSupplyPrice();
        float flat = Misc.getProfitMarginFlat();
        float mult = Misc.getProfitMarginMult();
        return price <= average - flat || price <= average / mult;
    }

    public boolean isDemandPriceSignificant(CommodityOnMarketAPI com, float price) {
        CommodityStats stats = this.getStats(com.getId());
        float average = stats.getAverageDemandPrice();
        float flat = Misc.getProfitMarginFlat();
        float mult = Misc.getProfitMarginMult();
        return price >= average + flat || price >= average * mult;
    }

    private void updateStatsNextStep() {
        EconomyAPI economy = Global.getSector().getEconomy();
        if (this.commodityIterator == null || !this.commodityIterator.hasNext()) {
            this.commodityIterator = new SaveableIterator<String>(economy.getAllCommodityIds());
        }
        if (!this.commodityIterator.hasNext()) {
            return;
        }
        String commodityId = this.commodityIterator.next();
        this.updateCommodityStats(commodityId);
    }

    public void updateCommodityStats(String commodityId) {
        EconomyAPI economy = Global.getSector().getEconomy();
        List<MarketAPI> markets = economy.getMarketsCopy();
        float totalSupply = 0.0f;
        float totalDemand = 0.0f;
        float totalStockpiles = 0.0f;
        float minSupplyPrice = Float.MAX_VALUE;
        float maxDemandPrice = 0.0f;
        float totalSupplyPrice = 0.0f;
        float totalDemandPrice = 0.0f;
        for (MarketAPI market : markets) {
            float demand;
            CommodityOnMarketAPI com = market.getCommodityData(commodityId);
            float supply = demand = com.getDemand().getDemandValue();
            float stockpile = com.getStockpile();
            if (supply < 10.0f && demand < 10.0f && stockpile < 10.0f) continue;
            float supplyPrice = Math.round(market.getSupplyPrice(com.getId(), 1.0, true));
            float demandPrice = Math.round(market.getDemandPrice(com.getId(), 1.0, true));
            if (supplyPrice < minSupplyPrice) {
                minSupplyPrice = supplyPrice;
            }
            if (demandPrice > maxDemandPrice) {
                maxDemandPrice = demandPrice;
            }
            totalSupply += supply;
            totalDemand += demand;
            totalStockpiles += stockpile;
            totalSupplyPrice += stockpile * supplyPrice;
            totalDemandPrice += demand * demandPrice;
        }
        CommodityStats stats = this.getStats(commodityId);
        stats.setTotalSupply(totalSupply);
        stats.setTotalDemand(totalDemand);
        stats.setTotalStockpiles(totalStockpiles);
        stats.setMaxDemandPrice(maxDemandPrice);
        stats.setMinSupplyPrice(minSupplyPrice);
        if (totalStockpiles > 0.0f) {
            stats.setAverageSupplyPrice(totalSupplyPrice / totalStockpiles);
        } else {
            stats.setAverageSupplyPrice(0.0f);
        }
        if (totalDemand > 0.0f) {
            stats.setAverageDemandPrice(totalDemandPrice / totalDemand);
        } else {
            stats.setAverageDemandPrice(0.0f);
        }
    }

    public CommodityStats getStats(String commodityId) {
        CommodityStats data = this.priceData.get(commodityId);
        if (data == null) {
            data = new CommodityStats(commodityId);
            this.priceData.put(commodityId, data);
        }
        return data;
    }

    public static class CommodityStats {
        private float minSupplyPrice;
        private float maxDemandPrice;
        private float averageSupplyPrice;
        private float averageDemandPrice;
        private float totalDemand;
        private float totalSupply;
        private float totalStockpiles;
        private final String commodityId;

        public CommodityStats(String commodityId) {
            this.commodityId = commodityId;
        }

        public float getMinSupplyPrice() {
            return this.minSupplyPrice;
        }

        public float getMaxDemandPrice() {
            return this.maxDemandPrice;
        }

        public float getAverageSupplyPrice() {
            return this.averageSupplyPrice;
        }

        public float getAverageDemandPrice() {
            return this.averageDemandPrice;
        }

        public String getCommodityId() {
            return this.commodityId;
        }

        public void setMinSupplyPrice(float min) {
            this.minSupplyPrice = min;
        }

        public void setMaxDemandPrice(float max) {
            this.maxDemandPrice = max;
        }

        public void setAverageSupplyPrice(float average) {
            this.averageSupplyPrice = average;
        }

        public float getTotalDemand() {
            return this.totalDemand;
        }

        public void setTotalDemand(float totalDemand) {
            this.totalDemand = totalDemand;
        }

        public float getTotalSupply() {
            return this.totalSupply;
        }

        public void setTotalSupply(float totalSupply) {
            this.totalSupply = totalSupply;
        }

        public float getTotalStockpiles() {
            return this.totalStockpiles;
        }

        public void setTotalStockpiles(float totalStockpiles) {
            this.totalStockpiles = totalStockpiles;
        }

        public void setAverageDemandPrice(float weightedAveragePrice) {
            this.averageDemandPrice = weightedAveragePrice;
        }
    }
}

