/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.campaign.FleetDataAPI;
import com.fs.starfarer.api.characters.FleetTotalItem;
import com.fs.starfarer.api.characters.FleetTotalSource;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;

public class CarrierGroup {
    public static float REPLACEMENT_RATE_PERCENT = 50.0f;
    public static float OFFICER_MULT = 1.5f;

    public static boolean isOfficer(MutableShipStatsAPI stats) {
        if (stats.getEntity() instanceof ShipAPI) {
            ShipAPI ship = (ShipAPI)stats.getEntity();
            if (ship == null) {
                return false;
            }
            return !ship.getCaptain().isDefault();
        }
        FleetMemberAPI member = stats.getFleetMember();
        if (member == null) {
            return false;
        }
        return !member.getCaptain().isDefault();
    }

    public static class Level1
    extends BaseSkillEffectDescription
    implements ShipSkillEffect,
    FleetTotalSource {
        public FleetTotalItem getFleetTotalItem() {
            return this.getFighterBaysTotal();
        }

        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            if (Level1.hasFighterBays(stats)) {
                float rateBonus = this.computeAndCacheThresholdBonus(stats, "cg_rep_rate", REPLACEMENT_RATE_PERCENT, BaseSkillEffectDescription.ThresholdBonusType.FIGHTER_BAYS);
                if (CarrierGroup.isOfficer(stats)) {
                    rateBonus *= OFFICER_MULT;
                }
                float timeMult = 1.0f / ((100.0f + rateBonus) / 100.0f);
                stats.getFighterRefitTimeMult().modifyMult(id, timeMult);
            }
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getFighterRefitTimeMult().unmodifyMult(id);
        }

        public String getEffectDescription(float level) {
            return null;
        }

        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            FleetDataAPI data = Level1.getFleetData(null);
            float rateBonus = this.computeAndCacheThresholdBonus(data, stats, "cg_rep_rate", REPLACEMENT_RATE_PERCENT, BaseSkillEffectDescription.ThresholdBonusType.FIGHTER_BAYS);
            info.addPara("+%s faster fighter replacement rate (maximum: %s)", 0.0f, this.hc, this.hc, (int)rateBonus + "%", (int)REPLACEMENT_RATE_PERCENT + "%");
            this.addFighterBayThresholdInfo(info, data);
            info.addPara(String.valueOf(this.indent) + "Effect increased by %s for ships with offcers, including flagship", 0.0f, this.tc, this.hc, Misc.getRoundedValueMaxOneAfterDecimal(OFFICER_MULT) + "\u00d7");
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_CARRIERS;
        }
    }
}

