/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.BattleObjectiveAPI;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatFleetManagerAPI;
import com.fs.starfarer.api.combat.DeployedFleetMemberAPI;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.impl.campaign.skills.SupportDoctrine;
import com.fs.starfarer.api.input.InputEventAPI;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoordinatedManeuversScript
extends BaseEveryFrameCombatPlugin {
    public static final Object KEY_STATUS = new Object();
    public static final float BASE_MAXIMUM = 20.0f;
    public static final float PER_BUOY = 5.0f;
    public static final String BONUS_ID = "coord_maneuvers_bonus";
    private CombatEngineAPI engine;
    private ShipAPI prevPlayerShip = null;
    private int skipFrames = 0;
    private Set<CombatFleetManagerAPI> needsCleanup = new HashSet<CombatFleetManagerAPI>();
    protected ShipAPI undoDPMod = null;

    @Override
    public void init(CombatEngineAPI engine) {
        this.engine = engine;
    }

    @Override
    public void advance(float amount, List<InputEventAPI> events) {
        if (this.engine == null) {
            return;
        }
        if (this.engine.isPaused()) {
            return;
        }
        ShipAPI playerShip = this.engine.getPlayerShip();
        if (playerShip != this.prevPlayerShip) {
            this.prevPlayerShip = playerShip;
            this.skipFrames = 20;
        }
        if (this.skipFrames > 0) {
            --this.skipFrames;
            return;
        }
        this.updateForSide(this.engine.getFleetManager(0));
        this.updateForSide(this.engine.getFleetManager(1));
        this.updateForceConcentration(this.engine.getFleetManager(0));
        this.updateForceConcentration(this.engine.getFleetManager(1));
        this.updateDPFromSupportDoctrine();
    }

    protected void updateDPFromSupportDoctrine() {
        ShipAPI from = this.engine.getShipPlayerIsTransferringCommandFrom();
        String id = String.valueOf(SupportDoctrine.SUPPORT_DOCTRINE_DP_REDUCTION_ID) + "_reverse";
        if (from != null) {
            MutableStat.StatMod bonus = from.getMutableStats().getDynamic().getMod("deployment_points_mod").getFlatBonus(SupportDoctrine.SUPPORT_DOCTRINE_DP_REDUCTION_ID);
            if (bonus != null && bonus.value != 0.0f) {
                this.undoDPMod = from;
                from.getMutableStats().getDynamic().getMod("deployment_points_mod").modifyFlat(id, -bonus.value);
                if (from.getFleetMember() != null) {
                    from.getFleetMember().getStats().getDynamic().getMod("deployment_points_mod").modifyFlat(id, -bonus.value);
                }
            }
        } else if (this.undoDPMod != null) {
            this.undoDPMod.getMutableStats().getDynamic().getMod("deployment_points_mod").unmodifyFlat(id);
            if (this.undoDPMod.getFleetMember() != null) {
                this.undoDPMod.getFleetMember().getStats().getDynamic().getMod("deployment_points_mod").unmodifyFlat(id);
            }
            this.undoDPMod = null;
        }
    }

    private void updateForSide(CombatFleetManagerAPI manager) {
        float max = 0.0f;
        for (PersonAPI commander : manager.getAllFleetCommanders()) {
            max = Math.max(max, 20.0f + commander.getStats().getDynamic().getValue("coord_maneuvers_max", 0.0f));
        }
        if (max <= 0.0f) {
            this.cleanUpIfNeeded(manager);
            return;
        }
        boolean buoysOnly = true;
        float total = 0.0f;
        List<DeployedFleetMemberAPI> deployed = manager.getDeployedCopyDFM();
        for (DeployedFleetMemberAPI member : deployed) {
            if (member.isFighterWing() || member.isStationModule()) continue;
            float curr = member.getShip().getMutableStats().getDynamic().getValue("coord_maneuvers_flat", 0.0f);
            total += curr;
        }
        if (total > 0.0f) {
            buoysOnly = false;
        }
        int numBuoys = 0;
        for (BattleObjectiveAPI obj : this.engine.getObjectives()) {
            if (obj.getOwner() != manager.getOwner() || !"nav_buoy".equals(obj.getType())) continue;
            total += 5.0f;
            ++numBuoys;
        }
        if (total <= 0.0f) {
            this.cleanUpIfNeeded(manager);
            return;
        }
        boolean includeSelf = false;
        includeSelf = true;
        for (DeployedFleetMemberAPI member : deployed) {
            if (member.isFighterWing() || member.getShip() == null) continue;
            float curr = member.getShip().getMutableStats().getDynamic().getValue("coord_maneuvers_flat", 0.0f);
            if (includeSelf) {
                curr = 0.0f;
            }
            float bonus = Math.min(max, Math.max(0.0f, total - curr));
            member.getShip().getMutableStats().getMaxSpeed().modifyPercent(BONUS_ID, bonus);
        }
        this.needsCleanup.add(manager);
        if (manager.getOwner() == this.engine.getPlayerShip().getOwner()) {
            float curr = this.engine.getPlayerShip().getMutableStats().getDynamic().getValue("coord_maneuvers_flat", 0.0f);
            if (includeSelf) {
                curr = 0.0f;
            }
            float bonus = Math.min(max, Math.max(0.0f, total - curr));
            String title = "Coordinated Maneuvers: " + (int)Math.min(max, total) + "%";
            String data = "+" + (int)bonus + "% top speed";
            if (buoysOnly) {
                title = "Nav Buoy";
                if (numBuoys > 1) {
                    title = String.valueOf(title) + "s";
                    title = String.valueOf(title) + " (" + numBuoys + ")";
                }
                data = "+" + (int)bonus + "% top speed";
            }
            String icon = Global.getSettings().getSpriteName("ui", "icon_tactical_coordinated_maneuvers");
            this.engine.maintainStatusForPlayerShip(KEY_STATUS, icon, title, data, false);
        }
    }

    protected void cleanUpIfNeeded(CombatFleetManagerAPI manager) {
        if (this.needsCleanup.contains(manager)) {
            this.needsCleanup.remove(manager);
            List<DeployedFleetMemberAPI> deployed = manager.getDeployedCopyDFM();
            for (DeployedFleetMemberAPI member : deployed) {
                if (member.isFighterWing() || member.getShip() == null) continue;
                member.getShip().getMutableStats().getMaxSpeed().unmodify(BONUS_ID);
            }
        }
    }

    protected void updateForceConcentration(CombatFleetManagerAPI manager) {
    }

    @Override
    public void renderInUICoords(ViewportAPI viewport) {
    }

    @Override
    public void renderInWorldCoords(ViewportAPI viewport) {
    }
}

