/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.characters.CharacterStatsSkillEffect;
import com.fs.starfarer.api.characters.DescriptionSkillEffect;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class CyberneticAugmentation {
    public static float MAX_ELITE_SKILLS_BONUS = 2.0f;
    public static float ECCM_BONUS = 5.0f;

    public static boolean isOfficer(MutableShipStatsAPI stats) {
        if (stats.getEntity() instanceof ShipAPI) {
            ShipAPI ship = (ShipAPI)stats.getEntity();
            return !ship.getCaptain().isDefault();
        }
        FleetMemberAPI member = stats.getFleetMember();
        if (member == null) {
            return false;
        }
        return !member.getCaptain().isDefault();
    }

    public static class Level0
    implements DescriptionSkillEffect {
        public String getString() {
            int base = Global.getSettings().getInt("officerMaxEliteSkills");
            return "*The base maximum number of elite skills per officer is " + base + ".";
        }

        public Color[] getHighlightColors() {
            Color h = Misc.getDarkHighlightColor();
            return new Color[]{h};
        }

        public String[] getHighlights() {
            int base = Global.getSettings().getInt("officerMaxEliteSkills");
            return new String[]{"" + base};
        }

        public Color getTextColor() {
            return null;
        }
    }

    public static class Level1
    implements CharacterStatsSkillEffect {
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            stats.getDynamic().getMod("officer_max_elite_skills_mod").modifyFlat(id, MAX_ELITE_SKILLS_BONUS);
        }

        public void unapply(MutableCharacterStatsAPI stats, String id) {
            stats.getDynamic().getMod("officer_max_elite_skills_mod").unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)MAX_ELITE_SKILLS_BONUS + " to maximum number of elite skills* for officers under your command";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.NONE;
        }
    }

    public static class Level2
    extends BaseSkillEffectDescription
    implements ShipSkillEffect {
        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            float opad = 10.0f;
            Color c = Misc.getBasePlayerColor();
            info.addPara("Affects: %s", opad + 5.0f, Misc.getGrayColor(), c, "all ships with officers, including flagship");
            info.addSpacer(opad);
            info.addPara("Reduces the weapon range penalty due to superior enemy Electronic Warfare by up to %s percentage points", 0.0f, this.hc, this.hc, "" + (int)ECCM_BONUS);
        }

        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            if (CyberneticAugmentation.isOfficer(stats)) {
                stats.getDynamic().getMod("electronic_warfare_penalty_mod").modifyFlat(id, -ECCM_BONUS);
            }
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDynamic().getMod("electronic_warfare_penalty_mod").unmodifyFlat(id);
        }
    }
}

