/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.DescriptionSkillEffect;
import com.fs.starfarer.api.characters.FleetStatsSkillEffect;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.MutableFleetStatsAPI;
import com.fs.starfarer.api.impl.campaign.DModManager;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class DerelictContingent {
    public static float MAX_DMODS = 5.0f;
    public static float MINUS_CR_PER_DMOD = 0.0f;
    public static float MINUS_DP_PERCENT_PER_DMOD = 6.0f;
    public static float EXTRA_DMODS = 4.0f;

    public static class Level0
    implements DescriptionSkillEffect {
        public String getString() {
            return "*Maximum effect reached at " + (int)MAX_DMODS + " d-mods.";
        }

        public Color[] getHighlightColors() {
            Color h = Misc.getHighlightColor();
            h = Misc.getDarkHighlightColor();
            return new Color[]{h};
        }

        public String[] getHighlights() {
            return new String[]{"" + (int)MAX_DMODS};
        }

        public Color getTextColor() {
            return null;
        }
    }

    public static class Level1
    extends BaseSkillEffectDescription
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            FleetMemberAPI member = stats.getFleetMember();
            float dmods = 0.0f;
            if (member != null && (dmods = (float)DModManager.getNumDMods(member.getVariant())) > MAX_DMODS) {
                dmods = MAX_DMODS;
            }
            if (dmods > 0.0f) {
                float depBonus = dmods * MINUS_DP_PERCENT_PER_DMOD;
                stats.getDynamic().getMod("deployment_points_mod").modifyMult(id, 1.0f - depBonus / 100.0f);
                stats.getDynamic().getMod("dmod_reduce_maintenance").modifyFlat(id, 1.0f);
                if (MINUS_CR_PER_DMOD > 0.0f) {
                    float crPenalty = MINUS_CR_PER_DMOD * dmods;
                    stats.getMaxCombatReadiness().modifyFlat(id, -crPenalty * 0.01f, "Derelict Operations skill");
                }
            }
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDynamic().getMod("deployment_points_mod").unmodify(id);
            stats.getDynamic().getMod("dmod_reduce_maintenance").unmodify(id);
            if (MINUS_CR_PER_DMOD > 0.0f) {
                stats.getMaxCombatReadiness().unmodify(id);
            }
        }

        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            info.addPara("Deployment point cost of ships reduced by %s per d-mod*", 0.0f, this.hc, this.hc, (int)MINUS_DP_PERCENT_PER_DMOD + "%");
            if (MINUS_CR_PER_DMOD > 0.0f) {
                info.addPara("(D) hull deployment cost reduction also applies to maintenance cost, but maximum CR is reduced by %s per d-mod*", 0.0f, this.hc, this.hc, (int)MINUS_CR_PER_DMOD + "%");
            } else {
                info.addPara("(D) hull deployment cost reduction also applies to maintenance cost", this.hc, 0.0f);
            }
        }
    }

    public static class Level2
    implements FleetStatsSkillEffect {
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
            stats.getDynamic().getMod("ship_dmod_reduction_mod").modifyFlat(id, -EXTRA_DMODS);
        }

        public void unapply(MutableFleetStatsAPI stats, String id) {
            stats.getDynamic().getMod("ship_dmod_reduction_mod").unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "Recovered ships have more d-mods than normal";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }
}

