/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.DescriptionSkillEffect;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.impl.campaign.skills.ElectronicWarfareScript;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class ElectronicWarfare {
    public static float PER_SHIP_BONUS = 1.0f;

    public static class Level0
    implements DescriptionSkillEffect {
        public String getString() {
            String max = String.valueOf((int)ElectronicWarfareScript.BASE_MAXIMUM) + "%";
            return "*The total ECM rating for the deployed ships of both fleets is compared, and the losing side's weapon range is reduced by the difference, up to a maximum of " + max + ". Does not apply to fighters, affects all weapons including missiles.";
        }

        public Color[] getHighlightColors() {
            Color h = Misc.getHighlightColor();
            h = Misc.getDarkHighlightColor();
            return new Color[]{h, h};
        }

        public String[] getHighlights() {
            String max = String.valueOf((int)ElectronicWarfareScript.BASE_MAXIMUM) + "%";
            String jammer = "+" + (int)ElectronicWarfareScript.PER_JAMMER + "%";
            return new String[]{jammer, max};
        }

        public Color getTextColor() {
            return null;
        }
    }

    public static class Level1A
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            if (!BaseSkillEffectDescription.isCivilian(stats)) {
                stats.getDynamic().getMod("electronic_warfare_flat").modifyFlat(id, PER_SHIP_BONUS);
            }
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDynamic().getMod("electronic_warfare_flat").unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "Every deployed combat ship grants +" + (int)PER_SHIP_BONUS + "% to ECM rating* of fleet";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }
}

