/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.BattleObjectiveAPI;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatFleetManagerAPI;
import com.fs.starfarer.api.combat.DeployedFleetMemberAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElectronicWarfareScript
extends BaseEveryFrameCombatPlugin {
    public static Object KEY_STATUS = new Object();
    public static Object KEY_STATUS2 = new Object();
    public static float BASE_MAXIMUM = 10.0f;
    public static float PER_JAMMER = 5.0f;
    public static String PENALTY_ID = "electronic_warfare_penalty";
    private CombatEngineAPI engine;
    private ShipAPI prevPlayerShip = null;
    private int skipFrames = 0;
    private Set<CombatFleetManagerAPI> needsCleanup = new HashSet<CombatFleetManagerAPI>();

    @Override
    public void init(CombatEngineAPI engine) {
        this.engine = engine;
    }

    @Override
    public void advance(float amount, List<InputEventAPI> events) {
        if (this.engine == null) {
            return;
        }
        if (this.engine.isPaused()) {
            return;
        }
        ShipAPI playerShip = this.engine.getPlayerShip();
        if (playerShip != this.prevPlayerShip) {
            this.prevPlayerShip = playerShip;
            this.skipFrames = 20;
        }
        if (this.skipFrames > 0) {
            --this.skipFrames;
            return;
        }
        int[] player = this.getTotalAndMaximum(this.engine.getFleetManager(0));
        int[] enemy = this.getTotalAndMaximum(this.engine.getFleetManager(1));
        if (player == null || enemy == null) {
            this.cleanUpIfNeeded(this.engine.getFleetManager(0));
            this.cleanUpIfNeeded(this.engine.getFleetManager(1));
            return;
        }
        float pTotal = player[0];
        float pMax = player[1];
        float eTotal = enemy[0];
        float eMax = enemy[1];
        float diff = pTotal - eTotal;
        if (diff == 0.0f) {
            this.cleanUpIfNeeded(this.engine.getFleetManager(0));
            this.cleanUpIfNeeded(this.engine.getFleetManager(1));
            return;
        }
        CombatFleetManagerAPI winner = this.engine.getFleetManager(0);
        CombatFleetManagerAPI loser = this.engine.getFleetManager(1);
        float max = pMax;
        if (diff < 0.0f) {
            CombatFleetManagerAPI temp = winner;
            winner = loser;
            loser = temp;
            max = eMax;
        }
        float penalty = Math.min(Math.abs(diff), max);
        this.cleanUpIfNeeded(winner);
        this.applyPenalty(loser, penalty, max);
        boolean playerWon = winner.getOwner() == this.engine.getPlayerShip().getOwner();
        String title = "ECM rating: " + (int)pTotal + "% vs " + (int)eTotal + "%";
        String data = "-" + (int)penalty + "% weapon range";
        if (playerWon) {
            data = "-" + (int)penalty + "% enemy weapon range";
        }
        String icon = Global.getSettings().getSpriteName("ui", "icon_tactical_electronic_warfare");
        if (this.engine.getPlayerShip() != null && !playerWon) {
            int eccm = 100 - Math.round(this.engine.getPlayerShip().getMutableStats().getDynamic().getValue("electronic_warfare_penalty_mod", 100.0f));
            if (eccm > 100) {
                eccm = 100;
            }
            if (eccm < 0) {
                eccm = 0;
            }
            if (eccm != 0) {
                this.engine.maintainStatusForPlayerShip(KEY_STATUS2, icon, "On-board ECCM", eccm + "% ecm neutralized", false);
            }
        }
        this.engine.maintainStatusForPlayerShip(KEY_STATUS, icon, title, data, !playerWon);
    }

    private void applyPenalty(CombatFleetManagerAPI manager, float penalty, float maxPenalty) {
        List<DeployedFleetMemberAPI> deployed = manager.getDeployedCopyDFM();
        for (DeployedFleetMemberAPI member : deployed) {
            float maxMod;
            float currMax;
            if (member.isFighterWing() || member.getShip() == null) continue;
            float currPenalty = penalty * member.getShip().getMutableStats().getDynamic().getValue("electronic_warfare_penalty_mult");
            currPenalty = member.getShip().getMutableStats().getDynamic().getValue("electronic_warfare_penalty_mod", currPenalty);
            if (currPenalty < 0.0f) {
                currPenalty = 0.0f;
            }
            if (currPenalty > (currMax = maxPenalty + (maxMod = penalty * member.getShip().getMutableStats().getDynamic().getValue("electronic_warfare_penalty_max_for_ship_mod", 0.0f)))) {
                currPenalty = currMax;
            }
            member.getShip().getMutableStats().getBallisticWeaponRangeBonus().modifyMult(PENALTY_ID, 1.0f - currPenalty / 100.0f);
            member.getShip().getMutableStats().getEnergyWeaponRangeBonus().modifyMult(PENALTY_ID, 1.0f - currPenalty / 100.0f);
            member.getShip().getMutableStats().getMissileWeaponRangeBonus().modifyMult(PENALTY_ID, 1.0f - currPenalty / 100.0f);
        }
        this.needsCleanup.add(manager);
    }

    protected void cleanUpIfNeeded(CombatFleetManagerAPI manager) {
        if (this.needsCleanup.contains(manager)) {
            this.needsCleanup.remove(manager);
            List<DeployedFleetMemberAPI> deployed = manager.getDeployedCopyDFM();
            for (DeployedFleetMemberAPI member : deployed) {
                if (member.isFighterWing() || member.getShip() == null) continue;
                member.getShip().getMutableStats().getBallisticWeaponRangeBonus().unmodify(PENALTY_ID);
                member.getShip().getMutableStats().getEnergyWeaponRangeBonus().unmodify(PENALTY_ID);
                member.getShip().getMutableStats().getMissileWeaponRangeBonus().unmodify(PENALTY_ID);
            }
        }
    }

    private int[] getTotalAndMaximum(CombatFleetManagerAPI manager) {
        float max = 0.0f;
        for (PersonAPI commander : manager.getAllFleetCommanders()) {
            max = Math.max(max, BASE_MAXIMUM + commander.getStats().getDynamic().getValue("electronic_warfare_max", 0.0f));
        }
        float total = 0.0f;
        List<DeployedFleetMemberAPI> deployed = manager.getDeployedCopyDFM();
        for (DeployedFleetMemberAPI member : deployed) {
            if (member.isFighterWing() || member.isStationModule()) continue;
            float curr = member.getShip().getMutableStats().getDynamic().getValue("electronic_warfare_flat", 0.0f);
            total += curr;
        }
        for (BattleObjectiveAPI obj : this.engine.getObjectives()) {
            if (obj.getOwner() != manager.getOwner() || !"sensor_array".equals(obj.getType())) continue;
            total += PER_JAMMER;
        }
        return new int[]{(int)total, (int)max};
    }

    @Override
    public void renderInUICoords(ViewportAPI viewport) {
    }

    @Override
    public void renderInWorldCoords(ViewportAPI viewport) {
    }
}

