/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.FleetStatsSkillEffect;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MarketSkillEffect;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.MutableFleetStatsAPI;

public class FleetLogistics {
    public static final float ACCESS_1 = 0.15f;
    public static final float ACCESS_2 = 0.15f;
    public static final float FLEET_SIZE = 25.0f;
    public static final float REPAIR_RATE_INCREASE = 25.0f;
    public static final float OFFICER_SHIP_RECOVERY_MOD = 1000.0f;
    public static final float MAINTENANCE_COST_REDUCTION = 25.0f;
    public static final float MAX_CR_BONUS = 15.0f;

    public static class Level1
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getRepairRatePercentPerDay().modifyPercent(id, 25.0f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getRepairRatePercentPerDay().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "25% faster repair rate";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }

    public static class Level1B
    implements FleetStatsSkillEffect {
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
            stats.getDynamic().getMod("officer_ship_recovery_mod").modifyFlat(id, 10.0f);
        }

        public void unapply(MutableFleetStatsAPI stats, String id) {
            stats.getDynamic().getMod("officer_ship_recovery_mod").unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "Flagship and ships with an officer in command nearly guaranteed to be recoverable if lost";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level2
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getSuppliesPerMonth().modifyMult(id, 0.75f, "Fleet logistics skill");
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getSuppliesPerMonth().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "-25% supply use for maintenance";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }

    public static class Level3
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getMaxCombatReadiness().modifyFlat(id, 0.14999999f, "Fleet logistics skill");
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getMaxCombatReadiness().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+15% maximum combat readiness";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }

    public static class Market1
    implements MarketSkillEffect {
        public void apply(MarketAPI market, String id, float level) {
            if (level <= 1.0f) {
                market.getAccessibilityMod().modifyFlat(id, 0.15f, "Fleet logistics");
            } else if (level >= 2.0f) {
                market.getAccessibilityMod().modifyFlat(id, 0.3f, "Fleet logistics");
            }
        }

        public void unapply(MarketAPI market, String id) {
            market.getAccessibilityMod().unmodifyFlat(id);
        }

        public String getEffectDescription(float level) {
            return "+" + Math.round(15.000001f) + "% accessibility";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.GOVERNED_OUTPOST;
        }
    }

    public static class Market2
    implements MarketSkillEffect {
        public void apply(MarketAPI market, String id, float level) {
        }

        public void unapply(MarketAPI market, String id) {
        }

        public String getEffectDescription(float level) {
            return "+" + Math.round(15.000001f) + "% accessibility";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.GOVERNED_OUTPOST;
        }
    }

    public static class Market3
    implements MarketSkillEffect {
        public void apply(MarketAPI market, String id, float level) {
            market.getStats().getDynamic().getMod("combat_fleet_size_mult").modifyFlat(id, 0.25f, "Fleet logistics");
        }

        public void unapply(MarketAPI market, String id) {
            market.getStats().getDynamic().getMod("combat_fleet_size_mult").unmodifyFlat(id);
        }

        public String getEffectDescription(float level) {
            return Math.round(25.0f) + "% larger fleets";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.GOVERNED_OUTPOST;
        }
    }
}

