/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.campaign.FleetDataAPI;
import com.fs.starfarer.api.characters.CharacterStatsSkillEffect;
import com.fs.starfarer.api.characters.FleetTotalItem;
import com.fs.starfarer.api.characters.FleetTotalSource;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class FluxRegulation {
    public static int VENTS_BONUS = 5;
    public static int CAPACITORS_BONUS = 5;
    public static float DISSIPATION_PERCENT = 10.0f;
    public static float CAPACITY_PERCENT = 10.0f;

    public static class Level1
    extends BaseSkillEffectDescription
    implements ShipSkillEffect,
    FleetTotalSource {
        public FleetTotalItem getFleetTotalItem() {
            return this.getCombatOPTotal();
        }

        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            if (!Level1.isCivilian(stats)) {
                float disBonus = this.computeAndCacheThresholdBonus(stats, "fr_dis", DISSIPATION_PERCENT, BaseSkillEffectDescription.ThresholdBonusType.OP);
                float capBonus = this.computeAndCacheThresholdBonus(stats, "fr_cap", CAPACITY_PERCENT, BaseSkillEffectDescription.ThresholdBonusType.OP);
                stats.getFluxDissipation().modifyPercent(id, disBonus);
                stats.getFluxCapacity().modifyPercent(id, capBonus);
            }
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getFluxDissipation().unmodifyPercent(id);
            stats.getFluxCapacity().unmodifyPercent(id);
        }

        public String getEffectDescription(float level) {
            return null;
        }

        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            FleetDataAPI data = Level1.getFleetData(null);
            float disBonus = this.computeAndCacheThresholdBonus(data, stats, "fr_dis", DISSIPATION_PERCENT, BaseSkillEffectDescription.ThresholdBonusType.OP);
            float capBonus = this.computeAndCacheThresholdBonus(data, stats, "fr_cap", CAPACITY_PERCENT, BaseSkillEffectDescription.ThresholdBonusType.OP);
            float opad = 10.0f;
            Color c = Misc.getBasePlayerColor();
            info.addPara("Affects: %s", opad + 5.0f, Misc.getGrayColor(), c, "all combat ships, including carriers and militarized civilian ships");
            info.addPara("+%s flux dissipation for combat ships (maximum: %s)", opad, this.hc, this.hc, (int)disBonus + "%", (int)DISSIPATION_PERCENT + "%");
            info.addPara("+%s flux capacity for combat ships (maximum: %s)", 0.0f, this.hc, this.hc, (int)capBonus + "%", (int)CAPACITY_PERCENT + "%");
            this.addOPThresholdInfo(info, data, stats);
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }

    public static class Level2
    implements CharacterStatsSkillEffect {
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            stats.getMaxCapacitorsBonus().modifyFlat(id, CAPACITORS_BONUS);
        }

        public void unapply(MutableCharacterStatsAPI stats, String id) {
            stats.getMaxCapacitorsBonus().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+" + CAPACITORS_BONUS + " maximum flux capacitors";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }

    public static class Level3
    implements CharacterStatsSkillEffect {
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            stats.getMaxVentsBonus().modifyFlat(id, VENTS_BONUS);
        }

        public void unapply(MutableCharacterStatsAPI stats, String id) {
            stats.getMaxVentsBonus().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+" + VENTS_BONUS + " maximum flux vents";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }
}

