/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.FleetStatsSkillEffect;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.MutableFleetStatsAPI;
import com.fs.starfarer.api.impl.campaign.skills.FieldRepairsScript;

public class HullRestoration {
    public static float RECOVERY_PROB = 2.0f;
    public static float CR_PER_SMOD = 5.0f;
    public static float DMOD_AVOID_MAX = 0.9f;
    public static float DMOD_AVOID_MIN = 0.75f;
    public static float DMOD_AVOID_MIN_DP = 5.0f;
    public static float DMOD_AVOID_MAX_DP = 60.0f;

    public static class Level1
    implements FleetStatsSkillEffect {
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
            stats.getDynamic().getMod("ship_recovery_mod").modifyFlat(id, RECOVERY_PROB);
        }

        public void unapply(MutableFleetStatsAPI stats, String id) {
            stats.getDynamic().getMod("ship_recovery_mod").unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "All of your ships are almost always recoverable if lost in combat";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level2
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            float mult;
            float dp = DMOD_AVOID_MIN_DP;
            if (stats.getFleetMember() != null) {
                dp = stats.getFleetMember().getDeploymentPointsCost();
            }
            if ((mult = 1.0f - (dp - DMOD_AVOID_MIN_DP) / (DMOD_AVOID_MAX_DP - DMOD_AVOID_MIN_DP)) > 1.0f) {
                mult = 1.0f;
            }
            if (mult < 0.0f) {
                mult = 0.0f;
            }
            float probAvoid = DMOD_AVOID_MIN + (DMOD_AVOID_MAX - DMOD_AVOID_MIN) * mult;
            stats.getDynamic().getMod("dmod_acquire_prob_mod").modifyMult(id, 1.0f - probAvoid);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDynamic().getMod("dmod_acquire_prob_mod").unmodify(id);
        }

        public String getEffectDescription(float level) {
            String lowDP = "" + (int)DMOD_AVOID_MIN_DP;
            String highDP = "" + (int)DMOD_AVOID_MAX_DP;
            String lowChance = Math.round(DMOD_AVOID_MIN * 100.0f) + "%";
            String highChance = Math.round(DMOD_AVOID_MAX * 100.0f) + "%";
            return "Ships lost in combat have a " + lowChance + " (if " + highDP + " deployment points or higher) to " + highChance + " (" + lowDP + " DP or lower) chance to avoid d-mods";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level3
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            float num = 0.0f;
            if (stats.getVariant() != null) {
                num = stats.getVariant().getSMods().size();
            }
            stats.getMaxCombatReadiness().modifyFlat(id, num * CR_PER_SMOD * 0.01f, "Hull Restoration skill");
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getMaxCombatReadiness().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)CR_PER_SMOD + "% maximum combat readiness per s-mod built into the hull";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level4A
    implements FleetStatsSkillEffect {
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
        }

        public void unapply(MutableFleetStatsAPI stats, String id) {
        }

        public String getEffectDescription(float level) {
            if (FieldRepairsScript.MONTHS_PER_DMOD_REMOVAL == 1) {
                return "Chance to remove one d-mod per month from a randomly selected ship in your fleet";
            }
            if (FieldRepairsScript.MONTHS_PER_DMOD_REMOVAL == 2) {
                return "Chance to remove a d-mod from a randomly selected ship in your fleet every two months";
            }
            return "Chance to remove a d-mod from a randomly selected ship in your fleet every " + FieldRepairsScript.MONTHS_PER_DMOD_REMOVAL + " months";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level4B
    implements FleetStatsSkillEffect {
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
        }

        public void unapply(MutableFleetStatsAPI stats, String id) {
        }

        public String getEffectDescription(float level) {
            return "Chance to quickly remove one d-mod from newly acquired ships; higher for ships with more d-mods";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }
}

