/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MarketSkillEffect;

public class Hypercognition {
    public static float ACCESS = 0.1f;
    public static float FLEET_SIZE = 20.0f;
    public static int DEFEND_BONUS = 50;
    public static float STABILITY_BONUS = 1.0f;

    public static class Level1
    implements MarketSkillEffect {
        public void apply(MarketAPI market, String id, float level) {
            market.getAccessibilityMod().modifyFlat(id, ACCESS, "Hypercognition");
        }

        public void unapply(MarketAPI market, String id) {
            market.getAccessibilityMod().unmodifyFlat(id);
        }

        public String getEffectDescription(float level) {
            return "+" + Math.round(ACCESS * 100.0f) + "% accessibility";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.GOVERNED_OUTPOST;
        }
    }

    public static class Level2
    implements MarketSkillEffect {
        public void apply(MarketAPI market, String id, float level) {
            market.getStats().getDynamic().getMod("combat_fleet_size_mult").modifyFlat(id, FLEET_SIZE / 100.0f, "Hypercognition");
        }

        public void unapply(MarketAPI market, String id) {
            market.getStats().getDynamic().getMod("combat_fleet_size_mult").unmodifyFlat(id);
        }

        public String getEffectDescription(float level) {
            return "+" + Math.round(FLEET_SIZE) + "% fleet size";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.GOVERNED_OUTPOST;
        }
    }

    public static class Level3
    implements MarketSkillEffect {
        public void apply(MarketAPI market, String id, float level) {
            market.getStats().getDynamic().getMod("ground_defenses_mod").modifyMult(id, 1.0f + (float)DEFEND_BONUS * 0.01f, "Hypercognition");
        }

        public void unapply(MarketAPI market, String id) {
            market.getStats().getDynamic().getMod("ground_defenses_mod").unmodifyMult(id);
        }

        public String getEffectDescription(float level) {
            return "+" + DEFEND_BONUS + "% effectiveness of ground defenses";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.GOVERNED_OUTPOST;
        }
    }

    public static class Level4
    implements MarketSkillEffect {
        public void apply(MarketAPI market, String id, float level) {
            market.getStability().modifyFlat(id, STABILITY_BONUS, "Hypercognition");
        }

        public void unapply(MarketAPI market, String id) {
            market.getStability().unmodifyFlat(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)STABILITY_BONUS + " stability";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.GOVERNED_OUTPOST;
        }
    }
}

