/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;

public class ImpactMitigation {
    public static float MANEUVERABILITY_BONUS_LARGE = 50.0f;
    public static float MANEUVERABILITY_BONUS_SMALL = 25.0f;
    public static float MAX_DAMAGE_REDUCTION_BONUS = 0.05f;
    public static float ARMOR_DAMAGE_REDUCTION = 25.0f;
    public static float ARMOR_KINETIC_REDUCTION = 50.0f;
    public static float DAMAGE_TO_MODULES_REDUCTION = 50.0f;

    public static ShipAPI.HullSize getHullSize(MutableShipStatsAPI stats) {
        if (stats.getEntity() instanceof ShipAPI) {
            ShipAPI ship = (ShipAPI)stats.getEntity();
            return ship.getHullSize();
        }
        FleetMemberAPI member = stats.getFleetMember();
        if (member == null) {
            return ShipAPI.HullSize.CAPITAL_SHIP;
        }
        return member.getHullSpec().getHullSize();
    }

    public static class Level2
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getArmorDamageTakenMult().modifyMult(id, 1.0f - ARMOR_DAMAGE_REDUCTION / 100.0f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getArmorDamageTakenMult().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "-" + (int)ARMOR_DAMAGE_REDUCTION + "% armor damage taken";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level3
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getKineticArmorDamageTakenMult().modifyMult(id, 1.0f - ARMOR_KINETIC_REDUCTION / 100.0f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getKineticArmorDamageTakenMult().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "-" + (int)ARMOR_KINETIC_REDUCTION + "% kinetic damage taken by armor";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level4
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getEngineDamageTakenMult().modifyMult(id, 1.0f - DAMAGE_TO_MODULES_REDUCTION / 100.0f);
            stats.getWeaponDamageTakenMult().modifyMult(id, 1.0f - DAMAGE_TO_MODULES_REDUCTION / 100.0f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getEngineDamageTakenMult().unmodify(id);
            stats.getWeaponDamageTakenMult().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "-" + (int)DAMAGE_TO_MODULES_REDUCTION + "% weapon and engine damage taken";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level5
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getMaxArmorDamageReduction().modifyFlat(id, MAX_DAMAGE_REDUCTION_BONUS);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getMaxArmorDamageReduction().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "Maximum damage reduction by armor increased from 85% to 90%";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level6
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            float bonus = MANEUVERABILITY_BONUS_LARGE;
            ShipAPI.HullSize size = ImpactMitigation.getHullSize(stats);
            if (size == ShipAPI.HullSize.FRIGATE || size == ShipAPI.HullSize.DESTROYER) {
                bonus = MANEUVERABILITY_BONUS_SMALL;
            }
            stats.getAcceleration().modifyPercent(id, bonus);
            stats.getDeceleration().modifyPercent(id, bonus);
            stats.getTurnAcceleration().modifyPercent(id, bonus * 2.0f);
            stats.getMaxTurnRate().modifyPercent(id, bonus);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getAcceleration().unmodify(id);
            stats.getDeceleration().unmodify(id);
            stats.getTurnAcceleration().unmodify(id);
            stats.getMaxTurnRate().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)MANEUVERABILITY_BONUS_LARGE + "% maneuverability for capital ships and cruisers, " + "+" + (int)MANEUVERABILITY_BONUS_SMALL + "% for destroyers and frigates";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }
}

