/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FleetDataAPI;
import com.fs.starfarer.api.characters.FleetStatsSkillEffect;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.MutableFleetStatsAPI;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;

public class MakeshiftEquipment {
    public static float SUPPLY_USE_REDUCTION_MAX_PERCENT = 50.0f;
    public static float SUPPLY_USE_REDUCTION_MAX_UNITS = 100.0f;
    public static float SURVEY_COST_MULT = 0.5f;
    public static float MINING_VALUE_MULT = 1.5f;
    public static float UPKEEP_MULT = 0.8f;
    public static String SUPPLIES_EFFECT_ID = "surveying_supply_use_mod";

    public static class Level1
    implements FleetStatsSkillEffect {
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
            String desc = "Surveying skill";
            stats.getDynamic().getStat("survey_cost_mult").modifyMult(id, SURVEY_COST_MULT, desc);
        }

        public void unapply(MutableFleetStatsAPI stats, String id) {
            stats.getDynamic().getStat("survey_cost_mult").unmodifyMult(id);
        }

        public String getEffectDescription(float level) {
            return "-" + Math.round((1.0f - SURVEY_COST_MULT) * 100.0f) + "% resources required to survey planets";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level2
    implements FleetStatsSkillEffect {
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
            String desc = "Surveying skill";
            stats.getDynamic().getStat("planet_mining_value_mult").modifyMult(id, SURVEY_COST_MULT, desc);
        }

        public void unapply(MutableFleetStatsAPI stats, String id) {
            stats.getDynamic().getStat("planet_mining_value_mult").unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+" + Math.round((1.0f - SURVEY_COST_MULT) * 100.0f) + "% resources extracted from surface deposits on uncolonized planets";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level3
    extends BaseSkillEffectDescription
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            id = SUPPLIES_EFFECT_ID;
            float useMult = this.getSupplyUseMult(id, Level3.getFleetData(stats));
            stats.getSuppliesPerMonth().modifyMult(id, useMult);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            id = SUPPLIES_EFFECT_ID;
            stats.getSuppliesPerMonth().unmodifyMult(id);
        }

        public String getEffectDescription(float level) {
            return null;
        }

        protected float getSupplyUseBase(String id, FleetDataAPI data) {
            if (data == null) {
                return 0.0f;
            }
            float supplyUse = 0.0f;
            for (FleetMemberAPI curr : data.getMembersListCopy()) {
                MutableStat stat = curr.getStats().getSuppliesPerMonth();
                MutableStat.StatMod mod = stat.getMultStatMod(id);
                if (mod != null) {
                    stat.unmodifyMult(mod.source);
                }
                supplyUse += stat.getModifiedValue();
                if (mod == null) continue;
                stat.modifyMult(mod.source, mod.value, mod.desc);
            }
            return supplyUse;
        }

        protected float getSupplyUseMult(String id, FleetDataAPI data) {
            if (data == null) {
                return 0.0f;
            }
            String key = "makeshift1";
            Float bonus = (Float)data.getCacheClearedOnSync().get(key);
            if (bonus != null) {
                return bonus.floatValue();
            }
            float supplyUse = this.getSupplyUseBase(id, data);
            float useMult = 0.0f;
            if (supplyUse > 0.0f) {
                float maxReduced = Math.min(supplyUse * (SUPPLY_USE_REDUCTION_MAX_PERCENT * 0.01f), SUPPLY_USE_REDUCTION_MAX_UNITS);
                useMult = 1.0f - maxReduced / supplyUse;
            }
            data.getCacheClearedOnSync().put(key, Float.valueOf(useMult));
            return useMult;
        }

        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            info.addPara("Reduces monthly supply consumption for ship maintenance by %s or %s units, whichever is lower", 0.0f, this.hc, this.hc, (int)SUPPLY_USE_REDUCTION_MAX_PERCENT + "%", "" + (int)SUPPLY_USE_REDUCTION_MAX_UNITS);
            if (Level3.isInCampaign()) {
                FleetDataAPI data = Global.getSector().getPlayerFleet().getFleetData();
                String id = SUPPLIES_EFFECT_ID;
                float supplyUse = this.getSupplyUseBase(id, data);
                float useMult = this.getSupplyUseMult(id, data);
                float reduction = supplyUse * (1.0f - useMult);
                boolean has = stats.getSkillLevel(skill.getId()) > 0.0f;
                String is = "is";
                if (!has) {
                    is = "would be";
                }
                info.addPara(String.valueOf(this.indent) + "Your fleet requires a base %s supplies per month for maintenance, which " + is + " reduced by %s, or %s units", 0.0f, this.tc, this.hc, Misc.getRoundedValueMaxOneAfterDecimal(supplyUse), Math.round((1.0f - useMult) * 100.0f) + "%", Misc.getRoundedValueMaxOneAfterDecimal(reduction));
            }
            info.addSpacer(5.0f);
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }
}

