/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.campaign.FleetDataAPI;
import com.fs.starfarer.api.characters.DescriptionSkillEffect;
import com.fs.starfarer.api.characters.FleetTotalItem;
import com.fs.starfarer.api.characters.FleetTotalSource;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import java.awt.Color;

public class PhaseCorps {
    public static float PHASE_SPEED_BONUS = 50.0f;
    public static float PEAK_TIME_BONUS = 180.0f;
    public static float PHASE_SHIP_SENSOR_BONUS_PERCENT = 100.0f;

    public static boolean isPhaseAndOfficer(MutableShipStatsAPI stats) {
        if (stats.getEntity() instanceof ShipAPI) {
            ShipAPI ship = (ShipAPI)stats.getEntity();
            if (!ship.getHullSpec().isPhase()) {
                return false;
            }
            return !ship.getCaptain().isDefault();
        }
        FleetMemberAPI member = stats.getFleetMember();
        if (member == null) {
            return false;
        }
        if (!member.isPhaseShip()) {
            return false;
        }
        return !member.getCaptain().isDefault();
    }

    public static boolean isPhase(MutableShipStatsAPI stats) {
        FleetMemberAPI member = stats.getFleetMember();
        if (member == null) {
            return false;
        }
        return member.isPhaseShip();
    }

    public static class Level0
    implements DescriptionSkillEffect {
        public String getString() {
            return "\n*The sensor strength of phase ships also contributes to the fleetwide stealth bonus granted by the Phase Field hullmod.";
        }

        public Color[] getHighlightColors() {
            return null;
        }

        public String[] getHighlights() {
            return null;
        }

        public Color getTextColor() {
            return null;
        }
    }

    public static class Level3
    extends BaseSkillEffectDescription
    implements ShipSkillEffect,
    FleetTotalSource {
        public FleetTotalItem getFleetTotalItem() {
            return this.getPhaseOPTotal();
        }

        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            if (PhaseCorps.isPhase(stats) && !Level3.isCivilian(stats)) {
                float peakBonus = this.computeAndCacheThresholdBonus(stats, "pc_peak", PEAK_TIME_BONUS, BaseSkillEffectDescription.ThresholdBonusType.PHASE_OP);
                stats.getPeakCRDuration().modifyFlat(id, peakBonus);
                float sensorBonus = this.computeAndCacheThresholdBonus(stats, "pc_sensor", PHASE_SHIP_SENSOR_BONUS_PERCENT, BaseSkillEffectDescription.ThresholdBonusType.PHASE_OP);
                stats.getSensorStrength().modifyPercent(id, sensorBonus);
                float speedBonus = this.computeAndCacheThresholdBonus(stats, "pc_speed", PHASE_SPEED_BONUS, BaseSkillEffectDescription.ThresholdBonusType.PHASE_OP);
                stats.getDynamic().getMod("phase_cloak_speed").modifyFlat(id, speedBonus);
                stats.getDynamic().getMod("phase_cloak_accel").modifyFlat(id, speedBonus);
            }
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getPeakCRDuration().unmodifyFlat(id);
            stats.getSensorStrength().unmodifyPercent(id);
            stats.getDynamic().getMod("phase_cloak_speed").unmodifyFlat(id);
            stats.getDynamic().getMod("phase_cloak_accel").unmodifyFlat(id);
        }

        public String getEffectDescription(float level) {
            return null;
        }

        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            FleetDataAPI data = Level3.getFleetData(null);
            float peakBonus = this.computeAndCacheThresholdBonus(data, stats, "pc_peak", PEAK_TIME_BONUS, BaseSkillEffectDescription.ThresholdBonusType.PHASE_OP);
            float sensorBonus = this.computeAndCacheThresholdBonus(data, stats, "pc_sensor", PHASE_SHIP_SENSOR_BONUS_PERCENT, BaseSkillEffectDescription.ThresholdBonusType.PHASE_OP);
            float speedBonus = this.computeAndCacheThresholdBonus(data, stats, "pc_speed", PHASE_SPEED_BONUS, BaseSkillEffectDescription.ThresholdBonusType.PHASE_OP);
            info.addSpacer(5.0f);
            info.addPara("+%s seconds peak operating time for combat phase ships (maximum: %s)", 0.0f, this.hc, this.hc, "" + (int)peakBonus, "" + (int)PEAK_TIME_BONUS);
            info.addPara("+%s top speed and acceleration while phase cloak active (maximum: %s)", 0.0f, this.hc, this.hc, (int)speedBonus + "%", (int)PHASE_SPEED_BONUS + "%");
            info.addPara("+%s to sensor strength of combat phase ships* (maximum: %s)", 0.0f, this.hc, this.hc, (int)sensorBonus + "%", (int)PHASE_SHIP_SENSOR_BONUS_PERCENT + "%");
            this.addPhaseOPThresholdInfo(info, data, stats);
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }
}

