/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;

public class ReliabilityEngineering {
    public static float PEAK_TIME_BONUS = 60.0f;
    public static float DEGRADE_REDUCTION_PERCENT = 25.0f;
    public static float MAX_CR_BONUS = 15.0f;
    public static float OVERLOAD_REDUCTION = 30.0f;

    public static class Level1
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getDynamic().getMod("individual_ship_recovery_mod").modifyFlat(id, 1000.0f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDynamic().getMod("individual_ship_recovery_mod").unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "If lost in combat, ship is almost always recoverable";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level2
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getPeakCRDuration().modifyFlat(id, PEAK_TIME_BONUS);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getPeakCRDuration().unmodifyFlat(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)PEAK_TIME_BONUS + " seconds peak operating time";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level3
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getCRLossPerSecondPercent().modifyMult(id, 1.0f - DEGRADE_REDUCTION_PERCENT / 100.0f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getCRLossPerSecondPercent().unmodifyMult(id);
        }

        public String getEffectDescription(float level) {
            return "-" + (int)DEGRADE_REDUCTION_PERCENT + "% combat readiness degradation rate after peak performance time runs out";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level4
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getMaxCombatReadiness().modifyFlat(id, MAX_CR_BONUS * 0.01f, "Reliabilty Engineering skill");
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getMaxCombatReadiness().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)MAX_CR_BONUS + "% maximum combat readiness";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level5
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getOverloadTimeMod().modifyMult(id, 1.0f - OVERLOAD_REDUCTION / 100.0f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getOverloadTimeMod().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "-" + (int)OVERLOAD_REDUCTION + "% overload duration";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }
}

