/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FleetDataAPI;
import com.fs.starfarer.api.characters.FleetStatsSkillEffect;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.StatBonus;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.MutableFleetStatsAPI;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;

public class Salvaging {
    public static float CREW_LOSS_REDUCTION = 75.0f;
    public static float SALVAGE_BONUS = 50.0f;
    public static final float COMBAT_SALVAGE = 20.0f;
    public static float CARGO_CAPACITY_MAX_PERCENT = 50.0f;
    public static float CARGO_CAPACITY_MAX_VALUE = 1000.0f;
    public static float FUEL_SALVAGE_BONUS = 25.0f;
    public static String CARGO_EFFECT_ID = "sal_cargo_cap_mod";

    public static class Level1
    implements FleetStatsSkillEffect {
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
            String desc = "Salvaging skill";
            stats.getDynamic().getStat("salvage_value_bonus_fleet_not_rare").modifyFlat(id, SALVAGE_BONUS * 0.01f, desc);
        }

        public void unapply(MutableFleetStatsAPI stats, String id) {
            stats.getDynamic().getStat("salvage_value_bonus_fleet_not_rare").unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)SALVAGE_BONUS + "% resources - but not rare items, such as blueprints - recovered from abandoned stations and other derelicts";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level2
    implements FleetStatsSkillEffect {
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
            stats.getDynamic().getStat("fuel_salvage_value_mult_fleet").modifyFlat(id, FUEL_SALVAGE_BONUS * 0.01f);
        }

        public void unapply(MutableFleetStatsAPI stats, String id) {
            stats.getDynamic().getStat("fuel_salvage_value_mult_fleet").unmodify(id);
        }

        public String getEffectDescription(float level) {
            float max = 0.0f;
            return "+" + (int)(max += FUEL_SALVAGE_BONUS) + "% fuel salvaged";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level3
    implements FleetStatsSkillEffect {
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
            stats.getDynamic().getStat("battle_salvage_value_bonus_fleet").modifyFlat(id, 0.19999999f);
        }

        public void unapply(MutableFleetStatsAPI stats, String id) {
            stats.getDynamic().getStat("battle_salvage_value_bonus_fleet").unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+20% post-battle salvage";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level4
    extends BaseSkillEffectDescription
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            id = CARGO_EFFECT_ID;
            float capMult = this.getCargoCapacityMult(id, Level4.getFleetData(stats));
            stats.getCargoMod().modifyMult(id, capMult);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            id = CARGO_EFFECT_ID;
            stats.getCargoMod().unmodifyMult(id);
        }

        public String getEffectDescription(float level) {
            return null;
        }

        protected float getCargoCapacityBase(String id, FleetDataAPI data) {
            if (data == null) {
                return 0.0f;
            }
            float cargoCap = 0.0f;
            for (FleetMemberAPI curr : data.getMembersListCopy()) {
                StatBonus stat = curr.getStats().getCargoMod();
                MutableStat.StatMod mod = stat.getMultBonus(id);
                if (mod != null) {
                    stat.unmodifyMult(mod.source);
                }
                cargoCap += curr.getCargoCapacity();
                if (mod == null) continue;
                stat.modifyMult(mod.source, mod.value, mod.desc);
            }
            return cargoCap;
        }

        protected float getCargoCapacityMult(String id, FleetDataAPI data) {
            if (data == null) {
                return 0.0f;
            }
            String key = "salvaging1";
            Float bonus = (Float)data.getCacheClearedOnSync().get(key);
            if (bonus != null) {
                return bonus.floatValue();
            }
            float cargoBase = this.getCargoCapacityBase(id, data);
            float capMult = 0.0f;
            if (cargoBase > 0.0f) {
                float addCapacity = Math.min(cargoBase * (CARGO_CAPACITY_MAX_PERCENT * 0.01f), CARGO_CAPACITY_MAX_VALUE);
                capMult = 1.0f + addCapacity / cargoBase;
                capMult = (float)Math.round(capMult * 100.0f) / 100.0f;
            }
            data.getCacheClearedOnSync().put(key, Float.valueOf(capMult));
            return capMult;
        }

        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            info.addSpacer(5.0f);
            info.addPara("Cargo capacity increased by %s or %s units, whichever is lower", 0.0f, this.hc, this.hc, (int)CARGO_CAPACITY_MAX_PERCENT + "%", "" + (int)CARGO_CAPACITY_MAX_VALUE);
            if (Level4.isInCampaign()) {
                FleetDataAPI data = Global.getSector().getPlayerFleet().getFleetData();
                String id = CARGO_EFFECT_ID;
                float cargoCap = this.getCargoCapacityBase(id, data);
                float capMult = this.getCargoCapacityMult(id, data);
                float increase = cargoCap * (capMult - 1.0f);
                boolean has = stats.getSkillLevel(skill.getId()) > 0.0f;
                String is = "is";
                if (!has) {
                    is = "would be";
                }
                info.addPara(String.valueOf(this.indent) + "Your fleet has a base cargo capacity of %s, which " + is + " increased by %s, or approximately %s units", 0.0f, this.tc, this.hc, Misc.getRoundedValueMaxOneAfterDecimal(cargoCap), Math.round((capMult - 1.0f) * 100.0f) + "%", Misc.getRoundedValueMaxOneAfterDecimal(increase));
            }
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level5
    implements FleetStatsSkillEffect {
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
            stats.getDynamic().getStat("overall_crew_loss_mult").modifyMult(id, 1.0f - CREW_LOSS_REDUCTION / 100.0f);
        }

        public void unapply(MutableFleetStatsAPI stats, String id) {
            stats.getDynamic().getStat("overall_crew_loss_mult").unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "-" + (int)CREW_LOSS_REDUCTION + "% crew lost in non-combat operations";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }
}

