/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.terrain;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.impl.campaign.terrain.BaseTerrain;
import com.fs.starfarer.api.util.Misc;
import java.util.EnumSet;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseRingTerrain
extends BaseTerrain {
    public RingParams params;
    protected transient EnumSet<CampaignEngineLayers> layers = EnumSet.of(CampaignEngineLayers.TERRAIN_2);

    @Override
    public void init(String terrainId, SectorEntityToken entity, Object param) {
        super.init(terrainId, entity, param);
        this.params = (RingParams)param;
        this.readResolve();
    }

    @Override
    public SectorEntityToken getRelatedEntity() {
        return this.params.relatedEntity;
    }

    protected Object readResolve() {
        this.layers = EnumSet.of(CampaignEngineLayers.TERRAIN_2);
        return this;
    }

    Object writeReplace() {
        return this;
    }

    @Override
    public EnumSet<CampaignEngineLayers> getActiveLayers() {
        return this.layers;
    }

    @Override
    public boolean containsEntity(SectorEntityToken other) {
        if (other.getContainingLocation() != this.entity.getContainingLocation()) {
            return false;
        }
        return this.containsPoint(other.getLocation(), other.getRadius()) && !this.isPreventedFromAffecting(other);
    }

    @Override
    public boolean containsPoint(Vector2f point, float radius) {
        float dist = Misc.getDistance(this.entity.getLocation(), point);
        if (dist > this.getMaxRadiusForContains() + radius) {
            return false;
        }
        return !(dist < this.getMinRadiusForContains() - radius);
    }

    protected float getMinRadiusForContains() {
        return this.params.middleRadius - this.params.bandWidthInEngine / 2.0f;
    }

    protected float getMaxRadiusForContains() {
        return this.params.middleRadius + this.params.bandWidthInEngine / 2.0f;
    }

    @Override
    public float getRenderRange() {
        return this.params.middleRadius + this.params.bandWidthInEngine / 2.0f + 50.0f;
    }

    public RingParams getRingParams() {
        return this.params;
    }

    @Override
    public float getProximitySoundFactor() {
        float width = this.params.bandWidthInEngine / 2.0f + this.getExtraSoundRadius() + Global.getSector().getPlayerFleet().getRadius();
        if (width <= 1.0f) {
            return 1.0f;
        }
        CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        float dist = Misc.getDistance(this.entity.getLocation(), player.getLocation());
        float mid = this.params.middleRadius;
        float distFromMid = Math.abs(dist - mid);
        if (dist < mid && this.params.middleRadius - this.params.bandWidthInEngine / 2.0f < this.getExtraSoundRadius()) {
            distFromMid = 0.0f;
        }
        if (distFromMid < width * 0.5f) {
            return 1.0f;
        }
        return (width - distFromMid) / (width * 0.5f);
    }

    @Override
    public void render(CampaignEngineLayers layer, ViewportAPI v) {
    }

    @Override
    public void renderOnMap(float factor, float alphaMult) {
    }

    @Override
    public void renderOnMapAbove(float factor, float alphaMult) {
    }

    @Override
    public float getMaxEffectRadius(Vector2f locFrom) {
        return this.params.middleRadius + this.params.bandWidthInEngine / 2.0f;
    }

    @Override
    public float getMinEffectRadius(Vector2f locFrom) {
        return this.params.middleRadius - this.params.bandWidthInEngine / 2.0f;
    }

    @Override
    public float getOptimalEffectRadius(Vector2f locFrom) {
        return this.params.middleRadius;
    }

    @Override
    public String getNameAOrAn() {
        if (this.getTerrainName() != null) {
            return Misc.getAOrAnFor(this.getTerrainName());
        }
        return "a";
    }

    public static class RingParams {
        public float bandWidthInEngine;
        public float middleRadius;
        public SectorEntityToken relatedEntity;
        public String name;

        public RingParams(float bandWidthInEngine, float middleRadius, SectorEntityToken relatedEntity, String name) {
            this.bandWidthInEngine = bandWidthInEngine;
            this.middleRadius = middleRadius;
            this.relatedEntity = relatedEntity;
            this.name = name;
        }

        public RingParams(float bandWidthInEngine, float middleRadius, SectorEntityToken relatedEntity) {
            this(bandWidthInEngine, middleRadius, relatedEntity, null);
        }
    }
}

