/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.terrain;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CampaignTerrainAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TerrainAIFlags;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.terrain.BaseRingTerrain;
import com.fs.starfarer.api.impl.campaign.terrain.DebrisPiece;
import com.fs.starfarer.api.impl.campaign.terrain.RingSystemTerrainPlugin;
import com.fs.starfarer.api.loading.Description;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.FaderUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class DebrisFieldTerrainPlugin
extends BaseRingTerrain {
    public static final float DISSIPATE_DAYS = 3.0f;
    protected transient List<DebrisPiece> pieces;
    protected transient boolean initedDebris = false;
    public DebrisFieldParams params;
    protected boolean fadingOut = false;
    protected FaderUtil expander;
    protected float elapsed;
    protected Boolean scavenged = null;
    protected transient boolean wasInNonCurrentLocation = false;
    private String nameForTooltip = null;

    public static float computeDetectionRange(float radius) {
        float range = 100.0f + radius * 5.0f;
        if (range > 2000.0f) {
            range = 2000.0f;
        }
        return range;
    }

    public void init(String terrainId, SectorEntityToken entity, Object param) {
        super.init(terrainId, entity, param);
        this.params = (DebrisFieldParams)param;
        this.name = this.params.name;
        if (this.name == null) {
            this.name = "Debris Field";
        }
        float dur = this.params.bandWidthInEngine / 500.0f;
        this.expander = new FaderUtil(0.0f, dur, dur);
        this.expander.fadeIn();
        ((CampaignTerrainAPI)entity).setRadius(this.params.bandWidthInEngine);
        entity.setDetectionRangeDetailsOverrideMult(Float.valueOf(0.4f));
        entity.addTag("debris");
    }

    public boolean isScavenged() {
        return this.scavenged != null && this.scavenged != false;
    }

    public void setScavenged(Boolean scavenged) {
        this.scavenged = scavenged;
    }

    public DebrisFieldParams getParams() {
        return this.params;
    }

    protected Object readResolve() {
        super.readResolve();
        this.layers = EnumSet.of(CampaignEngineLayers.TERRAIN_7A);
        return this;
    }

    public void advance(float amount) {
        int addIndicators;
        super.advance(amount);
        if (amount <= 0.0f) {
            return;
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        this.elapsed += days;
        if (!this.entity.isInCurrentLocation()) {
            this.pieces = null;
            this.initedDebris = false;
            this.wasInNonCurrentLocation = true;
            if (this.params.lastsDays - this.elapsed <= 0.0f) {
                this.getEntity().setExpired(true);
            }
            return;
        }
        ((CampaignTerrainAPI)this.entity).setRadius(this.params.bandWidthInEngine);
        float left = this.params.lastsDays - this.elapsed;
        if (left < 3.0f) {
            float decr = days / 3.0f * this.params.baseDensity;
            this.params.density -= decr;
            if (this.params.density < 0.0f) {
                this.params.density = 0.0f;
            }
        }
        if (this.wasInNonCurrentLocation) {
            this.expander.forceIn();
            this.wasInNonCurrentLocation = false;
        }
        this.expander.advance(days);
        this.initDebrisIfNeeded();
        ArrayList<DebrisPiece> remove = new ArrayList<DebrisPiece>();
        int withIndicator = 0;
        for (DebrisPiece piece : this.pieces) {
            piece.advance(days);
            if (piece.isDone()) {
                remove.add(piece);
                continue;
            }
            if (!piece.hasIndicator()) continue;
            ++withIndicator;
        }
        this.pieces.removeAll(remove);
        int withIndicatorGoal = (int)((float)this.pieces.size() * 0.1f);
        if (withIndicatorGoal < 3) {
            withIndicatorGoal = 3;
        }
        if ((addIndicators = withIndicatorGoal - withIndicator) > 0) {
            WeightedRandomPicker<DebrisPiece> picker = new WeightedRandomPicker<DebrisPiece>();
            for (DebrisPiece piece : this.pieces) {
                if (piece.hasIndicator()) continue;
                picker.add(piece);
            }
            int i = 0;
            while (i < addIndicators && !picker.isEmpty()) {
                DebrisPiece piece = (DebrisPiece)picker.pickAndRemove();
                if (piece != null) {
                    piece.showIndicator();
                }
                ++i;
            }
        }
        if (left > 0.0f) {
            this.addPiecesToMax();
        } else if (this.pieces.isEmpty()) {
            this.getEntity().setExpired(true);
        }
    }

    protected float getMaxRadiusForContains() {
        return super.getMaxRadiusForContains() * this.expander.getBrightness();
    }

    protected float getMinRadiusForContains() {
        return super.getMinRadiusForContains() * this.expander.getBrightness();
    }

    public void render(CampaignEngineLayers layer, ViewportAPI viewport) {
        super.render(layer, viewport);
        float alphaMult = viewport.getAlphaMult();
        alphaMult *= this.entity.getSensorFaderBrightness();
        alphaMult *= this.entity.getSensorContactFaderBrightness();
        if (alphaMult <= 0.0f) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.entity.getLocation().x, (float)this.entity.getLocation().y, (float)0.0f);
        this.initDebrisIfNeeded();
        for (DebrisPiece piece : this.pieces) {
            piece.render(alphaMult);
        }
        for (DebrisPiece piece : this.pieces) {
            piece.renderIndicator(alphaMult);
        }
        GL11.glPopMatrix();
    }

    protected void addPiecesToMax() {
        int baseMax;
        float mult = this.params.bandWidthInEngine / 500.0f;
        if ((baseMax = (int)((mult *= mult) * 100.0f * (0.5f + 0.5f * this.params.density))) < 7) {
            baseMax = 7;
        }
        int max = (int)((float)baseMax * this.expander.getBrightness() * this.expander.getBrightness());
        max *= 2;
        while (this.pieces.size() < max) {
            DebrisPiece piece = new DebrisPiece(this);
            this.pieces.add(piece);
        }
    }

    protected void initDebrisIfNeeded() {
        if (this.initedDebris) {
            return;
        }
        this.initedDebris = true;
        this.pieces = new ArrayList<DebrisPiece>();
        if (this.params.lastsDays - this.elapsed > 0.0f) {
            this.addPiecesToMax();
        }
        for (DebrisPiece piece : this.pieces) {
            piece.advance(1.0f * this.expander.getBrightness());
        }
    }

    public void applyEffect(SectorEntityToken entity, float days) {
        CampaignFleetAPI fleet;
        if (entity instanceof CampaignFleetAPI && Misc.isSlowMoving(fleet = (CampaignFleetAPI)entity)) {
            fleet.getStats().addTemporaryModMult(0.1f, String.valueOf(this.getModId()) + "_1", "Hiding inside debris field", RingSystemTerrainPlugin.getVisibilityMult(fleet), fleet.getStats().getDetectedRangeMod());
        }
    }

    public boolean hasTooltip() {
        return true;
    }

    public String getNameForTooltip() {
        if (this.nameForTooltip == null) {
            return "Debris Field";
        }
        return this.nameForTooltip;
    }

    public void setNameForTooltip(String nameForTooltip) {
        this.nameForTooltip = nameForTooltip;
    }

    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        float pad = 10.0f;
        float small = 5.0f;
        Color gray = Misc.getGrayColor();
        Color highlight = Misc.getHighlightColor();
        Color fuel = Global.getSettings().getColor("progressBarFuelColor");
        Color bad = Misc.getNegativeHighlightColor();
        tooltip.addTitle(this.getNameForTooltip());
        tooltip.addPara(Global.getSettings().getDescription(this.getTerrainId(), Description.Type.TERRAIN).getText1(), pad);
        float left = this.params.lastsDays - this.elapsed;
        if (left >= 1000.0f) {
            tooltip.addPara("This particular field appears stable and is unlikely to drift apart any time soon.", pad);
        } else {
            String atLeastTime = Misc.getAtLeastStringForDays((int)left);
            tooltip.addPara("This particular field is unstable, but should not drift apart for " + atLeastTime + ".", pad);
        }
        float nextPad = pad;
        if (expanded) {
            tooltip.addSectionHeading("Travel", Alignment.MID, pad);
            nextPad = small;
        }
        String stop = Global.getSettings().getControlStringForEnumName("GO_SLOW");
        tooltip.addPara("Reduces the range at which stationary or slow-moving* fleets inside it can be detected by %s.", nextPad, highlight, (int)((1.0f - RingSystemTerrainPlugin.getVisibilityMult(Global.getSector().getPlayerFleet())) * 100.0f) + "%");
        tooltip.addPara("*Press and hold %s to stop; combine with holding the left mouse button down to move slowly.", nextPad, Misc.getGrayColor(), highlight, stop);
        tooltip.addPara("Scavenging through the debris for anything useful is possible, but can be dangerous for the crew and equipment involved.", pad);
    }

    public boolean isTooltipExpandable() {
        return true;
    }

    public float getTooltipWidth() {
        return 350.0f;
    }

    public String getEffectCategory() {
        return "ringsystem-like";
    }

    public boolean hasAIFlag(Object flag) {
        return flag == TerrainAIFlags.HIDING_STATIONARY;
    }

    public String getIconSpriteName() {
        return Global.getSettings().getSpriteName("terrain", "debrisFieldMapIcon");
    }

    public boolean isFadingOut() {
        return this.fadingOut;
    }

    public FaderUtil getExpander() {
        return this.expander;
    }

    public float getGlowDaysLeft() {
        return this.params.glowsDays - this.elapsed;
    }

    public float getPieceGlowProbability() {
        float glowLeft = this.getGlowDaysLeft();
        if (glowLeft <= 0.0f) {
            return 0.0f;
        }
        if (this.params.glowsDays <= 0.0f) {
            return 0.0f;
        }
        return glowLeft / this.params.glowsDays;
    }

    public float getDaysLeft() {
        return this.params.lastsDays - this.elapsed;
    }

    public static class DebrisFieldParams
    extends BaseRingTerrain.RingParams {
        public float density;
        public float baseDensity;
        public float glowsDays;
        public float lastsDays;
        public float minSize = 4.0f;
        public float maxSize = 16.0f;
        public Color glowColor = new Color(255, 165, 100, 255);
        public String defFaction = null;
        public float defenderProb = 0.0f;
        public int minStr = 0;
        public int maxStr = 0;
        public int maxDefenderSize = 4;
        public long baseSalvageXP = 0L;
        public DebrisFieldSource source = DebrisFieldSource.MIXED;

        public DebrisFieldParams(float bandWidthInEngine, float density, float lastsDays, float glowsDays) {
            super(bandWidthInEngine, bandWidthInEngine / 2.0f, null);
            this.density = density < 0.0f ? 0.1f + StarSystemGenerator.random.nextFloat() * 0.9f : density;
            this.baseDensity = 1.0f;
            this.glowsDays = glowsDays;
            this.lastsDays = lastsDays;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DebrisFieldSource {
        GEN,
        PLAYER_SALVAGE,
        SALVAGE,
        BATTLE,
        MIXED;

    }
}

