/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.terrain;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TerrainAIFlags;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.impl.campaign.abilities.EmergencyBurnAbility;
import com.fs.starfarer.api.impl.campaign.terrain.BaseTiledTerrain;
import com.fs.starfarer.api.impl.campaign.terrain.HyperStormBoost;
import com.fs.starfarer.api.impl.campaign.terrain.HyperspaceAutomaton;
import com.fs.starfarer.api.loading.Description;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.FlickerUtilV2;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyperspaceTerrainPlugin
extends BaseTiledTerrain {
    public static final float VISIBLITY_MULT = 0.5f;
    public static final float STORM_STRIKE_SOUND_RANGE = 1500.0f;
    public static float STORM_MIN_TIMEOUT = 0.4f;
    public static float STORM_MAX_TIMEOUT = 0.6f;
    public static float STORM_DAMAGE_FRACTION = 0.3f;
    public static float STORM_MIN_STRIKE_DAMAGE = 0.05f;
    public static float STORM_MAX_STRIKE_DAMAGE = 0.95f;
    public static float STORM_SPEED_MULT = 1.0f;
    public static float STORM_SENSOR_RANGE_MULT = 1.0f;
    public static float STORM_VISIBILITY_FLAT = 0.0f;
    public static float TILE_SIZE = 200.0f;
    public static final CampaignEngineLayers FLASH = CampaignEngineLayers.TERRAIN_6A;
    public static final CampaignEngineLayers FLASH_OVER = CampaignEngineLayers.TERRAIN_9;
    public static final CampaignEngineLayers GLOW = CampaignEngineLayers.TERRAIN_8;
    public static final CampaignEngineLayers BASE = CampaignEngineLayers.TERRAIN_6;
    public static final CampaignEngineLayers SHIVER = CampaignEngineLayers.TERRAIN_9;
    public static final CampaignEngineLayers BASE_OVER = CampaignEngineLayers.TERRAIN_7;
    protected transient SpriteAPI flickerTexture;
    protected transient CellStateTracker[][] activeCells;
    protected List<CellStateTracker> savedActiveCells = new ArrayList<CellStateTracker>();
    protected HyperspaceAutomaton auto;
    protected transient String stormSoundId = null;
    private transient EnumSet<CampaignEngineLayers> layers = EnumSet.of(BASE, new CampaignEngineLayers[]{FLASH, GLOW, SHIVER, BASE_OVER, FLASH_OVER});
    protected transient float[] temp = new float[2];
    private transient CampaignEngineLayers currLayer = null;
    private transient boolean currLayerColorSet = false;
    private transient float currAlpha = 1.0f;

    @Override
    public void init(String terrainId, SectorEntityToken entity, Object param) {
        super.init(terrainId, entity, param);
    }

    @Override
    protected Object readResolve() {
        super.readResolve();
        this.layers = EnumSet.of(BASE, new CampaignEngineLayers[]{FLASH, GLOW, SHIVER, BASE_OVER, FLASH_OVER});
        if (this.auto == null) {
            this.auto = new HyperspaceAutomaton(this.params.w, this.params.h, 1.5f, 2.5f);
        }
        this.flickerTexture = Global.getSettings().getSprite(this.params.cat, String.valueOf(this.params.key) + "_glow");
        if (this.activeCells == null) {
            this.activeCells = new CellStateTracker[this.params.w][this.params.h];
            if (this.savedActiveCells != null) {
                Iterator<CellStateTracker> iterator = this.savedActiveCells.iterator();
                while (iterator.hasNext()) {
                    CellStateTracker curr;
                    this.activeCells[curr.i][curr.j] = curr = iterator.next();
                }
            }
        }
        int[][] cells = this.auto.getCells();
        int i = 0;
        while (i < this.activeCells.length) {
            int j = 0;
            while (j < this.activeCells[0].length) {
                if (this.tiles[i][j] >= 0) {
                    CellStateTracker curr = this.activeCells[i][j];
                    int val = cells[i][j];
                    float interval = this.auto.getInterval().getIntervalDuration();
                    if (val == 1 && curr == null) {
                        CellStateTracker cellStateTracker = new CellStateTracker(i, j, interval * 0.0f + interval * 1.5f * (float)Math.random(), interval * 0.5f + interval * 0.5f * (float)Math.random());
                        this.activeCells[i][j] = cellStateTracker;
                        curr = cellStateTracker;
                        float dur = (float)Math.random() * interval * 2.5f;
                        curr.advance(dur);
                    }
                }
                ++j;
            }
            ++i;
        }
        this.stormSoundId = this.getSpec().getCustom().optString("stormSound", null);
        return this;
    }

    public CellStateTracker[][] getActiveCells() {
        return this.activeCells;
    }

    @Override
    Object writeReplace() {
        HyperspaceTerrainPlugin copy = (HyperspaceTerrainPlugin)super.writeReplace();
        copy.savedActiveCells = new ArrayList<CellStateTracker>();
        int i = 0;
        while (i < copy.activeCells.length) {
            int j = 0;
            while (j < copy.activeCells[0].length) {
                CellStateTracker curr = copy.activeCells[i][j];
                if (curr != null && this.isTileVisible(i, j)) {
                    copy.savedActiveCells.add(curr);
                }
                ++j;
            }
            ++i;
        }
        return copy;
    }

    @Override
    public EnumSet<CampaignEngineLayers> getActiveLayers() {
        return this.layers;
    }

    protected float[] getThetaAndRadius(Random rand, float width, float height) {
        if (this.temp == null) {
            this.temp = new float[2];
        }
        float speedFactor = 0.5f;
        float time = this.elapsed * Global.getSector().getClock().getSecondsPerDay();
        float min = -360.0f * (rand.nextFloat() * 3.0f + 1.0f) * Misc.RAD_PER_DEG;
        float max = 360.0f * (rand.nextFloat() * 3.0f + 1.0f) * Misc.RAD_PER_DEG;
        float rate = (30.0f + 70.0f * rand.nextFloat()) * Misc.RAD_PER_DEG;
        float period = 2.0f * (max - min) / (rate *= speedFactor);
        float progress = rand.nextFloat() + time / period;
        float theta = (progress -= (float)((int)progress)) < 0.5f ? min + (max - min) * progress * 2.0f : min + (max - min) * (1.0f - progress) * 2.0f;
        this.temp[0] = theta;
        min = 0.0f;
        max = (width + height) * 0.025f;
        rate = max * 0.5f;
        period = 2.0f * (max - min) / (rate *= speedFactor);
        progress = rand.nextFloat() + time / period;
        progress -= (float)((int)progress);
        float radius = progress < 0.5f ? min + (max - min) * progress * 2.0f : min + (max - min) * (1.0f - progress) * 2.0f;
        this.temp[1] = radius;
        return this.temp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void renderQuad(int i, int j, float x, float y, float width, float height, float texX, float texY, float texW, float texH, float angle) {
        if (this.currLayer == null) {
            super.renderQuad(i, j, x, y, width, height, texX, texY, texW, texH, angle);
            return;
        }
        if (this.currLayer == FLASH_OVER) {
            return;
        }
        if (this.currLayer == SHIVER) {
            return;
        }
        CellStateTracker tracker = this.activeCells[i][j];
        float signal = 0.0f;
        if (tracker != null) {
            signal = tracker.getSignalBrightness();
        }
        if (this.currLayer == FLASH && (tracker == null || tracker.flicker == null || tracker.flicker.getBrightness() <= 0.0f)) {
            return;
        }
        if (this.currLayer == GLOW && signal <= 0.0f) {
            return;
        }
        long seed = (long)(x + y * (float)this.tiles.length) * 1000000L;
        Random rand = new Random(seed);
        angle = rand.nextFloat() * 360.0f;
        Color color = this.getRenderColor();
        float[] tr = this.getThetaAndRadius(rand, width, height);
        float theta1 = tr[0];
        float radius1 = tr[1];
        float sin1 = (float)Math.sin(theta1);
        float cos1 = (float)Math.cos(theta1);
        tr = this.getThetaAndRadius(rand, width, height);
        float theta2 = tr[0];
        float radius2 = tr[1];
        float sin2 = (float)Math.sin(theta2);
        float cos2 = (float)Math.cos(theta2);
        tr = this.getThetaAndRadius(rand, width, height);
        float theta3 = tr[0];
        float radius3 = tr[1];
        float sin3 = (float)Math.sin(theta3);
        float cos3 = (float)Math.cos(theta3);
        tr = this.getThetaAndRadius(rand, width, height);
        float theta4 = tr[0];
        float radius4 = tr[1];
        float sin4 = (float)Math.sin(theta4);
        float cos4 = (float)Math.cos(theta4);
        float vw = width / 2.0f;
        float vh = height / 2.0f;
        float cx = x + vw;
        float cy = y + vh;
        float cos = (float)Math.cos(angle * Misc.RAD_PER_DEG);
        float sin = (float)Math.sin(angle * Misc.RAD_PER_DEG);
        float shiverThreshold = 0.75f;
        boolean shiver = false;
        boolean flicker = false;
        if (this.currLayer == FLASH || this.currLayer == FLASH_OVER) {
            if (tracker != null && tracker.flicker != null && tracker.flicker.getBrightness() > 0.0f) {
                flicker = true;
            }
        } else if (this.currLayer == BASE) {
            if (!this.currLayerColorSet) {
                this.currLayerColorSet = true;
                GL11.glColor4ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()), (byte)((byte)((float)color.getAlpha() * this.currAlpha * 1.0f)));
            }
        } else if (this.currLayer == BASE_OVER) {
            if (!this.currLayerColorSet) {
                this.currLayerColorSet = true;
                GL11.glColor4ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()), (byte)((byte)((float)color.getAlpha() * this.currAlpha * 1.0f)));
            }
        } else if (this.currLayer == GLOW) {
            if (tracker == null || !(signal > 0.0f)) return;
            GL11.glColor4ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()), (byte)((byte)((float)color.getAlpha() * this.currAlpha * 1.0f * signal)));
        } else {
            if (this.currLayer != SHIVER) return;
            if (signal > shiverThreshold && tracker != null && tracker.flicker == null) {
                shiver = true;
            }
        }
        if (this.currLayer == GLOW || this.currLayer == BASE || this.currLayer == BASE_OVER) {
            int iter = 1;
            if (this.currLayer == GLOW) {
                iter = 1;
            }
            int k = 0;
            while (k < iter) {
                GL11.glTexCoord2f((float)texX, (float)texY);
                GL11.glVertex2f((float)(cx + (-vw * cos + vh * sin) + sin1 * radius1), (float)(cy + (-vw * sin - vh * cos) + cos1 * radius1));
                GL11.glTexCoord2f((float)texX, (float)(texY + texH));
                GL11.glVertex2f((float)(cx + (-vw * cos - vh * sin) + sin2 * radius2), (float)(cy + (-vw * sin + vh * cos) + cos2 * radius2));
                GL11.glTexCoord2f((float)(texX + texW), (float)(texY + texH));
                GL11.glVertex2f((float)(cx + (vw * cos - vh * sin) + sin3 * radius3), (float)(cy + (vw * sin + vh * cos) + cos3 * radius3));
                GL11.glTexCoord2f((float)(texX + texW), (float)texY);
                GL11.glVertex2f((float)(cx + (vw * cos + vh * sin) + sin4 * radius4), (float)(cy + (vw * sin - vh * cos) + cos4 * radius4));
                ++k;
            }
        }
        if (!flicker && !shiver) return;
        if (tracker == null) {
            return;
        }
        if (shiver) {
            return;
        }
        float shiverBrightness = (signal - shiverThreshold) / (1.0f - shiverThreshold);
        shiverBrightness = shiverBrightness > 0.9f ? (1.0f - shiverBrightness) / 0.1f : (shiverBrightness /= 0.9f);
        float ox = cx;
        float oy = cy;
        float maxJitter = 30.0f;
        if (shiver) {
            rand.setSeed((long)(x + y * (float)this.tiles.length) * 1000000L + Global.getSector().getClock().getTimestamp());
            maxJitter = 0.0f + 30.0f * shiverBrightness * shiverBrightness;
        } else {
            rand.setSeed((long)(x + y * (float)this.tiles.length) * 1000000L + (long)(tracker.flicker.getAngle() * 1000.0f));
        }
        maxJitter *= 5.0f;
        if (flicker) {
            vw *= 1.5f;
            vh *= 1.5f;
        }
        if (flicker) {
            float alpha = this.currAlpha;
            if (this.currLayer == FLASH_OVER) {
                alpha *= 0.25f;
            }
            GL11.glColor4ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()), (byte)((byte)((float)color.getAlpha() * alpha * tracker.flicker.getBrightness() * 1.0f)));
        } else if (shiver) {
            GL11.glColor4ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()), (byte)((byte)((float)color.getAlpha() * this.currAlpha * shiverBrightness * 0.075f)));
        }
        int maxIter = 1;
        if (shiver) {
            maxIter = 5;
        }
        int iter = 0;
        while (iter < maxIter) {
            cx = ox + rand.nextFloat() * maxJitter - maxJitter / 2.0f;
            cy = oy + rand.nextFloat() * maxJitter - maxJitter / 2.0f;
            GL11.glTexCoord2f((float)texX, (float)texY);
            GL11.glVertex2f((float)(cx + (-vw * cos + vh * sin) + sin1 * radius1), (float)(cy + (-vw * sin - vh * cos) + cos1 * radius1));
            cx = ox + rand.nextFloat() * maxJitter - maxJitter / 2.0f;
            cy = oy + rand.nextFloat() * maxJitter - maxJitter / 2.0f;
            GL11.glTexCoord2f((float)texX, (float)(texY + texH));
            GL11.glVertex2f((float)(cx + (-vw * cos - vh * sin) + sin2 * radius2), (float)(cy + (-vw * sin + vh * cos) + cos2 * radius2));
            cx = ox + rand.nextFloat() * maxJitter - maxJitter / 2.0f;
            cy = oy + rand.nextFloat() * maxJitter - maxJitter / 2.0f;
            GL11.glTexCoord2f((float)(texX + texW), (float)(texY + texH));
            GL11.glVertex2f((float)(cx + (vw * cos - vh * sin) + sin3 * radius3), (float)(cy + (vw * sin + vh * cos) + cos3 * radius3));
            cx = ox + rand.nextFloat() * maxJitter - maxJitter / 2.0f;
            cy = oy + rand.nextFloat() * maxJitter - maxJitter / 2.0f;
            GL11.glTexCoord2f((float)(texX + texW), (float)texY);
            GL11.glVertex2f((float)(cx + (vw * cos + vh * sin) + sin4 * radius4), (float)(cy + (vw * sin - vh * cos) + cos4 * radius4));
            ++iter;
        }
    }

    public String getNebulaMapTex() {
        return Global.getSettings().getSpriteName(this.params.cat, String.valueOf(this.params.key) + "_map");
    }

    public String getNebulaTex() {
        return Global.getSettings().getSpriteName(this.params.cat, this.params.key);
    }

    @Override
    public void advance(float amount) {
        int j;
        super.advance(amount);
        this.playStormStrikeSoundsIfNeeded();
        float days = Global.getSector().getClock().convertToDays(amount);
        this.auto.advance(days * 1.0f);
        int[][] cells = this.auto.getCells();
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        Vector2f test = new Vector2f();
        if (playerFleet != null) {
            test = playerFleet.getLocation();
        }
        float x = this.entity.getLocation().x;
        float y = this.entity.getLocation().y;
        float size = this.getTileSize();
        float w = (float)this.tiles.length * size;
        float h = (float)this.tiles[0].length * size;
        int xIndex = (int)((test.x - (x -= w / 2.0f)) / size);
        int yIndex = (int)((test.y - (y -= h / 2.0f)) / size);
        if (xIndex < 0) {
            xIndex = 0;
        }
        if (yIndex < 0) {
            yIndex = 0;
        }
        if (xIndex >= this.tiles.length) {
            xIndex = this.tiles.length - 1;
        }
        if (yIndex >= this.tiles[0].length) {
            yIndex = this.tiles[0].length - 1;
        }
        int subgridSize = (int)((10000.0f / size + 1.0f) * 2.0f);
        int minX = Math.max(0, xIndex - subgridSize / 2);
        int maxX = xIndex + subgridSize / 2;
        int minY = Math.max(0, yIndex - subgridSize / 2);
        int maxY = yIndex + subgridSize / 2;
        int pad = 4;
        int i = minX - pad;
        while (i <= maxX + pad && i < this.tiles.length) {
            j = minY - pad;
            while (j <= maxY + pad && j < this.tiles[0].length) {
                if ((i < minX || j < minY || i > maxX || j > maxY) && i >= 0 && j >= 0) {
                    this.activeCells[i][j] = null;
                }
                ++j;
            }
            ++i;
        }
        i = minX;
        while (i <= maxX && i < this.tiles.length) {
            j = minY;
            while (j <= maxY && j < this.tiles[0].length) {
                if (this.tiles[i][j] >= 0) {
                    CellStateTracker curr = this.activeCells[i][j];
                    int val = cells[i][j];
                    float interval = this.auto.getInterval().getIntervalDuration();
                    if (val == 1 && curr == null) {
                        CellStateTracker cellStateTracker = new CellStateTracker(i, j, interval * 0.0f + interval * 1.5f * (float)Math.random(), interval * 0.5f + interval * 0.5f * (float)Math.random());
                        this.activeCells[i][j] = cellStateTracker;
                        curr = cellStateTracker;
                    }
                    if (curr != null) {
                        if (val != 1 && curr.isStorming() && !curr.isWaning()) {
                            curr.wane(interval * 0.5f + interval * 0.5f * (float)Math.random());
                        }
                        curr.advance(days);
                        if (curr.isOff()) {
                            this.activeCells[i][j] = null;
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    protected void playStormStrikeSoundsIfNeeded() {
        if (this.stormSoundId == null) {
            return;
        }
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        if (playerFleet.getContainingLocation() != this.entity.getContainingLocation()) {
            return;
        }
        Vector2f test = playerFleet.getLocation();
        float x = this.entity.getLocation().x;
        float y = this.entity.getLocation().y;
        float size = this.getTileSize();
        float w = (float)this.tiles.length * size;
        float h = (float)this.tiles[0].length * size;
        int xIndex = (int)((test.x - (x -= w / 2.0f)) / size);
        int yIndex = (int)((test.y - (y -= h / 2.0f)) / size);
        if (xIndex < 0) {
            xIndex = 0;
        }
        if (yIndex < 0) {
            yIndex = 0;
        }
        if (xIndex >= this.tiles.length) {
            xIndex = this.tiles.length - 1;
        }
        if (yIndex >= this.tiles[0].length) {
            yIndex = this.tiles[0].length - 1;
        }
        int subgridSize = (int)((1500.0f / size + 1.0f) * 2.0f);
        float i = Math.max(0, xIndex - subgridSize / 2);
        while (i <= (float)(xIndex + subgridSize / 2) && i < (float)this.tiles.length) {
            float j = Math.max(0, yIndex - subgridSize / 2);
            while (j <= (float)(yIndex + subgridSize / 2) && j < (float)this.tiles[0].length) {
                int texIndex = this.tiles[(int)i][(int)j];
                if (texIndex >= 0) {
                    float dist;
                    float tcx = x + i * size + size / 2.0f;
                    float tcy = y + j * size + size / 2.0f;
                    Vector2f tileLoc = new Vector2f(tcx, tcy);
                    CellStateTracker curr = this.activeCells[(int)i][(int)j];
                    if (curr != null && curr.flicker != null && curr.isStorming() && curr.flicker.isPeakFrame() && curr.flicker.getNumBursts() <= 1 && !((dist = Misc.getDistance(test, tileLoc)) > 1500.0f)) {
                        float volumeMult = 1.0f - dist / 1500.0f;
                        if (!((volumeMult = (float)Math.sqrt(volumeMult)) <= 0.0f)) {
                            Global.getSoundPlayer().playSound(this.stormSoundId, 1.0f, 1.0f * volumeMult, tileLoc, Misc.ZERO);
                        }
                    }
                }
                j += 1.0f;
            }
            i += 1.0f;
        }
    }

    @Override
    public void render(CampaignEngineLayers layer, ViewportAPI viewport) {
        this.currLayer = layer;
        super.render(layer, viewport);
    }

    @Override
    public void renderOnMap(float factor, float alphaMult) {
        this.currLayer = null;
        super.renderOnMap(factor, alphaMult);
    }

    @Override
    public float getTileRenderSize() {
        return TILE_SIZE * 2.5f;
    }

    @Override
    public float getTileContainsSize() {
        return TILE_SIZE * 1.5f;
    }

    @Override
    public float getTileSize() {
        return TILE_SIZE;
    }

    @Override
    protected void renderSubArea(float startColumn, float endColumn, float startRow, float endRow, float factor, int samples, float alphaMult) {
        super.renderSubArea(startColumn, endColumn, startRow, endRow, factor, samples, alphaMult);
    }

    @Override
    public void preRender(CampaignEngineLayers layer, float alphaMult) {
        GL11.glEnable((int)3042);
        if (layer == FLASH || layer == FLASH_OVER) {
            GL11.glBlendFunc((int)770, (int)1);
            this.flickerTexture.bindTexture();
        } else {
            if (layer == GLOW || layer == SHIVER || layer == BASE) {
                GL11.glBlendFunc((int)770, (int)1);
            } else {
                GL11.glBlendFunc((int)770, (int)771);
            }
            if (layer == SHIVER) {
                this.flickerTexture.bindTexture();
            }
        }
        this.currAlpha = alphaMult;
        this.currLayerColorSet = false;
    }

    @Override
    public void preMapRender(float alphaMult) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.currAlpha = alphaMult;
        this.currLayerColorSet = false;
        Color color = this.getRenderColor();
        GL11.glColor4ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()), (byte)((byte)((float)color.getAlpha() * alphaMult)));
    }

    @Override
    public void renderOnRadar(Vector2f radarCenter, float factor, float alphaMult) {
        float yEnd;
        float xEnd;
        float yStart;
        this.currLayer = null;
        float radius = Global.getSettings().getFloat("campaignRadarRadius") + 2000.0f;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(-radarCenter.x * factor), (float)(-radarCenter.y * factor), (float)0.0f);
        this.preMapRender(alphaMult);
        int samples = 10;
        float x = this.entity.getLocation().x;
        float y = this.entity.getLocation().y;
        float size = this.getTileSize();
        float renderSize = this.getTileRenderSize();
        float w = (float)this.tiles.length * size;
        float h = (float)this.tiles[0].length * size;
        x -= w / 2.0f;
        y -= h / 2.0f;
        float extra = (renderSize - size) / 2.0f + 100.0f;
        float llx = radarCenter.x - radius;
        float lly = radarCenter.y - radius;
        float vw = radius * 2.0f;
        float vh = radius * 2.0f;
        if (llx > x + w + extra) {
            GL11.glPopMatrix();
            return;
        }
        if (lly > y + h + extra) {
            GL11.glPopMatrix();
            return;
        }
        if (llx + vw + extra < x) {
            GL11.glPopMatrix();
            return;
        }
        if (lly + vh + extra < y) {
            GL11.glPopMatrix();
            return;
        }
        float xStart = (int)((llx - x - extra) / size);
        if (xStart < 0.0f) {
            xStart = 0.0f;
        }
        if ((yStart = (float)((int)((lly - y - extra) / size))) < 0.0f) {
            yStart = 0.0f;
        }
        if ((xEnd = (float)((int)((llx + vw - x + extra) / size) + 1)) >= (float)this.tiles.length) {
            xEnd = this.tiles.length - 1;
        }
        if ((yEnd = (float)((int)((lly + vw - y + extra) / size) + 1)) >= (float)this.tiles.length) {
            yEnd = this.tiles[0].length - 1;
        }
        xStart = (int)Math.floor(xStart / (float)samples) * samples;
        xEnd = (int)Math.floor(xEnd / (float)samples) * samples;
        yStart = (int)Math.ceil(yStart / (float)samples) * samples;
        yEnd = (int)Math.ceil(yEnd / (float)samples) * samples;
        this.mapTexture.bindTexture();
        GL11.glEnable((int)3553);
        this.renderSubArea(xStart, xEnd, yStart, yEnd, factor, samples, alphaMult);
        GL11.glPopMatrix();
    }

    @Override
    public Color getRenderColor() {
        return Color.white;
    }

    @Override
    public boolean containsEntity(SectorEntityToken other) {
        return true;
    }

    @Override
    public boolean containsPoint(Vector2f test, float r) {
        return true;
    }

    public boolean isInClouds(SectorEntityToken other) {
        if (other.getContainingLocation() != this.entity.getContainingLocation()) {
            return false;
        }
        if (this.isPreventedFromAffecting(other)) {
            return false;
        }
        return super.containsPoint(other.getLocation(), other.getRadius());
    }

    public boolean isInClouds(Vector2f test, float r) {
        return super.containsPoint(test, r);
    }

    public int[] getTilePreferStorm(Vector2f test, float r) {
        float x = this.entity.getLocation().x;
        float y = this.entity.getLocation().y;
        float size = this.getTileSize();
        float containsSize = this.getTileContainsSize();
        float w = (float)this.tiles.length * size;
        float h = (float)this.tiles[0].length * size;
        x -= w / 2.0f;
        y -= h / 2.0f;
        float extra = (containsSize - size) / 2.0f;
        if (test.x + r + extra < x) {
            return null;
        }
        if (test.y + r + extra < y) {
            return null;
        }
        if (test.x > x + w + r + extra) {
            return null;
        }
        if (test.y > y + h + r + extra) {
            return null;
        }
        int xIndex = (int)((test.x - x) / size);
        int yIndex = (int)((test.y - y) / size);
        if (xIndex < 0) {
            xIndex = 0;
        }
        if (yIndex < 0) {
            yIndex = 0;
        }
        if (xIndex >= this.tiles.length) {
            xIndex = this.tiles.length - 1;
        }
        if (yIndex >= this.tiles[0].length) {
            yIndex = this.tiles[0].length - 1;
        }
        int[] found = null;
        float i = Math.max(0, xIndex - 1);
        while (i <= (float)(xIndex + 1) && i < (float)this.tiles.length) {
            float j = Math.max(0, yIndex - 1);
            while (j <= (float)(yIndex + 1) && j < (float)this.tiles[0].length) {
                int texIndex = this.tiles[(int)i][(int)j];
                if (texIndex >= 0) {
                    float tx = x + i * size + size / 2.0f - containsSize / 2.0f;
                    float ty = y + j * size + size / 2.0f - containsSize / 2.0f;
                    if (!(test.x + r < tx || test.y + r < ty || test.x > tx + containsSize + r || test.y > ty + containsSize + r)) {
                        int[] curr = new int[]{(int)i, (int)j};
                        CellStateTracker cell = this.activeCells[(int)i][(int)j];
                        if (cell != null && cell.isStorming()) {
                            return curr;
                        }
                        if (found == null || cell != null && cell.isSignaling()) {
                            found = curr;
                        }
                    }
                }
                j += 1.0f;
            }
            i += 1.0f;
        }
        return found;
    }

    public CellStateTracker getExactCellAt(Vector2f location) {
        int[] tile = this.getTile(location);
        CellStateTracker cell = null;
        if (tile != null) {
            cell = this.activeCells[tile[0]][tile[1]];
        }
        return cell;
    }

    public int[] getTile(Vector2f test) {
        float x = this.entity.getLocation().x;
        float y = this.entity.getLocation().y;
        float size = this.getTileSize();
        float containsSize = this.getTileContainsSize();
        float w = (float)this.tiles.length * size;
        float h = (float)this.tiles[0].length * size;
        x -= w / 2.0f;
        y -= h / 2.0f;
        float extra = (containsSize - size) / 2.0f;
        if (test.x + extra < x) {
            return null;
        }
        if (test.y + extra < y) {
            return null;
        }
        if (test.x > x + w + extra) {
            return null;
        }
        if (test.y > y + h + extra) {
            return null;
        }
        int xIndex = (int)((test.x - x) / size);
        int yIndex = (int)((test.y - y) / size);
        if (xIndex < 0) {
            xIndex = 0;
        }
        if (yIndex < 0) {
            yIndex = 0;
        }
        if (xIndex >= this.tiles.length) {
            xIndex = this.tiles.length - 1;
        }
        if (yIndex >= this.tiles[0].length) {
            yIndex = this.tiles[0].length - 1;
        }
        return new int[]{xIndex, yIndex};
    }

    public LocationState getStateAt(SectorEntityToken entity, float extraRadius) {
        boolean inCloud = this.isInClouds(entity);
        int[] tile = this.getTilePreferStorm(entity.getLocation(), entity.getRadius() + extraRadius);
        CellStateTracker cell = null;
        if (tile != null) {
            cell = this.activeCells[tile[0]][tile[1]];
        }
        if (!inCloud) {
            return LocationState.OPEN;
        }
        if (cell == null || !cell.isStorming()) {
            return LocationState.DEEP;
        }
        return LocationState.DEEP_STORM;
    }

    public CellStateTracker getCellAt(Vector2f location, float radius) {
        int[] tile = this.getTilePreferStorm(location, radius);
        CellStateTracker cell = null;
        if (tile != null) {
            cell = this.activeCells[tile[0]][tile[1]];
        }
        return cell;
    }

    public CellStateTracker getCellAt(SectorEntityToken entity, float extraRadius) {
        int[] tile = this.getTilePreferStorm(entity.getLocation(), entity.getRadius() + extraRadius);
        CellStateTracker cell = null;
        if (tile != null) {
            cell = this.activeCells[tile[0]][tile[1]];
        }
        return cell;
    }

    @Override
    protected boolean shouldPlayLoopOne() {
        LocationState state = this.getStateAt(Global.getSector().getPlayerFleet(), this.getExtraSoundRadius());
        return super.shouldPlayLoopOne() && state == LocationState.OPEN;
    }

    @Override
    protected boolean shouldPlayLoopTwo() {
        LocationState state = this.getStateAt(Global.getSector().getPlayerFleet(), this.getExtraSoundRadius());
        return super.shouldPlayLoopTwo() && state == LocationState.DEEP;
    }

    @Override
    protected boolean shouldPlayLoopThree() {
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        int[] tile = this.getTilePreferStorm(playerFleet.getLocation(), playerFleet.getRadius() + this.getExtraSoundRadius());
        CellStateTracker cell = null;
        if (tile != null) {
            cell = this.activeCells[tile[0]][tile[1]];
        }
        return super.shouldPlayLoopThree() && cell != null && cell.isSignaling();
    }

    @Override
    protected boolean shouldPlayLoopFour() {
        LocationState state = this.getStateAt(Global.getSector().getPlayerFleet(), this.getExtraSoundRadius());
        return super.shouldPlayLoopFour() && state == LocationState.DEEP_STORM;
    }

    @Override
    public void applyEffect(SectorEntityToken entity, float days) {
        if (entity instanceof CampaignFleetAPI) {
            CampaignFleetAPI fleet = (CampaignFleetAPI)entity;
            boolean inCloud = this.isInClouds(fleet);
            int[] tile = this.getTilePreferStorm(fleet.getLocation(), fleet.getRadius());
            CellStateTracker cell = null;
            if (tile != null) {
                cell = this.activeCells[tile[0]][tile[1]];
            }
            if (inCloud && !fleet.isInHyperspaceTransition()) {
                fleet.getStats().addTemporaryModMult(0.1f, String.valueOf(this.getModId()) + "_1", "In deep hyperspace", 0.5f, fleet.getStats().getDetectedRangeMod());
                float penalty = Misc.getBurnMultForTerrain(fleet);
                fleet.getStats().addTemporaryModMult(0.1f, String.valueOf(this.getModId()) + "_2", "In deep hyperspace", penalty, fleet.getStats().getFleetwideMaxBurnMod());
                if (cell != null && cell.isSignaling() && cell.signal < 0.2f) {
                    cell.signal = 0.0f;
                }
                if (cell != null && cell.isStorming() && !Misc.isSlowMoving(fleet)) {
                    if (STORM_SENSOR_RANGE_MULT != 1.0f) {
                        fleet.getStats().addTemporaryModMult(0.1f, String.valueOf(this.getModId()) + "_storm_sensor", "In deep hyperspace (storm)", STORM_SENSOR_RANGE_MULT, fleet.getStats().getSensorRangeMod());
                    }
                    if (STORM_VISIBILITY_FLAT != 0.0f) {
                        fleet.getStats().addTemporaryModFlat(0.1f, String.valueOf(this.getModId()) + "_storm_visibility", "In deep hyperspace (storm)", STORM_VISIBILITY_FLAT, fleet.getStats().getDetectedRangeMod());
                    }
                    if (STORM_SPEED_MULT != 1.0f) {
                        fleet.getStats().addTemporaryModMult(0.1f, String.valueOf(this.getModId()) + "_storm_speed", "In deep hyperspace (storm)", this.getAdjustedSpeedMult(fleet, STORM_SPEED_MULT), fleet.getStats().getFleetwideMaxBurnMod());
                    }
                    this.applyStormStrikes(cell, fleet, days);
                }
            }
        }
    }

    protected void applyStormStrikes(CellStateTracker cell, CampaignFleetAPI fleet, float days) {
        float resistance;
        FleetMemberAPI member3;
        if (cell.flicker != null && cell.flicker.getWait() > 0.0f) {
            cell.flicker.setNumBursts(0);
            cell.flicker.setWait(0.0f);
            cell.flicker.newBurst();
        }
        if (cell.flicker == null || !cell.flicker.isPeakFrame()) {
            return;
        }
        fleet.addScript(new HyperStormBoost(cell, fleet));
        String key = "$stormStrikeTimeout";
        MemoryAPI mem = fleet.getMemoryWithoutUpdate();
        if (mem.contains(key)) {
            return;
        }
        mem.set(key, true, (float)((double)STORM_MIN_TIMEOUT + (double)(STORM_MAX_TIMEOUT - STORM_MIN_TIMEOUT) * Math.random()));
        List<FleetMemberAPI> members = fleet.getFleetData().getMembersListCopy();
        if (members.isEmpty()) {
            return;
        }
        float totalValue = 0.0f;
        for (FleetMemberAPI member2 : members) {
            totalValue += member2.getStats().getSuppliesToRecover().getModifiedValue();
        }
        if (totalValue <= 0.0f) {
            return;
        }
        float strikeValue = totalValue * STORM_DAMAGE_FRACTION * (0.5f + (float)Math.random() * 0.5f);
        float ebCostThresholdMult = 4.0f;
        WeightedRandomPicker<FleetMemberAPI> picker = new WeightedRandomPicker<FleetMemberAPI>();
        WeightedRandomPicker<FleetMemberAPI> preferNotTo = new WeightedRandomPicker<FleetMemberAPI>();
        for (FleetMemberAPI member3 : members) {
            float ebCost;
            float w = 1.0f;
            if (member3.isMothballed()) {
                w *= 0.1f;
            }
            if ((ebCost = EmergencyBurnAbility.getCRCost(member3, fleet)) * ebCostThresholdMult > member3.getRepairTracker().getCR()) {
                preferNotTo.add(member3, w);
                continue;
            }
            picker.add(member3, w);
        }
        if (picker.isEmpty()) {
            picker.addAll(preferNotTo);
        }
        if ((member3 = (FleetMemberAPI)picker.pick()) == null) {
            return;
        }
        float crPerDep = member3.getDeployCost();
        float suppliesPerDep = member3.getStats().getSuppliesToRecover().getModifiedValue();
        if (suppliesPerDep <= 0.0f || crPerDep <= 0.0f) {
            return;
        }
        float strikeDamage = crPerDep * strikeValue / suppliesPerDep;
        if (strikeDamage < STORM_MIN_STRIKE_DAMAGE) {
            strikeDamage = STORM_MIN_STRIKE_DAMAGE;
        }
        if ((strikeDamage *= (resistance = member3.getStats().getDynamic().getValue("corona_resistance"))) > STORM_MAX_STRIKE_DAMAGE) {
            strikeDamage = STORM_MAX_STRIKE_DAMAGE;
        }
        float currCR = member3.getRepairTracker().getBaseCR();
        float crDamage = Math.min(currCR, strikeDamage);
        float ebCost = EmergencyBurnAbility.getCRCost(member3, fleet);
        if (currCR >= ebCost * ebCostThresholdMult) {
            crDamage = Math.min(currCR - ebCost * 1.5f, crDamage);
        }
        if (crDamage > 0.0f) {
            member3.getRepairTracker().applyCREvent(-crDamage, "hyperstorm", "Hyperspace storm strike");
        }
        float hitStrength = member3.getStats().getArmorBonus().computeEffective(member3.getHullSpec().getArmorRating());
        if ((hitStrength *= strikeDamage / crPerDep) > 0.0f) {
            member3.getStatus().applyDamage(hitStrength);
            if (member3.getStatus().getHullFraction() < 0.01f) {
                member3.getStatus().setHullFraction(0.01f);
            }
        }
        if (fleet.isPlayerFleet()) {
            String verb = "suffers";
            Color c = Misc.getNegativeHighlightColor();
            if (hitStrength <= 0.0f) {
                verb = "avoids";
                c = Misc.getTextColor();
            }
            Global.getSector().getCampaignUI().addMessage(String.valueOf(member3.getShipName()) + " " + verb + " damage from the storm", c);
            Global.getSector().getCampaignUI().showHelpPopupIfPossible("chmHyperStorm");
        }
    }

    public String getStormSoundId() {
        return this.stormSoundId;
    }

    @Override
    public boolean hasTooltip() {
        return true;
    }

    @Override
    public String getNameForTooltip() {
        return this.getTerrainName();
    }

    @Override
    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        float pad = 10.0f;
        float small = 5.0f;
        Color gray = Misc.getGrayColor();
        Color highlight = Misc.getHighlightColor();
        Color fuel = Global.getSettings().getColor("progressBarFuelColor");
        Color bad = Misc.getNegativeHighlightColor();
        CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        boolean inCloud = this.isInClouds(player);
        int[] tile = this.getTilePreferStorm(player.getLocation(), player.getRadius());
        CellStateTracker cell = null;
        if (tile != null) {
            cell = this.activeCells[tile[0]][tile[1]];
        }
        tooltip.addTitle(this.getTerrainName());
        if (!inCloud) {
            tooltip.addPara(Global.getSettings().getDescription(String.valueOf(this.getTerrainId()) + "_normal", Description.Type.TERRAIN).getText1(), pad);
        } else if (cell == null || !cell.isStorming()) {
            tooltip.addPara(Global.getSettings().getDescription(String.valueOf(this.getTerrainId()) + "_deep", Description.Type.TERRAIN).getText1(), pad);
        } else if (cell.isStorming()) {
            tooltip.addPara(Global.getSettings().getDescription(String.valueOf(this.getTerrainId()) + "_storm", Description.Type.TERRAIN).getText1(), pad);
        }
        String fuelCost = Misc.getRoundedValueMaxOneAfterDecimal(player.getLogistics().getFuelCostPerLightYear());
        float nextPad = pad;
        if (expanded) {
            tooltip.addSectionHeading("Travel", Alignment.MID, pad);
            nextPad = small;
        }
        tooltip.addPara("Traveling through hyperspace consumes fuel based on the distance travelled. Your fleet requires %s fuel per light-year.*", nextPad, highlight, fuelCost);
        if (inCloud) {
            tooltip.addPara("Reduces the range at which fleets inside can be detected by %s.", pad, highlight, "50%");
            tooltip.addPara("Reduces the speed of fleets inside by up to %s. Larger fleets are slowed down more.", nextPad, highlight, (int)(Misc.BURN_PENALTY_MULT * 100.0f) + "%");
            float penalty = Misc.getBurnMultForTerrain(Global.getSector().getPlayerFleet());
            tooltip.addPara("Your fleet's speed is reduced by %s.", pad, highlight, Math.round((1.0f - penalty) * 100.0f) + "%");
            tooltip.addSectionHeading("Hyperspace storms", Alignment.MID, pad);
            Color stormDescColor = Misc.getTextColor();
            if (cell != null && cell.isStorming()) {
                stormDescColor = bad;
            }
            tooltip.addPara("Being caught in a storm causes storm strikes to damage ships and reduce their combat readiness. Larger fleets attract more damaging strikes.", stormDescColor, pad);
            tooltip.addPara("In addition, storm strikes toss the fleet's drive bubble about with great violence, often causing a loss of control. Some commanders are known to use these to gain additional speed, and to save fuel - a practice known as \"storm riding\".", Misc.getTextColor(), pad);
            tooltip.addPara("\"Slow-moving\" fleets do not attract storm strikes.", Misc.getTextColor(), pad);
        }
        if (expanded) {
            tooltip.addSectionHeading("Combat", Alignment.MID, pad);
            tooltip.addPara("No combat effects.", nextPad);
        }
        tooltip.addPara("*1 light-year = 2000 units = 1 map grid cell", gray, pad);
    }

    protected float getAdjustedSpeedMult(CampaignFleetAPI fleet, float baseMult) {
        float skillMod = fleet.getCommanderStats().getDynamic().getValue("nav_penalty_mult");
        if (skillMod < 0.0f) {
            skillMod = 0.0f;
        }
        if (skillMod > 1.0f) {
            skillMod = 1.0f;
        }
        float penalty = 1.0f - baseMult;
        return 1.0f - (penalty *= skillMod);
    }

    @Override
    public boolean isTooltipExpandable() {
        return true;
    }

    @Override
    public float getTooltipWidth() {
        return 375.0f;
    }

    @Override
    public String getTerrainName() {
        CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        boolean inCloud = this.isInClouds(player);
        int[] tile = this.getTilePreferStorm(player.getLocation(), player.getRadius());
        boolean val = false;
        CellStateTracker cell = null;
        if (tile != null) {
            cell = this.activeCells[tile[0]][tile[1]];
        }
        String name = "Hyperspace";
        if (inCloud) {
            if (cell == null || !cell.isStorming()) {
                name = "Hyperspace (Deep)";
            } else if (cell.isStorming()) {
                name = "Hyperspace (Storm)";
            }
        }
        return name;
    }

    @Override
    public String getEffectCategory() {
        return "dark-hyper-like";
    }

    @Override
    public boolean hasAIFlag(Object flag) {
        return flag == TerrainAIFlags.REDUCES_SENSOR_RANGE;
    }

    @Override
    public boolean hasAIFlag(Object flag, CampaignFleetAPI fleet) {
        if (flag == TerrainAIFlags.DANGEROUS_UNLESS_GO_SLOW) {
            int[] tile = this.getTilePreferStorm(fleet.getLocation(), fleet.getRadius() + 100.0f);
            CellStateTracker cell = null;
            if (tile != null) {
                cell = this.activeCells[tile[0]][tile[1]];
            }
            if (cell != null) {
                return cell.isStorming() || cell.isSignaling();
            }
        }
        return this.hasAIFlag(flag);
    }

    @Override
    public int getNumMapSamples() {
        return 10;
    }

    public static void main(String[] args) {
        System.out.println(0.5f);
    }

    public void turnOffStorms(Vector2f loc, float radius) {
        this.setTileState(loc, radius, CellState.OFF, -1.0f, -1.0f);
    }

    public void setTileState(Vector2f loc, float radius, CellState state, float waitDur, float signalDur) {
        this.setTileState(loc, radius, state, waitDur, signalDur, signalDur);
    }

    public void setTileState(Vector2f loc, float radius, CellState state, float waitDur, float minSignalDur, float maxSignalDur) {
        float x = this.entity.getLocation().x;
        float y = this.entity.getLocation().y;
        float size = this.getTileSize();
        float containsSize = this.getTileContainsSize();
        float w = (float)this.tiles.length * size;
        float h = (float)this.tiles[0].length * size;
        x -= w / 2.0f;
        y -= h / 2.0f;
        float extra = (containsSize - size) / 2.0f;
        if (loc.x + radius + extra < x) {
            return;
        }
        if (loc.y + radius + extra < y) {
            return;
        }
        if (loc.x > x + w + radius + extra) {
            return;
        }
        if (loc.y > y + h + radius + extra) {
            return;
        }
        int xMin = (int)((loc.x - x - radius) / size);
        int yMin = (int)((loc.y - y - radius) / size);
        int xMax = (int)((loc.x - x + radius) / size);
        int yMax = (int)((loc.y - y + radius) / size);
        if (xMin < 0) {
            xMin = 0;
        }
        if (yMin < 0) {
            yMin = 0;
        }
        if (xMin >= this.tiles.length) {
            xMin = this.tiles.length - 1;
        }
        if (yMin >= this.tiles[0].length) {
            yMin = this.tiles[0].length - 1;
        }
        if (xMax < 0) {
            xMax = 0;
        }
        if (yMax < 0) {
            yMax = 0;
        }
        if (xMax >= this.tiles.length) {
            xMax = this.tiles.length - 1;
        }
        if (yMax >= this.tiles[0].length) {
            yMax = this.tiles[0].length - 1;
        }
        int i = xMin;
        while (i <= xMax) {
            int j = yMin;
            while (j <= yMax) {
                float ty;
                float tx;
                float dist;
                int texIndex = this.tiles[i][j];
                if (texIndex >= 0 && !((dist = Misc.getDistance(loc.x, loc.y, tx = x + (float)i * size + size / 2.0f - containsSize / 2.0f, ty = y + (float)j * size + size / 2.0f - containsSize / 2.0f)) > radius)) {
                    CellStateTracker cell = this.activeCells[i][j];
                    float interval = this.auto.getInterval().getIntervalDuration();
                    float wait = interval * 0.0f + interval * 1.5f * (float)Math.random();
                    if (waitDur >= 0.0f) {
                        wait = waitDur;
                    }
                    float signal = interval * 0.5f + interval * 0.5f * (float)Math.random();
                    if (minSignalDur >= 0.0f) {
                        signal = minSignalDur + (maxSignalDur - minSignalDur) * (float)Math.random();
                    }
                    wait *= 0.9f + (float)Math.random() * 0.2f;
                    signal *= 0.9f + (float)Math.random() * 0.2f;
                    if (cell == null && state != CellState.OFF) {
                        CellStateTracker cellStateTracker = new CellStateTracker(i, j, wait, signal);
                        this.activeCells[i][j] = cellStateTracker;
                        cell = cellStateTracker;
                        cell.state = state;
                    } else if (cell != null && state == CellState.OFF) {
                        if (cell.state == CellState.STORM || cell.state == CellState.STORM_WANE || cell.state == CellState.SIGNAL) {
                            float dur = 0.1f;
                            if (wait >= 0.0f) {
                                dur *= wait;
                            }
                            if (cell.state == CellState.STORM_WANE) {
                                dur = Math.min(cell.wane, dur);
                            } else {
                                cell.maxWane = dur * 4.0f;
                            }
                            cell.wane = dur;
                            cell.state = CellState.STORM_WANE;
                        } else {
                            this.activeCells[i][j] = null;
                        }
                    } else if (cell != null) {
                        cell.state = state;
                        if (state == CellState.WAIT) {
                            cell.wait = wait;
                        }
                        if (state == CellState.SIGNAL) {
                            cell.signal = signal;
                            cell.maxSignal = signal;
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CellState {
        OFF,
        WAIT,
        SIGNAL,
        STORM,
        STORM_WANE;

    }

    public static class CellStateTracker {
        public int i;
        public int j;
        public CellState state;
        public float wait;
        public float signal;
        public float wane;
        private float maxSignal;
        private float maxWane;
        public FlickerUtilV2 flicker = null;

        public CellStateTracker(int i, int j, float wait, float signal) {
            this.i = i;
            this.j = j;
            this.wait = wait;
            this.signal = signal;
            this.maxSignal = signal;
            this.state = CellState.WAIT;
        }

        public void advance(float days) {
            if (this.state == CellState.OFF) {
                return;
            }
            if (this.state == CellState.WAIT && days > 0.0f) {
                this.wait -= days;
                if (this.wait <= 0.0f) {
                    days = -this.wait;
                    this.wait = 0.0f;
                    this.state = CellState.SIGNAL;
                }
            }
            if (this.state == CellState.SIGNAL && days > 0.0f) {
                this.signal -= days;
                if (this.signal <= 0.0f) {
                    days = -this.signal;
                    this.signal = 0.0f;
                    this.state = CellState.STORM;
                    this.flicker = new FlickerUtilV2();
                    this.flicker.newBurst();
                }
            }
            if (this.state == CellState.STORM || this.state == CellState.STORM_WANE) {
                this.signal -= days;
            }
            if (this.state == CellState.STORM_WANE && days > 0.0f) {
                this.wane -= days;
                if (this.wane <= 0.0f) {
                    days = -this.wane;
                    this.wane = 0.0f;
                    if (this.flicker == null || this.flicker.getBrightness() <= 0.0f) {
                        this.state = CellState.OFF;
                    } else {
                        this.flicker.stop();
                    }
                }
            }
            if (this.flicker != null) {
                this.flicker.advance(days * 7.0f);
            }
        }

        public float getSignalBrightness() {
            if (this.state == CellState.SIGNAL) {
                return 1.0f - this.signal / this.maxSignal;
            }
            if (this.state == CellState.STORM) {
                return 1.0f;
            }
            if (this.state == CellState.STORM_WANE) {
                float fade = this.maxWane * 0.25f;
                if (this.wane > fade) {
                    return 1.0f;
                }
                return Math.max(0.0f, this.wane / fade);
            }
            return 0.0f;
        }

        public void wane(float wane) {
            this.wane = wane;
            this.maxWane = wane;
            this.state = CellState.STORM_WANE;
        }

        public boolean isOff() {
            return this.state == CellState.OFF;
        }

        public boolean isStorming() {
            return this.state == CellState.STORM || this.state == CellState.STORM_WANE;
        }

        public boolean isWaning() {
            return this.state == CellState.STORM_WANE;
        }

        public boolean isSignaling() {
            return this.state == CellState.SIGNAL;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LocationState {
        OPEN,
        DEEP,
        DEEP_STORM;

    }
}

