/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.terrain;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TerrainAIFlags;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberViewAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.impl.campaign.terrain.BaseRingTerrain;
import com.fs.starfarer.api.impl.campaign.terrain.CRLossPerSecondBuff;
import com.fs.starfarer.api.impl.campaign.terrain.PeakPerformanceBuff;
import com.fs.starfarer.api.impl.campaign.terrain.PulsarRenderer;
import com.fs.starfarer.api.impl.campaign.terrain.RangeBlockerUtil;
import com.fs.starfarer.api.impl.campaign.terrain.StarCoronaTerrainPlugin;
import com.fs.starfarer.api.loading.Description;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.EnumSet;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PulsarBeamTerrainPlugin
extends BaseRingTerrain
implements PulsarRenderer.PulsarRendererDelegate {
    public static float PULSAR_ARC = 57.295776f;
    protected transient SpriteAPI flareTexture = null;
    transient Color color = null;
    protected transient PulsarRenderer flare1;
    protected transient PulsarRenderer flare2;
    protected StarCoronaTerrainPlugin.CoronaParams params;
    protected transient RangeBlockerUtil blocker = null;
    protected float pulsarAngle = (float)Math.random() * 360.0f;
    protected float pulsarRotation = -1.0f * (10.0f + (float)Math.random() * 10.0f);
    private transient EnumSet<CampaignEngineLayers> layers = EnumSet.of(CampaignEngineLayers.TERRAIN_7);

    @Override
    public void init(String terrainId, SectorEntityToken entity, Object param) {
        super.init(terrainId, entity, param);
        this.params = (StarCoronaTerrainPlugin.CoronaParams)param;
        this.name = this.params.name;
        if (this.name == null) {
            this.name = "Pulsar Beam";
        }
    }

    @Override
    public String getNameForTooltip() {
        return "Pulsar Beam";
    }

    @Override
    protected Object readResolve() {
        super.readResolve();
        this.flareTexture = Global.getSettings().getSprite("terrain", "pulsar");
        this.layers = EnumSet.of(CampaignEngineLayers.TERRAIN_7);
        if (this.blocker == null) {
            this.blocker = new RangeBlockerUtil(1440, ((BaseRingTerrain)this).params.bandWidthInEngine + 1000.0f);
        }
        this.flare1 = new PulsarRenderer(this);
        this.flare2 = new PulsarRenderer(this);
        return this;
    }

    @Override
    Object writeReplace() {
        return this;
    }

    @Override
    protected boolean shouldPlayLoopOne() {
        return super.shouldPlayLoopOne() && this.containsEntity(Global.getSector().getPlayerFleet());
    }

    @Override
    protected float getLoopOneVolume() {
        float intensity = this.getIntensityAtPoint(Global.getSector().getPlayerFleet().getLocation());
        return intensity;
    }

    @Override
    protected float getExtraSoundRadius() {
        return 0.0f;
    }

    @Override
    public EnumSet<CampaignEngineLayers> getActiveLayers() {
        return this.layers;
    }

    public StarCoronaTerrainPlugin.CoronaParams getParams() {
        return this.params;
    }

    @Override
    public void advance(float amount) {
        super.advance(amount);
        float days = Global.getSector().getClock().convertToDays(amount);
        this.pulsarAngle += this.pulsarRotation * days * 1.0f;
        this.pulsarAngle = Misc.normalizeAngle(this.pulsarAngle);
        this.flare1.advance(amount);
        this.flare2.advance(amount);
        this.flare1.setCurrAngle(this.pulsarAngle);
        this.flare2.setCurrAngle(this.pulsarAngle + 180.0f);
        if (amount > 0.0f && this.blocker != null) {
            this.blocker.updateLimits(this.entity, this.params.relatedEntity, 0.5f);
            this.blocker.advance(amount, 100.0f, 0.5f);
        }
    }

    @Override
    public void render(CampaignEngineLayers layer, ViewportAPI viewport) {
        if (this.blocker != null && !this.blocker.wasEverUpdated()) {
            this.blocker.updateAndSync(this.entity, this.params.relatedEntity, 0.1f);
        }
        if (this.isNearViewport(this.pulsarAngle, viewport)) {
            this.flare1.render(viewport.getAlphaMult());
        }
        if (this.isNearViewport(this.pulsarAngle + 180.0f, viewport)) {
            this.flare2.render(viewport.getAlphaMult());
        }
    }

    protected boolean isNearViewport(float angle, ViewportAPI viewport) {
        float wClose = this.getPulsarInnerWidth();
        float wFar = this.getPulsarOuterWidth();
        float distClose = this.getPulsarInnerRadius();
        float distFar = this.getPulsarOuterRadius();
        float length = distFar - distClose;
        float incr = (float)Math.ceil((distFar - distClose) / 2000.0f);
        float dist = wClose;
        while (dist < distFar) {
            Vector2f test = Misc.getUnitVectorAtDegreeAngle(angle);
            test.scale(dist);
            Vector2f.add((Vector2f)test, (Vector2f)this.entity.getLocation(), (Vector2f)test);
            float testDist = wClose + (wFar - wClose) * (dist - distClose) / length;
            if (viewport.isNearViewport(test, (testDist *= 0.5f) + 500.0f)) {
                return true;
            }
            dist += incr;
        }
        return false;
    }

    @Override
    public float getRenderRange() {
        return this.getPulsarOuterRadius() + 1000.0f;
    }

    @Override
    public boolean containsPoint(Vector2f point, float radius) {
        if (this.blocker != null && this.blocker.isAnythingShortened()) {
            float max;
            float angle = Misc.getAngleInDegreesStrict(this.entity.getLocation(), point);
            float dist = Misc.getDistance(this.entity.getLocation(), point);
            if (dist > (max = this.blocker.getCurrMaxAt(angle))) {
                return false;
            }
        }
        if (!Misc.isInArc(this.pulsarAngle, PULSAR_ARC, this.entity.getLocation(), point) && !Misc.isInArc(this.pulsarAngle + 180.0f, PULSAR_ARC, this.entity.getLocation(), point)) {
            return false;
        }
        float dist = Misc.getDistance(this.entity.getLocation(), point);
        if (dist < this.getPulsarInnerRadius()) {
            return false;
        }
        return super.containsPoint(point, radius);
    }

    @Override
    public void applyEffect(SectorEntityToken entity, float days) {
        if (entity instanceof CampaignFleetAPI) {
            CampaignFleetAPI fleet = (CampaignFleetAPI)entity;
            float intensity = this.getIntensityAtPoint(fleet.getLocation());
            if (intensity <= 0.0f) {
                return;
            }
            String buffId = this.getModId();
            float buffDur = 0.1f;
            for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
                float curr;
                float lossMult;
                float resistance;
                float adjustedLossMult;
                float lossRate;
                float recoveryRate = member.getStats().getBaseCRRecoveryRatePercentPerDay().getModifiedValue();
                float loss = (-1.0f * recoveryRate + -1.0f * (lossRate = member.getStats().getBaseCRRecoveryRatePercentPerDay().getBaseValue()) * (adjustedLossMult = 0.0f + this.params.crLossMult * intensity * (resistance = member.getStats().getDynamic().getValue("corona_resistance")) * (lossMult = 1.0f) * 0.25f)) * days * 0.01f;
                if (loss > (curr = member.getRepairTracker().getBaseCR())) {
                    loss = curr;
                }
                if (resistance > 0.0f) {
                    member.getRepairTracker().applyCREvent(loss, "corona", "Pulsar beam effect");
                }
                float peakFraction = 1.0f / Math.max(1.3333f, 1.0f + this.params.crLossMult * intensity);
                float peakLost = 1.0f - peakFraction;
                float degradationMult = 1.0f + this.params.crLossMult * intensity * resistance / 2.0f;
                member.getBuffManager().addBuffOnlyUpdateStat(new PeakPerformanceBuff(String.valueOf(buffId) + "_1", 1.0f - (peakLost *= resistance), buffDur));
                member.getBuffManager().addBuffOnlyUpdateStat(new CRLossPerSecondBuff(String.valueOf(buffId) + "_2", degradationMult, buffDur));
            }
            float maxFleetBurn = fleet.getFleetData().getBurnLevel();
            float currFleetBurn = fleet.getCurrBurnLevel();
            float maxWindBurn = this.params.windBurnLevel;
            float currWindBurn = intensity * maxWindBurn;
            float maxFleetBurnIntoWind = maxFleetBurn - Math.abs(currWindBurn);
            float angle = Misc.getAngleInDegreesStrict(this.entity.getLocation(), fleet.getLocation());
            Vector2f windDir = Misc.getUnitVectorAtDegreeAngle(angle);
            if (currWindBurn < 0.0f) {
                windDir.negate();
            }
            Vector2f velDir = Misc.normalise(new Vector2f((ReadableVector2f)fleet.getVelocity()));
            velDir.scale(currFleetBurn);
            float fleetBurnAgainstWind = -1.0f * Vector2f.dot((Vector2f)windDir, (Vector2f)velDir);
            float accelMult = 0.5f;
            if (fleetBurnAgainstWind > maxFleetBurnIntoWind) {
                accelMult += 0.75f + 0.25f * (fleetBurnAgainstWind - maxFleetBurnIntoWind);
            }
            float seconds = days * Global.getSector().getClock().getSecondsPerDay();
            Vector2f vel = fleet.getVelocity();
            windDir.scale(seconds * fleet.getAcceleration() * accelMult);
            fleet.setVelocity(vel.x + windDir.x, vel.y + windDir.y);
            Color glowColor = this.getPulsarColorForAngle(angle);
            int alpha = glowColor.getAlpha();
            if (alpha < 75) {
                glowColor = Misc.setAlpha(glowColor, 75);
            }
            float durIn = 1.0f;
            float durOut = 3.0f;
            Misc.normalise(windDir);
            float sizeNormal = 10.0f + 25.0f * intensity;
            for (FleetMemberViewAPI view : fleet.getViews()) {
                view.getWindEffectDirX().shift(this.getModId(), windDir.x * sizeNormal, durIn, durOut, 1.0f);
                view.getWindEffectDirY().shift(this.getModId(), windDir.y * sizeNormal, durIn, durOut, 1.0f);
                view.getWindEffectColor().shift(this.getModId(), glowColor, durIn, durOut, intensity);
            }
        }
    }

    public float getIntensityAtPoint(Vector2f point) {
        float maxDiff;
        float maxDist = this.params.bandWidthInEngine;
        float minDist = this.params.relatedEntity.getRadius();
        float dist = Misc.getDistance(point, this.params.relatedEntity.getLocation());
        if (dist > maxDist) {
            return 0.0f;
        }
        float intensity = 1.0f;
        if (minDist < maxDist) {
            intensity = 1.0f - (dist - minDist) / (maxDist - minDist);
            if (intensity < 0.0f) {
                intensity = 0.0f;
            }
            if (intensity > 1.0f) {
                intensity = 1.0f;
            }
        }
        float angle = Misc.getAngleInDegreesStrict(this.params.relatedEntity.getLocation(), point);
        float diff = Misc.getAngleDiff(angle, this.pulsarAngle);
        if ((diff = Math.min(diff, Misc.getAngleDiff(angle, this.pulsarAngle + 180.0f))) > (maxDiff = PULSAR_ARC / 2.0f)) {
            diff = maxDiff;
        }
        if (diff > maxDiff * 0.5f) {
            intensity *= 0.25f + 0.75f * (1.0f - (diff - maxDiff * 0.5f) / (maxDiff * 0.5f));
        }
        return intensity;
    }

    @Override
    public Color getNameColor() {
        Color bad = Misc.getNegativeHighlightColor();
        Color base = super.getNameColor();
        return Misc.interpolateColor(base, bad, Global.getSector().getCampaignUI().getSharedFader().getBrightness() * 1.0f);
    }

    @Override
    public boolean hasTooltip() {
        return true;
    }

    @Override
    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        float pad = 10.0f;
        float small = 5.0f;
        Color gray = Misc.getGrayColor();
        Color highlight = Misc.getHighlightColor();
        Color fuel = Global.getSettings().getColor("progressBarFuelColor");
        Color bad = Misc.getNegativeHighlightColor();
        tooltip.addTitle("Pulsar Beam");
        tooltip.addPara(Global.getSettings().getDescription(this.getTerrainId(), Description.Type.TERRAIN).getText1(), pad);
        float nextPad = pad;
        if (expanded) {
            tooltip.addSectionHeading("Travel", Alignment.MID, pad);
            nextPad = small;
        }
        tooltip.addPara("Reduces the combat readiness of all ships caught in the pulsar beam at a rapid pace, and blows the fleet off-course.", nextPad);
        tooltip.addPara("The magnitude of the effect drops off rapidly with distance from the source.", pad);
        if (expanded) {
            tooltip.addSectionHeading("Combat", Alignment.MID, pad);
            tooltip.addPara("Reduces the peak performance time of ships and increases the rate of combat readiness degradation in protracted engagements.", small);
        }
    }

    @Override
    public boolean isTooltipExpandable() {
        return true;
    }

    @Override
    public float getTooltipWidth() {
        return 350.0f;
    }

    @Override
    public String getTerrainName() {
        return super.getTerrainName();
    }

    @Override
    public String getEffectCategory() {
        return null;
    }

    @Override
    public boolean hasAIFlag(Object flag, CampaignFleetAPI fleet) {
        if (fleet != null && this.containsEntity(fleet)) {
            return this.hasAIFlag(flag);
        }
        return false;
    }

    @Override
    public boolean hasAIFlag(Object flag) {
        return flag == TerrainAIFlags.CR_DRAIN || flag == TerrainAIFlags.BREAK_OTHER_ORBITS || flag == TerrainAIFlags.EFFECT_DIMINISHED_WITH_RANGE;
    }

    @Override
    public float getMaxEffectRadius(Vector2f locFrom) {
        float maxDist = this.params.bandWidthInEngine;
        return maxDist;
    }

    @Override
    public float getMinEffectRadius(Vector2f locFrom) {
        return 0.0f;
    }

    @Override
    public float getOptimalEffectRadius(Vector2f locFrom) {
        return this.params.relatedEntity.getRadius();
    }

    @Override
    public boolean canPlayerHoldStationIn() {
        return false;
    }

    @Override
    public RangeBlockerUtil getPulsarBlocker() {
        return this.blocker;
    }

    @Override
    public Vector2f getPulsarCenterLoc() {
        return this.params.relatedEntity.getLocation();
    }

    @Override
    public Color getPulsarColorForAngle(float angle) {
        if (this.color == null) {
            Color c = Color.white;
            c = this.params.relatedEntity instanceof PlanetAPI ? ((PlanetAPI)this.params.relatedEntity).getSpec().getCoronaColor() : Color.white;
            float alpha = 1.0f;
            this.color = Misc.setAlpha(c, (int)(200.0f * alpha));
            return this.color;
        }
        return this.color;
    }

    @Override
    public float getPulsarInnerRadius() {
        return this.params.relatedEntity.getRadius();
    }

    @Override
    public float getPulsarOuterRadius() {
        return this.params.middleRadius + this.params.bandWidthInEngine * 0.5f;
    }

    @Override
    public float getPulsarInnerWidth() {
        return PULSAR_ARC / 360.0f * 2.0f * (float)Math.PI * this.getPulsarInnerRadius();
    }

    @Override
    public float getPulsarOuterWidth() {
        float r1 = this.getPulsarInnerRadius();
        float r2 = this.getPulsarOuterRadius();
        return this.getPulsarInnerWidth() * r2 / r1;
    }

    @Override
    public float getPulsarScrollSpeed() {
        return 50.0f;
    }

    @Override
    public SpriteAPI getPulsarTexture() {
        return this.flareTexture;
    }
}

