/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.tutorial;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.VisualPanelAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TutorialLayInCourseDialogPluginImpl
implements InteractionDialogPlugin {
    protected InteractionDialogAPI dialog;
    protected TextPanelAPI textPanel;
    protected OptionPanelAPI options;
    protected VisualPanelAPI visual;
    protected CampaignFleetAPI playerFleet;
    protected MarketAPI ancyra;
    protected PersonAPI contact;

    public TutorialLayInCourseDialogPluginImpl(MarketAPI ancyra, PersonAPI contact) {
        this.ancyra = ancyra;
        this.contact = contact;
    }

    @Override
    public void init(InteractionDialogAPI dialog) {
        this.dialog = dialog;
        this.textPanel = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        this.visual = dialog.getVisualPanel();
        this.playerFleet = Global.getSector().getPlayerFleet();
        this.visual.showFleetInfo("Your fleet", this.playerFleet, null, null);
        this.optionSelected(null, (Object)OptionId.INIT);
    }

    @Override
    public Map<String, MemoryAPI> getMemoryMap() {
        return null;
    }

    @Override
    public void backFromEngagement(EngagementResultAPI result) {
    }

    @Override
    public void optionSelected(String text, Object optionData) {
        if (optionData == null) {
            return;
        }
        OptionId option = (OptionId)((Object)optionData);
        if (text != null) {
            this.dialog.addOptionSelectedText((Object)option);
        }
        String name = this.ancyra.getName();
        String personName = String.valueOf(this.contact.getPost().toLowerCase()) + " " + this.contact.getName().getLast();
        switch (option) {
            case INIT: {
                this.textPanel.addParagraph("Shortly after dispatching the pirates, you receive a tight-beam communication from the system's main inhabited world, " + name + ".");
                this.textPanel.addParagraph("The message is brief and asks you to travel there and contact " + personName + " as soon as possible.");
                this.options.clearOptions();
                this.options.addOption("Continue", (Object)OptionId.CONT1, null);
                break;
            }
            case CONT1: {
                this.textPanel.addParagraph("Let's lay in a course for " + name + ". You don't need to do this to travel, " + "but it helps keep track of where you're going and how long it'll take to get there.");
                String intel = Global.getSettings().getControlStringForEnumName("CORE_INTEL");
                this.textPanel.addPara("After dismissing this dialog, press %s to open the intel screen to view the details of the message you've just received.", Misc.getHighlightColor(), intel);
                this.textPanel.addPara("Select the message and click on the %s button to open the map centered directly on Ancyra. Then, left-click-and-hold on the planet, and select %s from the menu that pops up. Alternatively, you can just right-click on Ancyra.", Misc.getHighlightColor(), "\"Show on map\"", "\"Lay in Course\"");
                this.options.clearOptions();
                this.options.addOption("Continue", (Object)OptionId.CONT2, null);
                break;
            }
            case CONT2: {
                String map = Global.getSettings().getControlStringForEnumName("CORE_MAP");
                this.textPanel.addPara("You could also press %s to open the map and locate Ancyra manually.", Misc.getHighlightColor(), map);
                this.textPanel.addParagraph("Once you get to Ancyra, open the comm directory to contact " + personName + ".");
                this.options.clearOptions();
                this.options.addOption("Finish", (Object)OptionId.CONT3, null);
                break;
            }
            case CONT3: {
                Global.getSector().setPaused(false);
                this.dialog.dismiss();
            }
        }
    }

    @Override
    public void optionMousedOver(String optionText, Object optionData) {
    }

    @Override
    public void advance(float amount) {
    }

    @Override
    public Object getContext() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OptionId {
        INIT,
        CONT1,
        CONT2,
        CONT3;

    }
}

