/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.tutorial;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.VisualPanelAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TutorialLevelUpDialogPluginImpl
implements InteractionDialogPlugin {
    protected InteractionDialogAPI dialog;
    protected TextPanelAPI textPanel;
    protected OptionPanelAPI options;
    protected VisualPanelAPI visual;
    protected CampaignFleetAPI playerFleet;

    @Override
    public void init(InteractionDialogAPI dialog) {
        this.dialog = dialog;
        this.textPanel = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        this.visual = dialog.getVisualPanel();
        this.playerFleet = Global.getSector().getPlayerFleet();
        this.visual.showFleetInfo("Your fleet", this.playerFleet, null, null);
        this.optionSelected(null, (Object)OptionId.INIT);
    }

    @Override
    public Map<String, MemoryAPI> getMemoryMap() {
        return null;
    }

    @Override
    public void backFromEngagement(EngagementResultAPI result) {
    }

    @Override
    public void optionSelected(String text, Object optionData) {
        if (optionData == null) {
            return;
        }
        OptionId option = (OptionId)((Object)optionData);
        if (text != null) {
            this.dialog.addOptionSelectedText((Object)option);
        }
        String control = Global.getSettings().getControlStringForEnumName("CORE_CHARACTER");
        switch (option) {
            case INIT: {
                this.textPanel.addParagraph("You've gained a level!");
                this.textPanel.addPara("You gain %s skill point with each level-up, and an additional point at the start of the campaign.", Misc.getHighlightColor(), "1");
                this.textPanel.addPara("You also gain " + Misc.STORY + " points as you gain experience; these can be used to " + "take exceptional actions - to \"make your own story\", in a way. The tutorial will introduce " + "using these a bit later.", Misc.getStoryOptionColor(), String.valueOf(Misc.STORY) + " points");
                this.options.clearOptions();
                this.options.addOption("Continue", (Object)OptionId.CONT1, null);
                break;
            }
            case CONT1: {
                this.textPanel.addParagraph("Skill points are used to learn skills. Skills are arranged in four aptitudes - Combat, Leadership, Technology, and Industry. Each aptitude has a number of tiers, you advance to the higher tiers by picking skills from the lower ones.");
                this.textPanel.addPara("Skills that affect your piloted ship - all Combat skills, and a few skills in other aptitudes - can be made \"elite\" at the cost of a " + Misc.STORY + " point.", Misc.getStoryOptionColor(), String.valueOf(Misc.STORY) + " point");
                String max = "" + Global.getSettings().getLevelupPlugin().getMaxLevel();
                this.textPanel.addPara("The maximum level you can reach is %s.", Misc.getHighlightColor(), max);
                this.options.clearOptions();
                this.options.addOption("Continue", (Object)OptionId.CONT3, null);
                break;
            }
            case CONT2: {
                break;
            }
            case CONT3: {
                this.textPanel.addPara("Press %s to open the character tab and consider your options. You don't have to actually spend the points now if you don't want to.", Misc.getHighlightColor(), control);
                this.options.clearOptions();
                this.options.addOption("Finish", (Object)OptionId.CONT4, null);
                break;
            }
            case CONT4: {
                Global.getSector().setPaused(false);
                this.dialog.dismiss();
            }
        }
    }

    @Override
    public void optionMousedOver(String optionText, Object optionData) {
    }

    @Override
    public void advance(float amount) {
    }

    @Override
    public Object getContext() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OptionId {
        INIT,
        CONT1,
        CONT2,
        CONT3,
        CONT4;

    }
}

