/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.tutorial;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.PersistentUIDataAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.VisualPanelAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.loading.AbilitySpecAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TutorialTransponderDialogPluginImpl
implements InteractionDialogPlugin {
    protected InteractionDialogAPI dialog;
    protected TextPanelAPI textPanel;
    protected OptionPanelAPI options;
    protected VisualPanelAPI visual;
    protected CampaignFleetAPI playerFleet;
    protected MarketAPI ancyra;

    public TutorialTransponderDialogPluginImpl(MarketAPI ancyra) {
        this.ancyra = ancyra;
    }

    @Override
    public void init(InteractionDialogAPI dialog) {
        this.dialog = dialog;
        this.textPanel = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        this.visual = dialog.getVisualPanel();
        this.playerFleet = Global.getSector().getPlayerFleet();
        this.visual.showFleetInfo("Your fleet", this.playerFleet, null, null);
        this.optionSelected(null, (Object)OptionId.INIT);
    }

    @Override
    public Map<String, MemoryAPI> getMemoryMap() {
        return null;
    }

    @Override
    public void backFromEngagement(EngagementResultAPI result) {
    }

    @Override
    public void optionSelected(String text, Object optionData) {
        if (optionData == null) {
            return;
        }
        OptionId option = (OptionId)((Object)optionData);
        if (text != null) {
            this.dialog.addOptionSelectedText((Object)option);
        }
        String name = this.ancyra.getName();
        switch (option) {
            case INIT: {
                this.textPanel.addParagraph("Your fleet is getting closer to " + name + ", which is controlled by the Hegemony - " + "a major militaristic faction in the Sector.");
                this.textPanel.addParagraph("While in Hegemony space, a fleet is required by law to identify itself by keeping its transponder turned on. This is a view shared by most, though not all, major factions.");
                this.options.clearOptions();
                this.options.addOption("Continue", (Object)OptionId.CONT1, null);
                break;
            }
            case CONT1: {
                this.textPanel.addParagraph("Turning on the transponder makes your fleet highly visible, and everyone seeing it will know who you are - unlike that pirate fleet you fought earlier, which had to be very close to positively identify.");
                this.options.clearOptions();
                this.options.addOption("Continue", (Object)OptionId.CONT2, null);
                break;
            }
            case CONT2: {
                this.textPanel.addParagraph("Keeping your transponder on is a crippling disadvantage in hostile space, but as we're getting closer to port and we'd like to dock there, it's a good idea to turn it on.");
                AbilitySpecAPI ability = Global.getSettings().getAbilitySpec("transponder");
                Global.getSector().getCharacterData().addAbility(ability.getId());
                PersistentUIDataAPI.AbilitySlotsAPI slots = Global.getSector().getUIData().getAbilitySlotsAPI();
                slots.setCurrBarIndex(0);
                int slotIndex = 0;
                slots.getCurrSlotsCopy().get(slotIndex).setAbilityId(ability.getId());
                AddRemoveCommodity.addAbilityGainText(ability.getId(), this.textPanel);
                this.options.clearOptions();
                this.options.addOption("Continue", (Object)OptionId.CONT3, null);
            }
            case CONT3: {
                AbilitySpecAPI ability = Global.getSettings().getAbilitySpec("transponder");
                this.textPanel.addPara("Activate the %s before getting closer to " + this.ancyra.getName() + ", both to " + "avoid unwanted attention from patrols and to receive docking clearance.", Misc.getHighlightColor(), "\"" + ability.getName() + "\"");
                this.textPanel.addPara("Since turning it on and off has major consequences, it requires a double-tap to turn on or off - once to prime, and once more to confirm.", Misc.getHighlightColor(), "double-tap");
                this.options.clearOptions();
                this.options.addOption("Finish", (Object)OptionId.CONT4, null);
                break;
            }
            case CONT4: {
                Global.getSector().setPaused(false);
                this.dialog.dismiss();
            }
        }
    }

    @Override
    public void optionMousedOver(String optionText, Object optionData) {
    }

    @Override
    public void advance(float amount) {
    }

    @Override
    public Object getContext() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OptionId {
        INIT,
        CONT1,
        CONT2,
        CONT3,
        CONT4,
        CONT5,
        CONT6;

    }
}

