/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.velfield;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TerrainAIFlags;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.fleet.FleetMemberViewAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.abilities.SustainedBurnAbility;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhost;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhostManager;
import com.fs.starfarer.api.impl.campaign.terrain.BaseTerrain;
import com.fs.starfarer.api.impl.campaign.terrain.HyperspaceTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.velfield.BoundingBox;
import com.fs.starfarer.api.impl.campaign.velfield.SlipstreamBuilder;
import com.fs.starfarer.api.loading.Description;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.FaderUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.MutatingVertexUtil;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlipstreamTerrainPlugin2
extends BaseTerrain {
    public static float FUEL_USE_MULT = 0.5f;
    public static String FUEL_USE_MODIFIER_DESC = "Inside slipstream";
    public static int MAX_PARTICLES_ADD_PER_FRAME = 250;
    public static float RAD_PER_DEG = (float)Math.PI / 180;
    protected SlipstreamParams2 params = new SlipstreamParams2();
    protected List<SlipstreamSegment> segments = new ArrayList<SlipstreamSegment>();
    protected float totalLength = 0.0f;
    protected transient List<Vector2f> encounterPoints = new ArrayList<Vector2f>();
    protected transient List<SlipstreamParticle> particles = new ArrayList<SlipstreamParticle>();
    protected transient int[] lengthToIndexMap;
    protected transient int lengthDivisor;
    protected boolean needsRecompute = true;
    protected transient List<BoundingBox> bounds = new ArrayList<BoundingBox>();
    protected int segmentsPerBox;
    protected float texProgress0 = 0.0f;
    protected float texProgress1 = 0.0f;
    protected float texProgress2 = 0.0f;
    protected float[] despawnNoise = null;
    protected float despawnDelay = 0.0f;
    protected float despawnDays = 0.0f;
    protected float despawnElapsed = 0.0f;
    protected float[] spawnNoise = null;
    protected float spawnDays = 0.0f;
    protected float spawnElapsed = 0.0f;
    protected boolean dynamic = false;
    protected transient SlipstreamBuilder builder = null;
    protected int playerWasInSlipstreamFramesAgo = 1000;
    protected float playerDesiredYOffset = 1000.0f;
    private transient EnumSet<CampaignEngineLayers> layers = EnumSet.of(CampaignEngineLayers.TERRAIN_7);

    public static Vector2f rotateAroundOrigin(Vector2f v, float cos, float sin) {
        Vector2f r = new Vector2f();
        r.x = v.x * cos - v.y * sin;
        r.y = v.x * sin + v.y * cos;
        return r;
    }

    public boolean isDespawning() {
        return this.entity.hasTag("fading_out_and_expiring") || this.despawnNoise != null;
    }

    public void spawn(float spawnDays, Random random) {
        this.spawnDays = spawnDays;
        this.spawnElapsed = 0.0f;
        int numNoisePoints = 32;
        while (numNoisePoints < this.segments.size()) {
            numNoisePoints = (int)((float)numNoisePoints * 2.0f);
        }
        if (numNoisePoints > 512) {
            numNoisePoints = 512;
        }
        float spikes = 0.67f;
        this.spawnNoise = SlipstreamBuilder.initNoise1D(random, numNoisePoints, spikes);
        this.spawnNoise[0] = 0.5f;
        this.spawnNoise[this.spawnNoise.length - 1] = 0.5f;
        SlipstreamBuilder.genNoise1D(random, this.spawnNoise, numNoisePoints, spikes);
        SlipstreamBuilder.normalizeNoise1D(this.spawnNoise);
    }

    protected void advanceSpawn(float amount) {
        if (this.spawnNoise == null) {
            return;
        }
        if (this.despawnElapsed > 0.0f || this.despawnDays > 0.0f) {
            return;
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        this.spawnElapsed += days;
        float f = this.spawnElapsed / Math.max(0.1f, this.spawnDays);
        float size = this.segments.size();
        boolean allFadedIn = true;
        for (SlipstreamSegment seg : this.segments) {
            allFadedIn &= seg.fader.isFadedIn();
            float t = (float)(seg.index + 1) / size;
            float noise = SlipstreamBuilder.getInterpNoise(this.spawnNoise, t);
            if (noise <= f || f >= 1.0f) {
                float dur = Math.max(1.0f, Global.getSector().getClock().convertToSeconds((this.spawnDays - this.spawnElapsed) / 2.0f));
                seg.fader.setDurationIn(dur);
                seg.fader.fadeIn();
                continue;
            }
            seg.fader.fadeOut();
        }
        if (allFadedIn) {
            this.spawnNoise = null;
            this.spawnElapsed = 0.0f;
            this.spawnDays = 0.0f;
        }
    }

    public void despawn(float despawnDelay, float despawnDays, Random random) {
        this.despawnDays = despawnDays;
        this.despawnDelay = despawnDelay;
        this.despawnElapsed = 0.0f;
        int numNoisePoints = 32;
        while (numNoisePoints < this.segments.size()) {
            numNoisePoints = (int)((float)numNoisePoints * 2.0f);
        }
        if (numNoisePoints > 512) {
            numNoisePoints = 512;
        }
        float spikes = 0.67f;
        this.despawnNoise = SlipstreamBuilder.initNoise1D(random, numNoisePoints, spikes);
        this.despawnNoise[0] = 0.5f;
        this.despawnNoise[this.despawnNoise.length - 1] = 0.5f;
        SlipstreamBuilder.genNoise1D(random, this.despawnNoise, numNoisePoints, spikes);
        SlipstreamBuilder.normalizeNoise1D(this.despawnNoise);
    }

    protected void advanceDespawn(float amount) {
        if (this.despawnNoise == null) {
            return;
        }
        if (this.entity.hasTag("fading_out_and_expiring")) {
            return;
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        this.despawnDelay -= days;
        if (this.despawnDelay > 0.0f) {
            return;
        }
        this.despawnElapsed += days;
        float f = this.despawnElapsed / Math.max(0.1f, this.despawnDays);
        float size = this.segments.size();
        boolean allFaded = true;
        for (SlipstreamSegment seg : this.segments) {
            allFaded &= seg.fader.isFadedOut();
            float t = (float)(seg.index + 1) / size;
            float noise = SlipstreamBuilder.getInterpNoise(this.despawnNoise, t);
            if (!(noise <= f) && !(f >= 1.0f)) continue;
            float dur = Math.max(1.0f, Global.getSector().getClock().convertToSeconds((this.despawnDays - this.despawnElapsed) / 2.0f));
            seg.fader.setDurationOut(dur);
            seg.fader.fadeOut();
        }
        if (allFaded) {
            Misc.fadeAndExpire(this.entity);
            this.despawnNoise = null;
        }
    }

    public void setNeedsRecompute() {
        this.needsRecompute = true;
    }

    public void updateLengthToIndexMap() {
        float minSegmentLength = Float.MAX_VALUE;
        for (SlipstreamSegment curr : this.segments) {
            if (!(curr.lengthToNext > 0.0f) || !(minSegmentLength > curr.lengthToNext)) continue;
            minSegmentLength = curr.lengthToNext;
        }
        if (minSegmentLength < 50.0f) {
            minSegmentLength = 50.0f;
        }
        this.lengthDivisor = (int)(minSegmentLength - 1.0f);
        int numIndices = (int)(this.totalLength / (float)this.lengthDivisor);
        this.lengthToIndexMap = new int[numIndices];
        int lengthSoFar = 0;
        int i = 0;
        while (i < this.segments.size()) {
            SlipstreamSegment curr = this.segments.get(i);
            while ((float)lengthSoFar < curr.totalLength + curr.lengthToNext) {
                int lengthIndex = lengthSoFar / this.lengthDivisor;
                if (lengthIndex < this.lengthToIndexMap.length) {
                    this.lengthToIndexMap[lengthIndex] = i;
                }
                lengthSoFar += this.lengthDivisor;
            }
            ++i;
        }
    }

    public SlipstreamSegment getSegmentForDist(float distAlongStream) {
        if (this.lengthToIndexMap == null) {
            return null;
        }
        int mapIndex = (int)(distAlongStream / (float)this.lengthDivisor);
        if (mapIndex < 0 || mapIndex >= this.lengthToIndexMap.length) {
            return null;
        }
        int segIndex = this.lengthToIndexMap[mapIndex];
        SlipstreamSegment segment = this.segments.get(segIndex);
        while (distAlongStream < segment.totalLength) {
            if (--segIndex < 0) {
                return null;
            }
            segment = this.segments.get(segIndex);
        }
        while (distAlongStream > segment.totalLength + segment.lengthToNext) {
            if (++segIndex >= this.segments.size()) {
                return null;
            }
            segment = this.segments.get(segIndex);
        }
        return segment;
    }

    public void addSegment(Vector2f loc, float width) {
        SlipstreamSegment s = new SlipstreamSegment();
        s.loc.set((ReadableVector2f)loc);
        s.width = width;
        s.wobbledWidth = width - this.params.edgeWidth * 2.0f * 0.25f;
        float minRadius = 0.0f;
        float maxRadius = s.width * 0.05f;
        float rate = maxRadius * 0.5f;
        float angleRate = 50.0f;
        s.wobble1 = new MutatingVertexUtil(minRadius, maxRadius, rate, angleRate);
        s.wobble2 = new MutatingVertexUtil(minRadius, maxRadius, rate, angleRate);
        s.fader.fadeIn();
        this.segments.add(s);
        this.setNeedsRecompute();
    }

    @Override
    public void init(String terrainId, SectorEntityToken entity, Object pluginParams) {
        super.init(terrainId, entity, pluginParams);
        this.params = (SlipstreamParams2)pluginParams;
        this.readResolve();
    }

    @Override
    public float getRenderRange() {
        return this.totalLength * 0.6f + 1000.0f;
    }

    Object readResolve() {
        this.particles = new ArrayList<SlipstreamParticle>();
        this.bounds = new ArrayList<BoundingBox>();
        this.needsRecompute = true;
        this.layers = EnumSet.of(CampaignEngineLayers.TERRAIN_SLIPSTREAM);
        return this;
    }

    @Override
    public void advance(float amount) {
        super.advance(amount);
        if (amount <= 0.0f) {
            return;
        }
        if (this.entity.isInCurrentLocation()) {
            this.applyEffectToEntities(amount);
            this.doSoundPlayback(amount);
        }
        this.recomputeIfNeeded();
        this.advanceNearbySegments(amount);
        this.addParticles();
        this.advanceParticles(amount);
        this.advanceSpawn(amount);
        this.advanceDespawn(amount);
        if (this.entity.isInCurrentLocation()) {
            float texSpeed = Misc.getSpeedForBurnLevel(Math.min((float)this.params.burnLevel * 0.5f, (float)this.params.maxBurnLevelForTextureScroll));
            SpriteAPI sprite = Global.getSettings().getSprite("misc", this.params.spriteKey1);
            float texelsPerPixel = 1.0f;
            if (this.segments.size() > 1) {
                texelsPerPixel = this.segments.get((int)1).tx * sprite.getWidth() / Math.max(1.0f, this.segments.get((int)1).lengthToPrev);
            }
            float unitsPerOneTexIter = sprite.getWidth();
            float texUnitsPerSecondForSpeed = texSpeed / unitsPerOneTexIter * texelsPerPixel;
            this.texProgress0 -= texUnitsPerSecondForSpeed * amount * this.params.texScrollMult0;
            this.texProgress1 += texUnitsPerSecondForSpeed * amount * this.params.texScrollMult1;
            this.texProgress2 += texUnitsPerSecondForSpeed * amount * this.params.texScrollMult2;
            if (this.texProgress0 > 100000.0f) {
                this.texProgress0 -= 100000.0f;
            }
            if (this.texProgress1 > 100000.0f) {
                this.texProgress1 -= 100000.0f;
            }
            if (this.texProgress2 > 100000.0f) {
                this.texProgress2 -= 100000.0f;
            }
        }
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public void recomputeIfNeeded() {
        if (!this.needsRecompute) {
            return;
        }
        this.recompute();
    }

    public void recompute() {
        this.needsRecompute = false;
        Vector2f avgLoc = new Vector2f();
        int i = 0;
        while (i < this.segments.size()) {
            SlipstreamSegment curr = this.segments.get(i);
            curr.index = i++;
            Vector2f.add((Vector2f)avgLoc, (Vector2f)curr.loc, (Vector2f)avgLoc);
        }
        if (this.segments.size() > 0) {
            avgLoc.scale(1.0f / (float)this.segments.size());
            this.entity.setLocation(avgLoc.x, avgLoc.y);
        }
        SpriteAPI sprite = Global.getSettings().getSprite("misc", this.params.spriteKey1);
        SpriteAPI edge = Global.getSettings().getSprite("misc", this.params.edgeKey);
        float tx = 0.0f;
        float txe1 = 0.0f;
        float txe2 = 0.0f;
        float totalLength = 0.0f;
        int i2 = 0;
        while (i2 < this.segments.size()) {
            Vector2f dir;
            SlipstreamSegment prev = null;
            if (i2 > 0) {
                prev = this.segments.get(i2 - 1);
            }
            SlipstreamSegment curr = this.segments.get(i2);
            SlipstreamSegment next = null;
            SlipstreamSegment next2 = null;
            SlipstreamSegment next3 = null;
            if (i2 < this.segments.size() - 1) {
                next = this.segments.get(i2 + 1);
            }
            if (i2 < this.segments.size() - 2) {
                next2 = this.segments.get(i2 + 2);
            }
            if (i2 < this.segments.size() - 3) {
                next3 = this.segments.get(i2 + 3);
            }
            if (curr.dir == null) {
                curr.dir = new Vector2f();
            }
            if (curr.normal == null) {
                curr.normal = new Vector2f();
            }
            if (next == null) {
                if (prev != null) {
                    curr.dir.set((ReadableVector2f)prev.dir);
                }
            } else {
                dir = Vector2f.sub((Vector2f)next.loc, (Vector2f)curr.loc, (Vector2f)new Vector2f());
                curr.dir = dir = Misc.normalise(dir);
            }
            dir = curr.dir;
            if (prev == null || next == null) {
                curr.normal.set(-dir.y, dir.x);
            } else {
                Vector2f avg = Vector2f.add((Vector2f)prev.dir, (Vector2f)curr.dir, (Vector2f)new Vector2f());
                avg.scale(0.5f);
                curr.normal.set(-avg.y, avg.x);
            }
            float length = 0.0f;
            float texLength = 0.0f;
            float e1TexLength = 0.0f;
            float e2TexLength = 0.0f;
            if (prev != null) {
                Vector2f dir2 = Vector2f.sub((Vector2f)curr.loc, (Vector2f)prev.loc, (Vector2f)new Vector2f());
                length = dir2.length();
                texLength = length / sprite.getWidth();
                if (!this.dynamic) {
                    texLength = Math.min(texLength, sprite.getHeight() / curr.width);
                }
                Vector2f edgeCurr = new Vector2f((ReadableVector2f)curr.loc);
                edgeCurr.x += curr.normal.x * curr.width * 0.5f;
                edgeCurr.y += curr.normal.y * curr.width * 0.5f;
                Vector2f edgePrev = new Vector2f((ReadableVector2f)prev.loc);
                edgePrev.x += prev.normal.x * prev.width * 0.5f;
                edgePrev.y += prev.normal.y * prev.width * 0.5f;
                float length2 = Vector2f.sub((Vector2f)edgeCurr, (Vector2f)edgePrev, (Vector2f)new Vector2f()).length();
                e1TexLength = length2 / edge.getWidth() * edge.getHeight() / this.params.edgeWidth;
                edgeCurr = new Vector2f((ReadableVector2f)curr.loc);
                edgeCurr.x -= curr.normal.x * curr.width * 0.5f;
                edgeCurr.y -= curr.normal.y * curr.width * 0.5f;
                edgePrev = new Vector2f((ReadableVector2f)prev.loc);
                edgePrev.x -= prev.normal.x * prev.width * 0.5f;
                edgePrev.y -= prev.normal.y * prev.width * 0.5f;
                length2 = Vector2f.sub((Vector2f)edgeCurr, (Vector2f)edgePrev, (Vector2f)new Vector2f()).length();
                e2TexLength = length2 / edge.getWidth() * edge.getHeight() / this.params.edgeWidth;
            }
            curr.tx = tx += texLength;
            curr.txe1 = txe1 += e1TexLength;
            curr.txe2 = txe2 += e2TexLength;
            curr.lengthToPrev = length;
            curr.totalLength = totalLength += length;
            if (prev != null) {
                prev.lengthToNext = length;
            }
            if (next != null && next2 != null && next3 != null) {
                Vector2f p0 = curr.loc;
                Vector2f p1 = next.loc;
                Vector2f p2 = next2.loc;
                Vector2f p3 = next3.loc;
                float p1ToP2 = Misc.getAngleInDegrees(p1, p2);
                float p2ToP3 = Misc.getAngleInDegrees(p2, p3);
                float diff = Misc.getAngleDiff(p1ToP2, p2ToP3);
                float adjustment = Math.min(diff, Math.max(diff * 0.25f, diff - 10.0f));
                adjustment = diff * 0.5f;
                float angle = p1ToP2 + Misc.getClosestTurnDirection(p1ToP2, p2ToP3) * adjustment * 1.0f + 180.0f;
                float dist = Misc.getDistance(p2, p1);
                Vector2f p1Adjusted = Misc.getUnitVectorAtDegreeAngle(angle);
                p1Adjusted.scale(dist);
                Vector2f.add((Vector2f)p1Adjusted, (Vector2f)p2, (Vector2f)p1Adjusted);
                next.locB = p1Adjusted;
            } else if (next != null) {
                next.locB = next.loc;
            }
            if (prev == null) {
                curr.locB = new Vector2f((ReadableVector2f)curr.loc);
            }
            ++i2;
        }
        this.totalLength = totalLength;
        this.updateLengthToIndexMap();
        this.updateBoundingBoxes();
    }

    protected void updateBoundingBoxes() {
        this.segmentsPerBox = (int)Math.sqrt(this.segments.size()) + 1;
        if (this.segmentsPerBox < 20) {
            this.segmentsPerBox = 20;
        }
        this.bounds.clear();
        int i = 0;
        while (i < this.segments.size()) {
            ArrayList<SlipstreamSegment> section = new ArrayList<SlipstreamSegment>();
            int j = i;
            while (j < i + this.segmentsPerBox && j < this.segments.size()) {
                section.add(this.segments.get(j));
                ++j;
            }
            if (i + this.segmentsPerBox < this.segments.size()) {
                section.add(this.segments.get(i + this.segmentsPerBox));
            }
            BoundingBox box = BoundingBox.create(section);
            this.bounds.add(box);
            i += this.segmentsPerBox;
        }
    }

    protected void advanceNearbySegments(float amount) {
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        if (pf == null || !this.entity.isInCurrentLocation()) {
            if (this.spawnNoise != null || this.despawnNoise != null) {
                int i = 0;
                while (i < this.segments.size()) {
                    SlipstreamSegment curr = this.segments.get(i);
                    curr.fader.advance(amount);
                    ++i;
                }
            }
            return;
        }
        ViewportAPI viewport = Global.getSector().getViewport();
        float viewRadius = new Vector2f(viewport.getVisibleWidth() * 0.5f, viewport.getVisibleHeight() * 0.5f).length();
        viewRadius = Math.max(6000.0f, viewRadius);
        List<SlipstreamSegment> near = this.getSegmentsNear(viewport.getCenter(), viewRadius += 1000.0f);
        int i = 0;
        while (i < this.segments.size()) {
            SlipstreamSegment curr = this.segments.get(i);
            curr.fader.advance(amount);
            ++i;
        }
        HyperspaceTerrainPlugin plugin = (HyperspaceTerrainPlugin)Misc.getHyperspaceTerrain().getPlugin();
        int i2 = 0;
        while (i2 < near.size()) {
            SlipstreamSegment curr = near.get(i2);
            if (this.entity.isInHyperspace() && !curr.fader.isFadedOut() && curr.fader.getBrightness() * curr.bMult > 0.05f && curr.bMult > 0.0f) {
                plugin.setTileState(curr.loc, curr.width * 0.5f + this.params.edgeWidth + 100.0f, HyperspaceTerrainPlugin.CellState.OFF, 1.0f - curr.fader.getBrightness(), -1.0f);
            }
            float r1 = 0.5f + (float)Math.random() * 1.0f;
            float r2 = 0.5f + (float)Math.random() * 1.0f;
            curr.wobble1.advance(amount * r1);
            curr.wobble2.advance(amount * r2);
            Vector2f p1 = new Vector2f((ReadableVector2f)curr.loc);
            Vector2f p2 = new Vector2f((ReadableVector2f)curr.loc);
            p1.x += curr.normal.x * curr.width * 0.5f;
            p1.y += curr.normal.y * curr.width * 0.5f;
            p2.x -= curr.normal.x * curr.width * 0.5f;
            p2.y -= curr.normal.y * curr.width * 0.5f;
            p1.x += curr.wobble1.vector.x;
            p1.y += curr.wobble1.vector.y;
            p2.x += curr.wobble2.vector.x;
            p2.y += curr.wobble2.vector.y;
            float d = Misc.getDistance(p1, p2);
            curr.wobbledWidth = d - this.params.edgeWidth * 2.0f * 0.25f;
            if (curr.wobbledWidth < d * 0.5f) {
                curr.wobbledWidth = d * 0.5f;
            }
            if (curr.index > 0) {
                SlipstreamSegment prev = this.segments.get(curr.index - 1);
                Vector2f prev1 = new Vector2f((ReadableVector2f)prev.loc);
                Vector2f prev2 = new Vector2f((ReadableVector2f)prev.loc);
                prev1.x += prev.normal.x * prev.width * 0.5f;
                prev1.y += prev.normal.y * prev.width * 0.5f;
                prev2.x -= prev.normal.x * prev.width * 0.5f;
                prev2.y -= prev.normal.y * prev.width * 0.5f;
                float wobbleMult = 0.33f;
                wobbleMult = 0.4f;
                float maxWobbleRadius = Math.min(prev.width, curr.width) * 0.05f;
                float maxWobble1 = Misc.getDistance(p1, prev1) * wobbleMult;
                float maxWobble2 = Misc.getDistance(p2, prev2) * wobbleMult;
                maxWobble1 = Math.min(maxWobbleRadius, maxWobble1);
                maxWobble2 = Math.min(maxWobbleRadius, maxWobble2);
                if (curr.index < this.segments.size() - 1) {
                    SlipstreamSegment next = this.segments.get(curr.index + 1);
                    Vector2f next1 = new Vector2f((ReadableVector2f)next.loc);
                    Vector2f next2 = new Vector2f((ReadableVector2f)next.loc);
                    next1.x += next.normal.x * next.width * 0.5f;
                    next1.y += next.normal.y * next.width * 0.5f;
                    next2.x -= next.normal.x * next.width * 0.5f;
                    next2.y -= next.normal.y * next.width * 0.5f;
                    maxWobbleRadius = Math.min(next.width, curr.width) * 0.05f;
                    float maxWobble1A = Misc.getDistance(p1, next1) * wobbleMult;
                    float maxWobble2A = Misc.getDistance(p2, next2) * wobbleMult;
                    maxWobble1 = Math.min(maxWobble1, maxWobble1A);
                    maxWobble2 = Math.min(maxWobble2, maxWobble2A);
                }
                prev.wobble1.radius.setMax(maxWobble1);
                prev.wobble2.radius.setMax(maxWobble2);
                curr.wobble1.radius.setMax(maxWobble1);
                curr.wobble2.radius.setMax(maxWobble2);
            }
            ++i2;
        }
    }

    public void addParticles() {
        if (Global.getSector().getPlayerFleet() == null) {
            this.particles.clear();
            return;
        }
        boolean useNewSpawnMethod = true;
        if (useNewSpawnMethod) {
            int particlesToAdd;
            int numParticlesBasedOnArea;
            boolean inCurrentLocation = this.entity.isInCurrentLocation();
            boolean inHyperspace = this.entity.isInHyperspace();
            boolean spawnForAllSegments = false;
            ViewportAPI viewport = Global.getSector().getViewport();
            Vector2f locFrom = viewport.getCenter();
            float viewRadius = new Vector2f(viewport.getVisibleWidth() * 0.5f, viewport.getVisibleHeight() * 0.5f).length();
            viewRadius += 2000.0f;
            viewRadius = Math.max(viewRadius, 10000.0f);
            if (!inCurrentLocation) {
                if (inHyperspace) {
                    viewRadius = 5000.0f;
                    locFrom = Global.getSector().getPlayerFleet().getLocationInHyperspace();
                } else {
                    float dist = Misc.getDistanceToPlayerLY(this.entity);
                    spawnForAllSegments = dist < 2.0f;
                }
            }
            LinkedHashSet<Object> veryNearSet = new LinkedHashSet();
            if (inCurrentLocation) {
                float veryNearRadius = new Vector2f(viewport.getVisibleWidth() * 0.5f, viewport.getVisibleHeight() * 0.5f).length();
                viewRadius += 500.0f;
                veryNearSet = new LinkedHashSet<SlipstreamSegment>(this.getSegmentsNear(viewport.getCenter(), veryNearRadius));
            }
            List<SlipstreamSegment> near = spawnForAllSegments ? new ArrayList<SlipstreamSegment>(this.segments) : this.getSegmentsNear(locFrom, viewRadius);
            LinkedHashSet<SlipstreamSegment> nearSet = new LinkedHashSet<SlipstreamSegment>(near);
            LinkedHashMap<SlipstreamSegment, ArrayList<SlipstreamParticle>> particleMap = new LinkedHashMap<SlipstreamSegment, ArrayList<SlipstreamParticle>>();
            Iterator<SlipstreamParticle> iter = this.particles.iterator();
            while (iter.hasNext()) {
                SlipstreamParticle p = iter.next();
                SlipstreamSegment seg = this.getSegmentForDist(p.dist);
                if (seg == null) continue;
                if (!nearSet.contains(seg)) {
                    iter.remove();
                    continue;
                }
                ArrayList<SlipstreamParticle> list = (ArrayList<SlipstreamParticle>)particleMap.get(seg);
                if (list == null) {
                    list = new ArrayList<SlipstreamParticle>();
                    particleMap.put(seg, list);
                }
                list.add(p);
            }
            float totalArea = 0.0f;
            int nearParticles = 0;
            WeightedRandomPicker<SlipstreamSegment> segmentPicker = new WeightedRandomPicker<SlipstreamSegment>();
            int i = 0;
            while (i < near.size()) {
                SlipstreamSegment curr = near.get(i);
                if (!(curr.lengthToNext <= 0.0f)) {
                    float area = curr.lengthToNext * curr.width;
                    float desiredParticles = area / this.params.areaPerParticle;
                    if (desiredParticles < 1.0f) {
                        desiredParticles = 1.0f;
                    }
                    float particlesInSegment = 0.0f;
                    List list = (List)particleMap.get(curr);
                    if (list != null) {
                        particlesInSegment = list.size();
                    }
                    float mult = 1.0f;
                    if (veryNearSet.contains(curr)) {
                        mult = 10.0f;
                    }
                    float w = desiredParticles - particlesInSegment;
                    if ((w *= mult) < 5.0f) {
                        w = 5.0f;
                    }
                    segmentPicker.add(curr, w);
                    totalArea += area;
                    nearParticles = (int)((float)nearParticles + particlesInSegment);
                }
                ++i;
            }
            int actualDesired = numParticlesBasedOnArea = (int)(totalArea / this.params.areaPerParticle);
            if (numParticlesBasedOnArea < 10) {
                numParticlesBasedOnArea = 10;
            }
            if (numParticlesBasedOnArea > this.params.maxParticles) {
                numParticlesBasedOnArea = this.params.maxParticles;
            }
            if ((particlesToAdd = numParticlesBasedOnArea - nearParticles) > MAX_PARTICLES_ADD_PER_FRAME) {
                particlesToAdd = MAX_PARTICLES_ADD_PER_FRAME;
            }
            particlesToAdd = Math.min(particlesToAdd, this.params.maxParticles - this.particles.size());
            int added = 0;
            while (added < particlesToAdd) {
                ++added;
                SlipstreamSegment seg = (SlipstreamSegment)segmentPicker.pick();
                if (seg == null) continue;
                SlipstreamParticle p = new SlipstreamParticle();
                float fLength = (float)Math.random() * 1.0f;
                float fWidth = (float)Math.random() * 2.0f - 1.0f;
                float speed = this.params.minSpeed + (this.params.maxSpeed - this.params.minSpeed) * (float)Math.random();
                float dur = this.params.minDur + (this.params.maxDur - this.params.minDur) * (float)Math.random();
                p.yPos = fWidth;
                p.dist = seg.totalLength + seg.lengthToNext * fLength;
                p.speed = speed;
                float intensity = this.getIntensity(p.yPos);
                float wMult = this.getWidthBasedSpeedMult(p.dist);
                float speedMult = (0.65f + 0.35f * intensity) * wMult;
                p.speed *= speedMult;
                p.remaining = dur;
                p.color = this.getRandomColor();
                this.particles.add(p);
            }
        } else {
            float totalArea = 0.0f;
            int i = 0;
            while (i < this.segments.size()) {
                SlipstreamSegment curr = this.segments.get(i);
                totalArea += curr.lengthToPrev * curr.width;
                ++i;
            }
            int numParticlesBasedOnArea = (int)(totalArea / this.params.areaPerParticle);
            if (numParticlesBasedOnArea < 10) {
                numParticlesBasedOnArea = 10;
            }
            if (numParticlesBasedOnArea > this.params.maxParticles) {
                numParticlesBasedOnArea = this.params.maxParticles;
            }
            int added = 0;
            while (this.particles.size() < numParticlesBasedOnArea && added < MAX_PARTICLES_ADD_PER_FRAME) {
                ++added;
                SlipstreamParticle p = new SlipstreamParticle();
                float fLength = (float)Math.random() * 1.0f;
                float fWidth = (float)Math.random() * 2.0f - 1.0f;
                float speed = this.params.minSpeed + (this.params.maxSpeed - this.params.minSpeed) * (float)Math.random();
                float dur = this.params.minDur + (this.params.maxDur - this.params.minDur) * (float)Math.random();
                p.yPos = fWidth;
                p.dist = this.totalLength * fLength;
                p.speed = speed;
                float intensity = this.getIntensity(p.yPos);
                float wMult = this.getWidthBasedSpeedMult(p.dist);
                float speedMult = (0.65f + 0.35f * intensity) * wMult;
                p.speed *= speedMult;
                p.remaining = dur;
                p.color = this.getRandomColor();
                this.particles.add(p);
            }
        }
    }

    public void advanceParticles(float amount) {
        Iterator<SlipstreamParticle> iter = this.particles.iterator();
        while (iter.hasNext()) {
            SlipstreamParticle p = iter.next();
            p.remaining -= amount;
            p.elapsed += amount;
            if (p.remaining <= 0.0f) {
                iter.remove();
                continue;
            }
            p.dist += p.speed * amount;
        }
    }

    public float getWidthBasedSpeedMult(float distAlong) {
        SlipstreamSegment curr;
        float mult = 1.0f;
        if (this.params.slowDownInWiderSections && (curr = this.getSegmentForDist(distAlong)) != null) {
            float width = curr.width;
            if (this.segments.size() > curr.index + 1) {
                SlipstreamSegment next = this.segments.get(curr.index + 1);
                float f = (distAlong - curr.totalLength) / curr.lengthToNext;
                if (f < 0.0f) {
                    f = 0.0f;
                }
                if (f > 1.0f) {
                    f = 1.0f;
                }
                width = Misc.interpolate(width, next.width, f);
                mult = Math.min(this.params.widthForMaxSpeedMaxMult, this.params.widthForMaxSpeedMinMult + (1.0f - this.params.widthForMaxSpeedMinMult) * this.params.widthForMaxSpeed / width);
            }
        }
        return mult;
    }

    public float getWidth(float distAlong) {
        SlipstreamSegment curr = this.getSegmentForDist(distAlong);
        if (curr != null) {
            float width = curr.width;
            if (this.segments.size() > curr.index + 1) {
                SlipstreamSegment next = this.segments.get(curr.index + 1);
                float f = (distAlong - curr.totalLength) / curr.lengthToNext;
                if (f < 0.0f) {
                    f = 0.0f;
                }
                if (f > 1.0f) {
                    f = 1.0f;
                }
                width = Misc.interpolate(width, next.width, f);
                return width;
            }
            return curr.width;
        }
        return 0.0f;
    }

    public float getWobbledWidth(float distAlong) {
        SlipstreamSegment curr = this.getSegmentForDist(distAlong);
        if (curr != null) {
            float width = curr.wobbledWidth;
            if (this.segments.size() > curr.index + 1) {
                SlipstreamSegment next = this.segments.get(curr.index + 1);
                float f = (distAlong - curr.totalLength) / curr.lengthToNext;
                if (f < 0.0f) {
                    f = 0.0f;
                }
                if (f > 1.0f) {
                    f = 1.0f;
                }
                width = Misc.interpolate(width, next.wobbledWidth, f);
                return width;
            }
            return curr.wobbledWidth;
        }
        return 0.0f;
    }

    public float getIntensity(float yOff) {
        yOff = Math.abs(yOff);
        float intensity = 1.0f;
        float dropoffAt = 0.5f;
        dropoffAt = 0.33f;
        if (yOff > dropoffAt) {
            intensity = 1.0f - 1.0f * (yOff - dropoffAt) / (1.0f - dropoffAt);
        }
        return intensity;
    }

    public float getFaderBrightness(float distAlong) {
        SlipstreamSegment curr = this.getSegmentForDist(distAlong);
        if (curr != null) {
            if (this.segments.size() > curr.index + 1) {
                SlipstreamSegment next = this.segments.get(curr.index + 1);
                float f = (distAlong - curr.totalLength) / curr.lengthToNext;
                if (f < 0.0f) {
                    f = 0.0f;
                }
                if (f > 1.0f) {
                    f = 1.0f;
                }
                return Misc.interpolate(curr.fader.getBrightness() * curr.bMult, next.fader.getBrightness() * next.bMult, f);
            }
            return 0.0f;
        }
        return 0.0f;
    }

    public SlipstreamBuilder getBuilder() {
        return this.builder;
    }

    public void setBuilder(SlipstreamBuilder builder) {
        this.builder = builder;
    }

    public SlipstreamParams2 getParams() {
        return this.params;
    }

    @Override
    public void render(CampaignEngineLayers layer, ViewportAPI viewport) {
        this.recomputeIfNeeded();
        if (this.lengthToIndexMap == null) {
            return;
        }
        float viewRadius = new Vector2f(viewport.getVisibleWidth() * 0.5f, viewport.getVisibleHeight() * 0.5f).length();
        List<SlipstreamSegment> near = this.getSegmentsNear(viewport.getCenter(), viewRadius += 500.0f);
        LinkedHashSet<SlipstreamSegment> nearSet = new LinkedHashSet<SlipstreamSegment>(near);
        ArrayList subsections = new ArrayList();
        int prevIndex = -10;
        ArrayList<SlipstreamSegment> subsection = new ArrayList<SlipstreamSegment>();
        for (SlipstreamSegment seg : near) {
            if (prevIndex != seg.index - 1) {
                if (subsection != null && !subsection.isEmpty()) {
                    subsections.add(subsection);
                }
                subsection = new ArrayList();
            }
            subsection.add(seg);
            prevIndex = seg.index;
        }
        if (subsection != null && !subsection.isEmpty()) {
            subsections.add(subsection);
        }
        SpriteAPI sprite0 = Global.getSettings().getSprite("misc", this.params.spriteKey1);
        sprite0.setNormalBlend();
        sprite0.setColor(this.params.spriteColor);
        SpriteAPI sprite1 = Global.getSettings().getSprite("misc", this.params.spriteKey2);
        sprite1.setNormalBlend();
        sprite1.setColor(this.params.spriteColor);
        SpriteAPI sprite2 = Global.getSettings().getSprite("misc", this.params.spriteKey3);
        sprite2.setNormalBlend();
        sprite2.setColor(this.params.spriteColor);
        SpriteAPI edge = Global.getSettings().getSprite("misc", this.params.edgeKey);
        edge.setNormalBlend();
        edge.setColor(this.params.edgeColor);
        for (List list : subsections) {
            this.renderSegments(sprite0, sprite1, sprite2, edge, viewport.getAlphaMult(), list, 0.0f, false);
        }
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        float f = Global.getSector().getViewport().getViewMult();
        GL11.glLineWidth((float)Math.max(1.0f, Math.min(2.0f, 2.0f / f)));
        GL11.glEnable((int)2848);
        Misc.setColor(new Color(1.0f, 1.0f, 1.0f, 0.5f));
        Misc.setColor(Color.white);
        float f2 = -1.0f;
        boolean curvedTrails = true;
        boolean useTex = false;
        boolean bl = useTex = !Global.getSettings().getBoolean("slipstreamUseGLLines");
        if (!useTex) {
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glLineWidth((float)Math.max(1.0f, Math.min(2.0f, 2.0f / f)));
            GL11.glEnable((int)2848);
            GL11.glHint((int)3154, (int)4354);
        }
        if (!curvedTrails) {
            GL11.glBegin((int)1);
        }
        if (useTex) {
            GL11.glEnable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)1);
            SpriteAPI line = Global.getSettings().getSprite("graphics/hud/line4x4.png");
            line.bindTexture();
        } else {
            GL11.glBlendFunc((int)770, (int)1);
        }
        for (SlipstreamParticle p : this.particles) {
            Vector2f end;
            Vector2f mid;
            SlipstreamSegment seg = this.getSegmentForDist(p.dist);
            if (seg == null || !nearSet.contains(seg)) continue;
            float a = viewport.getAlphaMult();
            if (p.remaining <= 0.5f) {
                a = p.remaining / 0.5f;
            } else if (p.elapsed < this.params.particleFadeInTime) {
                a = p.elapsed / this.params.particleFadeInTime;
            }
            a *= this.getFaderBrightness(p.dist);
            float yPos = p.yPos;
            if (curvedTrails) {
                Vector2f curr;
                if (useTex) {
                    GL11.glBegin((int)8);
                    curr = this.getPointAt(p.dist, yPos);
                    if (curr == null || !viewport.isNearViewport(curr, p.speed * this.params.lineLengthFractionOfSpeed + 50.0f)) {
                        GL11.glEnd();
                        continue;
                    }
                    float iter = 5.0f;
                    float incr = p.speed * this.params.lineLengthFractionOfSpeed / iter;
                    float lw = 1.0f;
                    float i = 0.0f;
                    while (i < iter) {
                        float min = incr * 1.0f;
                        float dist = p.dist - i * incr - min;
                        Vector2f next = this.getPointAt(dist, yPos);
                        if (next == null) break;
                        Vector2f perp = this.getNormalAt(dist);
                        if (perp == null) {
                            GL11.glEnd();
                            break;
                        }
                        float a1 = a * (iter - i) / (iter - 1.0f);
                        if (i == 0.0f) {
                            a1 = 0.0f;
                        }
                        Misc.setColor(p.color, a1);
                        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
                        GL11.glVertex2f((float)(curr.x + perp.x * lw), (float)(curr.y + perp.y * lw));
                        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
                        GL11.glVertex2f((float)(curr.x - perp.x * lw), (float)(curr.y - perp.y * lw));
                        curr = next;
                        i += 1.0f;
                    }
                    GL11.glEnd();
                    continue;
                }
                GL11.glBegin((int)3);
                curr = this.getPointAt(p.dist, yPos);
                if (curr == null || !viewport.isNearViewport(curr, p.speed * this.params.lineLengthFractionOfSpeed + 50.0f)) {
                    GL11.glEnd();
                    continue;
                }
                float iter = 5.0f;
                float incr = p.speed * this.params.lineLengthFractionOfSpeed / iter;
                float i = 0.0f;
                while (i < iter) {
                    float min = incr * 0.5f;
                    Vector2f next = this.getPointAt(p.dist - i * incr - min, yPos);
                    if (next == null) {
                        GL11.glEnd();
                        break;
                    }
                    float a1 = a * (iter - i) / (iter - 1.0f);
                    if (i == 0.0f) {
                        a1 = 0.0f;
                    }
                    Misc.setColor(p.color, a1);
                    GL11.glVertex2f((float)curr.x, (float)curr.y);
                    curr = next;
                    i += 1.0f;
                }
                GL11.glEnd();
                continue;
            }
            Vector2f start = this.getPointAt(p.dist + p.speed * this.params.lineLengthFractionOfSpeed * 0.1f, yPos);
            if (start == null || !viewport.isNearViewport(start, 500.0f) || (mid = this.getPointAt(p.dist, yPos)) == null || (end = this.getPointAt(p.dist - p.speed * this.params.lineLengthFractionOfSpeed * 0.9f, yPos)) == null) continue;
            Misc.setColor(p.color, 0.0f);
            GL11.glVertex2f((float)start.x, (float)start.y);
            Misc.setColor(p.color, a);
            GL11.glVertex2f((float)mid.x, (float)mid.y);
            GL11.glVertex2f((float)mid.x, (float)mid.y);
            Misc.setColor(p.color, 0.0f);
            GL11.glVertex2f((float)end.x, (float)end.y);
        }
        if (!curvedTrails) {
            GL11.glEnd();
        }
    }

    public void renderSegments(SpriteAPI sprite0, SpriteAPI sprite1, SpriteAPI sprite2, SpriteAPI edge, float alpha, List<SlipstreamSegment> segments, float extraTX, boolean forMap) {
        Vector2f p2;
        Vector2f p1;
        Vector2f p22;
        Vector2f p12;
        float a;
        SlipstreamSegment curr;
        boolean subtract;
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        boolean wireframe = false;
        if (wireframe) {
            GL11.glLineWidth((float)1.0f);
            GL11.glEnable((int)2848);
            GL11.glPolygonMode((int)1032, (int)6913);
            GL11.glDisable((int)3553);
            GL11.glDisable((int)3042);
            Misc.setColor(Color.yellow);
            GL11.glEnable((int)2848);
            GL11.glBegin((int)3);
            for (SlipstreamSegment curr2 : segments) {
                GL11.glVertex2f((float)curr2.loc.x, (float)curr2.loc.y);
            }
            GL11.glEnd();
        }
        if (subtract = false) {
            GL14.glBlendEquation((int)32779);
        }
        if (!wireframe) {
            GL11.glEnable((int)3553);
            GL11.glEnable((int)3042);
        }
        GL11.glBlendFunc((int)770, (int)771);
        if (!forMap) {
            extraTX = this.texProgress0;
        }
        sprite0.bindTexture();
        Color color = sprite0.getColor();
        GL11.glBegin((int)8);
        int i = 0;
        while (i < segments.size()) {
            curr = segments.get(i);
            a = curr.fader.getBrightness() * curr.bMult;
            if (i == 0 || i == segments.size() - 1) {
                a = 0.0f;
            }
            p12 = new Vector2f((ReadableVector2f)curr.loc);
            p12.x += curr.normal.x * curr.width * 0.5f;
            p12.y += curr.normal.y * curr.width * 0.5f;
            p22 = new Vector2f((ReadableVector2f)curr.loc);
            p22.x -= curr.normal.x * curr.width * 0.5f;
            p22.y -= curr.normal.y * curr.width * 0.5f;
            if (!forMap) {
                p12.x += curr.wobble1.vector.x;
                p12.y += curr.wobble1.vector.y;
                p22.x += curr.wobble2.vector.x;
                p22.y += curr.wobble2.vector.y;
            }
            Misc.setColor(color, alpha * 1.0f * a);
            GL11.glTexCoord2f((float)(curr.tx + extraTX), (float)0.0f);
            GL11.glVertex2f((float)p12.x, (float)p12.y);
            GL11.glTexCoord2f((float)(curr.tx + extraTX), (float)1.0f);
            GL11.glVertex2f((float)p22.x, (float)p22.y);
            ++i;
        }
        GL11.glEnd();
        if (!forMap) {
            sprite1.bindTexture();
            color = sprite1.getColor();
            GL11.glBegin((int)8);
            i = 0;
            while (i < segments.size()) {
                curr = segments.get(i);
                a = curr.fader.getBrightness() * curr.bMult;
                if (i == 0 || i == segments.size() - 1) {
                    a = 0.0f;
                }
                p12 = new Vector2f((ReadableVector2f)curr.loc);
                p12.x += curr.normal.x * curr.width * 0.5f;
                p12.y += curr.normal.y * curr.width * 0.5f;
                p22 = new Vector2f((ReadableVector2f)curr.loc);
                p22.x -= curr.normal.x * curr.width * 0.5f;
                p22.y -= curr.normal.y * curr.width * 0.5f;
                p12.x += curr.wobble1.vector.x;
                p12.y += curr.wobble1.vector.y;
                p22.x += curr.wobble2.vector.x;
                p22.y += curr.wobble2.vector.y;
                Misc.setColor(color, alpha * 1.0f * a);
                GL11.glTexCoord2f((float)(curr.tx + this.texProgress1), (float)0.0f);
                GL11.glVertex2f((float)p12.x, (float)p12.y);
                GL11.glTexCoord2f((float)(curr.tx + this.texProgress1), (float)1.0f);
                GL11.glVertex2f((float)p22.x, (float)p22.y);
                ++i;
            }
            GL11.glEnd();
            sprite2.bindTexture();
            color = sprite2.getColor();
            GL11.glBegin((int)8);
            i = 0;
            while (i < segments.size()) {
                curr = segments.get(i);
                a = curr.fader.getBrightness() * curr.bMult;
                if (i == 0 || i == segments.size() - 1) {
                    a = 0.0f;
                }
                p12 = new Vector2f((ReadableVector2f)curr.loc);
                p12.x += curr.normal.x * curr.width * 0.5f;
                p12.y += curr.normal.y * curr.width * 0.5f;
                p22 = new Vector2f((ReadableVector2f)curr.loc);
                p22.x -= curr.normal.x * curr.width * 0.5f;
                p22.y -= curr.normal.y * curr.width * 0.5f;
                p12.x += curr.wobble1.vector.x;
                p12.y += curr.wobble1.vector.y;
                p22.x += curr.wobble2.vector.x;
                p22.y += curr.wobble2.vector.y;
                Misc.setColor(color, alpha * 1.0f * a);
                GL11.glTexCoord2f((float)(curr.tx + this.texProgress2), (float)0.0f);
                GL11.glVertex2f((float)p12.x, (float)p12.y);
                GL11.glTexCoord2f((float)(curr.tx + this.texProgress2), (float)1.0f);
                GL11.glVertex2f((float)p22.x, (float)p22.y);
                ++i;
            }
            GL11.glEnd();
        }
        color = edge.getColor();
        float wobbleMult = 0.5f;
        edge.bindTexture();
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)8);
        int i2 = 0;
        while (i2 < segments.size()) {
            SlipstreamSegment curr3 = segments.get(i2);
            float a2 = curr3.fader.getBrightness() * curr3.bMult;
            if (i2 == 0 || i2 == segments.size() - 1) {
                a2 = 0.0f;
            }
            p1 = new Vector2f((ReadableVector2f)curr3.loc);
            p2 = new Vector2f((ReadableVector2f)curr3.loc);
            p1.x += curr3.normal.x * curr3.width * 0.5f;
            p1.y += curr3.normal.y * curr3.width * 0.5f;
            p2.x += curr3.normal.x * (curr3.width * 0.5f - this.params.edgeWidth);
            p2.y += curr3.normal.y * (curr3.width * 0.5f - this.params.edgeWidth);
            if (!forMap) {
                p1.x += curr3.wobble1.vector.x * wobbleMult;
                p1.y += curr3.wobble1.vector.y * wobbleMult;
                p2.x += curr3.wobble1.vector.x * wobbleMult;
                p2.y += curr3.wobble1.vector.y * wobbleMult;
            }
            Misc.setColor(color, alpha * 1.0f * a2);
            GL11.glTexCoord2f((float)curr3.txe1, (float)1.0f);
            GL11.glVertex2f((float)p1.x, (float)p1.y);
            GL11.glTexCoord2f((float)curr3.txe1, (float)0.0f);
            GL11.glVertex2f((float)p2.x, (float)p2.y);
            ++i2;
        }
        GL11.glEnd();
        GL11.glBegin((int)8);
        i2 = 0;
        while (i2 < segments.size()) {
            SlipstreamSegment curr4 = segments.get(i2);
            float a3 = curr4.fader.getBrightness() * curr4.bMult;
            if (i2 == 0 || i2 == segments.size() - 1) {
                a3 = 0.0f;
            }
            p1 = new Vector2f((ReadableVector2f)curr4.loc);
            p1.x -= curr4.normal.x * curr4.width * 0.5f;
            p1.y -= curr4.normal.y * curr4.width * 0.5f;
            p2 = new Vector2f((ReadableVector2f)curr4.loc);
            p2.x -= curr4.normal.x * (curr4.width * 0.5f - this.params.edgeWidth);
            p2.y -= curr4.normal.y * (curr4.width * 0.5f - this.params.edgeWidth);
            if (!forMap) {
                p1.x += curr4.wobble2.vector.x * wobbleMult;
                p1.y += curr4.wobble2.vector.y * wobbleMult;
                p2.x += curr4.wobble2.vector.x * wobbleMult;
                p2.y += curr4.wobble2.vector.y * wobbleMult;
            }
            Misc.setColor(color, alpha * 1.0f * a3);
            GL11.glTexCoord2f((float)curr4.txe2, (float)1.0f);
            GL11.glVertex2f((float)p1.x, (float)p1.y);
            GL11.glTexCoord2f((float)curr4.txe2, (float)0.0f);
            GL11.glVertex2f((float)p2.x, (float)p2.y);
            ++i2;
        }
        GL11.glEnd();
        if (subtract) {
            GL14.glBlendEquation((int)32774);
        }
        if (wireframe) {
            GL11.glPolygonMode((int)1032, (int)6914);
        }
    }

    public Color getRandomColor() {
        return Misc.interpolateColor(this.params.minColor, this.params.maxColor, (float)Math.random());
    }

    public float getTotalLength() {
        return this.totalLength;
    }

    public float[] getLengthAndWidthFractionWithinStream(Vector2f loc) {
        return this.getLengthAndWidthFractionWithinStream(loc, 0.0f, false, 0.0f);
    }

    public float[] getLengthAndWidthFractionWithinStream(Vector2f loc, float extraRangeForCheck, boolean allowOutsideStream, float extraWidthForSegments) {
        this.recomputeIfNeeded();
        float dist = Misc.getDistance(loc, this.entity.getLocation());
        if (dist > this.getRenderRange()) {
            return null;
        }
        List<SlipstreamSegment> near = this.getSegmentsNear(loc, extraRangeForCheck);
        for (SlipstreamSegment curr : near) {
            Vector2f nextNormalP;
            SlipstreamSegment next = null;
            if (this.segments.size() > curr.index + 1) {
                next = this.segments.get(curr.index + 1);
            } else {
                next = new SlipstreamSegment();
                next.wobbledWidth = curr.wobbledWidth;
                next.normal = curr.normal;
                next.loc = new Vector2f((ReadableVector2f)curr.dir);
                next.loc.scale(curr.lengthToPrev);
                Vector2f.add((Vector2f)next.loc, (Vector2f)curr.loc, (Vector2f)next.loc);
                next.lengthToPrev = curr.lengthToPrev;
            }
            Vector2f p3 = loc;
            Vector2f p1 = curr.loc;
            Vector2f p2 = next.loc;
            Vector2f currNormalP1 = new Vector2f((ReadableVector2f)curr.loc);
            Vector2f currNormalP2 = new Vector2f((ReadableVector2f)curr.normal);
            currNormalP2.scale(100.0f);
            Vector2f.add((Vector2f)currNormalP2, (Vector2f)currNormalP1, (Vector2f)currNormalP2);
            Vector2f nextNormalP1 = new Vector2f((ReadableVector2f)next.loc);
            Vector2f nextNormalP2 = new Vector2f((ReadableVector2f)next.normal);
            nextNormalP2.scale(100.0f);
            Vector2f.add((Vector2f)nextNormalP2, (Vector2f)nextNormalP1, (Vector2f)nextNormalP2);
            Vector2f dir = new Vector2f((ReadableVector2f)curr.dir);
            dir.scale(100.0f);
            Vector2f p4 = Vector2f.add((Vector2f)p3, (Vector2f)dir, (Vector2f)new Vector2f());
            Vector2f currNormalP = Misc.intersectLines(currNormalP1, currNormalP2, p3, p4);
            if (currNormalP == null || (nextNormalP = Misc.intersectLines(nextNormalP1, nextNormalP2, p3, p4)) == null) continue;
            float u = (p3.x - currNormalP.x) * (nextNormalP.x - currNormalP.x) + (p3.y - currNormalP.y) * (nextNormalP.y - currNormalP.y);
            float denom = Vector2f.sub((Vector2f)nextNormalP, (Vector2f)currNormalP, (Vector2f)new Vector2f()).length();
            if ((denom *= denom) == 0.0f || !((u /= denom) >= 0.0f) || !(u <= 1.0f)) continue;
            Vector2f normalAtP3 = Misc.interpolateVector(curr.normal, next.normal, u);
            normalAtP3.scale(100.0f);
            Vector2f p3PlusNormal = Vector2f.add((Vector2f)p3, (Vector2f)normalAtP3, (Vector2f)new Vector2f());
            Vector2f intersect = Misc.intersectLines(p1, p2, p3, p3PlusNormal);
            if (intersect == null) continue;
            float distFromLine = Vector2f.sub((Vector2f)intersect, (Vector2f)p3, (Vector2f)new Vector2f()).length();
            float width = Misc.interpolate(curr.wobbledWidth, next.wobbledWidth, u);
            if (distFromLine >= (width += extraWidthForSegments) / 2.0f && !allowOutsideStream) {
                return null;
            }
            float[] result = new float[]{curr.totalLength + u * next.lengthToPrev, distFromLine / (width / 2.0f)};
            float currToLoc = Misc.getAngleInDegrees(p1, p3);
            float segDir = Misc.getAngleInDegrees(p1, p2);
            if (Misc.getClosestTurnDirection(segDir, currToLoc) < 0.0f) {
                result[1] = -result[1];
            }
            return result;
        }
        return null;
    }

    public void applyEffectToEntities(float amount) {
        if (this.entity.getContainingLocation() == null) {
            return;
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        for (CampaignFleetAPI campaignFleetAPI : this.entity.getContainingLocation().getFleets()) {
            if (this.isPreventedFromAffecting(campaignFleetAPI)) continue;
            this.applyEffect(campaignFleetAPI, days);
        }
        for (SectorEntityToken sectorEntityToken : this.entity.getContainingLocation().getCustomEntities()) {
            if (sectorEntityToken.hasTag("ghost")) {
                if (this.isPreventedFromAffecting(sectorEntityToken)) continue;
                this.applyEffectToGhost(sectorEntityToken, days);
                continue;
            }
            if (!"wreck".equals(sectorEntityToken.getCustomEntityType()) || this.isPreventedFromAffecting(sectorEntityToken)) continue;
            this.applyEffectToWreck(sectorEntityToken, days);
        }
    }

    protected void playerNoLongerinSlipstream() {
        ++this.playerWasInSlipstreamFramesAgo;
        if (this.playerWasInSlipstreamFramesAgo > 1000) {
            this.playerWasInSlipstreamFramesAgo = 1000;
        }
        this.playerDesiredYOffset = 1000.0f;
    }

    @Override
    public void applyEffect(SectorEntityToken other, float days) {
        if (other.hasTag("unaffected_by_slipstream")) {
            return;
        }
        if (!this.containsPoint(other.getLocation(), 0.0f)) {
            if (other.isPlayerFleet()) {
                this.playerNoLongerinSlipstream();
            }
            return;
        }
        if (other instanceof CampaignFleetAPI) {
            float fleetSpeedAlongWind;
            boolean fleetTryingToMove;
            CampaignFleetAPI fleet = (CampaignFleetAPI)other;
            float[] offset = this.getLengthAndWidthFractionWithinStream(fleet.getLocation());
            if (offset == null) {
                if (fleet.isPlayerFleet()) {
                    this.playerNoLongerinSlipstream();
                }
                return;
            }
            float distAlong = offset[0];
            float yOff = offset[1];
            float intensity = this.getIntensity(yOff);
            float wMult = this.getWidthBasedSpeedMult(distAlong);
            intensity *= wMult;
            if ((intensity *= this.getFaderBrightness(distAlong)) <= 0.05f) {
                if (fleet.isPlayerFleet()) {
                    this.playerNoLongerinSlipstream();
                }
                return;
            }
            this.preventOtherTerrainFromAffecting(fleet);
            fleet.getMemoryWithoutUpdate().set(SustainedBurnAbility.SB_NO_STOP, true, 0.1f);
            fleet.getMemoryWithoutUpdate().set(SustainedBurnAbility.SB_NO_SLOW, true, 0.1f);
            if (fleet.isPlayerFleet()) {
                if (this.playerWasInSlipstreamFramesAgo > 5) {
                    fleet.addFloatingText("Entering slipstream", Misc.setAlpha(fleet.getIndicatorColor(), 255), 0.5f);
                }
                this.playerWasInSlipstreamFramesAgo = 0;
            }
            float maxFleetBurn = fleet.getFleetData().getBurnLevel();
            float currFleetBurn = fleet.getCurrBurnLevel();
            float maxWindBurn = (float)this.params.burnLevel * 2.0f;
            float currWindBurn = intensity * maxWindBurn;
            float maxFleetBurnIntoWind = maxFleetBurn - Math.abs(currWindBurn);
            float seconds = days * Global.getSector().getClock().getSecondsPerDay();
            Vector2f p1 = this.getPointAt(distAlong, yOff);
            Vector2f p2 = this.getPointAt(distAlong + 1.0f, yOff);
            if (p1 == null || p2 == null) {
                if (fleet.isPlayerFleet()) {
                    this.playerNoLongerinSlipstream();
                }
                return;
            }
            Vector2f windDir = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(p1, p2));
            if (currWindBurn < 0.0f) {
                windDir.negate();
            }
            Vector2f velDir = Misc.normalise(new Vector2f((ReadableVector2f)fleet.getVelocity()));
            float baseFleetAccel = fleet.getTravelSpeed();
            if (baseFleetAccel < 10.0f) {
                baseFleetAccel = 10.0f;
            }
            boolean bl = fleetTryingToMove = fleet.getMoveDestination() != null && Misc.getDistance(fleet.getLocation(), fleet.getMoveDestination()) > fleet.getRadius() + 10.0f;
            if (fleet.isPlayerFleet()) {
                boolean bl2 = Global.getSector().getCampaignUI().isPlayerFleetFollowingMouse() || fleet.wasSlowMoving();
                String key = "$slipstream_moveToYOffset";
                if ((fleetTryingToMove &= bl2) && fleet.getMoveDestination() != null) {
                    float wmy;
                    float mx = Mouse.getX();
                    float my = Mouse.getY();
                    float wmx = Global.getSector().getViewport().convertScreenXToWorldX(mx);
                    float[] desired = this.getLengthAndWidthFractionWithinStream(new Vector2f(wmx, wmy = Global.getSector().getViewport().convertScreenYToWorldY(my)));
                    if (desired != null) {
                        this.playerDesiredYOffset = desired[1];
                        fleet.getMemoryWithoutUpdate().set(key, true, 0.2f);
                    } else {
                        this.playerDesiredYOffset = 1000.0f;
                    }
                }
                if (!fleet.getMemoryWithoutUpdate().getBoolean(key)) {
                    this.playerDesiredYOffset = 1000.0f;
                }
            }
            float windSpeedReduction = 0.0f;
            if (!fleetTryingToMove) {
                Vector2f dest = new Vector2f((ReadableVector2f)windDir);
                dest.scale(1000.0f);
                if (this.playerDesiredYOffset <= 1.0f && this.playerDesiredYOffset >= -1.0f) {
                    float currOffset = offset[1];
                    float diff = this.playerDesiredYOffset - currOffset;
                    float sign = Math.signum(diff);
                    float mult = Math.min(Math.abs(diff) * 1.0f, 1.0f);
                    dest = Misc.rotateAroundOrigin(dest, Math.min(60.0f, 60.0f * mult * 1.0f) * sign);
                }
                Vector2f.add((Vector2f)dest, (Vector2f)fleet.getLocation(), (Vector2f)dest);
                fleet.setMoveDestination(dest.x, dest.y);
            } else {
                Vector2f moveDir = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(fleet.getLocation(), fleet.getMoveDestination()));
                float dot = Vector2f.dot((Vector2f)windDir, (Vector2f)moveDir);
                if (fleet.wasSlowMoving()) {
                    dot = -1.0f;
                }
                if (dot < 0.0f) {
                    float accelBasedMult = fleet.getAcceleration() / baseFleetAccel;
                    if ((accelBasedMult *= accelBasedMult) > 1.0f) {
                        accelBasedMult = 1.0f;
                    }
                    if (accelBasedMult < 0.1f) {
                        accelBasedMult = 0.1f;
                    }
                    windSpeedReduction = -dot * fleet.getFleetData().getBurnLevel() * accelBasedMult;
                }
            }
            float burnBonus = fleet.getFleetData().getBurnLevel() - fleet.getFleetData().getMinBurnLevel();
            if (burnBonus < 0.0f) {
                burnBonus = 0.0f;
            }
            float maxSpeedWithWind = Misc.getSpeedForBurnLevel((float)this.params.burnLevel * intensity + burnBonus);
            if (windSpeedReduction > 0.0f) {
                maxSpeedWithWind = Misc.getSpeedForBurnLevel(Math.max((float)this.params.burnLevel * 0.5f * intensity, (float)this.params.burnLevel * intensity - windSpeedReduction));
            }
            if ((fleetSpeedAlongWind = Vector2f.dot((Vector2f)windDir, (Vector2f)fleet.getVelocity())) >= maxSpeedWithWind) {
                return;
            }
            velDir.scale(currFleetBurn);
            float windSpeed = Misc.getSpeedForBurnLevel(currWindBurn);
            Vector2f windVector = new Vector2f((ReadableVector2f)windDir);
            windVector.scale(windSpeed);
            Vector2f vel = fleet.getVelocity();
            float accelMult = 0.5f + 2.0f * intensity;
            windDir.scale(seconds * baseFleetAccel * (accelMult += 5.0f * intensity));
            fleet.setVelocity(vel.x + windDir.x, vel.y + windDir.y);
            fleet.getStats().addTemporaryModMult(0.1f, String.valueOf(this.getModId()) + "_1", FUEL_USE_MODIFIER_DESC, FUEL_USE_MULT, fleet.getStats().getDynamic().getStat("fuel_use_not_shown_on_map_mult"));
            boolean withGlow = true;
            if (withGlow) {
                Color glowColor = this.params.windGlowColor;
                int alpha = glowColor.getAlpha();
                if (alpha < 75) {
                    glowColor = Misc.setAlpha(glowColor, 75);
                }
                p1 = this.getNoWobblePointAt(distAlong, yOff);
                p2 = this.getNoWobblePointAt(distAlong + 100.0f, yOff);
                if (p1 != null && p2 != null) {
                    windDir = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(p1, p2));
                    String modId = "slipstream_" + this.entity.getId();
                    float durIn = 1.0f;
                    float durOut = 3.0f;
                    float sizeNormal = 5.0f + 10.0f * intensity;
                    for (FleetMemberViewAPI view : fleet.getViews()) {
                        view.getWindEffectDirX().shift(modId, windDir.x * sizeNormal, durIn, durOut, 1.0f);
                        view.getWindEffectDirY().shift(modId, windDir.y * sizeNormal, durIn, durOut, 1.0f);
                        view.getWindEffectColor().shift(modId, glowColor, durIn, durOut, 1.0f);
                    }
                }
            }
        }
    }

    public void applyEffectToGhost(SectorEntityToken other, float days) {
        SensorGhost ghost = SensorGhostManager.getGhostFor(other);
        if (ghost == null) {
            return;
        }
        if (other.hasTag("unaffected_by_slipstream")) {
            return;
        }
        if (!this.containsPoint(other.getLocation(), 0.0f)) {
            return;
        }
        float[] offset = this.getLengthAndWidthFractionWithinStream(other.getLocation());
        if (offset == null) {
            return;
        }
        float distAlong = offset[0];
        float yOff = offset[1];
        float intensity = this.getIntensity(yOff);
        float wMult = this.getWidthBasedSpeedMult(distAlong);
        intensity *= wMult;
        if ((intensity *= this.getFaderBrightness(distAlong)) <= 0.0f) {
            return;
        }
        float maxFleetBurn = ghost.getMaxBurn();
        float currFleetBurn = ghost.getCurrBurn();
        float maxWindBurn = (float)this.params.burnLevel * 2.0f;
        float currWindBurn = intensity * maxWindBurn;
        float maxFleetBurnIntoWind = maxFleetBurn - Math.abs(currWindBurn);
        float seconds = days * Global.getSector().getClock().getSecondsPerDay();
        Vector2f p1 = this.getPointAt(distAlong, yOff);
        Vector2f p2 = this.getPointAt(distAlong + 1.0f, yOff);
        if (p1 == null || p2 == null) {
            return;
        }
        Vector2f windDir = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(p1, p2));
        if (currWindBurn < 0.0f) {
            windDir.negate();
        }
        Vector2f velDir = Misc.normalise(new Vector2f((ReadableVector2f)other.getVelocity()));
        float baseFleetAccel = ghost.getAcceleration();
        if (baseFleetAccel < 10.0f) {
            baseFleetAccel = 10.0f;
        }
        velDir.scale(currFleetBurn);
        float fleetBurnAgainstWind = -1.0f * Vector2f.dot((Vector2f)windDir, (Vector2f)velDir);
        float windSpeed = Misc.getSpeedForBurnLevel(currWindBurn);
        Vector2f windVector = new Vector2f((ReadableVector2f)windDir);
        windVector.scale(windSpeed);
        Vector2f vel = other.getVelocity();
        Vector2f diff = Vector2f.sub((Vector2f)windVector, (Vector2f)vel, (Vector2f)new Vector2f());
        float max = diff.length();
        diff = Misc.normalise(diff);
        diff.scale(ghost.getAcceleration() * 3.0f * seconds);
        if (diff.length() > max) {
            diff.scale(max / diff.length());
        }
        float accelMult = 0.5f + 2.0f * intensity;
        if (fleetBurnAgainstWind > maxFleetBurnIntoWind) {
            accelMult += 0.25f * (fleetBurnAgainstWind - maxFleetBurnIntoWind);
        }
        windDir.scale(seconds * baseFleetAccel * accelMult);
        ghost.getMovement().getVelocity().set(vel.x + windDir.x, vel.y + windDir.y);
    }

    public void applyEffectToWreck(SectorEntityToken other, float days) {
        if (other.hasTag("unaffected_by_slipstream")) {
            return;
        }
        if (!this.containsPoint(other.getLocation(), 0.0f)) {
            return;
        }
        float[] offset = this.getLengthAndWidthFractionWithinStream(other.getLocation());
        if (offset == null) {
            return;
        }
        float distAlong = offset[0];
        float yOff = offset[1];
        float intensity = this.getIntensity(yOff);
        float wMult = this.getWidthBasedSpeedMult(distAlong);
        intensity *= wMult;
        if ((intensity *= this.getFaderBrightness(distAlong)) <= 0.0f) {
            return;
        }
        float maxWindBurn = (float)this.params.burnLevel * 0.5f;
        float currWindBurn = intensity * maxWindBurn;
        Vector2f p1 = this.getPointAt(distAlong, yOff);
        Vector2f p2 = this.getPointAt(distAlong + 1.0f, yOff);
        if (p1 == null || p2 == null) {
            return;
        }
        Vector2f windDir = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(p1, p2));
        if (currWindBurn < 0.0f) {
            windDir.negate();
        }
        float windSpeed = Misc.getSpeedForBurnLevel(currWindBurn);
        Vector2f windVector = new Vector2f((ReadableVector2f)windDir);
        windVector.scale(windSpeed);
        Vector2f vel = other.getVelocity();
        float f = 0.95f;
        other.getVelocity().set(vel.x * f + windVector.x * (1.0f - f), vel.y * f + windVector.y * (1.0f - f));
    }

    public Vector2f getPointAt(float lengthAlongStream, float offset) {
        this.recomputeIfNeeded();
        SlipstreamSegment curr = this.getSegmentForDist(lengthAlongStream);
        if (curr == null) {
            return null;
        }
        int index = curr.index;
        SlipstreamSegment next = null;
        SlipstreamSegment next2 = null;
        if (index >= this.segments.size() - 1) {
            return null;
        }
        if (index % 2 == 0) {
            next = this.segments.get(index + 1);
            if (index >= this.segments.size() - 2) {
                next2 = new SlipstreamSegment();
                next2.wobbledWidth = next.wobbledWidth;
                next2.normal = next.normal;
                next2.loc = new Vector2f((ReadableVector2f)next.dir);
                next2.loc.scale(next.lengthToPrev);
                Vector2f.add((Vector2f)next2.loc, (Vector2f)next.loc, (Vector2f)next2.loc);
                next2.lengthToPrev = next.lengthToPrev;
            } else {
                next2 = this.segments.get(index + 2);
            }
        }
        if (index % 2 != 0) {
            if (index >= this.segments.size() - 1) {
                return null;
            }
            curr = this.segments.get(index - 1);
            next = this.segments.get(index);
            next2 = this.segments.get(index + 1);
        }
        float lenForT = lengthAlongStream - curr.totalLength;
        float t = lenForT / (curr.lengthToNext + next2.lengthToPrev);
        Vector2f p0 = new Vector2f((ReadableVector2f)curr.loc);
        Vector2f p1 = new Vector2f((ReadableVector2f)next.locB);
        Vector2f p2 = new Vector2f((ReadableVector2f)next2.loc);
        p0.x += curr.normal.x * curr.wobbledWidth * 0.5f * offset;
        p0.y += curr.normal.y * curr.wobbledWidth * 0.5f * offset;
        p2.x += next2.normal.x * next2.wobbledWidth * 0.5f * offset;
        p2.y += next2.normal.y * next2.wobbledWidth * 0.5f * offset;
        p1.x += next.normal.x * next.wobbledWidth * 0.5f * offset;
        p1.y += next.normal.y * next.wobbledWidth * 0.5f * offset;
        Vector2f p = Misc.bezier(p0, p1, p2, t);
        return p;
    }

    public Vector2f getNoWobblePointAt(float lengthAlongStream, float offset) {
        SlipstreamSegment curr = this.getSegmentForDist(lengthAlongStream);
        if (curr == null) {
            return null;
        }
        int index = curr.index;
        if (index >= this.segments.size() - 2) {
            return null;
        }
        SlipstreamSegment next = this.segments.get(index + 1);
        SlipstreamSegment next2 = this.segments.get(index + 2);
        if (index % 2 != 0) {
            curr = this.segments.get(index - 1);
            next = this.segments.get(index);
            next2 = this.segments.get(index + 1);
        }
        float lenForT = lengthAlongStream - curr.totalLength;
        float t = lenForT / (curr.lengthToNext + next.lengthToNext);
        Vector2f p0 = new Vector2f((ReadableVector2f)curr.loc);
        Vector2f p1 = new Vector2f((ReadableVector2f)next.locB);
        Vector2f p2 = new Vector2f((ReadableVector2f)next2.loc);
        float edges = this.params.edgeWidth * 2.0f * 0.5f;
        p0.x += curr.normal.x * (curr.width - edges) * 0.5f * offset;
        p0.y += curr.normal.y * (curr.width - edges) * 0.5f * offset;
        p2.x += next2.normal.x * (next2.width - edges) * 0.5f * offset;
        p2.y += next2.normal.y * (next2.width - edges) * 0.5f * offset;
        p1.x += next.normal.x * (next.width - edges) * 0.5f * offset;
        p1.y += next.normal.y * (next.width - edges) * 0.5f * offset;
        Vector2f p = Misc.bezier(p0, p1, p2, t);
        return p;
    }

    public Vector2f getNormalAt(float lengthAlongStream) {
        Vector2f perp;
        float lenForT;
        float f;
        SlipstreamSegment curr = this.getSegmentForDist(lengthAlongStream);
        if (curr == null) {
            return null;
        }
        int index = curr.index;
        if (index >= this.segments.size() - 2) {
            return null;
        }
        SlipstreamSegment next = this.segments.get(index + 1);
        SlipstreamSegment next2 = this.segments.get(index + 2);
        if (index % 2 != 0) {
            curr = this.segments.get(index - 1);
            next = this.segments.get(index);
            next2 = this.segments.get(index + 1);
        }
        if ((f = (lenForT = lengthAlongStream - curr.totalLength) / curr.lengthToNext) < 1.0f) {
            perp = Misc.interpolateVector(curr.normal, next.normal, f);
        } else {
            f = (lenForT - curr.lengthToNext) / next.lengthToNext;
            perp = Misc.interpolateVector(next.normal, next2.normal, f);
        }
        return perp;
    }

    public List<SlipstreamSegment> getSegmentsNear(Vector2f loc, float range) {
        ArrayList<SlipstreamSegment> result = new ArrayList<SlipstreamSegment>();
        int boxIndex = 0;
        for (BoundingBox box : this.bounds) {
            if (box.pointNeedsDetailedCheck(loc, range)) {
                int min;
                int i = min = boxIndex * this.segmentsPerBox;
                while (i < min + this.segmentsPerBox && i < this.segments.size()) {
                    float r;
                    SlipstreamSegment curr = this.segments.get(i);
                    float distSq = Misc.getDistanceSq(curr.loc, loc);
                    if (distSq < (r = range + curr.width + Math.max(curr.lengthToPrev, curr.lengthToNext)) * r) {
                        result.add(curr);
                    }
                    ++i;
                }
            }
            ++boxIndex;
        }
        return result;
    }

    @Override
    protected boolean shouldCheckFleetsToApplyEffect() {
        return false;
    }

    @Override
    public boolean hasAIFlag(Object flag) {
        return flag == TerrainAIFlags.BREAK_OTHER_ORBITS || flag == TerrainAIFlags.MOVES_FLEETS;
    }

    @Override
    public boolean containsEntity(SectorEntityToken other) {
        if (other.getContainingLocation() != this.entity.getContainingLocation()) {
            return false;
        }
        return other != null && this.containsPoint(other.getLocation(), 0.0f) && !this.isPreventedFromAffecting(other);
    }

    @Override
    public boolean containsPoint(Vector2f point, float radius) {
        boolean doDetailedCheck = false;
        for (BoundingBox box : this.bounds) {
            doDetailedCheck |= box.pointNeedsDetailedCheck(point, radius);
        }
        if (!doDetailedCheck) {
            return false;
        }
        float[] coords = this.getLengthAndWidthFractionWithinStream(point, 0.0f, false, radius);
        if (coords == null) {
            return false;
        }
        float b = this.getFaderBrightness(coords[0]);
        return b > 0.0f;
    }

    public List<BoundingBox> getBounds() {
        return this.bounds;
    }

    @Override
    public EnumSet<CampaignEngineLayers> getActiveLayers() {
        return this.layers;
    }

    @Override
    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        float opad = 10.0f;
        tooltip.addTitle(this.getNameForTooltip());
        tooltip.addPara(Global.getSettings().getDescription(this.getTerrainId(), Description.Type.TERRAIN).getText1(), opad);
        tooltip.addPara("Most slipstreams are temporary, and in recent memory their ebb and flow has been unusually synchronized with the standard Domain cycle.", opad);
        tooltip.addPara("Fleets traveling inside a slipstream use %s less fuel for the distance covered.", opad, Misc.getHighlightColor(), Math.round((1.0f - FUEL_USE_MULT) * 100.0f) + "%");
        tooltip.addPara("In addition, traveling at burn levels above %s is even more fuel-efficient. For example, a fleet traveling at burn %s will consume half as much fuel for the distance it covers.", opad, Misc.getHighlightColor(), "20", "40", "half");
        tooltip.addPara("These fuel use reductions are not reflected by the fuel range indicator on the map.", opad);
    }

    @Override
    public boolean hasTooltip() {
        return true;
    }

    @Override
    public boolean isTooltipExpandable() {
        return false;
    }

    @Override
    public float getTooltipWidth() {
        return super.getTooltipWidth();
    }

    @Override
    public String getTerrainName() {
        if (this.params.name != null) {
            return this.params.name;
        }
        return "Slipstream";
    }

    @Override
    public String getNameForTooltip() {
        return "Slipstream";
    }

    @Override
    public String getEffectCategory() {
        return "slipstream";
    }

    @Override
    public void renderOnRadar(Vector2f radarCenter, float factor, float alphaMult) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(-radarCenter.x * factor), (float)(-radarCenter.y * factor), (float)0.0f);
        this.renderOnMap(factor, alphaMult, true, radarCenter);
        GL11.glPopMatrix();
    }

    public List<SlipstreamSegment> getSegments() {
        return this.segments;
    }

    @Override
    public void renderOnMap(float factor, float alphaMult) {
        this.renderOnMap(factor, alphaMult, false, null);
    }

    public void renderOnMap(float factor, float alphaMult, boolean forRadar, Vector2f radarCenter) {
        int n;
        this.recomputeIfNeeded();
        LinkedHashSet<Object> nearSet = new LinkedHashSet();
        if (forRadar) {
            float radius = Global.getSettings().getFloat("campaignRadarRadius");
            nearSet = new LinkedHashSet<SlipstreamSegment>(this.getSegmentsNear(radarCenter, radius));
            for (SlipstreamSegment slipstreamSegment : nearSet) {
                slipstreamSegment.discovered = true;
            }
            if (nearSet.isEmpty()) {
                return;
            }
        }
        ArrayList<SlipstreamSegment> list = new ArrayList<SlipstreamSegment>();
        int n2 = Math.min(this.segments.size() / 10, 5);
        boolean bl = true;
        if (bl < true) {
            n = 1;
        }
        int i = 0;
        while (i < this.segments.size()) {
            SlipstreamSegment curr = this.segments.get(i);
            if ((!forRadar || nearSet.contains(curr)) && (forRadar || curr.discovered || !Global.getSettings().isCampaignSensorsOn() || DebugFlags.SLIPSTREAM_DEBUG && !DebugFlags.USE_SLIPSTREAM_VISIBILITY_IN_DEBUG_MODE)) {
                list.add(curr);
                if (i + n >= this.segments.size() && i + 1 < this.segments.size()) {
                    list.add(this.segments.get(this.segments.size() - 1));
                }
            }
            i += n;
        }
        ArrayList subsections = new ArrayList();
        int prevIndex = -10;
        ArrayList<SlipstreamSegment> subsection = new ArrayList<SlipstreamSegment>();
        for (SlipstreamSegment seg : list) {
            if (prevIndex != seg.index - 1) {
                if (subsection != null && !subsection.isEmpty()) {
                    subsections.add(subsection);
                }
                subsection = new ArrayList();
            }
            subsection.add(seg);
            prevIndex = seg.index;
        }
        if (subsection != null && !subsection.isEmpty()) {
            subsections.add(subsection);
        }
        float texOffset = 0.0f;
        FaderUtil fader = Global.getSector().getCampaignUI().getSharedFader();
        float b = fader.getBrightness();
        b *= 0.5f;
        if (fader.getState() == FaderUtil.State.IN) {
            texOffset = b;
        } else if (fader.getState() == FaderUtil.State.OUT) {
            texOffset = 1.0f - b;
        }
        GL11.glPushMatrix();
        GL11.glScalef((float)factor, (float)factor, (float)1.0f);
        for (List list2 : subsections) {
            this.renderSegmentsForMap(list2, factor, alphaMult, forRadar, texOffset % 1.0f);
        }
        GL11.glPopMatrix();
    }

    protected void renderSegmentsForMap(List<SlipstreamSegment> segments, float factor, float alphaMult, boolean forRadar, float phase) {
        Color color;
        if (segments.isEmpty()) {
            return;
        }
        float widthMult = 1.0f;
        float lengthPerArrowMult = 1.0f;
        float minFactor = 0.012f;
        if (factor < minFactor) {
            widthMult = minFactor / factor;
            lengthPerArrowMult = 2.0f;
        }
        float lengthPerArrow = 700.0f;
        float start = segments.get((int)0).totalLength;
        float end = segments.get((int)(segments.size() - 1)).totalLength;
        start = (float)(Math.floor(start / (lengthPerArrow *= lengthPerArrowMult)) * (double)lengthPerArrow);
        if ((end = (float)(Math.ceil(end / lengthPerArrow) * (double)lengthPerArrow)) - start < lengthPerArrow) {
            return;
        }
        Color orig = color = this.params.mapColor;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2881);
        GL11.glHint((int)3155, (int)4354);
        float fadeDist = 500.0f;
        GL11.glBegin((int)4);
        float len = start;
        while (len < end) {
            Vector2f p0 = this.getPointAt(len + phase * lengthPerArrow, 0.0f);
            Vector2f p1 = this.getPointAt(len + phase * lengthPerArrow + 10.0f, 0.0f);
            if (p0 != null && p1 != null) {
                Vector2f t0;
                float w = this.getWidth(len + phase * lengthPerArrow) * widthMult;
                float triLength = lengthPerArrow * 0.33f;
                triLength = lengthPerArrow * 1.0f;
                triLength = Math.min(lengthPerArrow, (w + lengthPerArrow) / 2.0f);
                float a = this.getFaderBrightness(len + phase * lengthPerArrow + triLength / 2.0f);
                if (len + phase * lengthPerArrow - start < fadeDist) {
                    a *= (len + phase * lengthPerArrow - start) / fadeDist;
                }
                if (len + phase * lengthPerArrow > end - fadeDist) {
                    a *= (end - (len + phase * lengthPerArrow)) / fadeDist;
                }
                if (!(a <= 0.0f) && (t0 = this.getPointAt(len + phase * lengthPerArrow + triLength / 2.0f, 0.0f)) != null) {
                    Vector2f dir = Misc.getUnitVector(p0, t0);
                    Vector2f perp = new Vector2f(-dir.y, dir.x);
                    Vector2f t1 = new Vector2f((ReadableVector2f)p0);
                    Vector2f t2 = new Vector2f((ReadableVector2f)p0);
                    Vector2f t3 = new Vector2f((ReadableVector2f)p0);
                    float backOffset = 0.0f;
                    backOffset = triLength * 0.1f;
                    t3.x -= dir.x * backOffset;
                    t3.y -= dir.y * backOffset;
                    t1.x += perp.x * w / 2.0f;
                    t1.y += perp.y * w / 2.0f;
                    t1.x -= dir.x * triLength / 2.0f;
                    t1.y -= dir.y * triLength / 2.0f;
                    t2.x -= perp.x * w / 2.0f;
                    t2.y -= perp.y * w / 2.0f;
                    t2.x -= dir.x * triLength / 2.0f;
                    t2.y -= dir.y * triLength / 2.0f;
                    Misc.setColor(color, alphaMult * 1.0f * a);
                    GL11.glVertex2f((float)t0.x, (float)t0.y);
                    Misc.setColor(color, alphaMult * 0.0f * a);
                    GL11.glVertex2f((float)t1.x, (float)t1.y);
                    GL11.glVertex2f((float)t3.x, (float)t3.y);
                    Misc.setColor(color, alphaMult * 1.0f * a);
                    GL11.glVertex2f((float)t0.x, (float)t0.y);
                    Misc.setColor(color, alphaMult * 0.0f * a);
                    GL11.glVertex2f((float)t2.x, (float)t2.y);
                    GL11.glVertex2f((float)t3.x, (float)t3.y);
                    color = orig;
                }
            }
            len += lengthPerArrow;
        }
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        SpriteAPI line = Global.getSettings().getSprite("graphics/hud/line4x4.png");
        line.bindTexture();
        float incr = 100.0f;
        float lineW = 50.0f;
        GL11.glBegin((int)8);
        float len2 = start;
        while (len2 < end) {
            Vector2f p0 = this.getPointAt(len2, 0.0f);
            Vector2f p1 = this.getPointAt(len2 + 10.0f, 0.0f);
            if (p0 != null && p1 != null) {
                Vector2f dir = Misc.getUnitVector(p0, p1);
                Vector2f perp = new Vector2f(-dir.y, dir.x);
                float w = lineW;
                Vector2f p2 = new Vector2f((ReadableVector2f)p0);
                Vector2f p3 = new Vector2f((ReadableVector2f)p0);
                p2.x += perp.x * w * 0.5f;
                p2.y += perp.y * w * 0.5f;
                p3.x -= perp.x * w * 0.5f;
                p3.y -= perp.y * w * 0.5f;
                float a = this.getFaderBrightness(len2);
                if (len2 - start < fadeDist) {
                    a *= (len2 - start) / fadeDist;
                }
                if (len2 > end - fadeDist) {
                    a *= (end - len2) / fadeDist;
                }
                Misc.setColor(color, alphaMult * a * 0.5f);
                GL11.glTexCoord2f((float)0.0f, (float)0.0f);
                GL11.glVertex2f((float)p2.x, (float)p2.y);
                GL11.glTexCoord2f((float)0.0f, (float)1.0f);
                GL11.glVertex2f((float)p3.x, (float)p3.y);
            }
            len2 += incr;
        }
        GL11.glEnd();
        GL11.glDisable((int)2881);
    }

    protected void doSoundPlayback(float amount) {
        CampaignFleetAPI fleet = Global.getSector().getPlayerFleet();
        if (fleet != null && this.entity.isInCurrentLocation()) {
            float fMult;
            Vector2f loc = fleet.getLocation();
            float outerPlaybackRange = (float)this.getSpec().getCustom().optDouble("outsideSoundRange", 1000.0);
            float[] coords = this.getLengthAndWidthFractionWithinStream(loc, outerPlaybackRange + 2000.0f, true, 0.0f);
            float innerVolume = 0.0f;
            float innerPitch = 1.0f;
            float outerVolume = 0.0f;
            float outerPitch = 1.0f;
            SlipstreamSegment segment = null;
            List<SlipstreamSegment> near = this.getSegmentsNear(loc, outerPlaybackRange + 2000.0f);
            float pointProximityOuterVolume = 0.0f;
            for (SlipstreamSegment curr : near) {
                float check;
                float dist = Misc.getDistance(loc, curr.loc);
                if (!(dist < (check = curr.wobbledWidth / 2.0f + outerPlaybackRange))) continue;
                float volume = 1.0f - dist / check;
                if (!((volume *= curr.bMult * curr.fader.getBrightness()) > pointProximityOuterVolume)) continue;
                pointProximityOuterVolume = volume;
                segment = curr;
            }
            float f = fMult = coords == null ? 0.0f : this.getFaderBrightness(coords[0]);
            if (fMult <= 0.0f) {
                outerVolume = pointProximityOuterVolume;
            } else {
                float wMult = this.getWidthBasedSpeedMult(coords[0]);
                float f2 = Math.abs(coords[1]);
                if (f2 <= 1.0f) {
                    float intensity = this.getIntensity(f2);
                    float minPitch = (float)this.getSpec().getCustom().optDouble("minPitch", 0.5);
                    float maxPitch = (float)this.getSpec().getCustom().optDouble("maxPitch", 1.25);
                    innerVolume = 0.0f + 1.0f * (Math.min(1.0f, intensity * 2.0f) * wMult);
                    innerPitch = minPitch + (1.0f - minPitch) * intensity * wMult;
                    if (innerPitch > maxPitch) {
                        innerPitch = maxPitch;
                    }
                    outerVolume = 1.0f;
                    if (intensity >= 0.5f) {
                        outerVolume = 0.0f;
                    }
                } else {
                    float distFromStream = 0.0f;
                    distFromStream = this.getWidth(coords[0]) * 0.5f * (f2 - 1.0f);
                    if (distFromStream < outerPlaybackRange) {
                        float intensity = 1.0f - distFromStream / outerPlaybackRange;
                        outerVolume = 0.0f + 1.0f * (intensity * wMult);
                    }
                }
                innerVolume *= fMult;
                outerVolume *= fMult;
                outerVolume = Math.max(outerVolume, pointProximityOuterVolume);
            }
            outerVolume = Math.min(outerVolume, 1.0f - innerVolume);
            if (innerVolume < 0.0f) {
                innerVolume = 0.0f;
            }
            if (innerVolume > 1.0f) {
                innerVolume = 1.0f;
            }
            if (outerVolume > 1.0f) {
                outerVolume = 1.0f;
            }
            if (outerVolume < 0.0f) {
                outerVolume = 0.0f;
            }
            float loopFade = 0.5f;
            String soundId = this.getSpec().getLoopOne();
            if (soundId != null && innerVolume > 0.0f) {
                float gain = (float)this.getSpec().getCustom().optDouble("gain", 0.75);
                float gainHF = (float)this.getSpec().getCustom().optDouble("gainHF", 0.5);
                Global.getSoundPlayer().applyLowPassFilter(Math.max(0.0f, 1.0f - (1.0f - gain) * innerVolume), Math.max(0.0f, 1.0f - Math.min(1.0f - gainHF, innerVolume)));
                Global.getSoundPlayer().playLoop(soundId, fleet, innerPitch, this.getLoopOneVolume() * innerVolume, fleet.getLocation(), Misc.ZERO, loopFade, loopFade);
            }
            if ((soundId = this.getSpec().getLoopTwo()) != null && outerVolume > 0.0f) {
                Vector2f playbackLoc = fleet.getLocation();
                if (segment != null) {
                    playbackLoc = segment.loc;
                }
                Global.getSoundPlayer().playLoop(soundId, fleet, outerPitch, this.getLoopTwoVolume() * outerVolume, playbackLoc, Misc.ZERO, loopFade, loopFade);
            }
            float suppressionMult = innerVolume;
            Global.getSector().getCampaignUI().suppressMusic(this.getSpec().getMusicSuppression() * suppressionMult);
        }
    }

    @Override
    protected boolean shouldPlayLoopOne() {
        return false;
    }

    @Override
    protected boolean shouldPlayLoopTwo() {
        return false;
    }

    public List<Vector2f> getEncounterPoints() {
        if (this.encounterPoints == null) {
            this.encounterPoints = new ArrayList<Vector2f>();
            this.recomputeEncounterPoints();
        }
        return this.encounterPoints;
    }

    public void recomputeEncounterPoints() {
        this.encounterPoints = new ArrayList<Vector2f>();
        ArrayList sections = new ArrayList();
        boolean currSectionIsBreak = false;
        ArrayList<SlipstreamSegment> list = new ArrayList<SlipstreamSegment>();
        int i = 0;
        while (i < this.segments.size()) {
            boolean currSegmentIsBreak;
            SlipstreamSegment slipstreamSegment = this.segments.get(i);
            boolean bl = currSegmentIsBreak = slipstreamSegment.bMult <= 0.0f;
            if (list.isEmpty()) {
                currSectionIsBreak = currSegmentIsBreak;
            }
            if (currSectionIsBreak == currSegmentIsBreak) {
                list.add(slipstreamSegment);
            } else {
                if (!list.isEmpty()) {
                    sections.add(list);
                }
                list = new ArrayList();
                --i;
            }
            ++i;
        }
        boolean prevSectionWasLongEnough = false;
        for (List list2 : sections) {
            boolean sectionIsBreak = ((SlipstreamSegment)list2.get((int)0)).bMult <= 0.0f;
            float sectionLength = ((SlipstreamSegment)list2.get((int)(list2.size() - 1))).totalLength - ((SlipstreamSegment)list2.get((int)0)).totalLength;
            if (sectionIsBreak && prevSectionWasLongEnough && sectionLength >= 1000.0f) {
                Vector2f loc = new Vector2f((ReadableVector2f)((SlipstreamSegment)list2.get((int)0)).loc);
                Vector2f dir = new Vector2f((ReadableVector2f)((SlipstreamSegment)list2.get((int)0)).dir);
                dir.scale(Math.min(1000.0f, sectionLength * 0.4f));
                Vector2f.add((Vector2f)dir, (Vector2f)loc, (Vector2f)loc);
                this.encounterPoints.add(loc);
            }
            prevSectionWasLongEnough = !sectionIsBreak && (float)list2.size() >= 10.0f;
        }
        if (prevSectionWasLongEnough) {
            List list3 = (List)sections.get(sections.size() - 1);
            Vector2f loc = new Vector2f((ReadableVector2f)((SlipstreamSegment)list3.get((int)(list3.size() - 1))).loc);
            Vector2f dir = new Vector2f((ReadableVector2f)((SlipstreamSegment)list3.get((int)(list3.size() - 1))).dir);
            dir.scale(1000.0f);
            Vector2f.add((Vector2f)dir, (Vector2f)loc, (Vector2f)loc);
            this.encounterPoints.add(loc);
        }
    }

    public static class SlipstreamParams2 {
        public String spriteKey1 = "slipstream0";
        public String spriteKey2 = "slipstream1";
        public String spriteKey3 = "slipstream2";
        public String edgeKey = "slipstream_edge";
        public Color spriteColor = Color.white;
        public Color windGlowColor = new Color(0.65f, 0.5f, 1.0f, 0.75f);
        public Color edgeColor = Color.white;
        public float baseWidth = 768.0f;
        public float widthForMaxSpeed = 768.0f;
        public float edgeWidth = 256.0f;
        public float areaPerParticle = 10000.0f;
        public int maxParticles = 2000;
        public float minSpeed;
        public float maxSpeed;
        public Color minColor = new Color(0.5f, 0.3f, 0.75f, 0.1f);
        public Color maxColor = new Color(0.5f, 0.6f, 1.0f, 0.3f);
        public Color mapColor = new Color(0.5f, 0.6f, 1.0f, 1.0f);
        public float minDur = 2.0f;
        public float maxDur = 6.0f;
        public float particleFadeInTime = 1.0f;
        public float lineLengthFractionOfSpeed = 0.25f;
        public int burnLevel = 30;
        public int maxBurnLevelForTextureScroll = 30;
        public boolean slowDownInWiderSections = true;
        public float widthForMaxSpeedMinMult = 0.67f;
        public float widthForMaxSpeedMaxMult = 1.5f;
        public String name = null;
        public float texScrollMult0 = 0.0f;
        public float texScrollMult1 = -1.13f;
        public float texScrollMult2 = -0.28f;
    }

    public static class SlipstreamParticle {
        float speed;
        float dist;
        float yPos;
        Color color;
        float remaining;
        float elapsed;
    }

    public static class SlipstreamSegment {
        public Vector2f loc = new Vector2f();
        public float width;
        public float bMult = 1.0f;
        public transient Vector2f locB = new Vector2f();
        public transient Vector2f dir = new Vector2f();
        public transient float wobbledWidth;
        public transient int index = 0;
        public transient Vector2f normal = new Vector2f();
        public transient float tx = 0.0f;
        public transient float txe1 = 0.0f;
        public transient float txe2 = 0.0f;
        public transient float totalLength;
        public transient float lengthToPrev;
        public transient float lengthToNext;
        public transient MutatingVertexUtil wobble1;
        public transient MutatingVertexUtil wobble2;
        public FaderUtil fader = new FaderUtil(0.0f, 1.0f, 1.0f);
        public boolean discovered = false;

        public Object readResolve() {
            float minRadius = 0.0f;
            float maxRadius = this.width * 0.05f;
            float rate = maxRadius * 0.5f;
            float angleRate = 50.0f;
            this.wobble1 = new MutatingVertexUtil(minRadius, maxRadius, rate, angleRate);
            this.wobble2 = new MutatingVertexUtil(minRadius, maxRadius, rate, angleRate);
            this.locB = new Vector2f();
            return this;
        }
    }
}

