/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.world;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.util.vector.Vector2f;

public class MoteParticleScript
implements EveryFrameScript {
    protected float moteSpawnRate = 1.0f;
    protected SectorEntityToken entity;
    protected IntervalUtil moteSpawn = new IntervalUtil(0.01f, 0.1f);

    public MoteParticleScript(SectorEntityToken entity, float moteSpawnRate) {
        this.entity = entity;
        this.moteSpawnRate = moteSpawnRate;
    }

    public void advance(float amount) {
        float days = Misc.getDays(amount);
        this.moteSpawn.advance(days * this.moteSpawnRate);
        if (this.moteSpawn.intervalElapsed()) {
            MoteParticleScript.spawnMote(this.entity);
        }
    }

    public static void spawnMote(SectorEntityToken from) {
        if (!from.isInCurrentLocation()) {
            return;
        }
        float dur = 1.0f + 2.0f * (float)Math.random();
        dur *= 2.0f;
        float size = 3.0f + (float)Math.random() * 5.0f;
        size *= 3.0f;
        Color color = new Color(255, 100, 255, 175);
        Vector2f loc = Misc.getPointWithinRadius(from.getLocation(), from.getRadius());
        Vector2f vel = Misc.getUnitVectorAtDegreeAngle((float)Math.random() * 360.0f);
        vel.scale(5.0f + (float)Math.random() * 10.0f);
        vel.scale(0.25f);
        Vector2f.add((Vector2f)vel, (Vector2f)from.getVelocity(), (Vector2f)vel);
        Misc.addGlowyParticle(from.getContainingLocation(), loc, vel, size, 0.5f, dur, color);
    }

    public boolean isDone() {
        return false;
    }

    public boolean runWhilePaused() {
        return false;
    }
}

