/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.world;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.NascentGravityWellAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.characters.FullName;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.BattleCreationContext;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.MusicPlayerPluginImpl;
import com.fs.starfarer.api.impl.campaign.CoreLifecyclePluginImpl;
import com.fs.starfarer.api.impl.campaign.DerelictShipEntityPlugin;
import com.fs.starfarer.api.impl.campaign.FleetEncounterContext;
import com.fs.starfarer.api.impl.campaign.FleetInteractionDialogPluginImpl;
import com.fs.starfarer.api.impl.campaign.RuleBasedInteractionDialogPluginImpl;
import com.fs.starfarer.api.impl.campaign.WarningBeaconEntityPlugin;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV3;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.procgen.NebulaEditor;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseThemeGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RemnantSeededFleetManager;
import com.fs.starfarer.api.impl.campaign.procgen.themes.SalvageSpecialAssigner;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.ShipRecoverySpecial;
import com.fs.starfarer.api.impl.campaign.terrain.HyperspaceTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.MagneticFieldTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.world.ZigLeashAssignmentAI;
import com.fs.starfarer.api.loading.VariantSource;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.util.vector.Vector2f;

public class TTBlackSite {
    public static String HAMATSU_ID = "hamatsu";
    public static String NASCENT_WELL_KEY = "$ttBlackSite_well";
    public static String DEFEATED_ZIGGURAT_KEY = "$defeatedZiggurat";

    public void generate(SectorAPI sector) {
        StarSystemAPI system = sector.createStarSystem("Unknown Location");
        system.setName("Unknown Location");
        system.addTag("theme_unsafe");
        system.addTag("theme_hidden");
        LocationAPI hyper = Global.getSector().getHyperspace();
        system.getMemoryWithoutUpdate().set(MusicPlayerPluginImpl.MUSIC_SET_MEM_KEY, "music_campaign_alpha_site");
        system.setBackgroundTextureFilename("graphics/backgrounds/background4.jpg");
        system.getLocation().set(4000.0f, 2500.0f);
        HyperspaceTerrainPlugin hyperTerrain = (HyperspaceTerrainPlugin)Misc.getHyperspaceTerrain().getPlugin();
        NebulaEditor editor = new NebulaEditor(hyperTerrain);
        editor.clearArc(system.getLocation().x, system.getLocation().y, 0.0f, 200.0f, 0.0f, 360.0f);
        SectorEntityToken center = system.initNonStarCenter();
        system.setLightColor(new Color(225, 170, 255, 255));
        String type = "barren";
        type = "irradiated";
        PlanetAPI rock = system.addPlanet("site_alpha", center, "Alpha Site", type, 0.0f, 150.0f, 1200.0f, 40.0f);
        rock.getMemoryWithoutUpdate().set("$ttBlackSite", true);
        rock.getMarket().addCondition("no_atmosphere");
        rock.getMarket().addCondition("cold");
        rock.getMarket().addCondition("dark");
        rock.getMarket().addCondition("irradiated");
        rock.getMarket().addCondition("ruins_scattered");
        rock.getMarket().getMemoryWithoutUpdate().set("$ruinsExplored", true);
        CoreLifecyclePluginImpl.addRuinsJunk(rock);
        rock.setOrbit(null);
        rock.setLocation(1200.0f, 300.0f);
        SectorEntityToken field = system.addTerrain("magnetic_field", new MagneticFieldTerrainPlugin.MagneticFieldParams(150.0f, 500.0f, rock, 350.0f, 650.0f, new Color(60, 60, 150, 90), 1.0f, new Color(130, 60, 150, 130), new Color(150, 30, 120, 150), new Color(200, 50, 130, 190), new Color(250, 70, 150, 240), new Color(200, 80, 130, 255), new Color(75, 0, 160, 255), new Color(127, 0, 255, 255)));
        field.setCircularOrbit(rock, 0.0f, 0.0f, 75.0f);
        CustomCampaignEntityAPI beacon = system.addCustomEntity(null, null, "warning_beacon", "neutral");
        beacon.setCircularOrbitPointingDown(rock, 0.0f, 2500.0f, 60.0f);
        beacon.getMemoryWithoutUpdate().set("$ttBlackSite", true);
        beacon.getMemoryWithoutUpdate().set(WarningBeaconEntityPlugin.PING_ID_KEY, "warning_beacon3");
        beacon.getMemoryWithoutUpdate().set(WarningBeaconEntityPlugin.PING_FREQ_KEY, Float.valueOf(1.5f));
        beacon.getMemoryWithoutUpdate().set(WarningBeaconEntityPlugin.PING_COLOR_KEY, new Color(250, 125, 0, 255));
        beacon.getMemoryWithoutUpdate().set(WarningBeaconEntityPlugin.GLOW_COLOR_KEY, new Color(250, 55, 0, 255));
        SectorEntityToken cache = BaseThemeGenerator.addSalvageEntity(system, "alpha_site_weapons_cache", "neutral");
        cache.getMemoryWithoutUpdate().set("$ttWeaponsCache", true);
        cache.getLocation().set(11111.0f, 11111.0f);
        system.generateAnchorIfNeeded();
        NascentGravityWellAPI well = Global.getSector().createNascentGravityWell(beacon, 50.0f);
        well.addTag("no_entity_tooltip");
        well.setColorOverride(new Color(125, 50, 255));
        hyper.addEntity(well);
        well.autoUpdateHyperLocationBasedOnInSystemEntityAtRadius(beacon, 0.0f);
        TTBlackSite.addFleet(rock);
        SectorEntityToken hamatsu = TTBlackSite.addDerelict(system, beacon, "venture_Outdated", "ISS Hamatsu", HAMATSU_ID, ShipRecoverySpecial.ShipCondition.BATTERED, 200.0f, true);
        hamatsu.getMemoryWithoutUpdate().set("$hamatsu", true);
        Global.getSector().getMemoryWithoutUpdate().set(NASCENT_WELL_KEY, well);
    }

    public static NascentGravityWellAPI getWell() {
        return (NascentGravityWellAPI)Global.getSector().getMemoryWithoutUpdate().get(NASCENT_WELL_KEY);
    }

    public static void addFleet(SectorEntityToken rock) {
        CampaignFleetAPI fleet = FleetFactoryV3.createEmptyFleet("neutral", "patrolLarge", null);
        fleet.setName("Unidentified Vessel");
        fleet.setNoFactionInName(true);
        fleet.getMemoryWithoutUpdate().set("$cfai_makeHostile", true);
        fleet.getMemoryWithoutUpdate().set("$cfai_makeAggressive", true);
        fleet.getMemoryWithoutUpdate().set("$noRepImpact", true);
        fleet.getMemoryWithoutUpdate().set("$lowRepImpact", true);
        fleet.getMemoryWithoutUpdate().set("$noShipRecovery", true);
        fleet.getMemoryWithoutUpdate().set("$cfai_makeAlwaysPursue", true);
        fleet.getMemoryWithoutUpdate().set("$ziggurat", true);
        fleet.getMemoryWithoutUpdate().set(MusicPlayerPluginImpl.KEEP_PLAYING_LOCATION_MUSIC_DURING_ENCOUNTER_MEM_KEY, true);
        fleet.getFleetData().addFleetMember("ziggurat_Experimental");
        fleet.getFleetData().ensureHasFlagship();
        fleet.clearAbilities();
        fleet.setTransponderOn(true);
        PersonAPI person = TTBlackSite.createZigguratCaptain();
        fleet.setCommander(person);
        FleetMemberAPI flagship = fleet.getFlagship();
        flagship.setCaptain(person);
        flagship.updateStats();
        flagship.getRepairTracker().setCR(flagship.getRepairTracker().getMaxCR());
        flagship.setShipName("TTS Xenorphica");
        flagship.setVariant(flagship.getVariant().clone(), false, false);
        flagship.getVariant().setSource(VariantSource.REFIT);
        flagship.getVariant().addTag("ship_limited_tooltip");
        Vector2f loc = new Vector2f(rock.getLocation().x + 300.0f * ((float)Math.random() - 0.5f), rock.getLocation().y + 300.0f * ((float)Math.random() - 0.5f));
        fleet.setLocation(loc.x, loc.y);
        rock.getContainingLocation().addEntity(fleet);
        fleet.getMemoryWithoutUpdate().set("$fidConifgGen", new ZigFIDConfig());
        fleet.addScript(new ZigLeashAssignmentAI(fleet, rock));
    }

    public static PersonAPI createZigguratCaptain() {
        PersonAPI person = Global.getFactory().createPerson();
        person.setName(new FullName("Motes", "", FullName.Gender.ANY));
        person.setFaction("neutral");
        person.setPortraitSprite(Global.getSettings().getSpriteName("characters", "ziggurat_captain"));
        person.setPersonality("reckless");
        person.setRankId(Ranks.SPACE_CAPTAIN);
        person.setPostId(null);
        person.getStats().setSkipRefresh(true);
        person.getStats().setLevel(10);
        person.getStats().setSkillLevel("helmsmanship", 2.0f);
        person.getStats().setSkillLevel("target_analysis", 2.0f);
        person.getStats().setSkillLevel("impact_mitigation", 2.0f);
        person.getStats().setSkillLevel("gunnery_implants", 2.0f);
        person.getStats().setSkillLevel("energy_weapon_mastery", 2.0f);
        person.getStats().setSkillLevel("combat_endurance", 2.0f);
        person.getStats().setSkillLevel("polarized_armor", 2.0f);
        person.getStats().setSkillLevel("missile_specialization", 2.0f);
        person.getStats().setSkillLevel("field_modulation", 2.0f);
        person.getStats().setSkillLevel("damage_control", 2.0f);
        person.getStats().setSkillLevel("navigation", 1.0f);
        person.getStats().setSkipRefresh(false);
        return person;
    }

    public static SectorEntityToken addDerelict(StarSystemAPI system, SectorEntityToken focus, String variantId, String name, String id, ShipRecoverySpecial.ShipCondition condition, float orbitRadius, boolean recoverable) {
        DerelictShipEntityPlugin.DerelictShipData params = new DerelictShipEntityPlugin.DerelictShipData(new ShipRecoverySpecial.PerShipData(variantId, condition, 0.0f), false);
        if (name != null) {
            params.ship.shipName = name;
            params.ship.nameAlwaysKnown = true;
            params.ship.fleetMemberId = id;
        }
        SectorEntityToken ship = BaseThemeGenerator.addSalvageEntity(system, "wreck", "neutral", params);
        ship.setDiscoverable(true);
        float orbitDays = orbitRadius / (10.0f + (float)Math.random() * 5.0f);
        ship.setCircularOrbit(focus, (float)Math.random() * 360.0f, orbitRadius, orbitDays);
        if (recoverable) {
            SalvageSpecialAssigner.ShipRecoverySpecialCreator creator = new SalvageSpecialAssigner.ShipRecoverySpecialCreator(null, 0, 0, false, null, null);
            Misc.setSalvageSpecial(ship, creator.createSpecial(ship, null));
        }
        return ship;
    }

    public static class ZigFIDConfig
    implements FleetInteractionDialogPluginImpl.FIDConfigGen {
        public FleetInteractionDialogPluginImpl.FIDConfig createConfig() {
            FleetInteractionDialogPluginImpl.FIDConfig config = new FleetInteractionDialogPluginImpl.FIDConfig();
            config.showTransponderStatus = false;
            config.showEngageText = false;
            config.alwaysPursue = true;
            config.dismissOnLeave = false;
            config.withSalvage = false;
            config.printXPToDialog = true;
            config.noSalvageLeaveOptionText = "Continue";
            config.delegate = new FleetInteractionDialogPluginImpl.BaseFIDDelegate(){

                public void postPlayerSalvageGeneration(InteractionDialogAPI dialog, FleetEncounterContext context, CargoAPI salvage) {
                    new RemnantSeededFleetManager.RemnantFleetInteractionConfigGen().createConfig().delegate.postPlayerSalvageGeneration(dialog, context, salvage);
                }

                public void notifyLeave(InteractionDialogAPI dialog) {
                    SectorEntityToken other = dialog.getInteractionTarget();
                    if (!(other instanceof CampaignFleetAPI)) {
                        dialog.dismiss();
                        return;
                    }
                    CampaignFleetAPI fleet = (CampaignFleetAPI)other;
                    if (!fleet.isEmpty()) {
                        dialog.dismiss();
                        return;
                    }
                    Global.getSector().getMemoryWithoutUpdate().set(DEFEATED_ZIGGURAT_KEY, true);
                    ShipRecoverySpecial.PerShipData ship = new ShipRecoverySpecial.PerShipData("ziggurat_Hull", ShipRecoverySpecial.ShipCondition.WRECKED, 0.0f);
                    ship.shipName = "TTS Xenorphica";
                    DerelictShipEntityPlugin.DerelictShipData params = new DerelictShipEntityPlugin.DerelictShipData(ship, false);
                    CustomCampaignEntityAPI entity = (CustomCampaignEntityAPI)BaseThemeGenerator.addSalvageEntity(fleet.getContainingLocation(), "wreck", "neutral", params);
                    Misc.makeImportant(entity, "ziggurat");
                    entity.getMemoryWithoutUpdate().set("$ziggurat", true);
                    entity.getLocation().x = fleet.getLocation().x + (50.0f - (float)Math.random() * 100.0f);
                    entity.getLocation().y = fleet.getLocation().y + (50.0f - (float)Math.random() * 100.0f);
                    ShipRecoverySpecial.ShipRecoverySpecialData data = new ShipRecoverySpecial.ShipRecoverySpecialData(null);
                    data.notNowOptionExits = true;
                    data.noDescriptionText = true;
                    DerelictShipEntityPlugin dsep = (DerelictShipEntityPlugin)entity.getCustomPlugin();
                    ShipRecoverySpecial.PerShipData copy = dsep.getData().ship.clone();
                    copy.variant = Global.getSettings().getVariant(copy.variantId).clone();
                    copy.variantId = null;
                    copy.variant.addTag("ship_can_not_scuttle");
                    copy.variant.addTag("ship_unique_signature");
                    data.addShip(copy);
                    Misc.setSalvageSpecial(entity, data);
                    dialog.setInteractionTarget(entity);
                    RuleBasedInteractionDialogPluginImpl plugin = new RuleBasedInteractionDialogPluginImpl("AfterZigguratDefeat");
                    dialog.setPlugin(plugin);
                    plugin.init(dialog);
                }

                public void battleContextCreated(InteractionDialogAPI dialog, BattleCreationContext bcc) {
                    bcc.aiRetreatAllowed = false;
                    bcc.objectivesAllowed = false;
                    bcc.fightToTheLast = true;
                    bcc.enemyDeployAll = true;
                }
            };
            return config;
        }
    }
}

