/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleCreationPlugin;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CampaignTerrainAPI;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.BattleCreationContext;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.fleet.FleetGoal;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.terrain.BaseRingTerrain;
import com.fs.starfarer.api.impl.campaign.terrain.PulsarBeamTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.StarCoronaTerrainPlugin;
import com.fs.starfarer.api.impl.combat.EscapeRevealPlugin;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.mission.FleetSide;
import com.fs.starfarer.api.mission.MissionDefinitionAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BattleCreationPluginImpl
implements BattleCreationPlugin {
    protected float width;
    protected float height;
    protected float xPad = 2000.0f;
    protected float yPad = 2000.0f;
    protected List<String> objs = null;
    protected float prevXDir = 0.0f;
    protected float prevYDir = 0.0f;
    protected boolean escape;
    protected BattleCreationContext context;
    protected MissionDefinitionAPI loader;
    protected float coronaIntensity = 0.0f;
    protected StarCoronaTerrainPlugin corona = null;
    protected PulsarBeamTerrainPlugin pulsar = null;
    protected static String COMM = "comm_relay";
    protected static String SENSOR = "sensor_array";
    protected static String NAV = "nav_buoy";
    protected static float PLANET_AREA_WIDTH = 2000.0f;
    protected static float PLANET_AREA_HEIGHT = 2000.0f;
    protected static float PLANET_MAX_DIST = (float)Math.sqrt(PLANET_AREA_WIDTH / 2.0f * PLANET_AREA_WIDTH / 2.0f + PLANET_AREA_HEIGHT / 2.0f * PLANET_AREA_WIDTH / 2.0f);
    protected static float SINGLE_PLANET_MAX_DIST = 1000.0f;

    @Override
    public void initBattle(BattleCreationContext context, MissionDefinitionAPI loader) {
        boolean withObjectives;
        this.context = context;
        this.loader = loader;
        CampaignFleetAPI playerFleet = context.getPlayerFleet();
        CampaignFleetAPI otherFleet = context.getOtherFleet();
        FleetGoal playerGoal = context.getPlayerGoal();
        FleetGoal enemyGoal = context.getOtherGoal();
        Random random = Misc.getRandom(Misc.getSalvageSeed(otherFleet) * (long)otherFleet.getFleetData().getNumMembers(), 23);
        this.escape = playerGoal == FleetGoal.ESCAPE || enemyGoal == FleetGoal.ESCAPE;
        int maxFP = (int)Global.getSettings().getFloat("maxNoObjectiveBattleSize");
        int fpOne = 0;
        int fpTwo = 0;
        for (FleetMemberAPI member : playerFleet.getFleetData().getMembersListCopy()) {
            if (!member.canBeDeployedForCombat() && playerGoal != FleetGoal.ESCAPE) continue;
            fpOne = (int)((float)fpOne + member.getUnmodifiedDeploymentPointsCost());
        }
        for (FleetMemberAPI member : otherFleet.getFleetData().getMembersListCopy()) {
            if (!member.canBeDeployedForCombat() && playerGoal != FleetGoal.ESCAPE) continue;
            fpTwo = (int)((float)fpTwo + member.getUnmodifiedDeploymentPointsCost());
        }
        int smaller = Math.min(fpOne, fpTwo);
        boolean bl = withObjectives = smaller > maxFP;
        if (!context.objectivesAllowed) {
            withObjectives = false;
        }
        int numObjectives = 0;
        if (withObjectives) {
            numObjectives = fpOne + fpTwo > maxFP + 70 ? 4 : 3 + random.nextInt(2);
        }
        if (numObjectives > 4) {
            numObjectives = 4;
        }
        int baseCommandPoints = (int)Global.getSettings().getFloat("startingCommandPoints");
        loader.initFleet(FleetSide.PLAYER, "ISS", playerGoal, false, context.getPlayerCommandPoints() - baseCommandPoints, (int)playerFleet.getCommanderStats().getCommandPoints().getModifiedValue() - baseCommandPoints);
        loader.initFleet(FleetSide.ENEMY, "", enemyGoal, true, (int)otherFleet.getCommanderStats().getCommandPoints().getModifiedValue() - baseCommandPoints);
        List<FleetMemberAPI> playerShips = playerFleet.getFleetData().getCombatReadyMembersListCopy();
        if (playerGoal == FleetGoal.ESCAPE) {
            playerShips = playerFleet.getFleetData().getMembersListCopy();
        }
        for (FleetMemberAPI member : playerShips) {
            loader.addFleetMember(FleetSide.PLAYER, member);
        }
        List<FleetMemberAPI> enemyShips = otherFleet.getFleetData().getCombatReadyMembersListCopy();
        if (enemyGoal == FleetGoal.ESCAPE) {
            enemyShips = otherFleet.getFleetData().getMembersListCopy();
        }
        for (FleetMemberAPI member : enemyShips) {
            loader.addFleetMember(FleetSide.ENEMY, member);
        }
        this.width = 18000.0f;
        this.height = 18000.0f;
        if (this.escape) {
            this.width = 18000.0f;
            this.height = 18000.0f;
        } else if (withObjectives) {
            this.width = 24000.0f;
            this.height = numObjectives == 2 ? 14000.0f : 18000.0f;
        }
        this.createMap(random);
        context.setInitialDeploymentBurnDuration(1.5f);
        context.setNormalDeploymentBurnDuration(6.0f);
        context.setEscapeDeploymentBurnDuration(1.5f);
        this.xPad = 2000.0f;
        this.yPad = 3000.0f;
        if (this.escape) {
            this.addEscapeObjectives(loader, 2, random);
            context.setInitialEscapeRange(Global.getSettings().getFloat("escapeStartDistance"));
            context.setFlankDeploymentDistance(Global.getSettings().getFloat("escapeFlankDistance"));
            loader.addPlugin(new EscapeRevealPlugin(context));
        } else {
            if (withObjectives) {
                this.addObjectives(loader, numObjectives, random);
                context.setStandoffRange(this.height - 4500.0f);
            } else {
                context.setStandoffRange(6000.0f);
            }
            context.setFlankDeploymentDistance(this.height / 2.0f);
        }
    }

    @Override
    public void afterDefinitionLoad(final CombatEngineAPI engine) {
        if (this.coronaIntensity > 0.0f && (this.corona != null || this.pulsar != null)) {
            String name = "Corona";
            if (this.pulsar != null) {
                name = this.pulsar.getTerrainName();
            } else if (this.corona != null) {
                name = this.corona.getTerrainName();
            }
            final String name2 = name;
            final Object key1 = new Object();
            final Object key2 = new Object();
            final String icon = Global.getSettings().getSpriteName("ui", "icon_tactical_cr_penalty");
            engine.addPlugin(new BaseEveryFrameCombatPlugin(){

                @Override
                public void advance(float amount, List<InputEventAPI> events) {
                    engine.maintainStatusForPlayerShip(key1, icon, name2, "reduced peak time", true);
                    engine.maintainStatusForPlayerShip(key2, icon, name2, "faster CR degradation", true);
                }
            });
        }
    }

    protected void createMap(Random random) {
        this.loader.initMap(-this.width / 2.0f, this.width / 2.0f, -this.height / 2.0f, this.height / 2.0f);
        CampaignFleetAPI playerFleet = this.context.getPlayerFleet();
        String nebulaTex = null;
        String nebulaMapTex = null;
        boolean inNebula = false;
        boolean protectedFromCorona = false;
        for (CustomCampaignEntityAPI curr : playerFleet.getContainingLocation().getCustomEntitiesWithTag("protects_from_corona_in_battle")) {
            if (!(Misc.getDistance(curr.getLocation(), playerFleet.getLocation()) <= curr.getRadius() + Global.getSector().getPlayerFleet().getRadius() + 10.0f)) continue;
            protectedFromCorona = true;
            break;
        }
        float numRings = 0.0f;
        Color coronaColor = null;
        for (CampaignTerrainAPI terrain : playerFleet.getContainingLocation().getTerrainCopy()) {
            int alpha;
            float intensity;
            Color color;
            float angle;
            BaseRingTerrain plugin;
            if (terrain.getPlugin() instanceof NebulaTextureProvider) {
                NebulaTextureProvider provider;
                if (terrain.getPlugin().containsEntity(playerFleet)) {
                    inNebula = true;
                    if (!(terrain.getPlugin() instanceof NebulaTextureProvider)) continue;
                    provider = (NebulaTextureProvider)((Object)terrain.getPlugin());
                    nebulaTex = provider.getNebulaTex();
                    nebulaMapTex = provider.getNebulaMapTex();
                    continue;
                }
                if (nebulaTex != null || !(terrain.getPlugin() instanceof NebulaTextureProvider)) continue;
                provider = (NebulaTextureProvider)((Object)terrain.getPlugin());
                nebulaTex = provider.getNebulaTex();
                nebulaMapTex = provider.getNebulaMapTex();
                continue;
            }
            if (terrain.getPlugin() instanceof StarCoronaTerrainPlugin && this.pulsar == null && !protectedFromCorona) {
                plugin = (StarCoronaTerrainPlugin)terrain.getPlugin();
                if (!plugin.containsEntity(playerFleet)) continue;
                angle = Misc.getAngleInDegrees(terrain.getLocation(), playerFleet.getLocation());
                color = ((StarCoronaTerrainPlugin)plugin).getAuroraColorForAngle(angle);
                intensity = ((StarCoronaTerrainPlugin)plugin).getIntensityAtPoint(playerFleet.getLocation());
                intensity = 0.4f + 0.6f * intensity;
                alpha = (int)(80.0f * intensity);
                color = Misc.setAlpha(color, alpha);
                if (coronaColor != null && coronaColor.getAlpha() >= alpha) continue;
                coronaColor = color;
                this.coronaIntensity = intensity;
                this.corona = plugin;
                continue;
            }
            if (terrain.getPlugin() instanceof PulsarBeamTerrainPlugin && !protectedFromCorona) {
                plugin = (PulsarBeamTerrainPlugin)terrain.getPlugin();
                if (!plugin.containsEntity(playerFleet)) continue;
                angle = Misc.getAngleInDegreesStrict(terrain.getLocation(), playerFleet.getLocation());
                color = ((PulsarBeamTerrainPlugin)plugin).getPulsarColorForAngle(angle);
                intensity = ((PulsarBeamTerrainPlugin)plugin).getIntensityAtPoint(playerFleet.getLocation());
                intensity = 0.4f + 0.6f * intensity;
                alpha = (int)(80.0f * intensity);
                color = Misc.setAlpha(color, alpha);
                if (coronaColor != null && coronaColor.getAlpha() >= alpha) continue;
                coronaColor = color;
                this.coronaIntensity = intensity;
                this.pulsar = plugin;
                this.corona = null;
                continue;
            }
            if (!terrain.getType().equals("ring") || !terrain.getPlugin().containsEntity(playerFleet)) continue;
            numRings += 1.0f;
        }
        if (nebulaTex != null) {
            this.loader.setNebulaTex(nebulaTex);
            this.loader.setNebulaMapTex(nebulaMapTex);
        }
        if (coronaColor != null) {
            this.loader.setBackgroundGlowColor(coronaColor);
        }
        int numNebula = 15;
        if (inNebula) {
            numNebula = 100;
        }
        if (!inNebula && playerFleet.isInHyperspace()) {
            numNebula = 0;
        }
        int i = 0;
        while (i < numNebula) {
            float x = random.nextFloat() * this.width - this.width / 2.0f;
            float y = random.nextFloat() * this.height - this.height / 2.0f;
            float radius = 100.0f + random.nextFloat() * 400.0f;
            if (inNebula) {
                radius += 100.0f + 500.0f * random.nextFloat();
            }
            this.loader.addNebula(x, y, radius);
            ++i;
        }
        float numAsteroidsWithinRange = this.countNearbyAsteroids(playerFleet);
        int numAsteroids = Math.min(400, (int)((numAsteroidsWithinRange + 1.0f) * 20.0f));
        this.loader.addAsteroidField(0.0f, 0.0f, random.nextFloat() * 360.0f, this.width, 20.0f, 70.0f, numAsteroids);
        if (numRings > 0.0f) {
            int numRingAsteroids = (int)(numRings * 300.0f + numRings * 600.0f * random.nextFloat());
            if (numRingAsteroids > 1500) {
                numRingAsteroids = 1500;
            }
            this.loader.addRingAsteroids(0.0f, 0.0f, random.nextFloat() * 360.0f, this.width, 100.0f, 200.0f, numRingAsteroids);
        }
        this.loader.setBackgroundSpriteName(playerFleet.getContainingLocation().getBackgroundTextureFilename());
        if (playerFleet.getContainingLocation() == Global.getSector().getHyperspace()) {
            this.loader.setHyperspaceMode(true);
        } else {
            this.loader.setHyperspaceMode(false);
        }
        this.addClosestPlanet();
    }

    protected void addClosestPlanet() {
        float f;
        float radius;
        float bgWidth = 2048.0f;
        float bgHeight = 2048.0f;
        PlanetAPI planet = this.getClosestPlanet(this.context.getPlayerFleet());
        if (planet == null) {
            return;
        }
        float dist = Vector2f.sub((Vector2f)this.context.getPlayerFleet().getLocation(), (Vector2f)planet.getLocation(), (Vector2f)new Vector2f()).length() - planet.getRadius();
        if (dist < 0.0f) {
            dist = 0.0f;
        }
        float baseRadius = planet.getRadius();
        float scaleFactor = 1.5f;
        float maxRadius = 500.0f;
        float minRadius = 100.0f;
        float maxDist = SINGLE_PLANET_MAX_DIST - planet.getRadius();
        if (maxDist < 1.0f) {
            maxDist = 1.0f;
        }
        boolean playerHasStation = false;
        boolean enemyHasStation = false;
        for (FleetMemberAPI curr : this.context.getPlayerFleet().getFleetData().getMembersListCopy()) {
            if (!curr.isStation()) continue;
            playerHasStation = true;
            break;
        }
        for (FleetMemberAPI curr : this.context.getOtherFleet().getFleetData().getMembersListCopy()) {
            if (!curr.isStation()) continue;
            enemyHasStation = true;
            break;
        }
        float planetYOffset = 0.0f;
        if (playerHasStation) {
            planetYOffset = -bgHeight / 2.0f * 0.5f;
        }
        if (enemyHasStation) {
            planetYOffset = bgHeight / 2.0f * 0.5f;
        }
        if ((radius = baseRadius * (f = (maxDist - dist) / maxDist * 0.65f + 0.35f) * scaleFactor) > maxRadius) {
            radius = maxRadius;
        }
        if (radius < minRadius) {
            radius = minRadius;
        }
        this.loader.setPlanetBgSize(bgWidth * f, bgHeight * f);
        this.loader.addPlanet(0.0f, planetYOffset, radius, planet, 0.0f, true);
    }

    protected void addMultiplePlanets() {
        float bgWidth = 2048.0f;
        float bgHeight = 2048.0f;
        this.loader.setPlanetBgSize(bgWidth, bgHeight);
        List<NearbyPlanetData> planets = this.getNearbyPlanets(this.context.getPlayerFleet());
        if (!planets.isEmpty()) {
            float maxDist = PLANET_MAX_DIST;
            for (NearbyPlanetData data : planets) {
                float dist = Vector2f.sub((Vector2f)this.context.getPlayerFleet().getLocation(), (Vector2f)data.planet.getLocation(), (Vector2f)new Vector2f()).length();
                float baseRadius = data.planet.getRadius();
                float scaleFactor = 1.5f;
                float maxRadius = 500.0f;
                if (data.planet.isStar()) continue;
                float f = (maxDist - dist) / maxDist * 0.65f + 0.35f;
                float radius = baseRadius * f * scaleFactor;
                if (radius > maxRadius) {
                    radius = maxRadius;
                }
                this.loader.addPlanet(data.offset.x * bgWidth / PLANET_AREA_WIDTH * scaleFactor, data.offset.y * bgHeight / PLANET_AREA_HEIGHT * scaleFactor, radius, data.planet.getTypeId(), 0.0f, true);
            }
        }
    }

    protected void setRandomBackground(MissionDefinitionAPI loader, Random random) {
        String[] bgs = new String[]{"graphics/backgrounds/background1.jpg", "graphics/backgrounds/background2.jpg", "graphics/backgrounds/background3.jpg", "graphics/backgrounds/background4.jpg"};
        String pick = bgs[Math.min(bgs.length - 1, (int)(random.nextDouble() * (double)bgs.length))];
        loader.setBackgroundSpriteName(pick);
    }

    protected void addObjectives(MissionDefinitionAPI loader, int num, Random random) {
        this.objs = new ArrayList<String>(Arrays.asList(SENSOR, SENSOR, NAV, NAV));
        if (num == 2) {
            this.objs = new ArrayList<String>(Arrays.asList(SENSOR, SENSOR, NAV, NAV, COMM));
            this.addObjectiveAt(0.25f, 0.5f, 0.0f, 0.0f, random);
            this.addObjectiveAt(0.75f, 0.5f, 0.0f, 0.0f, random);
        } else if (num == 3) {
            float r = random.nextFloat();
            if (r < 0.33f) {
                this.addObjectiveAt(0.25f, 0.7f, 1.0f, 1.0f, random);
                this.addObjectiveAt(0.25f, 0.3f, 1.0f, 1.0f, random);
                this.addObjectiveAt(0.75f, 0.5f, 1.0f, 1.0f, COMM, random);
            } else if (r < 0.67f) {
                this.addObjectiveAt(0.75f, 0.7f, 1.0f, 1.0f, random);
                this.addObjectiveAt(0.75f, 0.3f, 1.0f, 1.0f, random);
                this.addObjectiveAt(0.25f, 0.5f, 1.0f, 1.0f, COMM, random);
            } else if (random.nextFloat() < 0.5f) {
                this.addObjectiveAt(0.22f, 0.7f, 1.0f, 1.0f, random);
                this.addObjectiveAt(0.5f, 0.5f, 1.0f, 1.0f, COMM, random);
                this.addObjectiveAt(0.78f, 0.3f, 1.0f, 1.0f, random);
            } else {
                this.addObjectiveAt(0.22f, 0.3f, 1.0f, 1.0f, random);
                this.addObjectiveAt(0.5f, 0.5f, 1.0f, 1.0f, COMM, random);
                this.addObjectiveAt(0.78f, 0.7f, 1.0f, 1.0f, random);
            }
        } else if (num == 4) {
            float r = random.nextFloat();
            if (r < 0.33f) {
                String[] maybeRelays = this.pickCommRelays(2, 2, false, true, true, false, random);
                this.addObjectiveAt(0.25f, 0.25f, 2.0f, 1.0f, maybeRelays[0], random);
                this.addObjectiveAt(0.25f, 0.75f, 2.0f, 1.0f, maybeRelays[1], random);
                this.addObjectiveAt(0.75f, 0.25f, 2.0f, 1.0f, maybeRelays[2], random);
                this.addObjectiveAt(0.75f, 0.75f, 2.0f, 1.0f, maybeRelays[3], random);
            } else if (r < 0.67f) {
                String[] maybeRelays = this.pickCommRelays(1, 2, true, false, true, false, random);
                this.addObjectiveAt(0.25f, 0.5f, 1.0f, 1.0f, maybeRelays[0], random);
                this.addObjectiveAt(0.5f, 0.75f, 1.0f, 1.0f, maybeRelays[1], random);
                this.addObjectiveAt(0.75f, 0.5f, 1.0f, 1.0f, maybeRelays[2], random);
                this.addObjectiveAt(0.5f, 0.25f, 1.0f, 1.0f, maybeRelays[3], random);
            } else if (random.nextFloat() < 0.5f) {
                String[] maybeRelays = this.pickCommRelays(1, 2, true, false, true, false, random);
                this.addObjectiveAt(0.25f, 0.25f, 1.0f, 0.0f, maybeRelays[0], random);
                this.addObjectiveAt(0.4f, 0.6f, 1.0f, 0.0f, maybeRelays[1], random);
                this.addObjectiveAt(0.6f, 0.4f, 1.0f, 0.0f, maybeRelays[2], random);
                this.addObjectiveAt(0.75f, 0.75f, 1.0f, 0.0f, maybeRelays[3], random);
            } else {
                String[] maybeRelays = this.pickCommRelays(1, 2, false, true, false, true, random);
                this.addObjectiveAt(0.25f, 0.75f, 1.0f, 0.0f, maybeRelays[0], random);
                this.addObjectiveAt(0.4f, 0.4f, 1.0f, 0.0f, maybeRelays[1], random);
                this.addObjectiveAt(0.6f, 0.6f, 1.0f, 0.0f, maybeRelays[2], random);
                this.addObjectiveAt(0.75f, 0.25f, 1.0f, 0.0f, maybeRelays[3], random);
            }
        }
    }

    protected String[] pickCommRelays(int min, int max, boolean comm1, boolean comm2, boolean comm3, boolean comm4, Random random) {
        String[] result = new String[4];
        WeightedRandomPicker<Integer> picker = new WeightedRandomPicker<Integer>(random);
        if (comm1) {
            picker.add(0);
        }
        if (comm2) {
            picker.add(1);
        }
        if (comm3) {
            picker.add(2);
        }
        if (comm4) {
            picker.add(3);
        }
        int num = min + random.nextInt(max - min + 1);
        int i = 0;
        while (i < num && !picker.isEmpty()) {
            result[((Integer)picker.pickAndRemove()).intValue()] = COMM;
            ++i;
        }
        return result;
    }

    protected void addEscapeObjectives(MissionDefinitionAPI loader, int num, Random random) {
        this.objs = new ArrayList<String>(Arrays.asList(SENSOR, SENSOR, NAV, NAV, COMM));
        if (num == 2) {
            float r = random.nextFloat();
            if (r < 0.33f) {
                this.addObjectiveAt(0.25f, 0.25f, 1.0f, 1.0f, random);
                this.addObjectiveAt(0.75f, 0.75f, 1.0f, 1.0f, random);
            } else if (r < 0.67f) {
                this.addObjectiveAt(0.75f, 0.25f, 1.0f, 1.0f, random);
                this.addObjectiveAt(0.25f, 0.75f, 1.0f, 1.0f, random);
            } else {
                this.addObjectiveAt(0.5f, 0.25f, 4.0f, 2.0f, random);
                this.addObjectiveAt(0.5f, 0.75f, 4.0f, 2.0f, random);
            }
        } else if (num == 3) {
            float r = random.nextFloat();
            if (r < 0.33f) {
                this.addObjectiveAt(0.25f, 0.75f, 1.0f, 1.0f, random);
                this.addObjectiveAt(0.25f, 0.25f, 1.0f, 1.0f, random);
                this.addObjectiveAt(0.75f, 0.5f, 1.0f, 6.0f, random);
            } else if (r < 0.67f) {
                this.addObjectiveAt(0.25f, 0.5f, 1.0f, 6.0f, random);
                this.addObjectiveAt(0.75f, 0.75f, 1.0f, 1.0f, random);
                this.addObjectiveAt(0.75f, 0.25f, 1.0f, 1.0f, random);
            } else {
                this.addObjectiveAt(0.5f, 0.25f, 4.0f, 1.0f, random);
                this.addObjectiveAt(0.5f, 0.5f, 4.0f, 1.0f, random);
                this.addObjectiveAt(0.5f, 0.75f, 4.0f, 1.0f, random);
            }
        } else if (num == 4) {
            float r = random.nextFloat();
            if (r < 0.33f) {
                this.addObjectiveAt(0.25f, 0.25f, 1.0f, 1.0f, random);
                this.addObjectiveAt(0.25f, 0.75f, 1.0f, 1.0f, random);
                this.addObjectiveAt(0.75f, 0.25f, 1.0f, 1.0f, random);
                this.addObjectiveAt(0.75f, 0.75f, 1.0f, 1.0f, random);
            } else if (r < 0.67f) {
                this.addObjectiveAt(0.35f, 0.25f, 2.0f, 0.0f, random);
                this.addObjectiveAt(0.65f, 0.35f, 2.0f, 0.0f, random);
                this.addObjectiveAt(0.5f, 0.6f, 4.0f, 1.0f, random);
                this.addObjectiveAt(0.5f, 0.8f, 4.0f, 1.0f, random);
            } else {
                this.addObjectiveAt(0.65f, 0.25f, 2.0f, 0.0f, random);
                this.addObjectiveAt(0.35f, 0.35f, 2.0f, 0.0f, random);
                this.addObjectiveAt(0.5f, 0.6f, 4.0f, 1.0f, random);
                this.addObjectiveAt(0.5f, 0.8f, 4.0f, 1.0f, random);
            }
        }
    }

    protected void addObjectiveAt(float xMult, float yMult, float xOff, float yOff, Random random) {
        this.addObjectiveAt(xMult, yMult, xOff, yOff, null, random);
    }

    protected void addObjectiveAt(float xMult, float yMult, float xOff, float yOff, String type, Random random) {
        if (type == null) {
            type = this.pickAny(random);
            if (this.objs != null && this.objs.size() > 0) {
                int index = (int)(random.nextDouble() * (double)this.objs.size());
                type = this.objs.remove(index);
            }
        }
        float minX = -this.width / 2.0f + this.xPad;
        float minY = -this.height / 2.0f + this.yPad;
        float x = (this.width - this.xPad * 2.0f) * xMult + minX;
        float y = (this.height - this.yPad * 2.0f) * yMult + minY;
        x = (float)((int)x / 1000) * 1000.0f;
        y = (float)((int)y / 1000) * 1000.0f;
        float offsetX = (float)Math.round((random.nextFloat() - 0.5f) * xOff * 1.0f) * 1000.0f;
        float offsetY = (float)Math.round((random.nextFloat() - 0.5f) * yOff * 1.0f) * 1000.0f;
        float xDir = Math.signum(offsetX);
        float yDir = Math.signum(offsetY);
        if (xDir == this.prevXDir && xOff > 0.0f) {
            xDir = -xDir;
            offsetX = Math.abs(offsetX) * -this.prevXDir;
        }
        if (yDir == this.prevYDir && yOff > 0.0f) {
            yDir = -yDir;
            offsetY = Math.abs(offsetY) * -this.prevYDir;
        }
        this.prevXDir = xDir;
        this.prevYDir = yDir;
        this.loader.addObjective(x += offsetX, y += offsetY, type);
        if (random.nextFloat() > 0.6f) {
            float nebulaSize = random.nextFloat() * 1500.0f + 500.0f;
            this.loader.addNebula(x, y, nebulaSize);
        }
    }

    protected String pickAny(Random random) {
        float r = random.nextFloat();
        if (r < 0.33f) {
            return "nav_buoy";
        }
        if (r < 0.67f) {
            return "sensor_array";
        }
        return "comm_relay";
    }

    protected float countNearbyAsteroids(CampaignFleetAPI playerFleet) {
        float numAsteroidsWithinRange = 0.0f;
        LocationAPI loc = playerFleet.getContainingLocation();
        if (loc instanceof StarSystemAPI) {
            StarSystemAPI system = (StarSystemAPI)loc;
            List<SectorEntityToken> asteroids = system.getAsteroids();
            for (SectorEntityToken asteroid : asteroids) {
                float range = Vector2f.sub((Vector2f)playerFleet.getLocation(), (Vector2f)asteroid.getLocation(), (Vector2f)new Vector2f()).length();
                if (!(range < 300.0f)) continue;
                numAsteroidsWithinRange += 1.0f;
            }
        }
        return numAsteroidsWithinRange;
    }

    protected List<NearbyPlanetData> getNearbyPlanets(CampaignFleetAPI playerFleet) {
        LocationAPI loc = playerFleet.getContainingLocation();
        ArrayList<NearbyPlanetData> result = new ArrayList<NearbyPlanetData>();
        if (loc instanceof StarSystemAPI) {
            StarSystemAPI system = (StarSystemAPI)loc;
            List<PlanetAPI> planets = system.getPlanets();
            for (PlanetAPI planet : planets) {
                float diffX = planet.getLocation().x - playerFleet.getLocation().x;
                float diffY = planet.getLocation().y - playerFleet.getLocation().y;
                if (!(Math.abs(diffX) < PLANET_AREA_WIDTH / 2.0f) || !(Math.abs(diffY) < PLANET_AREA_HEIGHT / 2.0f)) continue;
                result.add(new NearbyPlanetData(new Vector2f(diffX, diffY), planet));
            }
        }
        return result;
    }

    protected PlanetAPI getClosestPlanet(CampaignFleetAPI playerFleet) {
        LocationAPI loc = playerFleet.getContainingLocation();
        PlanetAPI closest = null;
        float minDist = Float.MAX_VALUE;
        if (loc instanceof StarSystemAPI) {
            StarSystemAPI system = (StarSystemAPI)loc;
            List<PlanetAPI> planets = system.getPlanets();
            for (PlanetAPI planet : planets) {
                float dist;
                if (planet.isStar() || "lava".equals(planet.getTypeId()) || "lava_minor".equals(planet.getTypeId()) || planet.getSpec().isDoNotShowInCombat() || !((dist = Vector2f.sub((Vector2f)this.context.getPlayerFleet().getLocation(), (Vector2f)planet.getLocation(), (Vector2f)new Vector2f()).length()) < minDist) || !(dist < SINGLE_PLANET_MAX_DIST)) continue;
                closest = planet;
                minDist = dist;
            }
        }
        return closest;
    }

    protected static class NearbyPlanetData {
        protected Vector2f offset;
        protected PlanetAPI planet;

        public NearbyPlanetData(Vector2f offset, PlanetAPI planet) {
            this.offset = offset;
            this.planet = planet;
        }
    }

    public static interface NebulaTextureProvider {
        public String getNebulaTex();

        public String getNebulaMapTex();
    }
}

