/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.EveryFrameWeaponEffectPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.util.FaderUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class LightsEffect
implements EveryFrameWeaponEffectPlugin {
    private Color base = null;
    private FaderUtil fader = new FaderUtil(1.0f, 0.5f, 0.5f);
    private FaderUtil pulse = new FaderUtil(1.0f, 2.0f, 2.0f, true, true);

    public LightsEffect() {
        this.fader.fadeIn();
        this.pulse.fadeIn();
    }

    public void advance(float amount, CombatEngineAPI engine, WeaponAPI weapon) {
        ShipAPI ship;
        if (engine.isPaused()) {
            return;
        }
        this.fader.advance(amount);
        this.pulse.advance(amount);
        SpriteAPI sprite = weapon.getSprite();
        if (this.base == null) {
            this.base = sprite.getColor();
        }
        if ((ship = weapon.getShip()).isHulk()) {
            this.fader.fadeOut();
        } else if (ship.getFluxTracker().isVenting()) {
            this.fader.fadeOut();
        } else {
            this.fader.fadeIn();
        }
        float alphaMult = this.fader.getBrightness() * (0.75f + this.pulse.getBrightness() * 0.25f);
        if (ship.getFluxTracker().isOverloaded()) {
            alphaMult = (float)Math.random() * this.fader.getBrightness();
        }
        Color color = Misc.scaleAlpha(this.base, alphaMult);
        sprite.setColor(color);
    }
}

