/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipEngineControllerAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.impl.combat.CRPluginImpl;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LowCRShipDamageSequence
extends BaseEveryFrameCombatPlugin {
    private ShipAPI ship;
    private CombatEngineAPI engine;
    private float severity;
    private float elapsed = 0.0f;
    private float beforeDamage;
    private IntervalUtil tracker = new IntervalUtil(0.25f, 1.0f);
    private WeightedRandomPicker<Object> disableTargets = new WeightedRandomPicker(true);
    private float disableAttempts = 0.0f;

    public LowCRShipDamageSequence(ShipAPI ship, float severity) {
        this.ship = ship;
        this.severity = severity;
        this.beforeDamage = 1.0f + 2.0f * (float)Math.random();
        List<WeaponAPI> weapons = ship.getUsableWeapons();
        for (WeaponAPI weapon : weapons) {
            this.disableTargets.add(weapon);
        }
        List<ShipEngineControllerAPI.ShipEngineAPI> engines = ship.getEngineController().getShipEngines();
        for (ShipEngineControllerAPI.ShipEngineAPI engine : engines) {
            if (engine.isSystemActivated()) continue;
            this.disableTargets.add(engine);
        }
        this.disableAttempts = Math.max(1, Math.round((0.25f + 0.75f * severity) * (float)this.disableTargets.getItems().size() * 0.25f));
        if (severity >= 1.0f) {
            this.disableAttempts *= 2.0f;
        }
    }

    public void disableNext() {
        if (this.disableAttempts <= 0.0f) {
            return;
        }
        this.disableAttempts -= 1.0f;
        ArrayList<Object> remove = new ArrayList<Object>();
        for (Object target : this.disableTargets.getItems()) {
            if (CRPluginImpl.isOkToPermanentlyDisableStatic(this.ship, target)) continue;
            remove.add(target);
        }
        for (Object target : remove) {
            this.disableTargets.remove(target);
        }
        Object module = this.disableTargets.pick();
        if (module != null) {
            this.disableTargets.remove(module);
            this.ship.applyCriticalMalfunction(module);
        }
    }

    @Override
    public void init(CombatEngineAPI engine) {
        this.engine = engine;
    }

    @Override
    public void advance(float amount, List<InputEventAPI> events) {
        if (this.engine.isPaused()) {
            return;
        }
        if (!this.engine.isEntityInPlay(this.ship)) {
            return;
        }
        this.elapsed += amount;
        if (this.elapsed > this.beforeDamage) {
            this.tracker.advance(amount);
            if (this.tracker.intervalElapsed()) {
                this.disableNext();
            }
            if (this.ship.isHulk() || this.disableAttempts <= 0.0f) {
                this.engine.removePlugin(this);
            }
        }
    }
}

