/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BeamAPI;
import com.fs.starfarer.api.combat.BeamEffectPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.impl.combat.RiftCascadeEffect;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class RiftLanceEffect
implements BeamEffectPlugin {
    public static float MINE_SPAWN_CHANCE = 0.0f;
    protected boolean done = false;

    public void advance(float amount, CombatEngineAPI engine, BeamAPI beam) {
        if (beam.getBrightness() < 1.0f || this.done) {
            return;
        }
        float range = beam.getWeapon().getRange();
        float length = beam.getLengthPrevFrame();
        if (length > range - 10.0f || beam.getDamageTarget() != null) {
            this.done = true;
            Vector2f loc = beam.getRayEndPrevFrame();
            Color color = RiftLanceEffect.getColorForDarkening(beam.getFringeColor());
            Color undercolor = RiftCascadeEffect.EXPLOSION_UNDERCOLOR;
            float a = 1.0f;
            color = Misc.scaleAlpha(color, a);
            undercolor = Misc.scaleAlpha(undercolor, a);
            float size = 75.0f;
            size *= 0.5f;
            float dur = beam.getWeapon().getSpec().getBurstDuration() + beam.getWeapon().getSpec().getBeamChargedownTime();
            if ((float)Math.random() < MINE_SPAWN_CHANCE) {
                this.spawnMine(beam.getSource(), loc);
            } else {
                Vector2f vel = new Vector2f();
                if (beam.getDamageTarget() != null) {
                    vel.set((ReadableVector2f)beam.getDamageTarget().getVelocity());
                }
                this.spawnHitDarkening(color, undercolor, loc, vel, size, dur);
            }
        }
    }

    public void spawnHitDarkening(Color color, Color undercolor, Vector2f point, Vector2f vel, float size, float baseDuration) {
        CombatEngineAPI engine = Global.getCombatEngine();
        if (!engine.getViewport().isNearViewport(point, 100.0f + size * 2.0f)) {
            return;
        }
        Color c = color;
        int i = 0;
        while (i < 5) {
            float dur = baseDuration + baseDuration * (float)Math.random();
            float nSize = size;
            Vector2f pt = Misc.getPointWithinRadius(point, nSize * 0.5f);
            Vector2f v = Misc.getUnitVectorAtDegreeAngle((float)Math.random() * 360.0f);
            v.scale(nSize + nSize * (float)Math.random() * 0.5f);
            v.scale(0.2f);
            Vector2f.add((Vector2f)vel, (Vector2f)v, (Vector2f)v);
            float maxSpeed = nSize * 1.5f * 0.2f;
            float minSpeed = nSize * 1.0f * 0.2f;
            float overMin = v.length() - minSpeed;
            if (overMin > 0.0f) {
                float durMult = 1.0f - overMin / (maxSpeed - minSpeed);
                if (durMult < 0.1f) {
                    durMult = 0.1f;
                }
                dur *= 0.5f + 0.5f * durMult;
            }
            engine.addNegativeNebulaParticle(pt, v, nSize * 1.0f, 2.0f, 0.5f / dur, 0.0f, dur, c);
            ++i;
        }
        float dur = baseDuration;
        float rampUp = 0.0f;
        c = undercolor;
        int i2 = 0;
        while (i2 < 12) {
            Vector2f loc = new Vector2f((ReadableVector2f)point);
            loc = Misc.getPointWithinRadius(loc, size * 1.0f);
            float s = size * 3.0f * (0.5f + (float)Math.random() * 0.5f);
            engine.addNebulaParticle(loc, vel, s, 1.5f, rampUp, 0.0f, dur, c);
            ++i2;
        }
    }

    public static Color getColorForDarkening(Color from) {
        Color c = new Color(255 - from.getRed(), 255 - from.getGreen(), 255 - from.getBlue(), 127);
        c = Misc.interpolateColor(c, Color.white, 0.4f);
        return c;
    }

    public void spawnMine(ShipAPI source, Vector2f mineLoc) {
        CombatEngineAPI engine = Global.getCombatEngine();
        MissileAPI mine = (MissileAPI)engine.spawnProjectile(source, null, "riftlance_minelayer", mineLoc, (float)Math.random() * 360.0f, null);
        if (source != null) {
            Global.getCombatEngine().applyDamageModifiersToSpawnedProjectileWithNullWeapon(source, WeaponAPI.WeaponType.MISSILE, false, mine.getDamage());
        }
        float fadeInTime = 0.05f;
        mine.getVelocity().scale(0.0f);
        mine.fadeOutThenIn(fadeInTime);
        float liveTime = 0.0f;
        mine.setFlightTime(mine.getMaxFlightTime() - liveTime);
        mine.addDamagedAlready(source);
        mine.setNoMineFFConcerns(true);
    }
}

