/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseCombatLayeredRenderingPlugin;
import com.fs.starfarer.api.combat.CombatEngineLayers;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.util.FaderUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.EnumSet;
import org.lwjgl.util.vector.ReadableVector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShipExplosionFlareVisual
extends BaseCombatLayeredRenderingPlugin {
    protected ShipExplosionFlareParams p;
    protected SpriteAPI sprite;
    protected FaderUtil fader;

    public ShipExplosionFlareVisual(ShipExplosionFlareParams p) {
        this.p = p;
        this.fader = new FaderUtil(0.0f, 0.25f, 2.0f);
        this.fader.setBounceDown(true);
        this.fader.fadeIn();
        this.sprite = Global.getSettings().getSprite("graphics/fx/starburst_glow1.png");
    }

    @Override
    public float getRenderRadius() {
        return Math.max(this.p.flareWidth, this.p.flareHeight) + 500.0f;
    }

    @Override
    public EnumSet<CombatEngineLayers> getActiveLayers() {
        return EnumSet.of(CombatEngineLayers.ABOVE_PARTICLES_LOWER);
    }

    @Override
    public void advance(float amount) {
        if (Global.getCombatEngine().isPaused()) {
            return;
        }
        this.fader.advance(amount);
        if (this.entity != null && this.p.attachedTo != null) {
            if (this.p.attachedTo instanceof ShipAPI) {
                this.entity.getLocation().set((ReadableVector2f)((ShipAPI)this.p.attachedTo).getShieldCenterEvenIfNoShield());
            } else {
                this.entity.getLocation().set((ReadableVector2f)this.p.attachedTo.getLocation());
            }
        }
    }

    @Override
    public void init(CombatEntityAPI entity) {
        super.init(entity);
    }

    @Override
    public boolean isExpired() {
        return this.fader.isFadedOut();
    }

    @Override
    public void render(CombatEngineLayers layer, ViewportAPI viewport) {
        float x = this.entity.getLocation().x;
        float y = this.entity.getLocation().y;
        float b = this.fader.getBrightness();
        b = this.fader.isFadingIn() && b > 0.01f ? (float)Math.sqrt(b) : (b *= b);
        float alphaMult = viewport.getAlphaMult();
        alphaMult *= b;
        float f = 0.5f + 0.5f * b;
        f = 1.0f;
        this.sprite.setColor(this.p.color);
        this.sprite.setSize(this.p.flareWidth * f, this.p.flareHeight * f);
        this.sprite.setAdditiveBlend();
        this.sprite.setAlphaMult(alphaMult);
        this.sprite.renderAtCenter(x, y);
        this.sprite.setColor(Misc.scaleAlpha(Color.white, 1.0f));
        this.sprite.setSize(this.p.flareWidth * f, this.p.flareHeight * f * 0.33f);
        this.sprite.setAdditiveBlend();
        this.sprite.setAlphaMult(alphaMult);
        this.sprite.renderAtCenter(x, y);
    }

    public static class ShipExplosionFlareParams
    implements Cloneable {
        public CombatEntityAPI attachedTo;
        public Color color;
        public float flareWidth;
        public float flareHeight;

        public ShipExplosionFlareParams() {
        }

        public ShipExplosionFlareParams(CombatEntityAPI attachedTo, Color color, float flareWidth, float flareHeight) {
            this.attachedTo = attachedTo;
            this.color = color;
            this.flareWidth = flareWidth;
            this.flareHeight = flareHeight;
        }

        protected ShipExplosionFlareParams clone() {
            try {
                return (ShipExplosionFlareParams)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }
}

