/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.hullmods;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.loading.FighterWingSpecAPI;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertedHangar
extends BaseHullMod {
    public static float FIGHTER_OP_PER_DP = 5.0f;
    public static int MIN_DP = 1;
    public static float REPLACEMENT_TIME_MULT = 1.5f;
    public static int CREW_REQ = 20;
    public static float REARM_TIME_FRACTION = 0.4f;
    public static float SMOD_CRUISER = 10.0f;
    public static float SMOD_CAPITAL = 25.0f;
    public static float CR_THRESHOLD_UNINSTALLABLE = 70.0f;

    public static int computeDPModifier(float fighterOPCost) {
        int mod = (int)Math.ceil(fighterOPCost / FIGHTER_OP_PER_DP);
        if (mod < MIN_DP) {
            mod = MIN_DP;
        }
        return mod;
    }

    public static float getFighterOPCost(MutableShipStatsAPI stats) {
        float cost = 0.0f;
        for (String wingId : ConvertedHangar.getFighterWings(stats)) {
            FighterWingSpecAPI spec = Global.getSettings().getFighterWingSpec(wingId);
            cost += spec.getOpCost(stats);
        }
        return cost;
    }

    public static List<String> getFighterWings(MutableShipStatsAPI stats) {
        if (stats.getVariant() != null) {
            return stats.getVariant().getFittedWings();
        }
        return new ArrayList<String>();
    }

    public float computeCRMult(float suppliesPerDep, float dpMod) {
        return 1.0f + dpMod / suppliesPerDep;
    }

    @Override
    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        float dpMod;
        boolean refitPenalty;
        float numBays = 1.0f;
        stats.getNumFighterBays().modifyFlat(id, numBays += stats.getDynamic().getMod("converted_hangar_mod").computeEffective(0.0f));
        boolean sMod = this.isSMod(stats);
        if (sMod) {
            float bonus = 0.0f;
            if (hullSize == ShipAPI.HullSize.CRUISER) {
                bonus = SMOD_CRUISER;
            } else if (hullSize == ShipAPI.HullSize.CAPITAL_SHIP) {
                bonus = SMOD_CAPITAL;
            }
            if (bonus != 0.0f) {
                stats.getDynamic().getStat("replacement_rate_increase_mult").modifyPercent(id, bonus);
            }
        }
        boolean crewIncrease = stats.getDynamic().getMod("converted_hangar_no_crew_increase").computeEffective(0.0f) <= 0.0f;
        boolean rearmIncrease = stats.getDynamic().getMod("converted_hangar_no_rearm_increase").computeEffective(0.0f) <= 0.0f;
        boolean dpIncrease = stats.getDynamic().getMod("converted_hangar_no_dp_increase").computeEffective(0.0f) <= 0.0f;
        boolean bl = refitPenalty = stats.getDynamic().getMod("converted_hangar_no_refit_penalty").computeEffective(0.0f) <= 0.0f;
        if (refitPenalty) {
            stats.getFighterRefitTimeMult().modifyMult(id, REPLACEMENT_TIME_MULT);
            stats.getDynamic().getStat("replacement_rate_decrease_mult").modifyMult(id, 1.0f / REPLACEMENT_TIME_MULT);
            stats.getDynamic().getStat("replacement_rate_increase_mult").modifyMult(id, 1.0f / REPLACEMENT_TIME_MULT);
        }
        if (rearmIncrease) {
            stats.getDynamic().getMod("fighter_rearm_time_extra_fraction_of_base_refit_time_mod").modifyFlat(id, REARM_TIME_FRACTION);
        }
        if (dpIncrease && (dpMod = (float)ConvertedHangar.computeDPModifier(ConvertedHangar.getFighterOPCost(stats))) > 0.0f) {
            stats.getDynamic().getMod("deployment_points_mod").modifyFlat(id, dpMod);
            if (stats.getFleetMember() != null) {
                float perDep = stats.getFleetMember().getHullSpec().getSuppliesToRecover();
                float mult = this.computeCRMult(perDep, dpMod);
                stats.getCRPerDeploymentPercent().modifyMult(id, mult);
            }
            stats.getSuppliesToRecover().modifyFlat(id, dpMod);
        }
        if (crewIncrease) {
            stats.getMinCrewMod().modifyFlat(id, CREW_REQ);
        }
    }

    @Override
    public boolean isApplicableToShip(ShipAPI ship) {
        if (ship != null && ship.getHullSpec().getCRToDeploy() > CR_THRESHOLD_UNINSTALLABLE) {
            return false;
        }
        return ship != null && !ship.isFrigate() && ship.getHullSpec().getFighterBays() <= 0 && !ship.getVariant().hasHullMod("converted_bay") && !ship.getVariant().hasHullMod("phasefield");
    }

    @Override
    public String getUnapplicableReason(ShipAPI ship) {
        if (ship != null && ship.getHullSpec().getCRToDeploy() > CR_THRESHOLD_UNINSTALLABLE) {
            return "Ship's combat readiness lost per deployment is too high";
        }
        if (ship != null && ship.isFrigate()) {
            return "Can not be installed on a frigate";
        }
        if (ship != null && ship.getHullSpec().getFighterBays() > 0) {
            return "Ship has standard fighter bays";
        }
        if (ship != null && ship.getVariant().hasHullMod("converted_bay")) {
            return "Ship has fighter bays";
        }
        return "Can not be installed on a phase ship";
    }

    @Override
    public void applyEffectsToFighterSpawnedByShip(ShipAPI fighter, ShipAPI ship, String id) {
    }

    public static void setFighterSkin(ShipAPI fighter, ShipAPI carrier) {
        SpriteAPI sprite = ConvertedHangar.getFighterSkin(fighter, carrier);
        if (sprite != null) {
            fighter.setSprite(sprite);
        }
    }

    public static SpriteAPI getFighterSkin(ShipAPI fighter, ShipAPI carrier) {
        if (carrier.getHullStyleId().equals(fighter.getHullStyleId())) {
            return null;
        }
        String cat = null;
        SpriteAPI skin = null;
        if (carrier.getOwner() == 0 || carrier.getOriginalOwner() == 0) {
            cat = "fighterSkinsPlayerOnly";
            skin = ConvertedHangar.getFighterSkin(cat, fighter, carrier);
        }
        if (skin != null) {
            return skin;
        }
        cat = "fighterSkinsPlayerAndNPC";
        skin = ConvertedHangar.getFighterSkin(cat, fighter, carrier);
        return skin;
    }

    public static SpriteAPI getFighterSkin(String cat, ShipAPI fighter, ShipAPI carrier) {
        String exclude = "fighterSkinsExcludeFromSharing";
        String id = fighter.getHullSpec().getHullId();
        String style = carrier.getHullStyleId();
        List<String> skins = Global.getSettings().getSpriteKeys(cat);
        LinkedHashSet<String> noSharing = new LinkedHashSet<String>(Global.getSettings().getSpriteKeys(exclude));
        ArrayList<SpriteAPI> matching = new ArrayList<SpriteAPI>();
        for (String key : skins) {
            if (key.equals(String.valueOf(id) + "_" + style)) {
                return Global.getSettings().getSprite(cat, key);
            }
            if (!key.startsWith(id) || noSharing.contains(key)) continue;
            matching.add(Global.getSettings().getSprite(cat, key));
        }
        if (!matching.isEmpty()) {
            SpriteAPI best = null;
            float minDist = Float.MAX_VALUE;
            for (SpriteAPI curr : matching) {
                float dist = Misc.getColorDist(carrier.getSpriteAPI().getAverageBrightColor(), curr.getAverageBrightColor());
                if (!(dist < minDist)) continue;
                best = curr;
                minDist = dist;
            }
            return best;
        }
        return null;
    }

    @Override
    public boolean shouldAddDescriptionToTooltip(ShipAPI.HullSize hullSize, ShipAPI ship, boolean isForModSpec) {
        return false;
    }

    @Override
    public void addPostDescriptionSection(TooltipMakerAPI tooltip, ShipAPI.HullSize hullSize, ShipAPI ship, float width, boolean isForModSpec) {
        float pad = 3.0f;
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        Color bad = Misc.getNegativeHighlightColor();
        tooltip.addPara("Converts the ship's standard shuttle hangar to house a fighter bay. The improvised flight deck, its crew, and the related machinery all function at a pace below that of a dedicated carrier.", opad);
        tooltip.addPara("Increases fighter refit time by %s, and the fighter replacement rate both decays and recovers %s more slowly. In addition, bombers returning to rearm (or fighters returning for repairs) take %s of their base refit time to relaunch, where normally it takes under a second. ", opad, h, Misc.getRoundedValueMaxOneAfterDecimal(REPLACEMENT_TIME_MULT) + "\u00d7", Misc.getRoundedValueMaxOneAfterDecimal(REPLACEMENT_TIME_MULT) + "\u00d7", Math.round(REARM_TIME_FRACTION * 100.0f) + "%");
        tooltip.addPara("Increases the minimum crew by %s to account for pilots and flight crews. Increases the ship's deployment points and supply cost to recover from deployment by %s for every %s ordnance points spent on fighters, or by at least %s point. This comes with a proportional increase in combat readiness lost per deployment.", opad, h, "" + CREW_REQ, "1", "" + (int)FIGHTER_OP_PER_DP, "" + MIN_DP);
        if (isForModSpec || ship == null || ship.getMutableStats() == null) {
            return;
        }
        MutableShipStatsAPI stats = ship.getMutableStats();
        boolean crewIncrease = stats.getDynamic().getMod("converted_hangar_no_crew_increase").computeEffective(0.0f) <= 0.0f;
        boolean rearmIncrease = stats.getDynamic().getMod("converted_hangar_no_rearm_increase").computeEffective(0.0f) <= 0.0f;
        boolean dpIncrease = stats.getDynamic().getMod("converted_hangar_no_dp_increase").computeEffective(0.0f) <= 0.0f;
        boolean refitPenalty = stats.getDynamic().getMod("converted_hangar_no_refit_penalty").computeEffective(0.0f) <= 0.0f;
        int dpMod = ConvertedHangar.computeDPModifier(ConvertedHangar.getFighterOPCost(stats));
        if (dpMod > 0) {
            if (dpIncrease) {
                tooltip.addPara("Deployment cost: %s", opad, h, "+" + dpMod);
            }
            float numW = 160.0f;
            float sizeW = width - numW - 10.0f;
            if (!ConvertedHangar.getFighterWings(stats).isEmpty() && rearmIncrease) {
                tooltip.beginTable(Misc.getBasePlayerColor(), Misc.getDarkPlayerColor(), Misc.getBrightPlayerColor(), 20.0f, true, true, new Object[]{"Wing", Float.valueOf(sizeW), "Seconds to relaunch", Float.valueOf(numW)});
                for (String wingId : ConvertedHangar.getFighterWings(stats)) {
                    FighterWingSpecAPI spec = Global.getSettings().getFighterWingSpec(wingId);
                    float refitPortion = spec.getRefitTime() * ship.getMutableStats().getDynamic().getValue("fighter_rearm_time_extra_fraction_of_base_refit_time_mod", 0.0f);
                    Color c = Misc.getTextColor();
                    tooltip.addRow(new Object[]{Alignment.MID, c, spec.getWingName(), Alignment.MID, h, Misc.getRoundedValueOneAfterDecimalIfNotWhole(refitPortion)});
                }
                tooltip.addTable("", 0, opad);
            }
        }
        ArrayList<String> negated = new ArrayList<String>();
        if (!refitPenalty) {
            negated.add("refit time and rate recovery modifiers");
        }
        if (!rearmIncrease) {
            negated.add("relaunch delay");
        }
        if (!crewIncrease) {
            negated.add("increased crew requirement");
        }
        if (!dpIncrease) {
            negated.add("deployment cost increase");
        }
        if (!negated.isEmpty()) {
            Color c = Misc.getPositiveHighlightColor();
            String isOrAre = "is";
            if (negated.size() > 1) {
                isOrAre = "are";
            }
            if (negated.size() >= 4) {
                isOrAre = String.valueOf(isOrAre) + " all";
            }
            tooltip.addPara("The " + Misc.getAndJoined(negated) + " " + isOrAre + " negated on this ship.", c, opad);
        }
    }

    @Override
    public String getSModDescriptionParam(int index, ShipAPI.HullSize hullSize, ShipAPI ship) {
        if (index == 0) {
            return (int)SMOD_CRUISER + "%";
        }
        if (index == 1) {
            return (int)SMOD_CAPITAL + "%";
        }
        return null;
    }
}

