/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.hullmods;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.hullmods.MilitarizedSubsystems;

public class EscortPackage
extends BaseHullMod {
    private static float MANEUVER_PERCENT = 10.0f;
    private static float PD_RANGE = 30.0f;
    public static float FIGHTER_DAMAGE_BONUS = 10.0f;
    public static float MISSILE_DAMAGE_BONUS = 10.0f;

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        float mult = MilitarizedSubsystems.getEffectMult(stats);
        stats.getDamageToFighters().modifyFlat(id, FIGHTER_DAMAGE_BONUS / 100.0f * mult);
        stats.getDamageToMissiles().modifyFlat(id, MISSILE_DAMAGE_BONUS / 100.0f * mult);
        stats.getBeamPDWeaponRangeBonus().modifyFlat(id, PD_RANGE * mult);
        stats.getNonBeamPDWeaponRangeBonus().modifyFlat(id, PD_RANGE * mult);
        stats.getAcceleration().modifyPercent(id, MANEUVER_PERCENT * mult);
        stats.getDeceleration().modifyPercent(id, MANEUVER_PERCENT * mult);
        stats.getTurnAcceleration().modifyPercent(id, MANEUVER_PERCENT * 2.0f * mult);
        stats.getMaxTurnRate().modifyPercent(id, MANEUVER_PERCENT * mult);
        stats.getDynamic().getMod("act_as_combat_ship").modifyFlat(id, 1.0f);
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        float mult = MilitarizedSubsystems.getEffectMult(null);
        if (index == 0) {
            return Math.round(MANEUVER_PERCENT * mult) + "%";
        }
        if (index == 1) {
            return "" + Math.round(PD_RANGE * mult);
        }
        if (index == 2) {
            return Math.round(FIGHTER_DAMAGE_BONUS * mult) + "%";
        }
        return null;
    }

    public boolean isApplicableToShip(ShipAPI ship) {
        if (this.shipHasOtherModInCategory(ship, this.spec.getId(), "civ_package")) {
            return false;
        }
        return ship.getVariant().hasHullMod("militarized_subsystems");
    }

    public String getUnapplicableReason(ShipAPI ship) {
        if (this.shipHasOtherModInCategory(ship, this.spec.getId(), "civ_package")) {
            return "Can only install one combat package on a civilian-grade hull";
        }
        if (!ship.getVariant().hasHullMod("militarized_subsystems")) {
            return "Can only be installed on civilian-grade hulls with Militarized Subsystems";
        }
        return super.getUnapplicableReason(ship);
    }
}

